;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cc/exec.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Apr 29 09:09:34 1995                          */
;*    Last change :  Tue Feb  6 17:40:13 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    When we don't need to make any action after invoking the C       */
;*    compiler (i.e. when the C compiler is called in a tail           */
;*    call position), rather than invoking it with the `system'        */
;*    we use the `execp' command. This module implements a             */
;*    private version of `exec' which take  parameters that            */
;*    tells if the command must return or not.                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cc_exec
   (include "Tools/trace.sch")
   (foreign (macro int execl (string string long) "execl"))
   (import  tools_error
	    engine_param
	    main)
   (export  (exec <string> <boolean> <string>)
	    (exec-fname)))

;*---------------------------------------------------------------------*/
;*    exec-fname ...                                                   */
;*---------------------------------------------------------------------*/
(define (exec-fname)
   "$myselfx1001")

;*---------------------------------------------------------------------*/
;*    exec ...                                                         */
;*---------------------------------------------------------------------*/
(define (exec cmd flag name)
   (if flag
       (begin
	  (trace other "system: " cmd #\Newline)
	  (let ((res (system cmd)))
	     (if (not (=fx res 0))
		 (exit-bigloo 1)
		 res)))
       (begin
	  (trace other "system/kill: " cmd #\Newline)
	  (system/kill cmd))))

;*---------------------------------------------------------------------*/
;*    system/kill ...                                                  */
;*---------------------------------------------------------------------*/
(define (system/kill cmd)
   (let loop ((fname (string-append *bigloo-tmp*
				    "/"
				    (symbol->string (gensym)))))
      (if (file-exists? fname)
	  (loop (string-append fname "x"))
	  (let ((port (open-output-file fname)))
	     (if (not (output-port? port))
		 (error "exec" "Can't open output file" fname)
		 (begin
		    (fprint port "#!/bin/sh")
		    (fprint port "myselfx1001=" fname)
		    (fprint port cmd)
		    (close-output-port port)
		    (system (string-append "chmod u+x " fname))
		    (execl fname fname 0)
		    (internal-error "system/kill"
				    "Can't execute cmd"
				    cmd)))))))


