;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Bivalue/walk.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jan 18 11:56:57 1995                          */
;*    Last change :  Wed Oct 11 11:14:21 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The bivaluation pass (the one which inserts `function' and       */
;*    `funcall'). The process this pass at the beginning of the        */
;*    compilation in order to have as soon as possible the real        */
;*    Abstract Syntax Tree.                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module bivalue_walk
   (include "Tools/pass.sch"
	    "Ast/node.sch")
   (import tools_shape
	   ast_global
	   bivalue_apply
	   bivalue_app
	   bivalue_cache)
   (export (bivalue-walk! <ast>)
	   (bivalue!      <ast>)
	   (bivalue*!     <ast>)))

;*---------------------------------------------------------------------*/
;*    bivalue-walk! ...                                                */
;*---------------------------------------------------------------------*/
(define (bivalue-walk! ast)
   (pass-prelude "Bivaluation" start-bivalue-cache!)
   (for-each (lambda (global)
		(let ((fun (global-value global)))
		   (enter-function (global-shape global))
		   (function-body-set! fun (bivalue! (function-body fun)))))
	     ast)
   (pass-postlude ast))

;*---------------------------------------------------------------------*/
;*    bivalue! ...                                                     */
;*    -------------------------------------------------------------    */
;*    There is neither `funcall' node neither 'fun' node because       */
;*    this pass is in charge to introduce them !                       */
;*---------------------------------------------------------------------*/
(define (bivalue! ast)
   (ast-case ast
      ((atom)
       ast)
      ((var)
       (let ((var (var-variable ast)))
	  (if (function? (variable-value var))
	      (begin
		 (function-escape?-set! (variable-value var) #t)
		 (ast-fun (ast-location ast)
			  #f
			  #f
			  ast))
	      ast)))
      ((kwote)
       ast)
      ((sequence)
       (bivalue*! (sequence-exp ast))
       ast)
      ((make-box)
       (make-box-value-set! ast (bivalue! (make-box-value ast)))
       ast)
      ((box-ref)
       (box-ref-var-set! ast (bivalue! (box-ref-var ast)))
       ast)
      ((box-set!)
       (box-set!-var-set! ast (bivalue! (box-set!-var ast)))
       (box-set!-value-set! ast (bivalue! (box-set!-value ast)))
       ast)
      ((app)
       (bivalue-app! ast))
      ((prag-ma)
       (bivalue*! (prag-ma-values ast))
       ast)
      ((setq)
       (setq-val-set! ast (bivalue! (setq-val ast)))
       ast)
      ((conditional)
       (conditional-test-set! ast (bivalue! (conditional-test ast)))
       (conditional-then-set! ast (bivalue! (conditional-then ast)))
       (conditional-else-set! ast (bivalue! (conditional-else ast)))
       ast)
      ((fail)
       (fail-proc-set! ast (bivalue! (fail-proc ast)))
       (fail-msg-set! ast (bivalue! (fail-msg ast)))
       (fail-obj-set! ast (bivalue! (fail-obj ast)))
       ast)
      ((app-ly)
       (bivalue-apply! ast))
      ((switch)
       (switch-test-set! ast (bivalue! (switch-test ast)))
       (for-each (lambda (clause)
		    (set-cdr! clause (bivalue! (cdr clause))))
		 (switch-clauses ast))
       ast)
      ((let-fun)
       (for-each (lambda (local)
		    (let ((fun (local-value local)))
		       (function-body-set! fun
					   (bivalue! (function-body fun)))))
		 (let-fun-locals ast))
       (let-fun-body-set! ast (bivalue! (let-fun-body ast)))
       ast)
      ((set-ex-it)
       (set-ex-it-body-set! ast (bivalue! (set-ex-it-body ast)))
       ast)
      ((jump-ex-it)
       (jump-ex-it-exit-set! ast (bivalue! (jump-ex-it-exit ast)))
       (jump-ex-it-value-set! ast (bivalue! (jump-ex-it-value ast)))
       ast)
      ((let-var)
       (for-each (lambda (binding)
		    (set-cdr! binding (bivalue! (cdr binding))))
		 (let-var-bindings ast))
       (let-var-body-set! ast (bivalue! (let-var-body ast)))
       ast)))

;*---------------------------------------------------------------------*/
;*    bivalue*! ...                                                    */
;*---------------------------------------------------------------------*/
(define (bivalue*! ast*)
   (if (null? ast*)
       'done
       (begin
	  (set-car! ast* (bivalue! (car ast*)))
	  (bivalue*! (cdr ast*)))))
   

