;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Ast/varinit.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Mar 19 13:57:04 1995                          */
;*    Last change :  Mon Jan 29 09:44:05 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The ast has been built, we check now that global variables are   */
;*    not used before their initialization.                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_varinit
   (include "Ast/node.sch"
	    "Tools/trace.sch")
   (import  engine_param
	    tools_module
	    tools_shape
	    tools_location
	    type_env
	    type_cache
	    ast_dump
	    ast_env
	    ast_global)
   (export  (check-var-init?)))

;*---------------------------------------------------------------------*/
;*    *stamp* ...                                                      */
;*---------------------------------------------------------------------*/
(define *stamp* (gensym))

;*---------------------------------------------------------------------*/
;*    check-var-init? ...                                              */
;*    -------------------------------------------------------------    */
;*    This check require a walk of the ast, starting from the          */
;*    initialization procedure.                                        */
;*---------------------------------------------------------------------*/
(define (check-var-init?)
   (let ((init-proc        (find-global (module-init-name *module-name*)
					*module-name*))
	 (no-type         '())
	 (non-bigloo-type '())
	 (bigloo-type     '()))
      ;; we collect all static variables. We maps them into to
      ;; set the one which have a Bigloo type and the others.
      (for-each-global!
       (lambda (global)
	  (if (and (eq? (global-class global) 'variable)
		   (or (eq? (global-import global) 'export)
		       (eq? (global-import global) 'static)))
	      (cond
		 ((null? (global-type global))
		  (set! no-type (cons global no-type)))
		 ((obj-type? (global-type global))
		  (set! bigloo-type (cons global bigloo-type)))
		 (else
		  (set! non-bigloo-type (cons global non-bigloo-type)))))))
      (walk-from init-proc no-type bigloo-type non-bigloo-type)))

;*---------------------------------------------------------------------*/
;*    ret ...                                                          */
;*---------------------------------------------------------------------*/
(define (ret a b c)
   (vector-set! *ret* 0 a)
   (vector-set! *ret* 1 b)
   (vector-set! *ret* 2 c)
   *ret*)

;*---------------------------------------------------------------------*/
;*    *ret* ...                                                        */
;*---------------------------------------------------------------------*/
(define *ret* (vector '() '() '()))

;*---------------------------------------------------------------------*/
;*    walk-from ...                                                    */
;*    -------------------------------------------------------------    */
;*    We walk across the body. If we found a global reference          */
;*    to an untialized variable, we warn or we produce an error        */
;*    (depending of the global type). If we found a computed call      */
;*    and some variable with non bigloo's type exists, we produce      */
;*    an error.                                                        */
;*---------------------------------------------------------------------*/
(define (walk-from var ntype btype nbtype)
   (if (eq? (variable-info var) *stamp*)
       (ret ntype btype nbtype)
       (begin
	  ;; we mark global as seen
	  (variable-info-set! var *stamp*)
	  (enter-function (shape var))
	  (ret '() '() '())
	  (let ((res (walk-on-ast (function-body (variable-value var))
				  ntype
				  btype
				  nbtype)))
	     (leave-function)
	     res))))

;*---------------------------------------------------------------------*/
;*    walk-on-ast ...                                                  */
;*---------------------------------------------------------------------*/
(define (walk-on-ast ast ntype btype nbtype)
   (trace init
	  "walk-on-ast: " (ast->sexp ast) #\Newline
	  "  ntype: " (shape ntype) #\Newline
	  "  btype: " (shape btype) #\Newline
	  "  nbtype: " (shape nbtype) #\Newline)
   (ast-case ast
      ((atom)
       (ret ntype btype nbtype))
      ((var)
       (let ((var (var-variable ast)))
	  (cond
	     ((local? var)
	      (ret ntype btype nbtype))
	     ((eq? (global-import var) 'import)
	      (ret ntype btype nbtype))
	     ((null? (global-type var))
	      (if (memq var ntype)
		  (begin
		     (global-type-set! var *obj*)
		     (if (and (integer? *warning*) (>fx *warning* 1))
			 (user-warning/location
			  (find-location ast)
			  (current-function)
			  "This variable could be used before initialized"
			  (global-shape var)))))
	      (ret ntype btype nbtype))
	     ((obj-type? (global-type var))
	      (ret ntype btype nbtype))
	     (else
	      (if (memq var nbtype)
		  (if (sub-obj-type? (global-type var))
		      (begin
			 (if (and (integer? *warning*) (>fx *warning* 1))
			     (user-warning/location
			      (find-location ast)
			      (current-function)
			      "Variable used before initialization"
			      (global-shape var)))
			 (global-type-set! var *obj*)
			 (ret ntype (cons var btype) (remq! var nbtype)))
		      (begin
			 (user-error/location
			  (find-location ast)
			  (current-function)
			  "Variable used before initialization"
			  (global-shape var))
			 #f))
		  (ret ntype btype nbtype))))))
      ((kwote)
       (ret ntype btype nbtype))
      ((sequence)
       (let loop ((sexps  (sequence-exp ast))
		  (ntype  ntype)
		  (btype  btype)
		  (nbtype nbtype))
	  (if (null? sexps)
	      (ret ntype btype nbtype)
	      (let ((res (walk-on-ast (car sexps) ntype btype nbtype)))
		 (if (not res)
		     #f
		     (loop (cdr sexps)
			   (vector-ref res 0)
			   (vector-ref res 1)
			   (vector-ref res 2)))))))
      ((app)
       (let loop ((sexps  (app-actuals ast))
		  (ntype  ntype)
		  (btype  btype)
		  (nbtype nbtype))
	  (if (null? sexps)
	      (cond
		 ((not (var? (app-fun ast)))
		  (user-error/location (find-location ast)
				       (current-function)
				       "Illegal application"
				       (shape ast)))
		 ((function? (variable-value (var-variable (app-fun ast))))
		  (let ((var (var-variable (app-fun ast))))
		     (if (or (local? var)
			     (not (eq? (global-import var) 'import)))
			 (walk-from (var-variable (app-fun ast))
				    ntype
				    btype
				    nbtype)
			 (ret ntype btype nbtype))))
		 ((null? nbtype)
		  (ret ntype btype '()))
		 (else
		  (user-error/location
		   (find-location ast)
		   (current-function)
		   "Variables could be used before initialization"
		   (map global-shape nbtype))))
	      (let ((res (walk-on-ast (car sexps) ntype btype nbtype)))
		 (if (not res)
		     #f
		     (loop (cdr sexps)
			   (vector-ref res 0)
			   (vector-ref res 1)
			   (vector-ref res 2)))))))
      ((prag-ma)
       (let loop ((sexps  (prag-ma-values ast))
		  (ntype  ntype)
		  (btype  btype)
		  (nbtype nbtype))
	  (if (null? sexps)
	      (ret ntype btype nbtype)
	      (let ((res (walk-on-ast (car sexps) ntype btype nbtype)))
		 (if (not res)
		     #f
		     (loop (cdr sexps)
			   (vector-ref res 0)
			   (vector-ref res 1)
			   (vector-ref res 2)))))))
      ((setq)
       (let ((res (walk-on-ast (setq-val ast) ntype btype nbtype)))
	  (if (not res)
	      res
	      (let ((ntype  (vector-ref res 0))
		    (btype  (vector-ref res 1))
		    (nbtype (vector-ref res 2))
		    (var    (var-variable (setq-var ast))))
		 (if (and (global? var)
			  (not (eq? (global-import var) 'import)))
		     (cond
			((null? (global-type var))
			 (ret (remq! var ntype) btype nbtype))
			((obj-type? (global-type var))
			 (ret ntype (remq! var btype) nbtype))
			(else
			 (ret ntype btype (remq! var nbtype))))
		     res)))))
      ((conditional)
       (let ((res (walk-on-ast (conditional-test ast) ntype btype nbtype)))
	  (if (not res)
	      res
	      (let ((res (walk-on-ast (conditional-then ast)
				      (vector-ref res 0)
				      (vector-ref res 1)
				      (vector-ref res 2))))
		 (if (not res)
		     res
		     (walk-on-ast (conditional-else ast)
				  (vector-ref res 0)
				  (vector-ref res 1)
				  (vector-ref res 2)))))))
      ((fail)
       (let ((res (walk-on-ast (fail-proc ast) ntype btype nbtype)))
	  (if (not res)
	      res
	      (let ((res (walk-on-ast (fail-msg ast)
				      (vector-ref res 0)
				      (vector-ref res 1)
				      (vector-ref res 2))))
		 (if (not res)
		     res
		     (walk-on-ast (fail-obj ast)
				  (vector-ref res 0)
				  (vector-ref res 1)
				  (vector-ref res 2)))))))
      ((app-ly)
       (let ((res (walk-on-ast (app-ly-fun ast) ntype btype nbtype)))
	  (if (not res)
	      res
	      (walk-on-ast (app-ly-value ast) 
			   (vector-ref res 0)
			   (vector-ref res 1)
			   (vector-ref res 2)))))
      ((switch)
       (let ((res (walk-on-ast (switch-test ast) ntype btype nbtype)))
	  (if (not res)
	      res
	      (let loop ((clause  (switch-clauses ast))
			 (new-res res))
		 (if (null? clause)
		     new-res
		     (let ((new-res (walk-on-ast (cdr (car clause))
						 ntype
						 btype
						 nbtype)))
			(if (not new-res)
			    new-res
			    (loop (cdr clause) new-res))))))))
      ((let-fun)
       (let ((res (walk-on-ast (let-fun-body ast) ntype btype nbtype)))
	  (if (not res)
	      res 
	      (let loop ((local (let-fun-locals ast)))
		 (if (null? local)
		     (ret ntype btype nbtype)
		     (if (not (walk-from (car local) ntype btype nbtype))
			 #f
			 (loop (cdr local))))))))
      ((set-ex-it)
       (walk-on-ast (set-ex-it-body ast) ntype btype nbtype))
      ((jump-ex-it)
       (walk-on-ast (jump-ex-it-exit ast) ntype btype nbtype)
       (walk-on-ast (jump-ex-it-value ast) ntype btype nbtype))
      ((let-var)
       (let ((res (walk-on-ast (let-var-body ast) ntype btype nbtype)))
	  (if (not res)
	      res
	      (let loop ((bindings (let-var-bindings ast))
			 (new-res  res))
		 (if (null? bindings)
		     new-res
		     (let ((res (walk-on-ast (cdr (car bindings))
					     ntype
					     btype
					     nbtype)))
			(if (not res)
			    res
			    (loop (cdr bindings) new-res))))))))))



	     
