;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Ast/loc.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jan 10 08:48:39 1995                          */
;*    Last change :  Wed Apr  3 17:14:11 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The ast length computation                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_loc
   (include "Ast/node.sch")
   (import  tools_shape)
   (export  (ast-set-loc! <loc> <ast>)))

;*---------------------------------------------------------------------*/
;*    ast-set-loc! ...                                                 */
;*---------------------------------------------------------------------*/
(define (ast-set-loc! loc ast)
   (ast-location-set! ast loc)
   (ast-case ast
      ((atom)
       'set-loc-done)
      ((var)
       'set-loc-done)
      ((box-ref)
       (ast-set-loc! loc (box-ref-var ast)))
      ((box-set!)
       (ast-set-loc! loc (box-set!-var ast))
       (ast-set-loc! loc (box-set!-value ast)))
      ((make-box)
       (ast-set-loc! loc (make-box-value ast)))
      ((kwote)
       'set-loc-done)
      ((sequence)
       (for-each (lambda (x) (ast-set-loc! loc x)) (sequence-exp ast)))
      ((setq)
       (ast-set-loc! loc (setq-var ast))
       (ast-set-loc! loc (setq-val ast)))
      ((conditional)
       (ast-set-loc! loc (conditional-test ast))
       (ast-set-loc! loc (conditional-then ast))
       (ast-set-loc! loc (conditional-else ast)))
      ((fail)
       (ast-set-loc! loc (fail-proc ast))
       (ast-set-loc! loc (fail-msg ast))
       (ast-set-loc! loc (fail-obj ast)))
      ((let-fun)
       (ast-set-loc! loc (let-fun-body ast))
       (for-each (lambda (local)
		    (ast-set-loc! loc (function-body (local-value local))))
		 (let-fun-locals ast)))
      ((let-var)
       (ast-set-loc! loc (let-var-body ast))
       (for-each (lambda (binding)
		    (ast-set-loc! loc (cdr binding)))
		 (let-var-bindings ast)))
      ((app-ly)
       (ast-set-loc! loc (app-ly-fun ast))
       (ast-set-loc! loc (app-ly-value ast)))
      ((app)
       (ast-set-loc! loc (app-fun ast))
       (for-each (lambda (actual)
		    (ast-set-loc! loc actual))
		 (app-actuals ast)))
      ((fun)
       'set-loc-done)
      ((funcall)
       (ast-set-loc! loc (funcall-fun ast))
       (for-each (lambda (actual)
		    (ast-set-loc! loc actual))
		 (funcall-actuals ast)))
      ((set-ex-it)
       (ast-set-loc! loc (set-ex-it-exit ast))
       (ast-set-loc! loc (set-ex-it-body ast)))
      ((jump-ex-it)
       (ast-set-loc! loc (jump-ex-it-exit ast))
       (ast-set-loc! loc (jump-ex-it-value ast)))
      ((switch)
       (ast-set-loc! loc (switch-test ast))
       (for-each (lambda (clause)
		    (ast-set-loc! loc (cdr clause)))
		 (switch-clauses ast)))
      ((prag-ma)
       (for-each (lambda (value)
		    (ast-set-loc! loc value))
		 (prag-ma-values ast))
       'set-loc-done)))






