;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Ast/labels.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jan  1 11:37:29 1995                          */
;*    Last change :  Fri Mar 22 11:35:55 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `labels->ast' translator                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_labels
   (include "Ast/node.sch"
	    "Tools/trace.sch")
   (import  tools_error
	    tools_shape
	    tools_misc
	    tools_location
	    tools_args
	    tools_progn
	    engine_param
	    parse_definition
	    type_env
	    ast_env
	    ast_sexp
	    ast_global
	    ast_local)
   (export (labels->ast <sexp> <stack> <sexp> <loc> <site>)))

;*---------------------------------------------------------------------*/
;*    labels->ast ...                                                  */
;*---------------------------------------------------------------------*/
(define (labels->ast exp stack entering loc site)
   (let ((loc (find-location/loc exp loc)))
      (match-case exp
         ((?- (and (? pair?) ?bindings) . ?body)
          (let* ((frame-fun    (allocate-functions bindings loc))
                 (new-stack    (append frame-fun stack))
                 (ast-bindings (map (lambda (fun b)
                                       (match-case b
                                          ((?- ?- . ?-)
                                           (labels-binding fun
                                                           b
                                                           new-stack
                                                           loc))
                                          (else
                                           (user-error/location
                                            loc
                                            (current-function)
                                            "Illegal `labels' expression"
                                            exp
                                            ''()))))
                                    frame-fun
                                    bindings))
		 (body         (sexp->ast (normalize-progn body)
                                          new-stack
                                          entering
                                          loc
                                          site)))
             (ast-let-fun (find-location/loc exp loc)
			  #f
			  #f
			  ast-bindings
			  body)))
         (else
          (user-error/location loc
                               (current-function)
                               "Illegal `labels' expression"
                               exp
                               ''())))))

;*---------------------------------------------------------------------*/
;*    allocate-functions ...                                           */
;*---------------------------------------------------------------------*/
(define (allocate-functions bindings loc)
   (let loop ((bindings bindings)
	      (res      '()))
      (if (null? bindings)
	  (reverse! res)
	  (match-case (car bindings)
	     ((?fun ?- . ?-)
	      (let* ((fun-ident (parse-formal-ident fun))
		     (fun-id    (car fun-ident))
		     (local     (make-local-variable fun-id
						     (find-type 'procedure))))
		 (local-type-set! local (find-type 'procedure))
		 (loop (cdr bindings)
		       (cons local res))))
	     (else
	      (user-error/location (find-location/loc (car bindings) loc)
                                   (current-function)
				   "Illegal `binding' form"
				   (car bindings)))))))
				   
;*---------------------------------------------------------------------*/
;*    labels-binding ...                                               */
;*---------------------------------------------------------------------*/
(define (labels-binding local binding stack loc)
   (match-case binding
      ((?fun ?args . ?body)
       (let* ((fun-ident (parse-formal-ident fun))
	      (id        (car fun-ident))
	      (type-res  (cdr fun-ident))
	      (formals   (map-on-args parse-formal-ident args)))
	  (set-local-procedure-slot! local
				     type-res
				     formals)
	  (let* ((fun  (local-value local))
		 (body (sexp->ast (normalize-progn body)
				  (append (function-args fun)
					  stack)
				  id
				  (find-location/loc binding loc)
				  'value)))
	     (function-body-set! fun body)
	     local)))
      (else
       (user-error/location loc
                            (current-function)
                            "Illegal `labels' form"
			    binding))))

;*---------------------------------------------------------------------*/
;*    set-local-procedure-slot! ...                                    */
;*---------------------------------------------------------------------*/
(define (set-local-procedure-slot! local type-res formals)
   (assert check (local type-res formals)
	   (and (local? local)
		(or (null? type-res)
		    (symbol? type-res))
		(or (pair? formals)
                    (null? formals))))
   (local-type-set!       local (find-type 'procedure))
   (let* ((value (make-function))
	  (arity (arity formals)))
      (function-inline?-set! value '())
      (function-arity-set!   value arity)
      ;; we create formals
      (function-args-set!    value
			     (let loop ((args formals)
					(res  '()))
				 (cond
				    ((null? args)
				     (reverse! res))
				    ((not (pair? (car args)))
				     ;; it is the last formal of an n-ary
				     ;; function
				     (reverse! (cons (make-local-variable
						      (car args)
						      (find-type (cdr args)))
						     res)))
				    (else
				     (let ((arg (car args)))
					(loop (cdr args)
					      (cons (make-local-variable
						     (car arg)
						     (find-type (cdr arg)))
						    res)))))))
      ;; we set the escaping slot
      (function-escape?-set! value #f)
      ;; we set the result type
      (function-type-res-set! value (find-type type-res))
      (local-value-set! local value)
      local))
