;;;
;;; tm-nemacs.el --- tm definitions depended on NEmacs
;;;
;;; Copyright (C) 1995 Free Software Foundation, Inc.
;;; Copyright (C) 1994,1995,1996 MORIOKA Tomohiko
;;;
;;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;;; Version:
;;;	$Id: tm-nemacs.el,v 7.6 1996/01/11 05:12:50 morioka Exp $
;;; Keywords: mail, news, MIME, multimedia, multilingual, encoded-word
;;;
;;; This file is part of tm (Tools for MIME).
;;;
;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or
;;; (at your option) any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with This program.  If not, write to the Free Software
;;; Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
;;;
;;; Code:

(require 'emu)


;;; @ variables
;;;

(defvar mime/default-coding-system *junet*)

(defvar mime/lc-charset-alist
  (list
   (cons (list lc-ascii)       "US-ASCII")
   (cons (list lc-ascii lc-jp) "ISO-2022-JP")
   ))

(defvar mime/unknown-charset "ISO-2022-JP")


;;; @ functions
;;;

(defun mime/convert-string-to-emacs (charset str)
  (cond ((string= "ISO-2022-JP" charset)
	 (code-convert-string str *junet* *internal*))
	((string= "US-ASCII" charset) str)
	((string-match "^ISO-8859-[1-9]$" charset)
	 (check-ASCII-string str))
	))

(defun mime/convert-string-from-emacs (string charset)
  (cond ((string= charset "ISO-2022-JP")
	 (code-convert-string string *internal* *junet*))
	((string= charset "US-ASCII") string)
	))

(defun mime/code-convert-region-to-emacs (beg end charset &optional encoding)
  (if (stringp charset)
      (progn
	(setq charset (upcase charset))
	(if (string= charset "ISO-2022-JP")
	    (code-convert-region beg end *junet* *internal*)
	  ))))


;;; @ end
;;;

(provide 'tm-nemacs)

(run-hooks 'tm-nemacs-load-hook)

;;; tm-nemacs.el ends here
