#!	/bin/sh
cd_info ()
{
	V=vars

	PREPARER="$(sed -e '/^#/d' -e '/^$/d' < $V/preparer)"
	ARCHIVE="$(sed -e '/^#/d' -e '/^$/d' < $V/archive)"
	TARGET="$(sed -e '/^#/d' -e '/^$/d' < $V/target)"
	ALWAYS_EXCLUDE="$(sed -e '/^#/d' -e '/^$/d' < $V/always-exclude)"
	CODE_NAME="$(sed -e '/^#/d' -e '/^$/d' < $V/code-name)"
	RELEASE="$(sed -e '/^#/d' -e '/^$/d' < $V/release)"
	ARCHITECTURE="$(sed -e '/^#/d' -e '/^$/d' < $V/architecture)"
	APPI="$(sed -e '/^#/d' -e '/^$/d' < $V/application-identifier)"
	COPY="$(sed -e '/^#/d' -e '/^$/d' < $V/copyright)"
	ABST="$(sed -e '/^#/d' -e '/^$/d' < $V/abstract)"
	BIBL="$(sed -e '/^#/d' -e '/^$/d' < $V/bibliography)"
	PREP="$(sed -e '/^#/d' -e '/^$/d' < $V/preparer)"
	PUBL="$(sed -e '/^#/d' -e '/^$/d' < $V/publisher)"
	SYSI="$(sed -e '/^#/d' -e '/^$/d' < $V/system-identifier)"
	VOLI="$(sed -e '/^#/d' -e '/^$/d' < $V/volume-identifier)"
	VOLS="$(sed -e '/^#/d' -e '/^$/d' < $V/volume-set)"

	if [ -n "$APPI" ]; then
		echo  APPI="$APPI"
	fi
	if [ -n "$COPY" ]; then
		echo  COPY="$COPY"
	fi
	if [ -n "$ABST" ]; then
		echo  ABST="$ABST"
	fi
	if [ -n "$BIBL" ]; then
		echo  BIBL="$BIBL"
	fi
	if [ -n "$PREP" ]; then
		echo  PREP="$PREP"
	fi
	if [ -n "$PUBL" ]; then
		echo  PUBL="$PUBL"
	fi
	if [ -n "$SYSI" ]; then
		echo  SYSI="$SYSI"
	fi
	if [ -n "$VOLI" ]; then
		echo  VOLI="$VOLI"
	fi
	if [ -n "$VOLS" ]; then
		echo  VOLS="$VOLS"
	fi

	return 0
}

make_boot_directory ()
{
	tmp=/tmp/$$

	if [ ! -d $ARCHIVE/boot ]; then
		mkdir -m 755 $ARCHIVE/boot
	fi

	cp $RELEASE"/disks-"$ARCHITECTURE/current/linux \
	 $ARCHIVE/boot
	cp $RELEASE"/disks-"$ARCHITECTURE/current/lmemroot.bin \
	 $ARCHIVE/boot
	cp $RELEASE"/disks-"$ARCHITECTURE/current/root.bin \
	 $ARCHIVE/boot
	cp $RELEASE"/disks-"$ARCHITECTURE/current/resc1440.bin \
	 $ARCHIVE/boot
	(mkdir $tmp; cd $tmp; unzip $ARCHIVE/tools/lodlin*.zip)
	cp $tmp/*/*.EXE $ARCHIVE/boot

	for i in batch/*; do
		todos < $i > $ARCHIVE/boot/`echo $i | sed -e s!batch/!!`
	done

	return 0
}
