/***************************************************************************
**    xIrcSocket.h  $Revision: 1.9 $ - $Name: V1-17B $ 
**    xSocket Class to parse IRC Messages
**
** Copyright (C) 1995, 1996  Joseph Croft <jcroft@unicomp.net>  
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
 ***************************************************************************/
#ifndef _xIRCSOCKET_H
#define _xIRCSOCKET_H

#include <qobject.h>
#include <qstring.h>
#include <xResources.h>
#include <xSocket.h>

typedef enum
{
   ipmUnknown,
   ipmMessage,
   ipmAction,
   ipmPing,
   ipmDCC,
   ipmDCCSend,
   ipmDCCChat,
   ipmVersion,
   ipmUserInfo,
   ipmClientInfo,
   ipmSource,
   ipmFinger,
   ipmErrMsg,
   ipmTime
} xIrcPrvMsgType;

typedef struct
{
   int               fd;
   xIrcPrvMsgType    pmsgTyp;
   int               rspCode;
   QString           rspStr;
   QString           srcNick;
   QString           srcAddr;
   QString           dstStr;
   QString           msgStr;
   QString           rawMsg;
} xIrcMessage;

class xIrcSocket : public xSocketTCP
{
   Q_OBJECT
   
public:
   xIrcSocket(xWidgetResInfo *pPRes, QObject *pParent, const char *pHost,
              const char *pService, QObject *pSocketDialog, 
              const char *pSlotStatus, const char *pSlotProgress, 
              int &err);
   ~xIrcSocket();
   
signals:
   void ircServerMessage(xIrcMessage *pMsg);
   void sendToServer(const char *pText);
   
   // Used internaly, best not mess with
   void socketDataOut(const char *pText);

public slots:
   void sendIrcServerMessage(xIrcMessage *pMsg);
      
protected slots:
   virtual void socketError(int err);

private slots:
   void rawSocketDataIn(char *pText);
   void socketDataIn(const char *pText);
   
protected:
   void parseMsgSpecial(xIrcMessage *pMsg, const char *pStr,
                        const char **pRtn);

private:
   int      serr;
   QString  socketBuffer;
};

#define IMT_MaxLength         512

#endif
