.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "DROP TYPE" "l" "2002-03-27" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP TYPE \- remove a user-defined data type
.SH SYNOPSIS
.sp
.nf
DROP TYPE \fItypename\fR [, ...]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fItypename\fB\fR
The name of an existing type.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP\fR
The message returned if the command is successful.
.TP
\fBERROR: RemoveType: type '\fItypename\fB' does not exist\fR
This message occurs if the specified type is not found.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP TYPE\fR will remove a user type from the
system catalogs.
.PP
Only the owner of a type can remove it.
.SH "NOTES"
.TP 0.2i
\(bu
It is the user's responsibility to remove any operators,
functions, aggregates, access methods, subtypes, and tables that
use a deleted type. However, the associated array data type
(which was automatically created by \fBCREATE TYPE\fR)
will be removed automatically.
.TP 0.2i
\(bu
If a built-in type is removed, the behavior of the server is
unpredictable.
.SH "EXAMPLES"
.PP
To remove the \fBbox\fR type:
.sp
.nf
DROP TYPE box;
.sp
.fi
.SH "COMPATIBILITY"
.PP
A \fBDROP TYPE\fR statement exists in SQL99. As with
most other ``drop'' commands, \fBDROP
TYPE\fR in SQL99 requires a ``drop behavior''
clause to select between dropping all dependent objects or refusing
to drop if dependent objects exist:
.sp
.nf
DROP TYPE \fIname\fR { CASCADE | RESTRICT }
.sp
.fi
PostgreSQL currently ignores
dependencies altogether.
.PP
Note that the \fBCREATE TYPE\fR command and the data
type extension mechanisms in PostgreSQL
differ from SQL99.
.SH "SEE ALSO"
\fBcreate_type\fR(l)

