<?php
/**
*
* common [Belarusian]
*
* @package language
* @version $Id: common.php,v 1.195 2007/11/06 14:55:07 acydburn Exp $
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
   exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> '',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|d.m.Y|',	// 01 Jan 2007 (with Relative days enabled)
	'USER_LANG'			=> 'be-by',

	'1_DAY'			=> '1 дзень',
	'1_MONTH'		=> '1 месяц',
	'1_YEAR'		=> '1 год',
	'2_WEEKS'		=> '2 тыдні',
	'3_MONTHS'		=> '3 месяца',
	'6_MONTHS'		=> '6 месяцаў',
	'7_DAYS'		=> '7 дзён',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Ваш уліковы запіс ужо быў актываваны.',
	'ACCOUNT_DEACTIVATED'			=> 'Ваш уліковы запіс быў адключаны ўручную і можа быць ізноў актываваны толькі адміністратарам канферэнцыі.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'Ваш уліковы запіс яшчэ не актываваны.',
	'ACP'							=> 'Адміністратарскі раздзел',
	'ACTIVE'						=> 'актыўны',
	'ACTIVE_ERROR'					=> 'Паказанае імя карыстальніка ў цяперашні час неактыўна. Калі вы выпрабоўваеце цяжкасці з актывацыяй свайго ўліковага запісу, то звяжыцеся з адміністратарам канферэнцыі.',
	'ADMINISTRATOR'					=> 'Адміністратар',
	'ADMINISTRATORS'				=> 'Адміністратары',
	'AGE'							=> 'Узрост',
	'AIM'							=> 'AIM',
	'ALLOWED'						=> 'Дазволена',
	'ALL_FILES'						=> 'Усе файлы',
	'ALL_FORUMS'					=> 'Усе форумы',
	'ALL_MESSAGES'					=> 'Усё паведамленні',
	'ALL_POSTS'						=> 'Усё паведамленні',
	'ALL_TIMES'						=> 'Гадзінны пояс: %1$s %2$s',
	'ALL_TOPICS'					=> 'Усе тэмы',
	'AND'							=> 'і',
	'ARE_WATCHING_FORUM'			=> 'Вы падпісаныя на апавяшчэнні аб новых паведамленнях у гэтым форуме.',
	'ARE_WATCHING_TOPIC'			=> 'Вы падпісаныя на апавяшчэнні аб новых паведамленнях у гэтай тэме.',
	'ASCENDING'						=> 'па ўзрастанні',
	'ATTACHMENTS'					=> 'Укладанні',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'Вы паспрабавалі адправіць недапушчальны тып файла малюнка.',
	'AUTHOR'						=> 'Аўтар',
	'AUTH_NO_PROFILE_CREATED'		=> 'Не атрымалася стварыць профіль карыстальніка.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'Не атрымалася загрузіць аватару, магчыма, файл падобны да віруса.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Дадзены файл не можа быць адлюстраваны, паколькі пашырэнне <strong>%s</strong> не дазволена',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'Не атрымалася загрузіць паказаную аватару. Магчыма, дадзеныя пашкоджаныя або недапушчальныя.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'Загружаны файл аватары пусты.',
	'AVATAR_INVALID_FILENAME'		=> '%s з\'яўляецца недапушчальным імем файла.',
	'AVATAR_NOT_UPLOADED'			=> 'Загрузка аватары не атрымалася.',
	'AVATAR_NO_SIZE'				=> 'Не атрымалася вызначыць памеры паказанай аватары. Калі ласка, увядзіце іх уручную.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'Паказаны файл загружаны толькі часткова',
	'AVATAR_PHP_SIZE_NA'			=> 'Занадта вялікі памер файла аватары.<br />Не атрымалася вызначыць максімальны памер, усталяваны ў php.ini.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'Занадта вялікі памер файла аватары. Максімальна дапушчальны памер — %d Мб.<br />Нататка: гэтае абмежаванне ўсталявана ў файле php.ini і не можа быць перавышана.',
	'AVATAR_URL_INVALID'			=> 'Паказаны адрас аватары недапушчальны.',
	'AVATAR_URL_NOT_FOUND'			=> 'Паказаны файл аватары не знойдзены.',
	'AVATAR_WRONG_FILESIZE'			=> 'Памер файла аватары павінен нахадзіцца ў дыяпазоне ад 0 да %1d %2s.',
	'AVATAR_WRONG_SIZE'				=> 'Памеры адпраўленай аватары — %5$d?%6$d. Памеры аватары павінны быць не меней %1$d?%2$d, але не больш %3$d?%4$d. Усе памеры паказаныя ў піксэлах.',

	'BACK_TO_TOP'			=> 'Вярнуцца да пачатку',
	'BACK_TO_PREV'			=> 'Вярнуцца на папярэднюю старонку',
	'BAN_TRIGGERED_BY_EMAIL'=> 'Доступ да канферэнцыі зачынены для вашага адрасу email.',
	'BAN_TRIGGERED_BY_IP'	=> 'Доступ да канферэнцыі зачынены для вашага IP-адрасы.',
	'BAN_TRIGGERED_BY_USER'	=> 'Доступ да канферэнцыі зачынены для вашага ўліковага запісу.',
	'BBCODE_GUIDE'			=> 'Кіраўніцтва па BBCode',
	'BCC'					=> 'Утоеная копія',
	'BIRTHDAYS'				=> 'Дні нараджэння',
	'BOARD_BAN_PERM'		=> 'Вам зачынены доступ да канферэнцыі.<br /><br />Для атрымання дадатковай інфармацыі %2$sзвяжыцеся з адміністратарам канферэнцыі%3$s.',
	'BOARD_BAN_REASON'		=> 'Чыннік: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'Вам зачынены доступ да канферэнцыі да <strong>%1$s</strong>.<br /><br />Для атрымання дадатковай інфармацыі %2$sзвяжыцеся з адміністратарам канферэнцыі%3$s.',
	'BOARD_DISABLE'			=> 'Выбачыце, але канферэнцыя ў сапраўдны момант недаступная',
	'BOARD_DISABLED'		=> 'Канферэнцыя ў сапраўдны момант адключаная.',
	'BOARD_UNAVAILABLE'		=> 'Канферэнцыя часова недаступная. Паспрабуйце зайсці праз некалькі хвілін.',
	'BROWSING_FORUM'		=> 'Зараз гэты форум праглядаюць: %1$s',	
	'BROWSING_FORUM_GUEST'	=> 'Зараз гэты форум праглядаюць: %1$s і %2$d госць',
	'BROWSING_FORUM_GUESTS'	=> 'Зараз гэты форум праглядаюць: %1$s і %2$d гасцей',
	'BYTES'					=> 'байт',

	'CANCEL'				=> 'Адмена',
	'CHANGE'				=> 'Змяніць',
	'CHANGE_FONT_SIZE'		=> 'Змяніць памер шрыфта',
	'CHANGING_PREFERENCES'	=> 'Змена асабістых налад',
	'CHANGING_PROFILE'		=> 'Змена налад профіля',
	'CLICK_VIEW_PRIVMSG'	=> '%sПерайсці у папку «Уваходныя»%s',
	'COLLAPSE_VIEW'			=> 'Згарнуць',
	'CLOSE_WINDOW'			=> 'Зачыніць акно',
	'COLOUR_SWATCH'			=> 'Палітра',
	'COMMA_SEPARATOR'		=> ', ',	// Used in pagination of ACP & prosilver, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Пацверджанне',
	'CONFIRM_CODE'			=> 'Код пацверджання',
	'CONFIRM_CODE_EXPLAIN'	=> 'Увядзіце код у дакладнасці так, як вы яго бачыце. Код не залежыць ад рэгістра, знака нуля ў ім няма.',
	'CONFIRM_CODE_WRONG'	=> 'Вы ўвялі няслушны код пацверджання.',
	'CONFIRM_OPERATION'		=> 'Вы ўпэўненыя, што жадаеце выканаць гэтую аперацыю?',
	'CONGRATULATIONS'		=> 'Віншуем',
	'CONNECTION_FAILED'		=> 'Памылка падлучэння.',
	'CONNECTION_SUCCESS'	=> 'Падлучэнне паспяхова ўсталявана.',
	'COOKIES_DELETED'		=> 'Усё cookies, усталяваныя форумамі, паспяхова выдаленыя.',
	'CURRENT_TIME'			=> 'Дзеючы час: %s',

	'DAY'					=> 'дзень',
	'DAYS'					=> 'дзён',
	'DELETE'				=> 'Выдаліць',
	'DELETE_ALL'			=> 'Выдаліць усё',
	'DELETE_COOKIES'		=> 'Выдаліць cookies канферэнцыі',
	'DELETE_MARKED'			=> 'Выдаліць адзначаныя',
	'DELETE_POST'			=> 'Выдаліць паведамленне',
	'DELIMITER'				=> 'Падзельнік',
	'DESCENDING'			=> 'па змяншэнні',
	'DISABLED'				=> 'Адключана',
	'DISPLAY'				=> 'Паказаць',
	'DISPLAY_GUESTS'		=> 'Паказаць госцяў',
	'DISPLAY_MESSAGES'		=> 'Паказаць паведамленні за',
	'DISPLAY_POSTS'			=> 'Паказаць паведамленні за',
	'DISPLAY_TOPICS'		=> 'Паказаць тэмы за',
	'DOWNLOADED'			=> 'Запамповак:',
	'DOWNLOADING_FILE'		=> 'Запампоўка файла',
	'DOWNLOAD_COUNT'		=> 'Запамповак: %d',
	'DOWNLOAD_COUNTS'		=> 'Запамповак: %d',
	'DOWNLOAD_COUNT_NONE'	=> 'Запамповак: 0',
	'VIEWED_COUNT'			=> 'Праглядаў: %d',
	'VIEWED_COUNTS'			=> 'Праглядаў: %d',
	'VIEWED_COUNT_NONE'		=> 'Праглядаў: 0',

	'EDIT_POST'							=> 'Рэдагаваць паведамленне',
	'EMAIL'								=> 'Email',
	'EMAIL_ADDRESS'						=> 'Адрас email',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Памылка пры адпраўцы email у <strong>радку %1$s</strong>. Адказ сервера: %2$s.',
	'EMPTY_SUBJECT'						=> 'Пры стварэнні новай тэмы неабходна паказаць загаловак.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Вы павінны паказаць тэму новага паведамлення.',
	'ENABLED'							=> 'Уключана',
	'ENCLOSURE'							=> 'Абмежавальнік',
	'ERR_CHANGING_DIRECTORY'			=> 'Не атрымалася змяніць папку.',
	'ERR_CONNECTING_SERVER'				=> 'Памылка падлучэння да сервера.',
	'ERR_JAB_AUTH'						=> 'Не атрымалася аўтарызавацца на серверы Jabber.',
	'ERR_JAB_CONNECT'					=> 'Не атрымалася падлучыцца да сервера Jabber.',
	'ERR_UNABLE_TO_LOGIN'				=> 'Паказана няслушнае імя карыстальніка або пароль.',
	'ERR_UNWATCHING'					=> 'Пры спробе адмовіцца ад падпіскі паўстала памылка.',
	'ERR_WATCHING'						=> 'Пры спробе падпісацца паўстала памылка.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'Паказаны шлях да канферэнцыі няслушны.',
	'EXPAND_VIEW'						=> 'Разгарнуць',
	'EXTENSION'							=> 'Пашырэнне',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'Пашырэнне <strong>%s</strong> было забароненае, укладанне больш недаступна.',

	'FAQ'					=> 'FAQ',
	'FAQ_EXPLAIN'			=> 'Часта зададзеныя пытанні',
	'FILENAME'				=> 'Імя файла',
	'FILESIZE'				=> 'Памер файла',
	'FILEDATE'				=> 'Дата стварэння файла',
	'FILE_COMMENT'			=> 'Каментар да файла',
	'FILE_NOT_FOUND'		=> 'Запытваемы файл не знойдзены.',
	'FIND_USERNAME'			=> 'Знайсці карыстальніка',
	'FOLDER'				=> 'Папка',
	'FORGOT_PASS'			=> 'Забылі пароль?',
	'FORM_INVALID'			=> 'Памылка адпраўкі формы. Паспрабуйце яшчэ раз.',
	'FORUM'					=> 'Форум',
	'FORUMS'				=> 'Форумы',
	'FORUMS_MARKED'			=> 'Усе форумы адзначаныя як прачытаныя',
	'FORUM_CAT'				=> 'Катэгорыя',
	'FORUM_INDEX'			=> 'Спіс форумаў',
	'FORUM_LINK'			=> 'Спасылка на форум',
	'FORUM_LOCATION'		=> 'Месца ў канферэнцыі',
	'FORUM_LOCKED'			=> 'Форум зачынены',
	'FORUM_RULES'			=> 'Правілы форума',
	'FORUM_RULES_LINK'		=> 'Паглядзець правілы форума',
	'FROM'					=> 'з',
	'FSOCK_DISABLED'		=> 'Дзеянне не можа быць завершанае, паколькі функцыя <var>fsockopen</var> адключаная або запытваемы сервер не знойдзены.',

	'FTP_FSOCK_HOST'				=> 'FTP-сервер',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'FTP-сервер для злучэння з бачынай.',
	'FTP_FSOCK_PASSWORD'			=> 'Пароль FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Пароль для ўваходу на FTP-сервер.',
	'FTP_FSOCK_PORT'				=> 'Порт FTP',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Порт для злучэння з FTP-серверам.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Шлях да phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Шлях да папкі, якая змяшчае phpBB, адносна кораня бачыны.',
	'FTP_FSOCK_TIMEOUT'				=> 'Тайм-аўт FTP',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'Час у секундах, на працягу якога сістэма будзе чакаць адказу ад FTP-сервера.',
	'FTP_FSOCK_USERNAME'			=> 'Імя карыстальніка FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Імя карыстальніка для злучэння з FTP-серверам.',

	'FTP_HOST'					=> 'FTP-сервер',
	'FTP_HOST_EXPLAIN'			=> 'FTP-сервер для злучэння з бачынай.',
	'FTP_PASSWORD'				=> 'Пароль FTP',
	'FTP_PASSWORD_EXPLAIN'		=> 'Пароль для ўваходу на FTP-сервер.',
	'FTP_PORT'					=> 'Порт FTP',
	'FTP_PORT_EXPLAIN'			=> 'Порт для злучэння з FTP-серверам.',
	'FTP_ROOT_PATH'				=> 'Шлях да phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Шлях да папкі, якая змяшчае phpBB, адносна кораня бачыны.',
	'FTP_TIMEOUT'				=> 'Тайм-аўт FTP',
	'FTP_TIMEOUT_EXPLAIN'		=> 'Час у секундах, на працягу якога сістэма будзе чакаць адказу ад FTP-сервера.',
	'FTP_USERNAME'				=> 'Імя карыстальніка FTP',
	'FTP_USERNAME_EXPLAIN'		=> 'Імя карыстальніка для злучэння з FTP-серверам.',

	'GENERAL_ERROR'				=> 'Агульная памылка',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',
	'GO'						=> 'Перайсці',
	'GOTO_PAGE'					=> 'На старонку',
	'GROUP'						=> 'Група',
	'GROUPS'					=> 'Групы',
	'GROUP_ERR_TYPE'			=> 'Вылучаны неадпавядалы тып групы.',
	'GROUP_ERR_USERNAME'		=> 'Не паказана імя групы.',
	'GROUP_ERR_USER_LONG'		=> 'Імя групы не можа быць даўжэй 60 знакаў. Паказанае імя групы занадта доўгае.',
	'GUEST'						=> 'Госць',
	'GUEST_USERS_ONLINE'		=> 'Зараз на канферэнцыі %d госцяў',
	'GUEST_USERS_TOTAL'			=> '%d госцяў',
	'GUEST_USERS_ZERO_ONLINE'	=> 'Зараз на канферэнцыі няма госцяў',
	'GUEST_USERS_ZERO_TOTAL'	=> '0 госцяў',
	'GUEST_USER_ONLINE'			=> 'Зараз на канферэнцыі %d госць',
	'GUEST_USER_TOTAL'			=> '%d госць',
	'G_ADMINISTRATORS'			=> 'Адміністратары',
	'G_BOTS'					=> 'Боты',
	'G_GUESTS'					=> 'Госці',
	'G_REGISTERED'				=> 'Зарэгістраваныя карыстальнікі',
	'G_REGISTERED_COPPA'		=> 'Зарэгістраваныя карыстальнікі (COPPA)',
	'G_GLOBAL_MODERATORS'		=> 'Супермадэратары',
	'G_NEWLY_REGISTERED'		=> 'Новыя карыстальнікі',

	'HIDDEN_USERS_ONLINE'		=> '%d утоеных карыстальнікаў',
	'HIDDEN_USERS_TOTAL'		=> '%d утоеных',
	'HIDDEN_USERS_TOTAL_AND'	=> '%d утоеных і ',
	'HIDDEN_USERS_ZERO_ONLINE'	=> '0 утоеных карыстальнікаў',
	'HIDDEN_USERS_ZERO_TOTAL'	=> '0 утоеных',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> '0 утоеных і ',
	'HIDDEN_USER_ONLINE'		=> '%d утоены карыстальнік',
	'HIDDEN_USER_TOTAL'		=> '%d утоены',
	'HIDDEN_USER_TOTAL_AND'		=> '%d утоены і ',
	'HIDE_GUESTS'			=> 'Схаваць госцяў',
	'HIDE_ME'			=> 'Схаваць маё знаходжанне на канферэнцыі ў гэты раз',
	'HOURS'				=> 'гадзін',
	'HOME'				=> 'На галоўную',

	'ICQ'						=> 'ICQ',
	'ICQ_STATUS'				=> 'Статут ICQ',
	'IF'						=> 'Калі',
	'IMAGE'						=> 'Малюнак',
	'IMAGE_FILETYPE_INVALID'	=> 'Тып файла малюнка %d не падтрымліваецца для MIME-тыпу %s.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Несупадзенне тыпу малюнка: чаканае пашырэнне %1$s замест атрыманага %2$s.',
	'IN'						=> 'у форуме',
	'INDEX'						=> 'Галоўная старонка',
	'INFORMATION'				=> 'Інфармацыя',
	'INTERESTS'					=> 'Інтарэсы',
	'INVALID_DIGEST_CHALLENGE'	=> 'Няслушны запыт аўтэнтыфікацыі.',
	'INVALID_EMAIL_LOG'			=> 'Магчыма, уведзены няслушны адрас email: <strong>%s</strong>',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'Ваш IP-адрас %1$s быў занесены ў чорны спіс і заблакаваны. Для атрымання дадатковай інфармацыі перайдзіце па спасылцы <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Зарэгістраваны',
	'JUMP_PAGE'				=> 'Увядзіце нумар старонкі, на якую жадаеце перайсці',
	'JUMP_TO'				=> 'Перайсці',
	'JUMP_TO_PAGE'			=> 'Перайсці на старонку:',

	'KB'					=> 'КБ',
	'KIB'					=> 'KіБ',

	'LAST_POST'							=> 'Апошняе паведамленне',
	'LAST_UPDATED'						=> 'Апошняя змена',
	'LAST_VISIT'						=> 'Апошняе наведванне',
	'LDAP_NO_LDAP_EXTENSION'			=> 'Пашырэнне LDAP недаступна.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Не атрымалася злучыцца з серверам LDAP.',
	'LEGEND'							=> 'Легенда',
	'LOCATION'							=> 'Адкуль',
	'LOCK_POST'							=> 'Заблакаваць паведамленне',
	'LOCK_POST_EXPLAIN'					=> 'забарона рэдагавання',
	'LOCK_TOPIC'						=> 'Зачыніць тэму',
	'LOGIN'								=> 'Уваход',
	'LOGIN_CHECK_PM'					=> 'Увайсці і праверыць асабістыя паведамленні.',
	'LOGIN_CONFIRMATION'				=> 'Пацверджанне ўваходу',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Для прадухілення падбору пароляў да вашага ўліковага запісу неабходна ўвесці код пацверджання пасля максімальнай колькасці няўдалых уваходаў у сістэму. Код паказаны на малюначку ніжэй. Увядзіце код у дакладнасці так, як вы яго бачыце. Калі вы не бачыце кода, то звернецеся да %sадміністратару%s.',
	'LOGIN_ERROR_ATTEMPTS'				=> 'Вы перавысілі максімальна дапушчальная колькасць спроб уваходу. Зараз, акрамя імя карыстальніка і пароля, вы павінны ўвесці код пацверджання, паказаны на малюначку ніжэй.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Apache не змог вас аўтэнтыфікаваць.',
	'LOGIN_ERROR_PASSWORD'				=> 'Вы ўвялі няслушны пароль. Праверце яго і паспрабуйце ўвесці яшчэ раз. Калі праблема са ўваходам застанецца, то паведаміце аб гэтым %sадміністратару%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Пры абнаўленні канферэнцыі не атрымалася пераўтварыць ваш пароль. Вы можаце %sзапытаць новы пароль%s. Калі вы працягваеце выпрабоўваць цяжкасці, то звяжыцеся з %sадміністратарам канферэнцыі%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Вы ўвялі няслушнае імя карыстальніка. Праверце яго і паспрабуйце ўвесці яшчэ раз. Калі праблема са ўваходам застанецца, то паведаміце аб гэтым %sадміністратару%s.',
	'LOGIN_FORUM'						=> 'Для прагляду або размяшчэнні паведамленняў у гэтым форуме неабходна ўвесці пароль.',
	'LOGIN_INFO'						=> 'Для ўваходу на канферэнцыю вы павінны быць зарэгістраваныя. Рэгістрацыя займае ўсяго некалькі хвілін, але падае вам шырэйшыя магчымасці. Адміністратарам канферэнцыі могуць быць усталяваныя таксама дадатковыя прывілеі для зарэгістраваных карыстальнікаў. Перш чым зарэгістравацца, вам варта азнаёміцца з правіламі і палітыкай, прынятымі на канферэнцыі. Падушыце, што ваша прысутнасць на форумах азначае згоду са <strong>усімі</strong> правіламі.',
	'LOGIN_VIEWFORUM'					=> 'Для прагляду гэтага форума вы павінны быць аўтарызаваныя.',
	'LOGIN_EXPLAIN_EDIT'				=> 'Для рэдагавання паведамленняў у гэтым форуме вы павінны быць аўтарызаваныя.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Для прагляду спісу карыстальнікаў, змешчаных зараз на канферэнцыі, вы павінны быць аўтарызаваныя.',
	'LOGOUT'							=> 'Выхад',
	'LOGOUT_USER'						=> 'Выхад [ %s ]',
	'LOG_ME_IN'							=> 'Аўтаматычна ўваходзіць пры кожным наведванні',

	'MARK'					=> 'Адзначыць',
	'MARK_ALL'				=> 'Адзначыць усё',
	'MARK_FORUMS_READ'		=> 'Адзначыць усе форумы як прачытаныя',
	'MB'					=> 'MБ',
	'MIB'					=> 'MіБ',
	'MCP'					=> 'Мадэратарскі раздзел',
	'MEMBERLIST'			=> 'Карыстальнікі',
	'MEMBERLIST_EXPLAIN'	=> 'Прагляд усяго спісу карыстальнікаў',
	'MERGE'					=> 'Аб\'яднаць',
	'MERGE_POSTS'			=> 'Аб\'яднаць паведамленні',
	'MERGE_TOPIC'			=> 'Аб\'яднаць тэму',
	'MESSAGE'				=> 'Паведамленне',
	'MESSAGES'				=> 'Паведамленняў',
	'MESSAGE_BODY'			=> 'Тэкст паведамлення',
	'MINUTES'				=> 'хвілін',
	'MODERATE'				=> 'Мадэраваць',
	'MODERATOR'				=> 'Мадэратар',
	'MODERATORS'			=> 'Мадэратары',
	'MONTH'					=> 'Месяц',
	'MOVE'					=> 'Перамясціць',
	'MSNM'					=> 'MSNM/WLM',

	'NA'						=> 'Не',
	'NEWEST_USER'				=> 'Новы карыстальнік: <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Новае паведамленне',
	'NEW_MESSAGES'				=> 'Новыя паведамленні',
	'NEW_PM'					=> 'Новых АП: <strong>%d</strong>',
	'NEW_PMS'					=> 'Новых АП: <strong>%d</strong>',
	'NEW_POST'					=> 'Новае паведамленне',
	'NEW_POSTS'					=> 'Новыя паведамленні',
	'NEXT'						=> 'Наст.',		// Used in pagination
	'NEXT_STEP'					=> 'Далей',
	'NEVER'						=> 'Ніколі',
	'NO'						=> 'Не',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Вы не можаце кіраваць гэтай групай.',
	'NOT_AUTHORISED'			=> 'У вас няма доступу ў гэтую частку форума.',
	'NOT_WATCHING_FORUM'		=> 'Вы больш не падпісаныя на абнаўленні ў гэтым форуме.',
	'NOT_WATCHING_TOPIC'		=> 'Вы больш не падпісаныя на гэтую тэму.',
	'NOTIFY_ADMIN'				=> 'Апавесціце адміністратара канферэнцыі або вэбмайстра.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Апавесціце адміністратара канферэнцыі або вэбмайстра: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'Вам забаронены доступ да гэтага файла.',
	'NO_ACTION'					=> 'Дзеянне не вызначанае.',
	'NO_ADMINISTRATORS'			=> 'Адміністратары на гэтым форуме не прызначаныя.',
	'NO_AUTH_ADMIN'				=> 'Вы не маеце праў доступу да адміністратарскага раздзелу.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Вы не можаце паўторна аўтарызавацца, як іншы карыстальнік.',
	'NO_AUTH_OPERATION'			=> 'Вы не маеце неабходных праў доступу для завяршэння гэтай аперацыі.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Не атрымалася злучыцца з SMTP-серверам: %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'Сёння няма дзён нараджэння.',
	'NO_EMAIL_MESSAGE'			=> 'Адсутнічае тэкст паведамлення.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Не атрымалася атрымаць адказ ад паштовага сервера.',
	'NO_EMAIL_SUBJECT'			=> 'Не паказаная тэма паведамлення.',
	'NO_FORUM'					=> 'Запытанага форума не існуе.',
	'NO_FORUMS'					=> 'На гэтай бачыне няма форумаў.',
	'NO_GROUP'					=> 'Запытанай групы не існуе.',
	'NO_GROUP_MEMBERS'			=> 'У цяперашні час у гэтай групе няма не аднаго карыстальніка.',
	'NO_IPS_DEFINED'			=> 'Не вызначаны IP-адрас або імя хаста',
	'NO_MEMBERS'				=> 'Не знойдзена не аднаго карыстальніка па зададзеных крытэрах',
	'NO_MESSAGES'				=> 'Няма паведамленняў',
	'NO_MODE'					=> 'Не паказаны рэжым.',
	'NO_MODERATORS'				=> 'Мадэратары на гэтым форуме не прызначаныя.',
	'NO_NEW_MESSAGES'			=> 'Няма новых паведамленняў',
	'NO_NEW_PM'					=> 'Новых АП: <strong>0</strong>',
	'NO_NEW_POSTS'				=> 'Няма новых паведамленняў',
	'NO_ONLINE_USERS'			=> 'няма зарэгістраваных карыстальнікаў',
	'NO_POSTS'					=> 'Няма паведамленняў',
	'NO_POSTS_TIME_FRAME'		=> 'У тэме няма паведамленняў за вылучаны перыяд часу.',
	'NO_FEED_ENABLED'			=> 'Каналы навін недаступныя на гэтай канферэнцыі.',
	'NO_FEED'					=> 'Запытваемы канал навін недаступны.',
	'NO_SUBJECT'				=> 'Не паказаная тэма',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'Паказаны пошукавы механізм адсутнічае.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Метад аўтэнтыфікацыі не падтрымліваецца.',
	'NO_TOPIC'					=> 'Запытанай тэмы не існуе.',
	'NO_TOPIC_FORUM'			=> 'Дадзеная тэма або форум больш не існуе.',
	'NO_TOPICS'					=> 'У гэтым форуме няма паведамленняў.',
	'NO_TOPICS_TIME_FRAME'		=> 'У форуме няма тэм за вылучаны перыяд часу.',
	'NO_UNREAD_PM'				=> 'Няма непрачытаных паведамленняў',
	'NO_UPLOAD_FORM_FOUND'		=> 'Запампоўванне файла ініцыявана, але даступны для запампоўкі файл не знойдзены.',
	'NO_USER'					=> 'Запытваемага карыстальніка не існуе.',
	'NO_USERS'					=> 'Запытваемых карыстальнікаў не існуе.',
	'NO_USER_SPECIFIED'			=> 'Імя карыстальніка не вызначанае.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'Няма паведамленняў у чарзе',		// 0
		1			=> 'Паведамленняў у чарзе: %d',			// 1+
	),

	'OCCUPATION'				=> 'Род заняткаў',
	'OFFLINE'					=> 'Не ў сеткі',
	'ONLINE'					=> 'У сеткі',
	'ONLINE_BUDDIES'			=> 'Сябры',
	'ONLINE_USERS_TOTAL'		=> 'Наведвальнікаў: <strong>%d</strong>, з іх ',
	'ONLINE_USERS_ZERO_TOTAL'	=> 'Наведвальнікаў: <strong>0</strong>, з іх ',
	'ONLINE_USER_TOTAL'			=> 'Наведвальнікаў: <strong>%d</strong>, з іх ',
	'OPTIONS'					=> 'Налады',

	'PAGE_OF'				=> 'Старонка <strong>%1$d</strong> з <strong>%2$d</strong>',
	'PASSWORD'				=> 'Пароль',
 	'PIXEL'					=> 'пікс.',
	'PLAY_QUICKTIME_FILE'	=> 'Прайграць файл QuickTime',
	'PM'					=> 'Асабістае паведамленне',
	'POSTING_MESSAGE'		=> 'Размяшчэнне паведамлення ў форуме «%s»',
	'POSTING_PRIVATE_MESSAGE'	=> 'Стварэнне асабістага паведамлення',
	'POST'					=> 'Паведамленне',
	'POST_ANNOUNCEMENT'		=> 'Аб\'ява',
	'POST_STICKY'			=> 'Прылепленая',
	'POSTED'				=> 'Дададзена',
	'POSTED_IN_FORUM'		=> 'у',
	'POSTED_ON_DATE'		=> '',
	'POSTS'					=> 'Паведамленняў',
	'POSTS_UNAPPROVED'		=> 'Прынамсі адно паведамленне ў гэтай тэме не было праверана.',
	'POST_BY_AUTHOR'		=> '',
	'POST_BY_FOE'			=> 'Аўтарам гэтага паведамлення з\'яўляецца <strong>%1$s</strong>, змешчаны ў вашым чорным спісе. %2$sПаказаць гэтае паведамленне%3$s.',
	'POST_DAY'				=> '%.2f паведамленняў у дзень',
	'POST_DETAILS'			=> 'Інфармацыя аб паведамленні',
	'POST_NEW_TOPIC'		=> 'Пачаць новую тэму',
	'POST_PCT'				=> '%.2f%% усіх паведамленняў',
	'POST_PCT_ACTIVE'		=> '%.2f%% паведамленняў карыстальніка',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% вашых паведамленняў',
	'POST_REPLY'			=> 'Адказаць',
	'POST_REPORTED'			=> 'Праглядзець скаргу',
	'POST_SUBJECT'			=> 'Загаловак паведамлення',
	'POST_TIME'				=> 'Час размяшчэння',
	'POST_TOPIC'			=> 'Новая тэма',
	'POST_UNAPPROVED'		=> 'Гэтае паведамленне чакае праверкі',
	'PREVIEW'				=> 'Прадпрагляд',
	'PREVIOUS'				=> 'Папяр.',		// Used in pagination
	'PREVIOUS_STEP'			=> 'Назад',
	'PRIVACY'				=> 'Дамова аб прыватнасці',
	'PRIVATE_MESSAGE'		=> 'Асабістае паведамленне',
	'PRIVATE_MESSAGES'		=> 'Асабістыя паведамленні',
	'PRIVATE_MESSAGING'		=> 'Асабістыя паведамленні',
	'PROFILE'				=> 'Асабісты раздзел',

	'READING_FORUM'				=> 'Прагляд форума «%s»',
	'READING_GLOBAL_ANNOUNCE'	=> 'Чытанне агульнай аб\'явы',
	'READING_LINK'				=> 'Пераход па спасылцы форума «%s»',
	'READING_TOPIC'				=> 'Прагляд тэмы ў форуме «%s»',
	'READ_PROFILE'				=> 'Профіль',
	'REASON'					=> 'Чыннік',
	'RECORD_ONLINE_USERS'		=> 'Больш за ўсё наведвальнікаў (<strong>%1$s</strong>) тут было %2$s',
	'REDIRECT'					=> 'Перанакіраванне',
	'REDIRECTS'					=> 'Пераходаў па спасылцы',
	'REGISTER'					=> 'Рэгістрацыя',
	'REGISTERED_USERS'			=> 'Зарэгістраваныя карыстальнікі:',
	'REG_USERS_ONLINE'			=> 'Зарэгістраваных карыстальнікаў: %d і ',
	'REG_USERS_TOTAL'			=> '%d зарэгістраваных, ',
	'REG_USERS_TOTAL_AND'		=> '%d зарэгістраваных  і ',
	'REG_USERS_ZERO_ONLINE'		=> 'Зарэгістраваных карыстальнікаў: 0 і ',
	'REG_USERS_ZERO_TOTAL'		=> '0 зарэгістраваных, ',
	'REG_USERS_ZERO_TOTAL_AND'	=> '0 зарэгістраваных і ',
	'REG_USER_ONLINE'			=> 'Зарэгістраваных карыстальнікаў: %d і ',
	'REG_USER_TOTAL'			=> '%d зарэгістраваны, ',
	'REG_USER_TOTAL_AND'		=> '%d зарэгістраваны і ',
	'REMOVE'					=> 'Выдаліць',
	'REMOVE_INSTALL'			=> 'Калі ласка, выдаліце, перамесціце або пераназавіце папку install перш, чым пачнеце карыстацца канферэнцыяй. У адваротным выпадку будзе даступны толькі адміністратарскі раздзел.',
	'REPLIES'					=> 'Адказы',
	'REPLY_WITH_QUOTE'			=> 'Адказаць з цытатай',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Размяшчэнне адказу на важную аб\'яву',
	'REPLYING_MESSAGE'			=> 'Размяшчэнне адказу ў форуме «%s»',
	'REPORT_BY'					=> 'Крыніца',
	'REPORT_POST'				=> 'Паскардзіцца на гэтае паведамленне',
	'REPORTING_POST'			=> 'Размяшчэнне скаргі на паведамленне',
	'RESEND_ACTIVATION'			=> 'Паўторна выслаць ліст для актывацыі ўліковага запісу',
	'RESET'						=> 'Вярнуць',
	'RESTORE_PERMISSIONS'		=> 'Аднавіць правы доступу',
	'RETURN_INDEX'				=> '%sВярнуцца на галоўную старонку%s',
	'RETURN_FORUM'				=> '%sВярнуцца ў форум%s',
	'RETURN_PAGE'				=> '%sВярнуцца на папярэднюю старонку%s',
	'RETURN_TOPIC'				=> '%sВярнуцца ў тэму%s',
	'RETURN_TO'					=> 'Вярнуцца ў',
	'FEED'						=> 'Канал',
	'FEED_NEWS'					=> 'Навіны',
	'FEED_TOPICS_ACTIVE' 		=> 'Актыўныя тэмы',
	'FEED_TOPICS_NEW' 		=> 'Новыя тэмы',
	'RULES_ATTACH_CAN'		=> 'Вы <strong>можаце</strong> дадаваць укладанні',
	'RULES_ATTACH_CANNOT'		=> 'Вы <strong>не можаце</strong> дадаваць укладанні',
	'RULES_DELETE_CAN'		=> 'Вы <strong>можаце</strong> выдаляць свае паведамленні',
	'RULES_DELETE_CANNOT'		=> 'Вы <strong>не можаце</strong> выдаляць свае паведамленні',
	'RULES_DOWNLOAD_CAN'		=> 'Вы <strong>можаце</strong> запампоўваць укладанні',
	'RULES_DOWNLOAD_CANNOT'		=> 'Вы <strong>не можаце</strong> запампоўваць укладанні',
	'RULES_EDIT_CAN'			=> 'Вы <strong>можаце</strong> рэдагаваць свае паведамленні',
	'RULES_EDIT_CANNOT'			=> 'Вы <strong>не можаце</strong> рэдагаваць свае паведамленні',
	'RULES_LOCK_CAN'			=> 'Вы <strong>можаце</strong> зачыняць свае тэмы',
	'RULES_LOCK_CANNOT'			=> 'Вы <strong>не можаце</strong> зачыняць свае тэмы',
	'RULES_POST_CAN'			=> 'Вы <strong>можаце</strong> пачынаць тэмы',
	'RULES_POST_CANNOT'			=> 'Вы <strong>не можаце</strong> пачынаць тэмы',
	'RULES_REPLY_CAN'			=> 'Вы <strong>можаце</strong> адказваць на паведамленні',
	'RULES_REPLY_CANNOT'		=> 'Вы <strong>не можаце</strong> адказваць на паведамленні',
	'RULES_VOTE_CAN'			=> 'Вы <strong>можаце</strong> галасаваць у апытаннях',
	'RULES_VOTE_CANNOT'			=> 'Вы <strong>не можаце</strong> галасаваць у апытаннях',

	'SEARCH'					=> 'Пошук',
	'SEARCH_MINI'				=> 'Пошук…',
	'SEARCH_ADV'				=> 'Пашыраны пошук',
	'SEARCH_ADV_EXPLAIN'		=> 'Параметры пашыранага пошуку',
	'SEARCH_KEYWORDS'			=> 'Ключавыя словы',
	'SEARCHING_FORUMS'			=> 'Пошук у форумах',
	'SEARCH_ACTIVE_TOPICS'		=> 'Актыўныя тэмы',
	'SEARCH_FOR'				=> 'Знайсці',
	'SEARCH_FORUM'				=> 'Пошук у форуме…',
	'SEARCH_NEW'				=> 'Новыя паведамленні',
	'SEARCH_POSTS_BY'			=> 'Шукаць паведамленні',
	'SEARCH_SELF'				=> 'Вашы паведамленні',
	'SEARCH_TOPIC'				=> 'Пошук у тэме…',
	'SEARCH_UNANSWERED'			=> 'Паведамленні без адказаў',
	'SEARCH_UNREAD'				=> 'Непрачытаныя паведамленні',
	'SECONDS'					=> 'секунд',
	'SELECT'					=> 'Выбар',
	'SELECT_ALL_CODE'			=> 'Вылучыць усё',
	'SELECT_DESTINATION_FORUM'	=> 'Вылучыце форум прызначэння',
	'SELECT_FORUM'				=> 'Вылучыце форум',
	'SEND_EMAIL'				=> 'Адправіць email',
	'SEND_EMAIL_USER'			=> 'Адправіць ліст карыстальніку',				// Used as: {L_SEND_EMAIL_USER} {USERNAME} -> E-mail UserX
	'SEND_PRIVATE_MESSAGE'		=> 'Адправіць асабістае паведамленне',
	'SETTINGS'					=> 'Налады',
	'SIGNATURE'					=> 'Подпіс',
	'SKIP'						=> 'Прапусціць',
	'SMTP_NO_AUTH_SUPPORT'		=> 'SMTP-сервер не падтрымлівае аўтэнтыфікацыю.',
	'SORRY_AUTH_READ'			=> 'Вы не аўтарызаваныя для чытання гэтага форума.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Вы не аўтарызаваныя для запампоўкі гэтага ўкладання.',
	'SORT_BY'					=> 'Поле сартавання',
	'SORT_JOINED'				=> 'Дата рэгістрацыі',
	'SORT_LOCATION'				=> 'Адкуль',
	'SORT_RANK'					=> 'Званне',
	'SORT_POSTS'				=> 'Паведамленні',
	'SORT_TOPIC_TITLE'			=> 'Назоў тэмы',
	'SORT_USERNAME'				=> 'Імя карыстальніка',
	'SPLIT_TOPIC'				=> 'Падзяліць тэму',
	'SQL_ERROR_OCCURRED'		=> 'Адбылася памылка SQL пры выбарцы на гэтай старонцы. Калі ласка, паведаміце %sадміністратару%s, калі памылка будзе паўтарацца.',
	'STATISTICS'				=> 'Статыстыка',
	'START_WATCHING_FORUM'		=> 'Падпісацца на форум',
	'START_WATCHING_TOPIC'		=> 'Падпісацца на тэму',
	'STOP_WATCHING_FORUM'		=> 'Адпісацца ад форума',
	'STOP_WATCHING_TOPIC'		=> 'Адпісацца ад тэмы',
	'SUBFORUM'					=> 'Падфорум',
	'SUBFORUMS'					=> 'Падфорумы',
	'SUBJECT'					=> 'Загаловак',
	'SUBMIT'					=> 'Адправіць',

	'TERMS_USE'			=> 'Агульныя правілы',
	'TEST_CONNECTION'	=> 'Праверыць падлучэнне',
	'THE_TEAM'			=> 'Наша каманда',
	'TIME'				=> 'Час',

	'TOO_LONG'			=> 'Уведзенае значэнне занадта доўгае.',

	'TOO_LONG_AIM'					=> 'Імя ў AIM занадта доўгае.',
	'TOO_LONG_CONFIRM_CODE'			=> 'Уведзены код пацверджання занадта доўгі.',
	'TOO_LONG_DATEFORMAT'			=> 'Уведзены фармат даты занадта доўгі.',
	'TOO_LONG_ICQ'					=> 'Нумар ICQ занадта доўгі.',
	'TOO_LONG_INTERESTS'			=> 'Занадта доўгі радок інтарэсаў.',
	'TOO_LONG_JABBER'				=> 'Імя ўліковага запісу Jabber занадта доўгае.',
	'TOO_LONG_LOCATION'				=> 'Радок «Адкуль» занадта доўгі.',
	'TOO_LONG_MSN'					=> 'Імя ў MSN/WLM занадта доўгае.',
	'TOO_LONG_NEW_PASSWORD'			=> 'Уведзены пароль занадта доўгі.',
	'TOO_LONG_OCCUPATION'			=> 'Радок «Род заняткаў» занадта доўгі.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'Пацверджанне пароля занадта доўгае.',
	'TOO_LONG_USER_PASSWORD'		=> 'Пароль занадта доўгі.',
	'TOO_LONG_USERNAME'				=> 'Імя карыстальніка занадта доўгае.',
	'TOO_LONG_EMAIL'				=> 'Адрас email занадта доўгі.',
	'TOO_LONG_EMAIL_CONFIRM'		=> 'Пацверджанне адрасу email занадта доўгае.',
	'TOO_LONG_WEBSITE'				=> 'Адрас бачыны занадта доўгі.',
	'TOO_LONG_YIM'					=> 'Імя ў YIM занадта доўгае.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'Вы вылучылі занадта шмат варыянтаў адказу пры галасаванні.',

	'TOO_SHORT'						=> 'Уведзенае значэнне занадта кароткае.',

	'TOO_SHORT_AIM'					=> 'Імя ў AIM занадта кароткае.',
	'TOO_SHORT_CONFIRM_CODE'		=> 'Уведзены код пацверджання занадта кароткі.',
	'TOO_SHORT_DATEFORMAT'			=> 'Уведзены фармат даты занадта кароткі.',
	'TOO_SHORT_ICQ'					=> 'Нумар ICQ занадта кароткі.',
	'TOO_SHORT_INTERESTS'			=> 'Занадта кароткі радок інтарэсаў.',
	'TOO_SHORT_JABBER'				=> 'Імя ўліковага запісу Jabber занадта кароткае.',
	'TOO_SHORT_LOCATION'			=> 'Радок «Адкуль» занадта кароткая.',
	'TOO_SHORT_MSN'					=> 'Імя ў MSNM/WLM занадта кароткае.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'Уведзены пароль занадта кароткі.',
	'TOO_SHORT_OCCUPATION'			=> 'Радок «Род заняткаў» занадта кароткая.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'Пацверджанне пароля занадта кароткае.',
	'TOO_SHORT_USER_PASSWORD'		=> 'Пароль занадта кароткі.',
	'TOO_SHORT_USERNAME'			=> 'Імя карыстальніка занадта кароткае.',
	'TOO_SHORT_EMAIL'				=> 'Адрас email занадта кароткі.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'Пацверджанне адрасу email занадта кароткае.',
	'TOO_SHORT_WEBSITE'				=> 'Адрас бачыны занадта кароткі.',
	'TOO_SHORT_YIM'					=> 'Імя ў YIM занадта кароткае.',

	'TOPIC'				=> 'Тэма',
	'TOPICS'			=> 'Тэмы',
	'TOPICS_UNAPPROVED'	=> 'Прынамсі адна тэма ў гэтым форуме не была ўхваленая.',
	'TOPIC_ICON'		=> 'Значок',
	'TOPIC_LOCKED'		=> 'Гэтая тэма зачыненая, вы не можаце рэдагаваць і пакідаць паведамленні ў ёй.',
	'TOPIC_LOCKED_SHORT'=> 'Зачынена',
	'TOPIC_MOVED'		=> 'Перанесеная',
	'TOPIC_REVIEW'		=> 'Агляд тэмы',
	'TOPIC_TITLE'		=> 'Назва тэмы',
	'TOPIC_UNAPPROVED'	=> 'Дадзеная тэма не была ўхваленая',
	'TOTAL_ATTACHMENTS'	=> 'Укладанні',
	'TOTAL_LOG'			=> '1 лог',
	'TOTAL_LOGS'		=> 'Логаў: %d',
	'TOTAL_NO_PM'		=> 'Усяго 0 асабістых паведамленняў',
	'TOTAL_PM'			=> 'Усяго 1 асабістае паведамленне',
	'TOTAL_PMS'			=> 'Усяго %d асабістых паведамленняў',
	'TOTAL_POSTS'		=> 'Усяго паведамленняў',
	'TOTAL_POSTS_OTHER'	=> 'Усяго паведамленняў: <strong>%d</strong>',
	'TOTAL_POSTS_ZERO'	=> 'Усяго паведамленняў: <strong>0</strong>',
	'TOPIC_REPORTED'	=> 'На дадзеную тэму паступілі скаргі',
	'TOTAL_TOPICS_OTHER'=> 'Тэм: <strong>%d</strong>',
	'TOTAL_TOPICS_ZERO'	=> 'Тэм: <strong>0</strong>',
	'TOTAL_USERS_OTHER'	=> 'Карыстальнікаў: <strong>%d</strong>',
	'TOTAL_USERS_ZERO'	=> 'Карыстальнікаў: <strong>0</strong>',
	'TRACKED_PHP_ERROR'	=> 'Адсочанныя памылкі PHP: %s',

	'UNABLE_GET_IMAGE_SIZE'	=> 'Не атрымалася вызначыць памеры малюнка.',
	'UNABLE_TO_DELIVER_FILE'=> 'Не атрымалася даставіць файл.',
	'UNKNOWN_BROWSER'		=> 'Невядомы браўзэр',
	'UNMARK_ALL'			=> 'Зняць вылучэнне',
	'UNREAD_MESSAGES'		=> 'Непрачытаныя паведамленні',
	'UNREAD_PM'				=> 'Непрачытаных паведамленняў: <strong>%d</strong>',
	'UNREAD_PMS'			=> 'Непрачытаных паведамленняў: <strong>%d</strong>',
	'UNWATCHED_FORUMS'			=> 'Вы больш не падпісаныя на вылучаныя форумы.',
	'UNWATCHED_TOPICS'			=> 'Вы больш не падпісаныя на вылучаныя тэмы.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Вы больш не падпісаныя на вылучанае.',
	'UPDATE'				=> 'Абнавіць',
	'UPLOAD_IN_PROGRESS'	=> 'Вырабляецца запампоўка.',
	'URL_REDIRECT'			=> 'Калі ваш браўзэр не падтрымлівае аўтаматычнае перанакіраванне, %sнацісніце гэтую спасылку для пераходу%s.',
	'USERGROUPS'			=> 'Групы',
	'USERNAME'				=> 'Імя карыстальніка',
	'USERNAMES'				=> 'Імёны карыстальнікаў',
	'USER_AVATAR'			=> 'Аватара карыстальніка',
	'USER_CANNOT_READ'		=> 'Вы не можаце чытаць паведамленні ў гэтым форуме.',
	'USER_POST'				=> '%d паведамленне',
	'USER_POSTS'			=> '%d паведамленняў',
	'USERS'					=> 'Карыстальнікі',
	'USE_PERMISSIONS'		=> 'Праверыць правы карыстальніка',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Вам не дазволена выкарыстоўваць гэтую магчымасць. Верагодна, вы нядаўна зарэгістраваліся на канферэнцыі, або вам неабходна праявіць больш актыўнасьці на ёй, каб атрымаць такое права.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Праглядаў:',
	'VIEWING_FAQ'				=> 'Прагляд FAQ',
	'VIEWING_MEMBERS'			=> 'Прагляд спісу карыстальнікаў',
	'VIEWING_ONLINE'			=> 'Прагляд старонкі «Хто зараз на канферэнцыі»',
	'VIEWING_MCP'				=> 'Прагляд мадэратарскага раздзела',
	'VIEWING_MEMBER_PROFILE'	=> 'Прагляд профіля карыстальніка',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Прагляд асабістых паведамленняў',
	'VIEWING_REGISTER'			=> 'Рэгістрацыя ўліковага запісу',
	'VIEWING_UCP'				=> 'Прагляд асабістага раздзела',
	'VIEWS'						=> 'Прагляды',
	'VIEW_BOOKMARKS'			=> 'Праглядзець закладкі',
	'VIEW_FORUM_LOGS'			=> 'Праглядзець логі',
	'VIEW_LATEST_POST'			=> 'Перайсці да апошняга паведамлення',
	'VIEW_NEWEST_POST'			=> 'Перайсці да першага непрачытанага паведамлення',
	'VIEW_NOTES'				=> 'Нататкі аб карыстальніку',
	'VIEW_ONLINE_TIME'			=> 'заснавана на актыўнасці карыстальнікаў за апошнюю хвіліну',
	'VIEW_ONLINE_TIMES'			=> 'заснавана на актыўнасці карыстальнікаў за апошнія %d хвілін',
	'VIEW_TOPIC'				=> 'Прагляд тэмы',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Аб\'ява: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Важная: ',
	'VIEW_TOPIC_LOCKED'			=> 'Зачынена: ',
	'VIEW_TOPIC_LOGS'			=> 'Прагляд логаў',
	'VIEW_TOPIC_MOVED'			=> 'Перамешчаная: ',
	'VIEW_TOPIC_POLL'			=> 'Апытанне: ',
	'VIEW_TOPIC_STICKY'			=> 'Прылепленая: ',
	'VISIT_WEBSITE'				=> 'Перайсці на бачыну',

	'WARNINGS'			=> 'Папярэджанні',
	'WARN_USER'			=> 'Вынесці папярэджанне',
	'WELCOME_SUBJECT'	=> 'Сардэчна запрашаем на канферэнцыю «%s»',
	'WEBSITE'			=> 'Бачына',
	'WHOIS'				=> 'Інфармацыя аб IP-адрасе',
	'WHO_IS_ONLINE'		=> 'Хто зараз на канферэнцыі',
	'WRONG_PASSWORD'	=> 'Вы ўвялі няслушны пароль.',

	'WRONG_DATA_ICQ'			=> 'Уведзены нумар не з\'яўляюцца правільным нумарам ICQ.',
	'WRONG_DATA_JABBER'			=> 'Уведзенае імя не з\'яўляецца правільным імем Jabber.',
	'WRONG_DATA_LANG'			=> 'Паказаны няправільная мова.',
	'WRONG_DATA_WEBSITE'		=> 'Адрас бачыны павінен быць правільнай спасылкай, уключальнай найменне пратаколу. Напрыклад, http://www.example.com/.',
	'WROTE'						=> 'пісаў(а)',

	'YEAR'				=> 'Год',
	'YEAR_MONTH_DAY'	=> '(ГГГГ-ММ-ДД)',
	'YES'				=> 'Так',
	'YIM'				=> 'YIM',
	'YOU_LAST_VISIT'	=> 'Папярэдняе наведванне: %s',
	'YOU_NEW_PM'		=> 'Вам дашло новае асабістае паведамленне.',
	'YOU_NEW_PMS'		=> 'Вам дашлі новыя асабістыя паведамленні.',
	'YOU_NO_NEW_PM'		=> 'У вас няма новых асабістых паведамленняў.',

	'datetime'			=> array(
		'TODAY'		=> 'Сёння',
		'TOMORROW'	=> 'Заўтра',
		'YESTERDAY'	=> 'Учора',

		'AGO'		=> array(
			0		=> 'меней хвіліны назад',
			1		=> '%d хвіліну назад',
			2		=> '%d хвіліны назад',
			5		=> '%d хвілін назад',
			21		=> '%d хвіліну назад',
			22		=> '%d хвіліны назад',
			25		=> '%d хвілін назад',
			31		=> '%d хвіліну назад',
			32		=> '%d хвіліны назад',
			35		=> '%d хвілін назад',
			41		=> '%d хвіліну назад',
			42		=> '%d хвіліны назад',
			45		=> '%d хвілін назад',
			51		=> '%d хвіліну назад',
			52		=> '%d хвіліны назад',
			55		=> '%d хвілін назад',
			60		=> '1 гадзіна назад',
		),

		'Sunday'	=> 'Нядзеля',
		'Monday'	=> 'Панядзелак',
		'Tuesday'	=> 'Аўторак',
		'Wednesday'	=> 'Серада',
		'Thursday'	=> 'Чацвер',
		'Friday'	=> 'Пятніца',
		'Saturday'	=> 'Субота',

		'Sun'		=> 'Нд',
		'Mon'		=> 'Пн',
		'Tue'		=> 'Ат',
		'Wed'		=> 'Ср',
		'Thu'		=> 'Чц',
		'Fri'		=> 'Пт',
		'Sat'		=> 'Сб',

		'January'	=> 'Студзень',
		'February'	=> 'Люты',
		'March'		=> 'Сакавік',
		'April'		=> 'Красавік',
		'May'		=> 'Травень',
		'June'		=> 'Чэрвень',
		'July'		=> 'Ліпень',
		'August'	=> 'Жнівень',
		'September'	=> 'Верасень',
		'October'	=> 'Кастрычнік',
		'November'	=> 'Лістапад',
		'December'	=> 'Снежань',

		'Jan'		=> 'сту',
		'Feb'		=> 'лют',
		'Mar'		=> 'сак',
		'Apr'		=> 'кра',
		'May_short'	=> 'тра',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'чэр',
		'Jul'		=> 'ліп',
		'Aug'		=> 'жні',
		'Sep'		=> 'вер',
		'Oct'		=> 'кас',
		'Nov'		=> 'ліс',
		'Dec'		=> 'сне',
	),

	'tz'				=> array(
		'-12'	=> 'UTC - 12 гадзін',
		'-11'	=> 'UTC - 11 гадзін',
		'-10'	=> 'UTC - 10 гадзін',
		'-9.5'	=> 'UTC - 9:30 гадзін',
		'-9'	=> 'UTC - 9 гадзін',
		'-8'	=> 'UTC - 8 гадзін',
		'-7'	=> 'UTC - 7 гадзін',
		'-6'	=> 'UTC - 6 гадзін',
		'-5'	=> 'UTC - 5 гадзін',
		'-4.5'	=> 'UTC - 4:30 гадзіны',
		'-4'	=> 'UTC - 4 гадзіны',
		'-3.5'	=> 'UTC - 3:30 гадзіны',
		'-3'	=> 'UTC - 3 гадзіны',
		'-2'	=> 'UTC - 2 гадзіны',
		'-1'	=> 'UTC - 1 гадзіна',
		'0'		=> 'UTC',
		'1'		=> 'UTC + 1 гадзіна',
		'2'		=> 'UTC + 2 гадзіны',
		'3'		=> 'UTC + 3 гадзіны',
		'3.5'	=> 'UTC + 3:30 гадзіны',
		'4'		=> 'UTC + 4 гадзіны',
		'4.5'	=> 'UTC + 4:30 гадзіны',
		'5'		=> 'UTC + 5 гадзін',
		'5.5'	=> 'UTC + 5:30 гадзін',
		'5.75'	=> 'UTC + 5:45 гадзін',
		'6'		=> 'UTC + 6 гадзін',
		'6.5'	=> 'UTC + 6:30 гадзін',
		'7'		=> 'UTC + 7 гадзін',
		'8'		=> 'UTC + 8 гадзін',
		'8.75'	=> 'UTC + 8:45 гадзін',
		'9'		=> 'UTC + 9 гадзін',
		'9.5'	=> 'UTC + 9:30 гадзін',
		'10'	=> 'UTC + 10 гадзін',
		'10.5'	=> 'UTC + 10:30 гадзін',
		'11'	=> 'UTC + 11 гадзін',
		'11.5'	=> 'UTC + 11:30 гадзін',
		'12'	=> 'UTC + 12 гадзін',
		'12.75'	=> 'UTC + 12:45 гадзін',
		'13'	=> 'UTC + 13 гадзін',
		'14'	=> 'UTC + 14 гадзін',
		'dst'	=> '[ Летні час ]',
	),

	'tz_zones'	=> array(
		'-12'	=> '[UTC - 12] Мерыдыян змены дат (захад)',
		'-11'	=> '[UTC - 11] о. Мідуэй, Самоа',
		'-10'	=> '[UTC - 10] Гаваі',
		'-9.5'	=> '[UTC - 9:30] Маркізскія абтокі',
		'-9'	=> '[UTC - 9] Аляска',
		'-8'	=> '[UTC - 8] Ціхаакіянскі час (ЗША і Канада) і Ціхуана',
		'-7'	=> '[UTC - 7] Арызона',
		'-6'	=> '[UTC - 6] Мехіка, Цэнтральная Амерыка, Цэнтральны час (ЗША і Канада)',
		'-5'	=> '[UTC - 5] Індыяна (усход), Усходні час (ЗША і Канада)',
		'-4.5'	=> '[UTC - 4:30] Венесуэла',
		'-4'	=> '[UTC - 4] Каракас, Сант\'яга, Атлантычны час (Канада)',
		'-3.5'	=> '[UTC - 3:30] Ньюфаундлэнд',
		'-3'	=> '[UTC - 3] Бразілія, Грэнландыя',
		'-2'	=> '[UTC - 2] Сярэдняатлантычны час',
		'-1'	=> '[UTC - 1] Азорскія абтокі, абтокі Зялёнага мыса',
		'0'		=> '[UTC] Час па Грынвічы: Дублін, Лондан, Лісабон, Эдынбург',
		'1'		=> '[UTC + 1] Берлін, Мадрыд, Парыж, Рым, Заходняя Цэнтральная Афрыка',
		'2'		=> '[UTC + 2] Афіны, Вільнюс, Кіеў, Менск, Рыга, Талін, Цэнтральная Афрыка',
		'3'		=> '[UTC + 3] Валгаград, Масква, Санкт-Пецярбург',
		'3.5'	=> '[UTC + 3:30] Тэгеран',
		'4'		=> '[UTC + 4] Баку, Ерэван, Самара, Тбілісі',
		'4.5'	=> '[UTC + 4:30] Кабул',
		'5'		=> '[UTC + 5] Екацярынбург, Ісламабад, Карачы, Арэнбург, Ташкент',
		'5.5'	=> '[UTC + 5:30] Бамбей, Калькута, Мадрас, Нью-Дзелі',
		'5.75'	=> '[UTC + 5:45] Катманду',
		'6'		=> '[UTC + 6] Алматы, Астана, Навасібірск, Омск',
		'6.5'	=> '[UTC + 6:30] Рангун',
		'7'		=> '[UTC + 7] Бангкок, Краснаярск',
		'8'		=> '[UTC + 8] Ганконг, Іркуцк, Пекін, Сінгапур',
		'8.75'	=> '[UTC + 8:45] Паўднёваўсходняя Заходняя Аўстралія',
		'9'		=> '[UTC + 9] Токіо, Сеўл, Чыта, Якуцк',
		'9.5'	=> '[UTC + 9:30] Дарвін',
		'10'	=> '[UTC + 10] Уладзівасток, Канбера, Мельбурн, Сіднэй',
		'10.5'	=> '[UTC + 10:30] Лорд-Хаў',
		'11'	=> '[UTC + 11] Магадан, Сахалін, Саламонавы аб-у',
		'11.5'	=> '[UTC + 11:30] Абток Нарфолк',
		'12'	=> '[UTC + 12] Камчатка, Новая Зеландыя, Фіджы',
		'12.75'	=> '[UTC + 12:45] Абтокі Чацем',
		'13'	=> '[UTC + 13] Абтокі Фенікс, Тонга',
		'14'	=> '[UTC + 14] Абток Лайн',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '10 сту 2005, 17:57',
		'd M Y H:i'				=> '10 сту 2005 17:57',
		'M jS, \'y, H:i'		=> 'Сту 1, \'07, 13:37',
		'D M d, Y g:i a'		=> 'Пн сту 10, 2005 5:57 pm',
		'F jS, Y, g:i a'		=> 'Студзень 1, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> 'Сёння, 13:37 / 01 Сту 2007, 13:37',
		'|F jS, Y|, g:i a'		=> 'Сёння, 1:37 pm / Студзень 1, 2007, 1:37 pm'
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=>'|d M Y|, H:i'// Сёння, 13:37 / 01 Сту 2007, 13:37

));

?>
