.\" $XdotOrg: $
.\" 
.\" Copyright \(co Digital Equipment Corporation, 1996
.\" 
.\" Permission to use, copy, modify, distribute, and sell this
.\" documentation for any purpose is hereby granted without fee,
.\" provided that the above copyright notice and this permission
.\" notice appear in all copies.  Digital Equipment Corporation
.\" makes no representations about the suitability for any purpose
.\" of the information in this document.  This documentation is
.\" provided ``as is'' without express or implied warranty.
.\"
.\" Copyright 1999, 2005 Sun Microsystems, Inc.  All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.\" X Window System is a trademark of The Open Group.
.\" 
.TH DPMSGetVersion __libmansuffix__ __xorgversion__ "X FUNCTIONS"
.SH NAME
DPMSGetVersion \- returns the version of the DPMS extension implemented by
the X server
.SH SYNOPSIS
.PP
.nf
\fBcc\fR [ \fIflag\fR \&.\&.\&. ] \fIfile\fR \&.\&.\&. -\fBlXext\fR [ \fIlibrary\fR \&.\&.\&. ]
\&#include <X11/extensions/dpms.h>
.HP
.B Status DPMSGetVersion
(
.br
      Display *\fIdisplay\fP\^,
.br
      int *\fImajor_version\fP\^,
.br
      int *\fIminor_version\fP\^ 
);
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I display
Specifies the connection to the X server
.TP
.I major_version
Specifies the return location for the extension major version
.TP
.I minor_version
Specifies the return location for the extension minor version
.SH DESCRIPTION
.LP
The 
.I DPMSGetVersion 
function returns the version of the Display Power Management Signaling (DPMS)
extension implemented by the X server.  It returns a major and minor version 
number. The major version number will be incremented for protocol incompatible
changes, and the minor version number will be incremented for small, upward 
compatible changes.
.SH "RETURN VALUES"
.TP 15
TRUE
The 
.I DPMSGetVersion 
function returns TRUE when the extension is supported and values are returned.
.TP 15
FALSE
The 
.I DPMSGetVersion 
function returns FALSE when the extension is not supported.
.SH "SEE ALSO"
.BR DPMSCapable (__libmansuffix__),
.BR DPMSQueryExtension (__libmansuffix__)
