/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _authinfo_h_
#define _authinfo_h_

#include "url.h"
#include "dllist.h"

typedef struct {
	protocol	prot;
	char		*host;
	int		port;
	char		*user;
	char		*pass;	
	char		*base;
	char		*realm;
	int		type;
} authinfo;

extern dllist *authdata;

extern int authinfo_load(char *);
extern int authinfo_save(char *);
extern authinfo *authinfo_match_entry(protocol , char * , int , char * , char *);

#define free_deep_authinfo(entry)\
        _free((entry)->pass);\
        _free((entry)->user);\
        _free((entry)->host);\
        _free((entry)->base);\
        _free(entry);


#endif

