/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#ifndef _CardBoxP_H_
#define _CardBoxP_H_

#include <Nws/BaseConstP.h>
#include <X11/CoreP.h>

#include <Nws/CardBox.h>

typedef struct {
	Widget button;
	Widget box;
} Associated_pair;

typedef struct {
	char empty;
} CardBoxClassPart;

typedef struct _CardBoxClassRec{
	CoreClassPart		core_class;
	CompositeClassPart	composite_class;
	ConstraintClassPart	constraint_class;
	BaseConstClassPart	baseConst_class;
	CardBoxClassPart	cardBox_class;
} CardBoxClassRec;

typedef struct {
	/* resources */
	String 		* button_labels;
	XFontStruct 	* font;
	Pixel		card_background;
	int		number_of_buttons;
	XtCallbackList	switch_;
	/* hidden */
	Associated_pair	* pairs;
	int		activated;
	Boolean 	initializing;
	Widget		bBox;
} CardBoxPart;

typedef struct _CardBoxConstraintsPart {
	String		associated_button;
} CardBoxConstraintsPart;

typedef struct _CardBoxConstraintsRec {
	CardBoxConstraintsPart 	cardBox;
} CardBoxConstraintsRec, *CardBoxConstraints;
 
typedef struct _CardBoxRec {
	CorePart		core;
	CompositePart 		composite;
	ConstraintPart		constraint;
	BaseConstPart		baseConst;
	CardBoxPart		cardBox;
} CardBoxRec;

extern CardBoxClassRec cardBoxClassRec;

#endif
