/* fcpwrap - fsh wrapper for use with scp
   Copyright (C) 1999 by Andreas Sigfridsson

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include <stdlib.h>
#include <string.h>
#include <unistd.h>

/*
	ssh    [-a]    [-c    idea|blowfish|des|3des|arcfour|none]
	[-e escape_char] [-i identity_file]  [-l login_name]  [-n]
	[-k]  [-V]  [-o option] [-p port] [-q] [-P] [-t] [-v] [-x]
	[-C] [-g] [-L port:host:hostport]  [-R port:host:hostport]
	hostname [command]
*/

int main (int argc, char *argv [])
{
	 int i, j;
	 char *args = "ceilopLR";	/* All flags that take one argument */
	 char *login = 0;
	 char **newArgv;
	 int numArgs;

	 /* Skip all ssh specific flags, but not the "-l" flag used by fsh */
	 for (i = 1; i < argc; i++)
	 {
		 if (argv [i][0] != '-')	/* Non-flag? */
			 break;
		 if (argv [i][1] == 'l')	/* fsh login flag? */
		 {
			 login = argv [++i];
			 continue;
		 }
		 if (strchr (args, argv [i][1]))	/* Flag with one arg */
			 i++;
		 /* Assume other flags to take no arguments */
	 }

	 /* Build a new argument table */
	 numArgs = 1 + argc - i + (login ? 2 : 0) + 1;
	 /* command, arguments and null pointer */
	 newArgv = (char**) malloc (numArgs * sizeof (char**));
	 newArgv [0] = "fsh";
	 if (login)
	 {
		 newArgv [1] = "-l";
		 newArgv [2] = login;
	 }
	 for (j = 1 + (login ? 2 : 0); j < numArgs; i++, j++)
		 newArgv [j] = argv [i];

	 return execvp ("fsh", newArgv);
}
