//
// $Id$
//
//
// Original author: Kate Hoff <Katherine.Hoff@cshs.org>
//
// Copyright 2008 Spielberg Family Center for Applied Proteomics
//   Cedars-Sinai Medical Cnter, Los Angeles, California  90048
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and 
// limitations under the License.
//
                                                                                                     
#ifndef _FEATUREDETECTOR_HPP_
#define _FEATUREDETECTOR_HPP_


#include "MZRTField.hpp"
#include "pwiz/utility/misc/Export.hpp"
#include "pwiz/data/msdata/MSData.hpp"
#include "pwiz/data/misc/PeakData.hpp"

namespace pwiz {
namespace analysis {

using namespace pwiz::data::peakdata;

class PWIZ_API_DECL FeatureDetector

{

public:

  typedef msdata::MSData MSData;
  typedef data::peakdata::Feature Feature;

  virtual void detect(const MSData& msd, FeatureField& result) const = 0; 
  
  virtual ~FeatureDetector(){}

};


} // namespace analysis
} // namespace pwiz




#endif  
