
#include <glib.h>
#include "libindicate/indicator.h"
#include "libindicate/server.h"
#include "libindicate/interests.h"

#define MAX_INDICATOR_COUNT 100

static gboolean passed = TRUE;
static GMainLoop * mainloop = NULL;
static int count = 0;


static void
indicator_displayed (IndicateIndicator * indicator, gboolean displayed, gpointer user_data)
{
	g_debug("Indicator displayed: %s", displayed ? "true" : "false");
	if (displayed) {
		count++;
	}

	return;
}

static gboolean
done_timeout_cb (gpointer data)
{
	g_debug("%d of %d indicators displayed", count, MAX_INDICATOR_COUNT);
	if (count != MAX_INDICATOR_COUNT) {
		passed = FALSE;
	}
	g_main_loop_quit(mainloop);
	return FALSE;
}

static guint indicators = 0;
static gboolean
idle_func (gpointer data)
{
	if (indicators == MAX_INDICATOR_COUNT) {
		return FALSE;
	}

	indicators++;
	IndicateIndicator * indicator = indicate_indicator_new();
	g_signal_connect(G_OBJECT(indicator), INDICATE_INDICATOR_SIGNAL_DISPLAYED, G_CALLBACK(indicator_displayed), NULL);
	indicate_indicator_show(indicator);

	return TRUE;
}

int
main (int argc, char * argv)
{
	g_type_init();

	g_idle_add(idle_func, NULL);
	g_timeout_add(MAX_INDICATOR_COUNT * 10, done_timeout_cb, NULL);

	mainloop = g_main_loop_new(NULL, FALSE);
	g_main_loop_run(mainloop);

	return !passed;
}
