#define MNEMONIC_BITS 10
#define SUFFIX_BITS 3
#define FCT1_BITS 7
#define STR1_BITS 4
#define OFF1_1_BITS 7
#define OFF1_1_BIAS 3
#define OFF1_2_BITS 7
#define OFF1_2_BIAS 4
#define OFF1_3_BITS 1
#define OFF1_3_BIAS 7
#define FCT2_BITS 6
#define STR2_BITS 2
#define OFF2_1_BITS 7
#define OFF2_1_BIAS 5
#define OFF2_2_BITS 7
#define OFF2_2_BIAS 4
#define OFF2_3_BITS 4
#define OFF2_3_BIAS 7
#define FCT3_BITS 4
#define STR3_BITS 1
#define OFF3_1_BITS 6
#define OFF3_1_BIAS 10
#define OFF3_2_BITS 1
#define OFF3_2_BIAS 21

#include <i386_data.h>

#define suffix_none 0
#define suffix_w 1
#define suffix_w0 2
#define suffix_W 3
#define suffix_tttn 4
#define suffix_D 7
#define suffix_w1 5
#define suffix_W1 6

static const opfct_t op1_fct[] =
{
  NULL,
  FCT_MOD$R_M,
  FCT_Mod$R_m,
  FCT_abs,
  FCT_ax,
  FCT_ax$w,
  FCT_ccc,
  FCT_ddd,
  FCT_disp8,
  FCT_ds_bx,
  FCT_ds_si,
  FCT_dx,
  FCT_es_di,
  FCT_freg,
  FCT_imm$s,
  FCT_imm$w,
  FCT_imm16,
  FCT_imm64$w,
  FCT_imm8,
  FCT_imms8,
  FCT_mmxreg,
  FCT_mod$16r_m,
  FCT_mod$64r_m,
  FCT_mod$8r_m,
  FCT_mod$r_m,
  FCT_mod$r_m$w,
  FCT_reg,
  FCT_reg$w,
  FCT_reg64,
  FCT_rel,
  FCT_sel,
  FCT_sreg2,
  FCT_sreg3,
  FCT_string,
  FCT_xmmreg,
};
static const char op1_str[] =
  "%ax\0"
  "%cl\0"
  "%rax\0"
  "%st\0"
  "%xmm0\0"
  "*";
static const uint8_t op1_str_idx[] = {
  0,
  4,
  8,
  13,
  17,
  23,
};
static const opfct_t op2_fct[] =
{
  NULL,
  FCT_MOD$R_M,
  FCT_Mod$R_m,
  FCT_abs,
  FCT_absval,
  FCT_ax$w,
  FCT_ccc,
  FCT_ddd,
  FCT_ds_si,
  FCT_dx,
  FCT_es_di,
  FCT_freg,
  FCT_imm8,
  FCT_mmxreg,
  FCT_mod$64r_m,
  FCT_mod$r_m,
  FCT_mod$r_m$w,
  FCT_oreg,
  FCT_oreg$w,
  FCT_reg,
  FCT_reg$w,
  FCT_reg64,
  FCT_sreg3,
  FCT_string,
  FCT_xmmreg,
};
static const char op2_str[] =
  "%rcx\0"
  "%st";
static const uint8_t op2_str_idx[] = {
  0,
  5,
};
static const opfct_t op3_fct[] =
{
  NULL,
  FCT_mmxreg,
  FCT_mod$r_m,
  FCT_reg,
  FCT_string,
  FCT_xmmreg,
};
static const char op3_str[] =
  "%rdx";
static const uint8_t op3_str_idx[] = {
  0,
};
static const struct instr_enc instrtab[] =
{
  { .mnemonic = MNE_adc, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 15, .str1 = 0, .off1_1 = 5, .off1_2 = 3, .off1_3 = 0, .fct2 = 5, .str2 = 0, .off2_1 = 11, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_adc, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 15, .str1 = 0, .off1_1 = 13, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_adc, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 19, .str1 = 0, .off1_1 = 13, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_adc, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 27, .str1 = 0, .off1_1 = 7, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_adc, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 20, .str2 = 0, .off2_1 = 5, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_add, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 15, .str1 = 0, .off1_1 = 5, .off1_2 = 3, .off1_3 = 0, .fct2 = 5, .str2 = 0, .off2_1 = 11, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_add, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 15, .str1 = 0, .off1_1 = 13, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_add, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 19, .str1 = 0, .off1_1 = 13, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_add, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 27, .str1 = 0, .off1_1 = 7, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_add, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 20, .str2 = 0, .off2_1 = 5, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_addsubpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_addsubps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_and, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 15, .str1 = 0, .off1_1 = 5, .off1_2 = 3, .off1_3 = 0, .fct2 = 5, .str2 = 0, .off2_1 = 11, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_and, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 15, .str1 = 0, .off1_1 = 13, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_and, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 19, .str1 = 0, .off1_1 = 13, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_and, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 27, .str1 = 0, .off1_1 = 7, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_and, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 20, .str2 = 0, .off2_1 = 5, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_andpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_andps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_andnpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_andnps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movslq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 21, .str2 = 0, .off2_1 = 5, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_bsf, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_bsr, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_bswap, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 26, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_bt, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 26, .str1 = 0, .off1_1 = 15, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_bt, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 21, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_btc, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 26, .str1 = 0, .off1_1 = 15, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_btc, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 21, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_btr, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 26, .str1 = 0, .off1_1 = 15, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_btr, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 21, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_bts, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 26, .str1 = 0, .off1_1 = 15, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_bts, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 21, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_call, .rep = 0, .repe = 0, .suffix = 3, .modrm = 0, .fct1 = 29, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_call, .rep = 0, .repe = 0, .suffix = 3, .modrm = 1, .fct1 = 22, .str1 = 6, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_lcall, .rep = 0, .repe = 0, .suffix = 3, .modrm = 1, .fct1 = 22, .str1 = 6, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_INVALID, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_INVALID, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_clc, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cld, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cli, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_syscall, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_clts, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sysret, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sysenter, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sysexit, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmc, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmov, .rep = 0, .repe = 0, .suffix = 4, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 15, .str1 = 0, .off1_1 = 5, .off1_2 = 3, .off1_3 = 0, .fct2 = 5, .str2 = 0, .off2_1 = 11, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmp, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 15, .str1 = 0, .off1_1 = 13, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmp, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 19, .str1 = 0, .off1_1 = 13, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 27, .str1 = 0, .off1_1 = 7, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 20, .str2 = 0, .off2_1 = 5, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_INVALID, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_INVALID, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_INVALID, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_INVALID, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmps, .rep = 0, .repe = 1, .suffix = 1, .modrm = 0, .fct1 = 12, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 8, .str2 = 0, .off2_1 = 3, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmpxchg, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 27, .str1 = 0, .off1_1 = 15, .off1_2 = 11, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 8, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_INVALID, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cpuid, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvtdq2pd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvtpd2dq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvttpd2dq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_dec, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_div, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_emms, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_enter, .rep = 0, .repe = 0, .suffix = 3, .modrm = 0, .fct1 = 16, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 12, .str2 = 0, .off2_1 = 19, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fnop, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fchs, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fabs, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_ftst, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fxam, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fld1, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fldl2t, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fldl2e, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fldpi, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fldlg2, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fldln2, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fldz, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_f2xm1, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fyl2x, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fptan, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fpatan, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fxtract, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fprem1, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fdecstp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fincstp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fprem, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fyl2xp1, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fsqrt, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fsincos, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_frndint, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fscale, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fsin, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcos, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fadd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fadd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 33, .str1 = 4, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 11, .str2 = 0, .off2_1 = 8, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fadd, .rep = 0, .repe = 0, .suffix = 7, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fmul, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fmul, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 33, .str1 = 4, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 11, .str2 = 0, .off2_1 = 8, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fmul, .rep = 0, .repe = 0, .suffix = 7, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fsub, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fsub, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 33, .str1 = 4, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 11, .str2 = 0, .off2_1 = 8, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fsub, .rep = 0, .repe = 0, .suffix = 7, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fsubr, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fsubr, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 33, .str1 = 4, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 11, .str2 = 0, .off2_1 = 8, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fsubr, .rep = 0, .repe = 0, .suffix = 7, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fst, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fst, .rep = 0, .repe = 0, .suffix = 7, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fstp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fstp, .rep = 0, .repe = 0, .suffix = 7, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fldenv, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fldcw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fnstenv, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fnstcw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fxch, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_faddp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 33, .str1 = 4, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 11, .str2 = 0, .off2_1 = 8, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcmovb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fiadd, .rep = 0, .repe = 0, .suffix = 5, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcmove, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fmulp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 33, .str1 = 4, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 11, .str2 = 0, .off2_1 = 8, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fimul, .rep = 0, .repe = 0, .suffix = 5, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fsubp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 33, .str1 = 4, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 11, .str2 = 0, .off2_1 = 8, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fisub, .rep = 0, .repe = 0, .suffix = 5, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fsubrp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 33, .str1 = 4, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 11, .str2 = 0, .off2_1 = 8, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fisubr, .rep = 0, .repe = 0, .suffix = 5, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fnstsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 33, .str1 = 1, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fbld, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcomip, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fbstp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fchs, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fclex, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_finit, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fwait, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fnclex, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcmovb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcmove, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcmovbe, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcmovu, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcmovnb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcmovne, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcmovnbe, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcmovnu, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcom, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcom, .rep = 0, .repe = 0, .suffix = 7, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcomp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcomp, .rep = 0, .repe = 0, .suffix = 7, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcompp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcomi, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcomip, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fucomi, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fucomip, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcos, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fdecstp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fdiv, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fdiv, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 33, .str1 = 4, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 11, .str2 = 0, .off2_1 = 8, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fdiv, .rep = 0, .repe = 0, .suffix = 7, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fidivl, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fdivp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 33, .str1 = 4, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 11, .str2 = 0, .off2_1 = 8, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fidiv, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fdivrp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 33, .str1 = 4, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 11, .str2 = 0, .off2_1 = 8, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fdivr, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 2, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fdivr, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 33, .str1 = 4, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 11, .str2 = 0, .off2_1 = 8, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fdivr, .rep = 0, .repe = 0, .suffix = 7, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fidivrl, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fidivr, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fdivrp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 33, .str1 = 4, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 11, .str2 = 0, .off2_1 = 8, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_ffree, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcmovbe, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_ficom, .rep = 0, .repe = 0, .suffix = 5, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fcmovu, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_ficomp, .rep = 0, .repe = 0, .suffix = 5, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fild, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fildl, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fildll, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fincstp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fninit, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fist, .rep = 0, .repe = 0, .suffix = 5, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fistp, .rep = 0, .repe = 0, .suffix = 5, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fistpll, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fisttp, .rep = 0, .repe = 0, .suffix = 5, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fisttpll, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fldt, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fstpt, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fld, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fld, .rep = 0, .repe = 0, .suffix = 7, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fucom, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_frstor, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fucomp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 13, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fnsave, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fnstsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_hlt, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_idiv, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_imul, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_imul, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_imul, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 14, .str1 = 0, .off1_1 = 13, .off1_2 = 2, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 3, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_in, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 5, .str2 = 0, .off2_1 = 11, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_in, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 11, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 5, .str2 = 0, .off2_1 = 3, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_inc, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_ins, .rep = 1, .repe = 0, .suffix = 1, .modrm = 0, .fct1 = 11, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 10, .str2 = 0, .off2_1 = 3, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_int, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_int3, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_invd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_swapgs, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_invlpg, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_iret, .rep = 0, .repe = 0, .suffix = 6, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_j, .rep = 0, .repe = 0, .suffix = 4, .modrm = 0, .fct1 = 8, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_j, .rep = 0, .repe = 0, .suffix = 4, .modrm = 0, .fct1 = 29, .str1 = 0, .off1_1 = 13, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_set, .rep = 0, .repe = 0, .suffix = 4, .modrm = 1, .fct1 = 23, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_INVALID, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 8, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_jmp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 8, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_jmp, .rep = 0, .repe = 0, .suffix = 3, .modrm = 0, .fct1 = 29, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_jmp, .rep = 0, .repe = 0, .suffix = 3, .modrm = 1, .fct1 = 22, .str1 = 6, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_ljmp, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 30, .str1 = 0, .off1_1 = 37, .off1_2 = 0, .off1_3 = 0, .fct2 = 4, .str2 = 0, .off2_1 = 3, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_ljmp, .rep = 0, .repe = 0, .suffix = 3, .modrm = 1, .fct1 = 22, .str1 = 6, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_lahf, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_lar, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 21, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_lea, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 5, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_leave, .rep = 0, .repe = 0, .suffix = 3, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_lfs, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_lgs, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_lgdt, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_lidt, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_lldt, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 21, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_lmsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 21, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_lock, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_lods, .rep = 1, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 10, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 5, .str2 = 0, .off2_1 = 3, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_loop, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 8, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_loope, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 8, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_loopne, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 8, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_lsl, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 21, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_lss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_ltr, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 21, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_mov, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 27, .str1 = 0, .off1_1 = 7, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_mov, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 20, .str2 = 0, .off2_1 = 5, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_mov, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 15, .str1 = 0, .off1_1 = 13, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_mov, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 17, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 18, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_mov, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 3, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 5, .str2 = 0, .off2_1 = 35, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_mov, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 5, .str1 = 0, .off1_1 = 37, .off1_2 = 3, .off1_3 = 0, .fct2 = 3, .str2 = 0, .off2_1 = 3, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_mov, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 6, .str1 = 0, .off1_1 = 15, .off1_2 = 0, .off1_3 = 0, .fct2 = 21, .str2 = 0, .off2_1 = 16, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_mov, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 28, .str1 = 0, .off1_1 = 18, .off1_2 = 0, .off1_3 = 0, .fct2 = 6, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_mov, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 7, .str1 = 0, .off1_1 = 15, .off1_2 = 0, .off1_3 = 0, .fct2 = 21, .str2 = 0, .off2_1 = 16, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_mov, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 28, .str1 = 0, .off1_1 = 18, .off1_2 = 0, .off1_3 = 0, .fct2 = 7, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_mov, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 32, .str1 = 0, .off1_1 = 7, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_mov, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 22, .str2 = 0, .off2_1 = 5, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movs, .rep = 1, .repe = 0, .suffix = 1, .modrm = 0, .fct1 = 10, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 10, .str2 = 0, .off2_1 = 3, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movsbl, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 23, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movswl, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 21, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movzbl, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 23, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movzwl, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 21, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_mul, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_neg, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pause, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_INVALID, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_popcnt, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_not, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_or, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 27, .str1 = 0, .off1_1 = 7, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_or, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 20, .str2 = 0, .off2_1 = 5, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_or, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 15, .str1 = 0, .off1_1 = 13, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_or, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 19, .str1 = 0, .off1_1 = 13, .off1_2 = 0, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_or, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 15, .str1 = 0, .off1_1 = 5, .off1_2 = 3, .off1_3 = 0, .fct2 = 5, .str2 = 0, .off2_1 = 11, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_out, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 5, .str1 = 0, .off1_1 = 13, .off1_2 = 3, .off1_3 = 0, .fct2 = 12, .str2 = 0, .off2_1 = 3, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_out, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 5, .str1 = 0, .off1_1 = 5, .off1_2 = 3, .off1_3 = 0, .fct2 = 9, .str2 = 0, .off2_1 = 3, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_outs, .rep = 1, .repe = 0, .suffix = 1, .modrm = 0, .fct1 = 10, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 9, .str2 = 0, .off2_1 = 3, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pop, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 28, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pop, .rep = 0, .repe = 0, .suffix = 3, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pop, .rep = 0, .repe = 0, .suffix = 3, .modrm = 0, .fct1 = 32, .str1 = 0, .off1_1 = 7, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_popf, .rep = 0, .repe = 0, .suffix = 3, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_push, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 28, .str1 = 0, .off1_1 = 10, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pushq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_push, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 28, .str1 = 0, .off1_1 = 2, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pop, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 28, .str1 = 0, .off1_1 = 2, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_push, .rep = 0, .repe = 0, .suffix = 3, .modrm = 0, .fct1 = 14, .str1 = 0, .off1_1 = 5, .off1_2 = 2, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_push, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 31, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_push, .rep = 0, .repe = 0, .suffix = 3, .modrm = 0, .fct1 = 32, .str1 = 0, .off1_1 = 7, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pushf, .rep = 0, .repe = 0, .suffix = 3, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_rcl, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_rcl, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 33, .str1 = 2, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_rcl, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 13, .off1_2 = 0, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_rcr, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_rcr, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 33, .str1 = 2, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_rcr, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 13, .off1_2 = 0, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_rdmsr, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_rdpmc, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_rdtsc, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_ret, .rep = 0, .repe = 0, .suffix = 3, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_ret, .rep = 0, .repe = 0, .suffix = 3, .modrm = 0, .fct1 = 16, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_lret, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_lret, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 16, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_rol, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_rol, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 33, .str1 = 2, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_rol, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 13, .off1_2 = 0, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_ror, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_ror, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 33, .str1 = 2, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_ror, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 13, .off1_2 = 0, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_rsm, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sahf, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sar, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sar, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 33, .str1 = 2, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sar, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 13, .off1_2 = 0, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sbb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 27, .str1 = 0, .off1_1 = 7, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sbb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 20, .str2 = 0, .off2_1 = 5, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sbb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 15, .str1 = 0, .off1_1 = 5, .off1_2 = 3, .off1_3 = 0, .fct2 = 5, .str2 = 0, .off2_1 = 11, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sbb, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 15, .str1 = 0, .off1_1 = 13, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sbb, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 19, .str1 = 0, .off1_1 = 13, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_scas, .rep = 0, .repe = 1, .suffix = 0, .modrm = 0, .fct1 = 12, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 5, .str2 = 0, .off2_1 = 3, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_set, .rep = 0, .repe = 0, .suffix = 4, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_shl, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_shl, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 33, .str1 = 2, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_shl, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 13, .off1_2 = 0, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_shr, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_shld, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 21, .off1_2 = 0, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 2, .str3 = 0, .off3_1 = 6, .off3_2 = 0, },
  { .mnemonic = MNE_shld, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 33, .str1 = 2, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 2, .str3 = 0, .off3_1 = 6, .off3_2 = 0, },
  { .mnemonic = MNE_shr, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 33, .str1 = 2, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_shr, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 13, .off1_2 = 0, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_shrd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 21, .off1_2 = 0, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 2, .str3 = 0, .off3_1 = 6, .off3_2 = 0, },
  { .mnemonic = MNE_shrd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 33, .str1 = 2, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 2, .str3 = 0, .off3_1 = 6, .off3_2 = 0, },
  { .mnemonic = MNE_vmcall, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_vmlaunch, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_vmresume, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_vmxoff, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_vmread, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 28, .str1 = 0, .off1_1 = 15, .off1_2 = 0, .off1_3 = 0, .fct2 = 14, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_vmwrite, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 22, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 21, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sgdt, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_monitor, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 33, .str1 = 3, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 1, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 4, .str3 = 1, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_mwait, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 33, .str1 = 3, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 23, .str2 = 1, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sidt, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sldt, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_smsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_stc, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_std, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sti, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_stos, .rep = 1, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 5, .str1 = 0, .off1_1 = 5, .off1_2 = 3, .off1_3 = 0, .fct2 = 10, .str2 = 0, .off2_1 = 3, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_str, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sub, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 27, .str1 = 0, .off1_1 = 7, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sub, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 20, .str2 = 0, .off2_1 = 5, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sub, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 15, .str1 = 0, .off1_1 = 5, .off1_2 = 3, .off1_3 = 0, .fct2 = 5, .str2 = 0, .off2_1 = 11, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sub, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 15, .str1 = 0, .off1_1 = 13, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sub, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 19, .str1 = 0, .off1_1 = 13, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_test, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 27, .str1 = 0, .off1_1 = 7, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_test, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 15, .str1 = 0, .off1_1 = 5, .off1_2 = 3, .off1_3 = 0, .fct2 = 5, .str2 = 0, .off2_1 = 11, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_test, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 15, .str1 = 0, .off1_1 = 13, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_ud2a, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_verr, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 21, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_verw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 21, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_wbinvd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_prefetch, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 23, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_prefetchw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 23, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_prefetchnta, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_prefetcht0, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_prefetcht1, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_prefetcht2, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_nop, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_wrmsr, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_xadd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 27, .str1 = 0, .off1_1 = 15, .off1_2 = 11, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 8, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_xchg, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 27, .str1 = 0, .off1_1 = 7, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_xchg, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 4, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 17, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_xlat, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 9, .str1 = 0, .off1_1 = 5, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_xor, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 27, .str1 = 0, .off1_1 = 7, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_xor, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 25, .str1 = 0, .off1_1 = 5, .off1_2 = 9, .off1_3 = 0, .fct2 = 20, .str2 = 0, .off2_1 = 5, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_xor, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 15, .str1 = 0, .off1_1 = 5, .off1_2 = 3, .off1_3 = 0, .fct2 = 5, .str2 = 0, .off2_1 = 11, .off2_2 = 3, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_xor, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 15, .str1 = 0, .off1_1 = 13, .off1_2 = 3, .off1_3 = 0, .fct2 = 16, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_xor, .rep = 0, .repe = 0, .suffix = 1, .modrm = 1, .fct1 = 19, .str1 = 0, .off1_1 = 13, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 3, .off2_2 = 9, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_emms, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pand, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pand, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pandn, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pandn, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmaddwd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmaddwd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_por, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_por, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pxor, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pxor, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_andnps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_andps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmpeqps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmpltps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmpleps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmpunordps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmpneqps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmpnltps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmpnleps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmpordps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmpeqss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmpltss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmpless, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmpunordss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmpneqss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmpnltss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmpnless, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cmpordss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fxrstor, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_fxsave, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_ldmxcsr, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_stmxcsr, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movsd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movupd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movups, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movsd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 34, .str1 = 0, .off1_1 = 23, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 19, .off2_2 = 25, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 34, .str1 = 0, .off1_1 = 23, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 19, .off2_2 = 25, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movupd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 34, .str1 = 0, .off1_1 = 23, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 19, .off2_2 = 25, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movups, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 34, .str1 = 0, .off1_1 = 15, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movddup, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movsldup, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movlpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movhlps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 34, .str1 = 0, .off1_1 = 18, .off1_2 = 0, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movlps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movhlpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 34, .str1 = 0, .off1_1 = 23, .off1_2 = 0, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 24, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movhlps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 34, .str1 = 0, .off1_1 = 15, .off1_2 = 0, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 16, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movlpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 34, .str1 = 0, .off1_1 = 23, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 19, .off2_2 = 25, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movlps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 34, .str1 = 0, .off1_1 = 15, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_unpcklpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_unpcklps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_unpckhpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_unpckhps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movshdup, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movhpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movlhps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 34, .str1 = 0, .off1_1 = 18, .off1_2 = 0, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movhps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movlhpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 34, .str1 = 0, .off1_1 = 23, .off1_2 = 0, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 24, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movlhps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 34, .str1 = 0, .off1_1 = 15, .off1_2 = 0, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 16, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movhpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 34, .str1 = 0, .off1_1 = 23, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 19, .off2_2 = 25, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movhps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 34, .str1 = 0, .off1_1 = 15, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movapd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movaps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movapd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 34, .str1 = 0, .off1_1 = 23, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 19, .off2_2 = 25, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movaps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 34, .str1 = 0, .off1_1 = 15, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvtsi2sd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvtsi2ss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvtpi2pd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvtpi2ps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movntpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 34, .str1 = 0, .off1_1 = 23, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 19, .off2_2 = 25, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movntps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 34, .str1 = 0, .off1_1 = 15, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvttsd2si, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvttss2si, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvttpd2pi, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvttps2pi, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvtpd2pi, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvtsd2si, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvtss2si, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvtps2pi, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_ucomisd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_ucomiss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_comisd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_comiss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_getsec, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movmskpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 34, .str1 = 0, .off1_1 = 26, .off1_2 = 0, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movmskps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 34, .str1 = 0, .off1_1 = 18, .off1_2 = 0, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sqrtpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sqrtsd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sqrtss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sqrtps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_rsqrtss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_rsqrtps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_rcpss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_rcpps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_andpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_andps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_andnpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_andnps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_orpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_orps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_xorpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_xorps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_addsd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_addss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_addpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_addps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_mulsd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_mulss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_mulpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_mulps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvtsd2ss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvtss2sd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvtpd2ps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvtps2pd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvtps2dq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvttps2dq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_cvtdq2ps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_subsd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_subss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_subpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_subps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_minsd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_minss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_minpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_minps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_divsd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_divss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_divpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_divps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_maxsd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_maxss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_maxpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_maxps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_punpcklbw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_punpcklbw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_punpcklwd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_punpcklwd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_punpckldq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_punpckldq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_packsswb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_packsswb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pcmpgtb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pcmpgtb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pcmpgtw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pcmpgtw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pcmpgtd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pcmpgtd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_packuswb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_packuswb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_punpckhbw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_punpckhbw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_punpckhwd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_punpckhwd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_punpckhdq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_punpckhdq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_packssdw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_packssdw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_punpcklqdq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_punpckhqdq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movdqa, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movdqu, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pshufd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 29, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 19, .off2_2 = 25, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 16, .off3_2 = 0, },
  { .mnemonic = MNE_pshuflw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 29, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 19, .off2_2 = 25, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 16, .off3_2 = 0, },
  { .mnemonic = MNE_pshufhw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 29, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 19, .off2_2 = 25, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 16, .off3_2 = 0, },
  { .mnemonic = MNE_pshufw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 21, .off1_2 = 0, .off1_3 = 0, .fct2 = 1, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 1, .str3 = 0, .off3_1 = 8, .off3_2 = 0, },
  { .mnemonic = MNE_pcmpeqb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pcmpeqb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pcmpeqw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pcmpeqw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pcmpeqd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pcmpeqd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_haddpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_haddps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_hsubpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_hsubps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 34, .str1 = 0, .off1_1 = 23, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 19, .off2_2 = 25, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 20, .str1 = 0, .off1_1 = 15, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movdqa, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 34, .str1 = 0, .off1_1 = 23, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 19, .off2_2 = 25, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movdqu, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 34, .str1 = 0, .off1_1 = 23, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 19, .off2_2 = 25, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 20, .str1 = 0, .off1_1 = 15, .off1_2 = 0, .off1_3 = 0, .fct2 = 1, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movnti, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 26, .str1 = 0, .off1_1 = 15, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pinsrw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 29, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 19, .off2_2 = 25, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 16, .off3_2 = 0, },
  { .mnemonic = MNE_pinsrw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 21, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 1, .str3 = 0, .off3_1 = 8, .off3_2 = 0, },
  { .mnemonic = MNE_pextrw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 29, .off1_2 = 0, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 24, .off2_2 = 0, .off2_3 = 0, .fct3 = 3, .str3 = 0, .off3_1 = 16, .off3_2 = 0, },
  { .mnemonic = MNE_pextrw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 21, .off1_2 = 0, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 16, .off2_2 = 0, .off2_3 = 0, .fct3 = 3, .str3 = 0, .off3_1 = 8, .off3_2 = 0, },
  { .mnemonic = MNE_shufpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 29, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 19, .off2_2 = 25, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 16, .off3_2 = 0, },
  { .mnemonic = MNE_shufps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 21, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 8, .off3_2 = 0, },
  { .mnemonic = MNE_psrlw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psrlw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psrld, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psrld, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psrlq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psrlq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_paddq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_paddq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmullw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmullw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 34, .str1 = 0, .off1_1 = 23, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 19, .off2_2 = 25, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movdq2q, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 34, .str1 = 0, .off1_1 = 26, .off1_2 = 0, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movq2dq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 20, .str1 = 0, .off1_1 = 26, .off1_2 = 0, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmovmskb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 34, .str1 = 0, .off1_1 = 26, .off1_2 = 0, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmovmskb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 20, .str1 = 0, .off1_1 = 18, .off1_2 = 0, .off1_3 = 0, .fct2 = 19, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psubusb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psubusb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psubusw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psubusw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pminub, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pminub, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_paddusb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_paddusb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_paddusw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_paddusw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmaxub, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmaxub, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pavgb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pavgb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psraw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psraw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psrad, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psrad, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pavgw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pavgw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmulhuw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmulhuw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmulhw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmulhw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movntdq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 34, .str1 = 0, .off1_1 = 23, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 19, .off2_2 = 25, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_movntq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 20, .str1 = 0, .off1_1 = 15, .off1_2 = 0, .off1_3 = 0, .fct2 = 1, .str2 = 0, .off2_1 = 11, .off2_2 = 17, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psubsb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psubsb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psubsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psubsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pminsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pminsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_paddsb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_paddsb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_paddsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_paddsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmaxsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmaxsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_lddqu, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psllw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psllw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pslld, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pslld, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psllq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psllq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmuludq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmuludq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psadbw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psadbw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_maskmovdqu, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 34, .str1 = 0, .off1_1 = 26, .off1_2 = 0, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_maskmovq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 20, .str1 = 0, .off1_1 = 18, .off1_2 = 0, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psubb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psubb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psubw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psubw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psubd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psubd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psubq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psubq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_paddb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_paddb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_paddw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_paddw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_paddd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_paddd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pshufb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pshufb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_phaddw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_phaddw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_phaddd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_phaddd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_phaddsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_phaddsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmaddubsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmaddubsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_phsubw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_phsubw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_phsubd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_phsubd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_phsubsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_phsubsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psignb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psignb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psignw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psignw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psignd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psignd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmulhrsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmulhrsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pabsb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pabsb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pabsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pabsw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pabsd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pabsd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 21, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_palignr, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 37, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_palignr, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 29, .off1_2 = 0, .off1_3 = 0, .fct2 = 1, .str2 = 0, .off2_1 = 19, .off2_2 = 25, .off2_3 = 0, .fct3 = 1, .str3 = 0, .off3_1 = 16, .off3_2 = 0, },
  { .mnemonic = MNE_vmclear, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_vmxon, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 21, .off1_2 = 25, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_vmptrld, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_vmptrst, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psrlw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 29, .off1_2 = 0, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 24, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psrlw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 21, .off1_2 = 0, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 16, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psraw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 29, .off1_2 = 0, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 24, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psraw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 21, .off1_2 = 0, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 16, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psllw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 29, .off1_2 = 0, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 24, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psllw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 21, .off1_2 = 0, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 16, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psrld, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 29, .off1_2 = 0, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 24, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psrld, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 21, .off1_2 = 0, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 16, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psrad, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 29, .off1_2 = 0, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 24, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psrad, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 21, .off1_2 = 0, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 16, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pslld, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 29, .off1_2 = 0, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 24, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pslld, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 21, .off1_2 = 0, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 16, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psrlq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 29, .off1_2 = 0, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 24, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psrlq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 21, .off1_2 = 0, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 16, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psrldq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 29, .off1_2 = 0, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 24, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psllq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 29, .off1_2 = 0, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 24, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_psllq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 21, .off1_2 = 0, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 16, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pslldq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 18, .str1 = 0, .off1_1 = 29, .off1_2 = 0, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 24, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_lfence, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_mfence, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_sfence, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 0, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_clflush, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 24, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_INVALID, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 1, .str1 = 0, .off1_1 = 13, .off1_2 = 17, .off1_3 = 0, .fct2 = 13, .str2 = 0, .off2_1 = 13, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_blendps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 37, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_blendpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 37, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_blendvps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 33, .str1 = 5, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_blendvpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 33, .str1 = 5, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_dpps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 37, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_dppd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 37, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_insertps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 37, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_movntdqa, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_mpsadbw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 37, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_packusdw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pblendvb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 33, .str1 = 5, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_pblendw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 37, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_pcmpeqq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pcmpestri, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 37, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_pcmpestrm, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 37, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_pcmpistri, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 37, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_pcmpistrm, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 37, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_pcmpgtq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_phminposuw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pinsrb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 37, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_pinsrd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 37, .off1_2 = 0, .off1_3 = 0, .fct2 = 15, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_pmaxsb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmaxsd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmaxud, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmaxuw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pminsb, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pminsd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pminud, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pminuw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmovsxbw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmovsxbd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmovsxbq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmovsxwd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmovsxwq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmovsxdq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmovzxbw, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmovzxbd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmovzxbq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmovzxwd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmovzxwq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmovzxdq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmuldq, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_pmulld, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_ptest, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 2, .str1 = 0, .off1_1 = 29, .off1_2 = 33, .off1_3 = 0, .fct2 = 24, .str2 = 0, .off2_1 = 29, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
  { .mnemonic = MNE_roundps, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 37, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_roundpd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 37, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_roundss, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 37, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_roundsd, .rep = 0, .repe = 0, .suffix = 0, .modrm = 1, .fct1 = 18, .str1 = 0, .off1_1 = 37, .off1_2 = 0, .off1_3 = 0, .fct2 = 2, .str2 = 0, .off2_1 = 27, .off2_2 = 33, .off2_3 = 0, .fct3 = 5, .str3 = 0, .off3_1 = 24, .off3_2 = 0, },
  { .mnemonic = MNE_pop, .rep = 0, .repe = 0, .suffix = 0, .modrm = 0, .fct1 = 31, .str1 = 0, .off1_1 = 0, .off1_2 = 0, .off1_3 = 0, .fct2 = 0, .str2 = 0, .off2_1 = 0, .off2_2 = 0, .off2_3 = 0, .fct3 = 0, .str3 = 0, .off3_1 = 0, .off3_2 = 0, },
};
static const uint8_t match_data[] =
{
  0x1, 0xfe, 0x14,
  0x2, 0xfe, 0x80, 0x38, 0x10,
  0x2, 0xfe, 0x82, 0x38, 0x10,
  0x2, 0xfe, 0x10, 0, 0,
  0x2, 0xfe, 0x12, 0, 0,
  0x1, 0xfe, 0x4,
  0x2, 0xfe, 0x80, 0x38, 0,
  0x12, 0x83, 0x38, 0,
  0x2, 0xfe, 0, 0, 0,
  0x2, 0xfe, 0x2, 0, 0,
  0x34, 0x66, 0xf, 0xd0, 0, 0,
  0x34, 0xf2, 0xf, 0xd0, 0, 0,
  0x1, 0xfe, 0x24,
  0x2, 0xfe, 0x80, 0x38, 0x20,
  0x2, 0xfe, 0x82, 0x38, 0x20,
  0x2, 0xfe, 0x20, 0, 0,
  0x2, 0xfe, 0x22, 0, 0,
  0x34, 0x66, 0xf, 0x54, 0, 0,
  0x23, 0xf, 0x54, 0, 0,
  0x34, 0x66, 0xf, 0x55, 0, 0,
  0x23, 0xf, 0x55, 0, 0,
  0x12, 0x63, 0, 0,
  0x23, 0xf, 0xbc, 0, 0,
  0x23, 0xf, 0xbd, 0, 0,
  0x12, 0xf, 0xf8, 0xc8,
  0x23, 0xf, 0xa3, 0, 0,
  0x23, 0xf, 0xba, 0x38, 0x20,
  0x23, 0xf, 0xbb, 0, 0,
  0x23, 0xf, 0xba, 0x38, 0x38,
  0x23, 0xf, 0xb3, 0, 0,
  0x23, 0xf, 0xba, 0x38, 0x30,
  0x23, 0xf, 0xab, 0, 0,
  0x23, 0xf, 0xba, 0x38, 0x28,
  0x11, 0xe8,
  0x12, 0xff, 0x38, 0x10,
  0x12, 0xff, 0x38, 0x18,
  0x11, 0x98,
  0x11, 0x99,
  0x11, 0xf8,
  0x11, 0xfc,
  0x11, 0xfa,
  0x22, 0xf, 0x5,
  0x22, 0xf, 0x6,
  0x22, 0xf, 0x7,
  0x22, 0xf, 0x34,
  0x22, 0xf, 0x35,
  0x11, 0xf5,
  0x13, 0xf, 0xf0, 0x40, 0, 0,
  0x1, 0xfe, 0x3c,
  0x2, 0xfe, 0x80, 0x38, 0x38,
  0x12, 0x83, 0x38, 0x38,
  0x2, 0xfe, 0x38, 0, 0,
  0x2, 0xfe, 0x3a, 0, 0,
  0x34, 0xf2, 0xf, 0xc2, 0, 0,
  0x34, 0xf3, 0xf, 0xc2, 0, 0,
  0x34, 0x66, 0xf, 0xc2, 0, 0,
  0x23, 0xf, 0xc2, 0, 0,
  0x1, 0xfe, 0xa6,
  0x13, 0xf, 0xfe, 0xb0, 0, 0,
  0x23, 0xf, 0xc7, 0x38, 0x8,
  0x22, 0xf, 0xa2,
  0x34, 0xf3, 0xf, 0xe6, 0, 0,
  0x34, 0xf2, 0xf, 0xe6, 0, 0,
  0x34, 0x66, 0xf, 0xe6, 0, 0,
  0x2, 0xfe, 0xfe, 0x38, 0x8,
  0x2, 0xfe, 0xf6, 0x38, 0x30,
  0x22, 0xf, 0x77,
  0x11, 0xc8,
  0x22, 0xd9, 0xd0,
  0x22, 0xd9, 0xe0,
  0x22, 0xd9, 0xe1,
  0x22, 0xd9, 0xe4,
  0x22, 0xd9, 0xe5,
  0x22, 0xd9, 0xe8,
  0x22, 0xd9, 0xe9,
  0x22, 0xd9, 0xea,
  0x22, 0xd9, 0xeb,
  0x22, 0xd9, 0xec,
  0x22, 0xd9, 0xed,
  0x22, 0xd9, 0xee,
  0x22, 0xd9, 0xf0,
  0x22, 0xd9, 0xf1,
  0x22, 0xd9, 0xf2,
  0x22, 0xd9, 0xf3,
  0x22, 0xd9, 0xf4,
  0x22, 0xd9, 0xf5,
  0x22, 0xd9, 0xf6,
  0x22, 0xd9, 0xf7,
  0x22, 0xd9, 0xf8,
  0x22, 0xd9, 0xf9,
  0x22, 0xd9, 0xfa,
  0x22, 0xd9, 0xfb,
  0x22, 0xd9, 0xfc,
  0x22, 0xd9, 0xfd,
  0x22, 0xd9, 0xfe,
  0x22, 0xd9, 0xff,
  0x12, 0xd8, 0xf8, 0xc0,
  0x12, 0xdc, 0xf8, 0xc0,
  0x2, 0xfb, 0xd8, 0x38, 0,
  0x12, 0xd8, 0xf8, 0xc8,
  0x12, 0xdc, 0xf8, 0xc8,
  0x2, 0xfb, 0xd8, 0x38, 0x8,
  0x12, 0xd8, 0xf8, 0xe0,
  0x12, 0xdc, 0xf8, 0xe0,
  0x2, 0xfb, 0xd8, 0x38, 0x20,
  0x12, 0xd8, 0xf8, 0xe8,
  0x12, 0xdc, 0xf8, 0xe8,
  0x2, 0xfb, 0xd8, 0x38, 0x28,
  0x12, 0xdd, 0xf8, 0xd0,
  0x2, 0xfb, 0xd9, 0x38, 0x10,
  0x12, 0xdd, 0xf8, 0xd8,
  0x2, 0xfb, 0xd9, 0x38, 0x18,
  0x12, 0xd9, 0x38, 0x20,
  0x12, 0xd9, 0x38, 0x28,
  0x12, 0xd9, 0x38, 0x30,
  0x12, 0xd9, 0x38, 0x38,
  0x12, 0xd9, 0xf8, 0xc8,
  0x12, 0xde, 0xf8, 0xc0,
  0x12, 0xda, 0xf8, 0xc0,
  0x2, 0xfb, 0xda, 0x38, 0,
  0x12, 0xda, 0xf8, 0xc8,
  0x12, 0xde, 0xf8, 0xc8,
  0x2, 0xfb, 0xda, 0x38, 0x8,
  0x12, 0xde, 0xf8, 0xe0,
  0x2, 0xfb, 0xda, 0x38, 0x20,
  0x12, 0xde, 0xf8, 0xe8,
  0x2, 0xfb, 0xda, 0x38, 0x28,
  0x22, 0xdf, 0xe0,
  0x12, 0xdf, 0x38, 0x20,
  0x12, 0xdf, 0xf8, 0xf0,
  0x12, 0xdf, 0x38, 0x30,
  0x22, 0xd9, 0xe0,
  0x33, 0x9b, 0xdb, 0xe2,
  0x33, 0x9b, 0xdb, 0xe3,
  0x11, 0x9b,
  0x22, 0xdb, 0xe2,
  0x12, 0xda, 0xf8, 0xc0,
  0x12, 0xda, 0xf8, 0xc8,
  0x12, 0xda, 0xf8, 0xd0,
  0x12, 0xda, 0xf8, 0xd8,
  0x12, 0xdb, 0xf8, 0xc0,
  0x12, 0xdb, 0xf8, 0xc8,
  0x12, 0xdb, 0xf8, 0xd0,
  0x12, 0xdb, 0xf8, 0xd8,
  0x12, 0xd8, 0xf8, 0xd0,
  0x2, 0xfb, 0xd8, 0x38, 0x10,
  0x12, 0xd8, 0xf8, 0xd8,
  0x2, 0xfb, 0xd8, 0x38, 0x18,
  0x22, 0xde, 0xd9,
  0x12, 0xdb, 0xf8, 0xf0,
  0x12, 0xdf, 0xf8, 0xf0,
  0x12, 0xdb, 0xf8, 0xe8,
  0x12, 0xdf, 0xf8, 0xe8,
  0x22, 0xd9, 0xff,
  0x22, 0xd9, 0xf6,
  0x12, 0xd8, 0xf8, 0xf0,
  0x12, 0xdc, 0xf8, 0xf0,
  0x2, 0xfb, 0xd8, 0x38, 0x30,
  0x12, 0xda, 0x38, 0x30,
  0x12, 0xde, 0xf8, 0xf0,
  0x12, 0xde, 0x38, 0x30,
  0x12, 0xde, 0xf8, 0xf8,
  0x12, 0xd8, 0xf8, 0xf8,
  0x12, 0xdc, 0xf8, 0xf8,
  0x2, 0xfb, 0xd8, 0x38, 0x38,
  0x12, 0xda, 0x38, 0x38,
  0x12, 0xde, 0x38, 0x38,
  0x12, 0xde, 0xf8, 0xf0,
  0x12, 0xdd, 0xf8, 0xc0,
  0x12, 0xda, 0xf8, 0xd0,
  0x2, 0xfb, 0xda, 0x38, 0x10,
  0x12, 0xda, 0xf8, 0xd8,
  0x2, 0xfb, 0xda, 0x38, 0x18,
  0x12, 0xdf, 0x38, 0,
  0x12, 0xdb, 0x38, 0,
  0x12, 0xdf, 0x38, 0x28,
  0x22, 0xd9, 0xf7,
  0x22, 0xdb, 0xe3,
  0x2, 0xfb, 0xdb, 0x38, 0x10,
  0x2, 0xfb, 0xdb, 0x38, 0x18,
  0x12, 0xdf, 0x38, 0x38,
  0x2, 0xfb, 0xdb, 0x38, 0x8,
  0x12, 0xdd, 0x38, 0x8,
  0x12, 0xdb, 0x38, 0x28,
  0x12, 0xdb, 0x38, 0x38,
  0x12, 0xd9, 0xf8, 0xc0,
  0x2, 0xfb, 0xd9, 0x38, 0,
  0x12, 0xdd, 0xf8, 0xe0,
  0x12, 0xdd, 0x38, 0x20,
  0x12, 0xdd, 0xf8, 0xe8,
  0x12, 0xdd, 0x38, 0x30,
  0x12, 0xdd, 0x38, 0x38,
  0x11, 0xf4,
  0x2, 0xfe, 0xf6, 0x38, 0x38,
  0x2, 0xfe, 0xf6, 0x38, 0x28,
  0x23, 0xf, 0xaf, 0, 0,
  0x2, 0xfd, 0x69, 0, 0,
  0x1, 0xfe, 0xe4,
  0x1, 0xfe, 0xec,
  0x2, 0xfe, 0xfe, 0x38, 0,
  0x1, 0xfe, 0x6c,
  0x11, 0xcd,
  0x11, 0xcc,
  0x22, 0xf, 0x8,
  0x33, 0xf, 0x1, 0xf8,
  0x23, 0xf, 0x1, 0x38, 0x38,
  0x11, 0xcf,
  0x1, 0xf0, 0x70,
  0x12, 0xf, 0xf0, 0x80,
  0x13, 0xf, 0xf0, 0x90, 0x38, 0,
  0x11, 0xe3,
  0x11, 0xeb,
  0x11, 0xe9,
  0x12, 0xff, 0x38, 0x20,
  0x11, 0xea,
  0x12, 0xff, 0x38, 0x28,
  0x11, 0x9f,
  0x23, 0xf, 0x2, 0, 0,
  0x12, 0x8d, 0, 0,
  0x11, 0xc9,
  0x23, 0xf, 0xb4, 0, 0,
  0x23, 0xf, 0xb5, 0, 0,
  0x23, 0xf, 0x1, 0x38, 0x10,
  0x23, 0xf, 0x1, 0x38, 0x18,
  0x23, 0xf, 0, 0x38, 0x10,
  0x23, 0xf, 0x1, 0x38, 0x30,
  0x11, 0xf0,
  0x1, 0xfe, 0xac,
  0x11, 0xe2,
  0x11, 0xe1,
  0x11, 0xe0,
  0x23, 0xf, 0x3, 0, 0,
  0x23, 0xf, 0xb2, 0, 0,
  0x23, 0xf, 0, 0x38, 0x18,
  0x2, 0xfe, 0x88, 0, 0,
  0x2, 0xfe, 0x8a, 0, 0,
  0x2, 0xfe, 0xc6, 0x38, 0,
  0x1, 0xf0, 0xb0,
  0x1, 0xfe, 0xa0,
  0x1, 0xfe, 0xa2,
  0x23, 0xf, 0x20, 0xc0, 0xc0,
  0x23, 0xf, 0x22, 0xc0, 0xc0,
  0x23, 0xf, 0x21, 0xc0, 0xc0,
  0x23, 0xf, 0x23, 0xc0, 0xc0,
  0x12, 0x8c, 0, 0,
  0x12, 0x8e, 0, 0,
  0x1, 0xfe, 0xa4,
  0x23, 0xf, 0xbe, 0, 0,
  0x23, 0xf, 0xbf, 0, 0,
  0x23, 0xf, 0xb6, 0, 0,
  0x23, 0xf, 0xb7, 0, 0,
  0x2, 0xfe, 0xf6, 0x38, 0x20,
  0x2, 0xfe, 0xf6, 0x38, 0x18,
  0x22, 0xf3, 0x90,
  0x11, 0x90,
  0x34, 0xf3, 0xf, 0xb8, 0, 0,
  0x2, 0xfe, 0xf6, 0x38, 0x10,
  0x2, 0xfe, 0x8, 0, 0,
  0x2, 0xfe, 0xa, 0, 0,
  0x2, 0xfe, 0x80, 0x38, 0x8,
  0x2, 0xfe, 0x82, 0x38, 0x8,
  0x1, 0xfe, 0xc,
  0x1, 0xfe, 0xe6,
  0x1, 0xfe, 0xee,
  0x1, 0xfe, 0x6e,
  0x12, 0x8f, 0xf8, 0xc0,
  0x12, 0x8f, 0x38, 0,
  0x12, 0xf, 0xc7, 0x81,
  0x11, 0x9d,
  0x12, 0xff, 0xf8, 0xf0,
  0x12, 0xff, 0x38, 0x30,
  0x1, 0xf8, 0x50,
  0x1, 0xf8, 0x58,
  0x1, 0xfd, 0x68,
  0x1, 0xe7, 0x6,
  0x12, 0xf, 0xc7, 0x80,
  0x11, 0x9c,
  0x2, 0xfe, 0xd0, 0x38, 0x10,
  0x2, 0xfe, 0xd2, 0x38, 0x10,
  0x2, 0xfe, 0xc0, 0x38, 0x10,
  0x2, 0xfe, 0xd0, 0x38, 0x18,
  0x2, 0xfe, 0xd2, 0x38, 0x18,
  0x2, 0xfe, 0xc0, 0x38, 0x18,
  0x22, 0xf, 0x32,
  0x22, 0xf, 0x33,
  0x22, 0xf, 0x31,
  0x11, 0xc3,
  0x11, 0xc2,
  0x11, 0xcb,
  0x11, 0xca,
  0x2, 0xfe, 0xd0, 0x38, 0,
  0x2, 0xfe, 0xd2, 0x38, 0,
  0x2, 0xfe, 0xc0, 0x38, 0,
  0x2, 0xfe, 0xd0, 0x38, 0x8,
  0x2, 0xfe, 0xd2, 0x38, 0x8,
  0x2, 0xfe, 0xc0, 0x38, 0x8,
  0x22, 0xf, 0xaa,
  0x11, 0x9e,
  0x2, 0xfe, 0xd0, 0x38, 0x38,
  0x2, 0xfe, 0xd2, 0x38, 0x38,
  0x2, 0xfe, 0xc0, 0x38, 0x38,
  0x2, 0xfe, 0x18, 0, 0,
  0x2, 0xfe, 0x1a, 0, 0,
  0x1, 0xfe, 0x1c,
  0x2, 0xfe, 0x80, 0x38, 0x18,
  0x2, 0xfe, 0x82, 0x38, 0x18,
  0x1, 0xfe, 0xae,
  0x13, 0xf, 0xf0, 0x90, 0x38, 0,
  0x2, 0xfe, 0xd0, 0x38, 0x20,
  0x2, 0xfe, 0xd2, 0x38, 0x20,
  0x2, 0xfe, 0xc0, 0x38, 0x20,
  0x2, 0xfe, 0xd0, 0x38, 0x28,
  0x23, 0xf, 0xa4, 0, 0,
  0x23, 0xf, 0xa5, 0, 0,
  0x2, 0xfe, 0xd2, 0x38, 0x28,
  0x2, 0xfe, 0xc0, 0x38, 0x28,
  0x23, 0xf, 0xac, 0, 0,
  0x23, 0xf, 0xad, 0, 0,
  0x33, 0xf, 0x1, 0xc1,
  0x33, 0xf, 0x1, 0xc2,
  0x33, 0xf, 0x1, 0xc3,
  0x33, 0xf, 0x1, 0xc4,
  0x23, 0xf, 0x78, 0, 0,
  0x23, 0xf, 0x79, 0, 0,
  0x23, 0xf, 0x1, 0x38, 0,
  0x33, 0xf, 0x1, 0xc8,
  0x33, 0xf, 0x1, 0xc9,
  0x23, 0xf, 0x1, 0x38, 0x8,
  0x23, 0xf, 0, 0x38, 0,
  0x23, 0xf, 0x1, 0x38, 0x20,
  0x11, 0xf9,
  0x11, 0xfd,
  0x11, 0xfb,
  0x1, 0xfe, 0xaa,
  0x23, 0xf, 0, 0x38, 0x8,
  0x2, 0xfe, 0x28, 0, 0,
  0x2, 0xfe, 0x2a, 0, 0,
  0x1, 0xfe, 0x2c,
  0x2, 0xfe, 0x80, 0x38, 0x28,
  0x2, 0xfe, 0x82, 0x38, 0x28,
  0x2, 0xfe, 0x84, 0, 0,
  0x1, 0xfe, 0xa8,
  0x2, 0xfe, 0xf6, 0x38, 0,
  0x22, 0xf, 0xb,
  0x23, 0xf, 0, 0x38, 0x20,
  0x23, 0xf, 0, 0x38, 0x28,
  0x22, 0xf, 0x9,
  0x23, 0xf, 0xd, 0x38, 0,
  0x23, 0xf, 0xd, 0x38, 0x8,
  0x23, 0xf, 0x18, 0x38, 0,
  0x23, 0xf, 0x18, 0x38, 0x8,
  0x23, 0xf, 0x18, 0x38, 0x10,
  0x23, 0xf, 0x18, 0x38, 0x18,
  0x23, 0xf, 0x1f, 0, 0,
  0x22, 0xf, 0x30,
  0x13, 0xf, 0xfe, 0xc0, 0, 0,
  0x2, 0xfe, 0x86, 0, 0,
  0x1, 0xf8, 0x90,
  0x11, 0xd7,
  0x2, 0xfe, 0x30, 0, 0,
  0x2, 0xfe, 0x32, 0, 0,
  0x1, 0xfe, 0x34,
  0x2, 0xfe, 0x80, 0x38, 0x30,
  0x2, 0xfe, 0x82, 0x38, 0x30,
  0x22, 0xf, 0x77,
  0x34, 0x66, 0xf, 0xdb, 0, 0,
  0x23, 0xf, 0xdb, 0, 0,
  0x34, 0x66, 0xf, 0xdf, 0, 0,
  0x23, 0xf, 0xdf, 0, 0,
  0x34, 0x66, 0xf, 0xf5, 0, 0,
  0x23, 0xf, 0xf5, 0, 0,
  0x34, 0x66, 0xf, 0xeb, 0, 0,
  0x23, 0xf, 0xeb, 0, 0,
  0x34, 0x66, 0xf, 0xef, 0, 0,
  0x23, 0xf, 0xef, 0, 0,
  0x23, 0xf, 0x55, 0, 0,
  0x23, 0xf, 0x54, 0, 0,
  0x24, 0xf, 0xc2, 0, 0, 0xff, 0,
  0x24, 0xf, 0xc2, 0, 0, 0xff, 0x1,
  0x24, 0xf, 0xc2, 0, 0, 0xff, 0x2,
  0x24, 0xf, 0xc2, 0, 0, 0xff, 0x3,
  0x24, 0xf, 0xc2, 0, 0, 0xff, 0x4,
  0x24, 0xf, 0xc2, 0, 0, 0xff, 0x5,
  0x24, 0xf, 0xc2, 0, 0, 0xff, 0x6,
  0x24, 0xf, 0xc2, 0, 0, 0xff, 0x7,
  0x35, 0xf3, 0xf, 0xc2, 0, 0, 0xff, 0,
  0x35, 0xf3, 0xf, 0xc2, 0, 0, 0xff, 0x1,
  0x35, 0xf3, 0xf, 0xc2, 0, 0, 0xff, 0x2,
  0x35, 0xf3, 0xf, 0xc2, 0, 0, 0xff, 0x3,
  0x35, 0xf3, 0xf, 0xc2, 0, 0, 0xff, 0x4,
  0x35, 0xf3, 0xf, 0xc2, 0, 0, 0xff, 0x5,
  0x35, 0xf3, 0xf, 0xc2, 0, 0, 0xff, 0x6,
  0x35, 0xf3, 0xf, 0xc2, 0, 0, 0xff, 0x7,
  0x23, 0xf, 0xae, 0x38, 0x8,
  0x23, 0xf, 0xae, 0x38, 0,
  0x23, 0xf, 0xae, 0x38, 0x10,
  0x23, 0xf, 0xae, 0x38, 0x18,
  0x34, 0xf2, 0xf, 0x10, 0, 0,
  0x34, 0xf3, 0xf, 0x10, 0, 0,
  0x34, 0x66, 0xf, 0x10, 0, 0,
  0x23, 0xf, 0x10, 0, 0,
  0x34, 0xf2, 0xf, 0x11, 0, 0,
  0x34, 0xf3, 0xf, 0x11, 0, 0,
  0x34, 0x66, 0xf, 0x11, 0, 0,
  0x23, 0xf, 0x11, 0, 0,
  0x34, 0xf2, 0xf, 0x12, 0, 0,
  0x34, 0xf3, 0xf, 0x12, 0, 0,
  0x34, 0x66, 0xf, 0x12, 0, 0,
  0x23, 0xf, 0x12, 0xc0, 0xc0,
  0x23, 0xf, 0x12, 0, 0,
  0x34, 0x66, 0xf, 0x13, 0xc0, 0xc0,
  0x23, 0xf, 0x13, 0xc0, 0xc0,
  0x34, 0x66, 0xf, 0x13, 0, 0,
  0x23, 0xf, 0x13, 0, 0,
  0x34, 0x66, 0xf, 0x14, 0, 0,
  0x23, 0xf, 0x14, 0, 0,
  0x34, 0x66, 0xf, 0x15, 0, 0,
  0x23, 0xf, 0x15, 0, 0,
  0x34, 0xf3, 0xf, 0x16, 0, 0,
  0x34, 0x66, 0xf, 0x16, 0, 0,
  0x23, 0xf, 0x16, 0xc0, 0xc0,
  0x23, 0xf, 0x16, 0, 0,
  0x34, 0x66, 0xf, 0x17, 0xc0, 0xc0,
  0x23, 0xf, 0x17, 0xc0, 0xc0,
  0x34, 0x66, 0xf, 0x17, 0, 0,
  0x23, 0xf, 0x17, 0, 0,
  0x34, 0x66, 0xf, 0x28, 0, 0,
  0x23, 0xf, 0x28, 0, 0,
  0x34, 0x66, 0xf, 0x29, 0, 0,
  0x23, 0xf, 0x29, 0, 0,
  0x34, 0xf2, 0xf, 0x2a, 0, 0,
  0x34, 0xf3, 0xf, 0x2a, 0, 0,
  0x34, 0x66, 0xf, 0x2a, 0, 0,
  0x23, 0xf, 0x2a, 0, 0,
  0x34, 0x66, 0xf, 0x2b, 0, 0,
  0x23, 0xf, 0x2b, 0, 0,
  0x34, 0xf2, 0xf, 0x2c, 0, 0,
  0x34, 0xf3, 0xf, 0x2c, 0, 0,
  0x34, 0x66, 0xf, 0x2c, 0, 0,
  0x23, 0xf, 0x2c, 0, 0,
  0x34, 0x66, 0xf, 0x2d, 0, 0,
  0x34, 0xf2, 0xf, 0x2d, 0, 0,
  0x34, 0xf3, 0xf, 0x2d, 0, 0,
  0x23, 0xf, 0x2d, 0, 0,
  0x34, 0x66, 0xf, 0x2e, 0, 0,
  0x23, 0xf, 0x2e, 0, 0,
  0x34, 0x66, 0xf, 0x2f, 0, 0,
  0x23, 0xf, 0x2f, 0, 0,
  0x22, 0xf, 0x37,
  0x34, 0x66, 0xf, 0x50, 0xc0, 0xc0,
  0x23, 0xf, 0x50, 0xc0, 0xc0,
  0x34, 0x66, 0xf, 0x51, 0, 0,
  0x34, 0xf2, 0xf, 0x51, 0, 0,
  0x34, 0xf3, 0xf, 0x51, 0, 0,
  0x23, 0xf, 0x51, 0, 0,
  0x34, 0xf3, 0xf, 0x52, 0, 0,
  0x23, 0xf, 0x52, 0, 0,
  0x34, 0xf3, 0xf, 0x53, 0, 0,
  0x23, 0xf, 0x53, 0, 0,
  0x34, 0x66, 0xf, 0x54, 0, 0,
  0x23, 0xf, 0x54, 0, 0,
  0x34, 0x66, 0xf, 0x55, 0, 0,
  0x23, 0xf, 0x55, 0, 0,
  0x34, 0x66, 0xf, 0x56, 0, 0,
  0x23, 0xf, 0x56, 0, 0,
  0x34, 0x66, 0xf, 0x57, 0, 0,
  0x23, 0xf, 0x57, 0, 0,
  0x34, 0xf2, 0xf, 0x58, 0, 0,
  0x34, 0xf3, 0xf, 0x58, 0, 0,
  0x34, 0x66, 0xf, 0x58, 0, 0,
  0x23, 0xf, 0x58, 0, 0,
  0x34, 0xf2, 0xf, 0x59, 0, 0,
  0x34, 0xf3, 0xf, 0x59, 0, 0,
  0x34, 0x66, 0xf, 0x59, 0, 0,
  0x23, 0xf, 0x59, 0, 0,
  0x34, 0xf2, 0xf, 0x5a, 0, 0,
  0x34, 0xf3, 0xf, 0x5a, 0, 0,
  0x34, 0x66, 0xf, 0x5a, 0, 0,
  0x23, 0xf, 0x5a, 0, 0,
  0x34, 0x66, 0xf, 0x5b, 0, 0,
  0x34, 0xf3, 0xf, 0x5b, 0, 0,
  0x23, 0xf, 0x5b, 0, 0,
  0x34, 0xf2, 0xf, 0x5c, 0, 0,
  0x34, 0xf3, 0xf, 0x5c, 0, 0,
  0x34, 0x66, 0xf, 0x5c, 0, 0,
  0x23, 0xf, 0x5c, 0, 0,
  0x34, 0xf2, 0xf, 0x5d, 0, 0,
  0x34, 0xf3, 0xf, 0x5d, 0, 0,
  0x34, 0x66, 0xf, 0x5d, 0, 0,
  0x23, 0xf, 0x5d, 0, 0,
  0x34, 0xf2, 0xf, 0x5e, 0, 0,
  0x34, 0xf3, 0xf, 0x5e, 0, 0,
  0x34, 0x66, 0xf, 0x5e, 0, 0,
  0x23, 0xf, 0x5e, 0, 0,
  0x34, 0xf2, 0xf, 0x5f, 0, 0,
  0x34, 0xf3, 0xf, 0x5f, 0, 0,
  0x34, 0x66, 0xf, 0x5f, 0, 0,
  0x23, 0xf, 0x5f, 0, 0,
  0x34, 0x66, 0xf, 0x60, 0, 0,
  0x23, 0xf, 0x60, 0, 0,
  0x34, 0x66, 0xf, 0x61, 0, 0,
  0x23, 0xf, 0x61, 0, 0,
  0x34, 0x66, 0xf, 0x62, 0, 0,
  0x23, 0xf, 0x62, 0, 0,
  0x34, 0x66, 0xf, 0x63, 0, 0,
  0x23, 0xf, 0x63, 0, 0,
  0x34, 0x66, 0xf, 0x64, 0, 0,
  0x23, 0xf, 0x64, 0, 0,
  0x34, 0x66, 0xf, 0x65, 0, 0,
  0x23, 0xf, 0x65, 0, 0,
  0x34, 0x66, 0xf, 0x66, 0, 0,
  0x23, 0xf, 0x66, 0, 0,
  0x34, 0x66, 0xf, 0x67, 0, 0,
  0x23, 0xf, 0x67, 0, 0,
  0x34, 0x66, 0xf, 0x68, 0, 0,
  0x23, 0xf, 0x68, 0, 0,
  0x34, 0x66, 0xf, 0x69, 0, 0,
  0x23, 0xf, 0x69, 0, 0,
  0x34, 0x66, 0xf, 0x6a, 0, 0,
  0x23, 0xf, 0x6a, 0, 0,
  0x34, 0x66, 0xf, 0x6b, 0, 0,
  0x23, 0xf, 0x6b, 0, 0,
  0x34, 0x66, 0xf, 0x6c, 0, 0,
  0x34, 0x66, 0xf, 0x6d, 0, 0,
  0x34, 0x66, 0xf, 0x6e, 0, 0,
  0x23, 0xf, 0x6e, 0, 0,
  0x34, 0x66, 0xf, 0x6f, 0, 0,
  0x34, 0xf3, 0xf, 0x6f, 0, 0,
  0x23, 0xf, 0x6f, 0, 0,
  0x34, 0x66, 0xf, 0x70, 0, 0,
  0x34, 0xf2, 0xf, 0x70, 0, 0,
  0x34, 0xf3, 0xf, 0x70, 0, 0,
  0x23, 0xf, 0x70, 0, 0,
  0x34, 0x66, 0xf, 0x74, 0, 0,
  0x23, 0xf, 0x74, 0, 0,
  0x34, 0x66, 0xf, 0x75, 0, 0,
  0x23, 0xf, 0x75, 0, 0,
  0x34, 0x66, 0xf, 0x76, 0, 0,
  0x23, 0xf, 0x76, 0, 0,
  0x34, 0x66, 0xf, 0x7c, 0, 0,
  0x34, 0xf2, 0xf, 0x7c, 0, 0,
  0x34, 0x66, 0xf, 0x7d, 0, 0,
  0x34, 0xf2, 0xf, 0x7d, 0, 0,
  0x34, 0x66, 0xf, 0x7e, 0, 0,
  0x34, 0xf3, 0xf, 0x7e, 0, 0,
  0x23, 0xf, 0x7e, 0, 0,
  0x34, 0x66, 0xf, 0x7f, 0, 0,
  0x34, 0xf3, 0xf, 0x7f, 0, 0,
  0x23, 0xf, 0x7f, 0, 0,
  0x23, 0xf, 0xc3, 0, 0,
  0x34, 0x66, 0xf, 0xc4, 0, 0,
  0x23, 0xf, 0xc4, 0, 0,
  0x34, 0x66, 0xf, 0xc5, 0xc0, 0xc0,
  0x23, 0xf, 0xc5, 0xc0, 0xc0,
  0x34, 0x66, 0xf, 0xc6, 0, 0,
  0x23, 0xf, 0xc6, 0, 0,
  0x34, 0x66, 0xf, 0xd1, 0, 0,
  0x23, 0xf, 0xd1, 0, 0,
  0x34, 0x66, 0xf, 0xd2, 0, 0,
  0x23, 0xf, 0xd2, 0, 0,
  0x34, 0x66, 0xf, 0xd3, 0, 0,
  0x23, 0xf, 0xd3, 0, 0,
  0x34, 0x66, 0xf, 0xd4, 0, 0,
  0x23, 0xf, 0xd4, 0, 0,
  0x34, 0x66, 0xf, 0xd5, 0, 0,
  0x23, 0xf, 0xd5, 0, 0,
  0x34, 0x66, 0xf, 0xd6, 0, 0,
  0x34, 0xf2, 0xf, 0xd6, 0xc0, 0xc0,
  0x34, 0xf3, 0xf, 0xd6, 0xc0, 0xc0,
  0x34, 0x66, 0xf, 0xd7, 0xc0, 0xc0,
  0x23, 0xf, 0xd7, 0xc0, 0xc0,
  0x34, 0x66, 0xf, 0xd8, 0, 0,
  0x23, 0xf, 0xd8, 0, 0,
  0x34, 0x66, 0xf, 0xd9, 0, 0,
  0x23, 0xf, 0xd9, 0, 0,
  0x34, 0x66, 0xf, 0xda, 0, 0,
  0x23, 0xf, 0xda, 0, 0,
  0x34, 0x66, 0xf, 0xdc, 0, 0,
  0x23, 0xf, 0xdc, 0, 0,
  0x34, 0x66, 0xf, 0xdd, 0, 0,
  0x23, 0xf, 0xdd, 0, 0,
  0x34, 0x66, 0xf, 0xde, 0, 0,
  0x23, 0xf, 0xde, 0, 0,
  0x34, 0x66, 0xf, 0xe0, 0, 0,
  0x23, 0xf, 0xe0, 0, 0,
  0x34, 0x66, 0xf, 0xe1, 0, 0,
  0x23, 0xf, 0xe1, 0, 0,
  0x34, 0x66, 0xf, 0xe2, 0, 0,
  0x23, 0xf, 0xe2, 0, 0,
  0x34, 0x66, 0xf, 0xe3, 0, 0,
  0x23, 0xf, 0xe3, 0, 0,
  0x34, 0x66, 0xf, 0xe4, 0, 0,
  0x23, 0xf, 0xe4, 0, 0,
  0x34, 0x66, 0xf, 0xe5, 0, 0,
  0x23, 0xf, 0xe5, 0, 0,
  0x34, 0x66, 0xf, 0xe7, 0, 0,
  0x23, 0xf, 0xe7, 0, 0,
  0x34, 0x66, 0xf, 0xe8, 0, 0,
  0x23, 0xf, 0xe8, 0, 0,
  0x34, 0x66, 0xf, 0xe9, 0, 0,
  0x23, 0xf, 0xe9, 0, 0,
  0x34, 0x66, 0xf, 0xea, 0, 0,
  0x23, 0xf, 0xea, 0, 0,
  0x34, 0x66, 0xf, 0xec, 0, 0,
  0x23, 0xf, 0xec, 0, 0,
  0x34, 0x66, 0xf, 0xed, 0, 0,
  0x23, 0xf, 0xed, 0, 0,
  0x34, 0x66, 0xf, 0xee, 0, 0,
  0x23, 0xf, 0xee, 0, 0,
  0x34, 0xf2, 0xf, 0xf0, 0, 0,
  0x34, 0x66, 0xf, 0xf1, 0, 0,
  0x23, 0xf, 0xf1, 0, 0,
  0x34, 0x66, 0xf, 0xf2, 0, 0,
  0x23, 0xf, 0xf2, 0, 0,
  0x34, 0x66, 0xf, 0xf3, 0, 0,
  0x23, 0xf, 0xf3, 0, 0,
  0x34, 0x66, 0xf, 0xf4, 0, 0,
  0x23, 0xf, 0xf4, 0, 0,
  0x34, 0x66, 0xf, 0xf6, 0, 0,
  0x23, 0xf, 0xf6, 0, 0,
  0x34, 0x66, 0xf, 0xf7, 0xc0, 0xc0,
  0x23, 0xf, 0xf7, 0xc0, 0xc0,
  0x34, 0x66, 0xf, 0xf8, 0, 0,
  0x23, 0xf, 0xf8, 0, 0,
  0x34, 0x66, 0xf, 0xf9, 0, 0,
  0x23, 0xf, 0xf9, 0, 0,
  0x34, 0x66, 0xf, 0xfa, 0, 0,
  0x23, 0xf, 0xfa, 0, 0,
  0x34, 0x66, 0xf, 0xfb, 0, 0,
  0x23, 0xf, 0xfb, 0, 0,
  0x34, 0x66, 0xf, 0xfc, 0, 0,
  0x23, 0xf, 0xfc, 0, 0,
  0x34, 0x66, 0xf, 0xfd, 0, 0,
  0x23, 0xf, 0xfd, 0, 0,
  0x34, 0x66, 0xf, 0xfe, 0, 0,
  0x23, 0xf, 0xfe, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0, 0, 0,
  0x34, 0xf, 0x38, 0, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x1, 0, 0,
  0x34, 0xf, 0x38, 0x1, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x2, 0, 0,
  0x34, 0xf, 0x38, 0x2, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x3, 0, 0,
  0x34, 0xf, 0x38, 0x3, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x4, 0, 0,
  0x34, 0xf, 0x38, 0x4, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x5, 0, 0,
  0x34, 0xf, 0x38, 0x5, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x6, 0, 0,
  0x34, 0xf, 0x38, 0x6, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x7, 0, 0,
  0x34, 0xf, 0x38, 0x7, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x8, 0, 0,
  0x34, 0xf, 0x38, 0x8, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x9, 0, 0,
  0x34, 0xf, 0x38, 0x9, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0xa, 0, 0,
  0x34, 0xf, 0x38, 0xa, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0xb, 0, 0,
  0x34, 0xf, 0x38, 0xb, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x1c, 0, 0,
  0x34, 0xf, 0x38, 0x1c, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x1d, 0, 0,
  0x34, 0xf, 0x38, 0x1d, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x1e, 0, 0,
  0x34, 0xf, 0x38, 0x1e, 0, 0,
  0x45, 0x66, 0xf, 0x3a, 0xf, 0, 0,
  0x34, 0xf, 0x3a, 0xf, 0, 0,
  0x34, 0x66, 0xf, 0xc7, 0x38, 0x30,
  0x34, 0xf3, 0xf, 0xc7, 0x38, 0x30,
  0x23, 0xf, 0xc7, 0x38, 0x30,
  0x23, 0xf, 0xc7, 0x38, 0x38,
  0x34, 0x66, 0xf, 0x71, 0xf8, 0xd0,
  0x23, 0xf, 0x71, 0xf8, 0xd0,
  0x34, 0x66, 0xf, 0x71, 0xf8, 0xe0,
  0x23, 0xf, 0x71, 0xf8, 0xe0,
  0x34, 0x66, 0xf, 0x71, 0xf8, 0xf0,
  0x23, 0xf, 0x71, 0xf8, 0xf0,
  0x34, 0x66, 0xf, 0x72, 0xf8, 0xd0,
  0x23, 0xf, 0x72, 0xf8, 0xd0,
  0x34, 0x66, 0xf, 0x72, 0xf8, 0xe0,
  0x23, 0xf, 0x72, 0xf8, 0xe0,
  0x34, 0x66, 0xf, 0x72, 0xf8, 0xf0,
  0x23, 0xf, 0x72, 0xf8, 0xf0,
  0x34, 0x66, 0xf, 0x73, 0xf8, 0xd0,
  0x23, 0xf, 0x73, 0xf8, 0xd0,
  0x34, 0x66, 0xf, 0x73, 0xf8, 0xd8,
  0x34, 0x66, 0xf, 0x73, 0xf8, 0xf0,
  0x23, 0xf, 0x73, 0xf8, 0xf0,
  0x34, 0x66, 0xf, 0x73, 0xf8, 0xf8,
  0x33, 0xf, 0xae, 0xe8,
  0x33, 0xf, 0xae, 0xf0,
  0x33, 0xf, 0xae, 0xf8,
  0x23, 0xf, 0xae, 0x38, 0x38,
  0x23, 0xf, 0xf, 0, 0,
  0x45, 0x66, 0xf, 0x3a, 0xc, 0, 0,
  0x45, 0x66, 0xf, 0x3a, 0xd, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x14, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x15, 0, 0,
  0x45, 0x66, 0xf, 0x3a, 0x40, 0, 0,
  0x45, 0x66, 0xf, 0x3a, 0x41, 0, 0,
  0x45, 0x66, 0xf, 0x3a, 0x21, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x2a, 0, 0,
  0x45, 0x66, 0xf, 0x3a, 0x42, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x2b, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x10, 0, 0,
  0x45, 0x66, 0xf, 0x3a, 0xe, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x29, 0, 0,
  0x45, 0x66, 0xf, 0x3a, 0x61, 0, 0,
  0x45, 0x66, 0xf, 0x3a, 0x60, 0, 0,
  0x45, 0x66, 0xf, 0x3a, 0x63, 0, 0,
  0x45, 0x66, 0xf, 0x3a, 0x62, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x37, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x41, 0, 0,
  0x45, 0x66, 0xf, 0x3a, 0x20, 0, 0,
  0x45, 0x66, 0xf, 0x3a, 0x22, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x3c, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x3d, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x3f, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x3e, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x38, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x39, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x3b, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x3a, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x20, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x21, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x22, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x23, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x24, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x25, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x30, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x31, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x32, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x33, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x34, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x35, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x28, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x40, 0, 0,
  0x45, 0x66, 0xf, 0x38, 0x17, 0, 0,
  0x45, 0x66, 0xf, 0x3a, 0x8, 0, 0,
  0x45, 0x66, 0xf, 0x3a, 0x9, 0, 0,
  0x45, 0x66, 0xf, 0x3a, 0xa, 0, 0,
  0x45, 0x66, 0xf, 0x3a, 0xb, 0, 0,
  0x1, 0xe7, 0x7,
};
