/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import thredds.catalog.DataFormatType;
import thredds.catalog.DatasetFilter;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvDataset;
import thredds.catalog.ServiceType;
import thredds.catalog.ui.CatalogChooser;
import thredds.catalog.ui.ThreddsDatasetChooser;
import thredds.catalog.ui.tools.CatalogEnhancer;
import thredds.catalog.ui.tools.DLCrawler;
import thredds.catalog.ui.tools.TDServerConfigurator;
import thredds.ui.BAMutil;
import thredds.ui.FileManager;
import thredds.ui.IndependentDialog;
import thredds.ui.IndependentWindow;
import thredds.ui.TextGetPutPane;
import thredds.ui.TextHistoryPane;
import ucar.nc2.util.IO;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.Debug;

public class ThreddsUI
extends JPanel {
    private static final String VIEWER_SIZE = "ViewerSize";
    private static final String SOURCE_WINDOW_SIZE = "SourceWindowSize";
    private static final String XML_WINDOW_SIZE = "XmlWindowSize";
    private PreferencesExt store;
    private Component parent;
    private ThreddsDatasetChooser datasetChooser = null;
    private CatalogEnhancer catEditor = null;
    private DLCrawler catCrawler = null;
    private TDServerConfigurator serverConfigure = null;
    private TextGetPutPane sourcePane;
    private JTabbedPane tabbedPane;
    private TextHistoryPane xmlPane;
    private IndependentDialog xmlWindow = null;
    private IndependentWindow sourceWindow = null;
    FileManager fileChooser = null;
    private int defaultWidth = 700;
    private int defaultHeight = 350;
    private boolean debugSelection = false;

    public ThreddsUI(JFrame parent, PreferencesExt store) {
        this.store = store;
        this.parent = parent;
        this.enableEvents(64L);
        Dimension d = (Dimension)store.getBean(VIEWER_SIZE, null);
        this.setPreferredSize(d != null ? d : new Dimension(this.defaultWidth, this.defaultHeight));
        try {
            this.makeActionsSystem();
            this.makeActionsDataset();
            this.makeUI();
        }
        catch (Exception e) {
            System.out.println("UI creation Exception");
            e.printStackTrace();
        }
        PreferencesExt fcPrefs = (PreferencesExt)store.node("FileManager");
        FileFilter[] filters = new FileFilter[]{new FileManager.NetcdfExtFilter()};
        this.fileChooser = new FileManager(parent, null, filters, fcPrefs);
    }

    private void makeUI() throws Exception {
        this.tabbedPane = new JTabbedPane(1);
        this.datasetChooser = this.makeDatasetChooser(this.tabbedPane);
        this.sourcePane = new TextGetPutPane((PreferencesExt)this.store.node("getputPane"));
        this.sourceWindow = new IndependentWindow("Source", BAMutil.getImage("thredds"), this.sourcePane);
        this.sourceWindow.setBounds((Rectangle)this.store.getBean(SOURCE_WINDOW_SIZE, new Rectangle(50, 50, 725, 450)));
        this.xmlPane = new TextHistoryPane(false);
        this.xmlWindow = new IndependentDialog(null, false, "XML data", this.xmlPane);
        this.xmlWindow.setBounds((Rectangle)this.store.getBean(XML_WINDOW_SIZE, new Rectangle(50, 50, 725, 450)));
        boolean showSystemTools = Debug.isSet("thredds/showTools");
        if (showSystemTools) {
            this.catEditor = new CatalogEnhancer((PreferencesExt)this.store.node("catEditor"), this.parent);
            this.tabbedPane.addTab("Catalog Enhancer", this.catEditor);
            this.catCrawler = new DLCrawler((PreferencesExt)this.store.node("catCrawler"), this.parent);
            this.tabbedPane.addTab("DLCrawler", this.catCrawler);
            this.serverConfigure = new TDServerConfigurator((PreferencesExt)this.store.node("serverConfigure"), this.parent);
            this.tabbedPane.addTab("TDS Configure", this.serverConfigure);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
    }

    private ThreddsDatasetChooser makeDatasetChooser(JTabbedPane tabbedPane) {
        this.datasetChooser = new ThreddsDatasetChooser((PreferencesExt)this.store.node("ThreddsDatasetChooser"), tabbedPane);
        if (Debug.isSet("System/filterDataset")) {
            this.datasetChooser.setDatasetFilter(new DatasetFilter.ByServiceType(ServiceType.DODS));
        }
        this.datasetChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("InvAccess")) {
                    ThreddsUI.this.firePropertyChangeEvent(e);
                    return;
                }
                if (e.getPropertyName().equals("Dataset") || e.getPropertyName().equals("File")) {
                    DataFormatType format;
                    InvDataset ds = (InvDataset)e.getNewValue();
                    InvAccess access = ds.getAccess(ServiceType.HTTPServer);
                    if (access != null && ((format = access.getDataFormatType()) == DataFormatType.PLAIN || format == DataFormatType.XML)) {
                        String urlString = access.getStandardUrlName();
                        IO.readURLcontents(urlString);
                        ThreddsUI.this.xmlPane.setText(IO.readURLcontents(urlString));
                        ThreddsUI.this.xmlPane.gotoTop();
                        ThreddsUI.this.xmlWindow.setVisible(true);
                        return;
                    }
                    ThreddsUI.this.firePropertyChangeEvent(e);
                }
            }
        });
        JButton catSource = new JButton("Source");
        catSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CatalogChooser cc = ThreddsUI.this.datasetChooser.getCatalogChooser();
                String catURL = cc.getCurrentURL();
                if (ThreddsUI.this.debugSelection) {
                    System.out.println("Catalog Source: url = " + catURL);
                }
                ThreddsUI.this.sourcePane.setURL(catURL);
                ThreddsUI.this.sourcePane.gotoTop();
                ThreddsUI.this.sourceWindow.show();
            }
        });
        this.datasetChooser.getCatalogChooser().addButton(catSource);
        JButton dcqSource = new JButton("Source");
        dcqSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String catURL = ThreddsUI.this.datasetChooser.getQueryChooser().getCurrentURL();
                ThreddsUI.this.sourcePane.setURL(catURL);
                ThreddsUI.this.sourcePane.gotoTop();
                ThreddsUI.this.sourceWindow.show();
            }
        });
        this.datasetChooser.getQueryChooser().addButton(dcqSource);
        JButton dqcCatSource = new JButton("Source");
        dqcCatSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String catURL = ThreddsUI.this.datasetChooser.getQueryChooser().getCatalogChooser().getCurrentURL();
                System.out.println("DQC Catalog Source: url = " + catURL);
                ThreddsUI.this.sourcePane.setURL(catURL);
                ThreddsUI.this.sourcePane.gotoTop();
                ThreddsUI.this.sourceWindow.show();
            }
        });
        this.datasetChooser.getQueryChooser().getCatalogChooser().addButton(dqcCatSource);
        return this.datasetChooser;
    }

    public void storePersistentData() {
        this.store.putBeanObject(VIEWER_SIZE, this.getSize());
        this.store.putBeanObject(SOURCE_WINDOW_SIZE, this.sourceWindow.getBounds());
        if (this.fileChooser != null) {
            this.fileChooser.save();
        }
        if (this.datasetChooser != null) {
            this.datasetChooser.save();
        }
        if (this.sourcePane != null) {
            this.sourcePane.save();
        }
        if (this.catEditor != null) {
            this.catEditor.save();
        }
        if (this.catCrawler != null) {
            this.catCrawler.save();
        }
        if (this.serverConfigure != null) {
            this.serverConfigure.save();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.add(PropertyChangeListener.class, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.remove(PropertyChangeListener.class, l);
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PropertyChangeListener.class) continue;
            ((PropertyChangeListener)listeners[i + 1]).propertyChange(event);
        }
    }

    public void setDataset(String location) {
        this.datasetChooser.getCatalogChooser().setCatalog(location);
        this.tabbedPane.setSelectedComponent(this.datasetChooser.getCatalogChooser());
    }

    private void makeActionsSystem() {
        AbstractAction clearDebugFlagsAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
            }
        };
        BAMutil.setActionProperties(clearDebugFlagsAction, null, "Clear Debug Flags", false, 68, -1);
        AbstractAction setDebugFlagsAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                InvCatalogFactory.debugURL = Debug.isSet("InvCatalogFactory/debugURL");
                InvCatalogFactory.debugOpen = Debug.isSet("InvCatalogFactory/debugOpen");
                InvCatalogFactory.debugVersion = Debug.isSet("InvCatalogFactory/debugVersion");
                InvCatalogFactory.showParsedXML = Debug.isSet("InvCatalogFactory/showParsedXML");
                InvCatalogFactory.showStackTrace = Debug.isSet("InvCatalogFactory/showStackTrace");
                InvCatalogFactory.debugXML = Debug.isSet("InvCatalogFactory/debugXML");
                InvCatalogFactory.debugDBurl = Debug.isSet("InvCatalogFactory/debugDBurl");
                InvCatalogFactory.debugXMLopen = Debug.isSet("InvCatalogFactory/debugXMLopen");
                InvCatalogFactory.showCatalogXML = Debug.isSet("InvCatalogFactory/showCatalogXML");
            }
        };
        BAMutil.setActionProperties(setDebugFlagsAction, null, "Set Debug Flags", false, 83, -1);
    }

    private void makeActionsDataset() {
    }
}

