// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package autoscaling provides a client for Auto Scaling.
package autoscaling

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opAttachInstances = "AttachInstances"

// AttachInstancesRequest generates a request for the AttachInstances operation.
func (c *AutoScaling) AttachInstancesRequest(input *AttachInstancesInput) (req *request.Request, output *AttachInstancesOutput) {
	op := &request.Operation{
		Name:       opAttachInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &AttachInstancesOutput{}
	req.Data = output
	return
}

// Attaches one or more EC2 instances to the specified Auto Scaling group.
//
// When you attach instances, Auto Scaling increases the desired capacity of
// the group by the number of instances being attached. If the number of instances
// being attached plus the desired capacity of the group exceeds the maximum
// size of the group, the operation fails.
//
// For more information, see Attach EC2 Instances to Your Auto Scaling Group
// (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/attach-instance-asg.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) AttachInstances(input *AttachInstancesInput) (*AttachInstancesOutput, error) {
	req, out := c.AttachInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opAttachLoadBalancers = "AttachLoadBalancers"

// AttachLoadBalancersRequest generates a request for the AttachLoadBalancers operation.
func (c *AutoScaling) AttachLoadBalancersRequest(input *AttachLoadBalancersInput) (req *request.Request, output *AttachLoadBalancersOutput) {
	op := &request.Operation{
		Name:       opAttachLoadBalancers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachLoadBalancersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AttachLoadBalancersOutput{}
	req.Data = output
	return
}

// Attaches one or more load balancers to the specified Auto Scaling group.
//
// To describe the load balancers for an Auto Scaling group, use DescribeLoadBalancers.
// To detach the load balancer from the Auto Scaling group, use DetachLoadBalancers.
//
// For more information, see Attach a Load Balancer to Your Auto Scaling Group
// (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/attach-load-balancer-asg.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) AttachLoadBalancers(input *AttachLoadBalancersInput) (*AttachLoadBalancersOutput, error) {
	req, out := c.AttachLoadBalancersRequest(input)
	err := req.Send()
	return out, err
}

const opCompleteLifecycleAction = "CompleteLifecycleAction"

// CompleteLifecycleActionRequest generates a request for the CompleteLifecycleAction operation.
func (c *AutoScaling) CompleteLifecycleActionRequest(input *CompleteLifecycleActionInput) (req *request.Request, output *CompleteLifecycleActionOutput) {
	op := &request.Operation{
		Name:       opCompleteLifecycleAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CompleteLifecycleActionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CompleteLifecycleActionOutput{}
	req.Data = output
	return
}

// Completes the lifecycle action for the associated token initiated under the
// given lifecycle hook with the specified result.
//
// This operation is a part of the basic sequence for adding a lifecycle hook
// to an Auto Scaling group:
//
//  Create a notification target. A target can be either an Amazon SQS queue
// or an Amazon SNS topic. Create an IAM role. This role allows Auto Scaling
// to publish lifecycle notifications to the designated SQS queue or SNS topic.
// Create the lifecycle hook. You can create a hook that acts when instances
// launch or when instances terminate. If necessary, record the lifecycle action
// heartbeat to keep the instance in a pending state. Complete the lifecycle
// action.  For more information, see Auto Scaling Pending State (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingPendingState.html)
// and Auto Scaling Terminating State (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingTerminatingState.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) CompleteLifecycleAction(input *CompleteLifecycleActionInput) (*CompleteLifecycleActionOutput, error) {
	req, out := c.CompleteLifecycleActionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateAutoScalingGroup = "CreateAutoScalingGroup"

// CreateAutoScalingGroupRequest generates a request for the CreateAutoScalingGroup operation.
func (c *AutoScaling) CreateAutoScalingGroupRequest(input *CreateAutoScalingGroupInput) (req *request.Request, output *CreateAutoScalingGroupOutput) {
	op := &request.Operation{
		Name:       opCreateAutoScalingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAutoScalingGroupInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &CreateAutoScalingGroupOutput{}
	req.Data = output
	return
}

// Creates an Auto Scaling group with the specified name and attributes.
//
// If you exceed your maximum limit of Auto Scaling groups, which by default
// is 20 per region, the call fails. For information about viewing and updating
// this limit, see DescribeAccountLimits.
//
// For more information, see Auto Scaling Groups (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingGroup.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) CreateAutoScalingGroup(input *CreateAutoScalingGroupInput) (*CreateAutoScalingGroupOutput, error) {
	req, out := c.CreateAutoScalingGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateLaunchConfiguration = "CreateLaunchConfiguration"

// CreateLaunchConfigurationRequest generates a request for the CreateLaunchConfiguration operation.
func (c *AutoScaling) CreateLaunchConfigurationRequest(input *CreateLaunchConfigurationInput) (req *request.Request, output *CreateLaunchConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateLaunchConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLaunchConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &CreateLaunchConfigurationOutput{}
	req.Data = output
	return
}

// Creates a launch configuration.
//
// If you exceed your maximum limit of launch configurations, which by default
// is 100 per region, the call fails. For information about viewing and updating
// this limit, see DescribeAccountLimits.
//
// For more information, see Launch Configurations (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/LaunchConfiguration.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) CreateLaunchConfiguration(input *CreateLaunchConfigurationInput) (*CreateLaunchConfigurationOutput, error) {
	req, out := c.CreateLaunchConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opCreateOrUpdateTags = "CreateOrUpdateTags"

// CreateOrUpdateTagsRequest generates a request for the CreateOrUpdateTags operation.
func (c *AutoScaling) CreateOrUpdateTagsRequest(input *CreateOrUpdateTagsInput) (req *request.Request, output *CreateOrUpdateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateOrUpdateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateOrUpdateTagsInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &CreateOrUpdateTagsOutput{}
	req.Data = output
	return
}

// Creates or updates tags for the specified Auto Scaling group.
//
// A tag is defined by its resource ID, resource type, key, value, and propagate
// flag. The value and the propagate flag are optional parameters. The only
// supported resource type is auto-scaling-group, and the resource ID must be
// the name of the group. The PropagateAtLaunch flag determines whether the
// tag is added to instances launched in the group. Valid values are true or
// false.
//
// When you specify a tag with a key that already exists, the operation overwrites
// the previous tag definition, and you do not get an error message.
//
// For more information, see Tagging Auto Scaling Groups and Instances (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/ASTagging.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) CreateOrUpdateTags(input *CreateOrUpdateTagsInput) (*CreateOrUpdateTagsOutput, error) {
	req, out := c.CreateOrUpdateTagsRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteAutoScalingGroup = "DeleteAutoScalingGroup"

// DeleteAutoScalingGroupRequest generates a request for the DeleteAutoScalingGroup operation.
func (c *AutoScaling) DeleteAutoScalingGroupRequest(input *DeleteAutoScalingGroupInput) (req *request.Request, output *DeleteAutoScalingGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteAutoScalingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAutoScalingGroupInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteAutoScalingGroupOutput{}
	req.Data = output
	return
}

// Deletes the specified Auto Scaling group.
//
// If the group has instances or scaling activities in progress, you must specify
// the option to force the deletion in order for it to succeed.
//
// If the group has policies, deleting the group deletes the policies, the
// underlying alarm actions, and any alarm that no longer has an associated
// action.
//
// To remove instances from the Auto Scaling group before deleting it, call
// DetachInstances with the list of instances and the option to decrement the
// desired capacity so that Auto Scaling does not launch replacement instances.
//
// To terminate all instances before deleting the Auto Scaling group, call
// UpdateAutoScalingGroup and set the minimum size and desired capacity of the
// Auto Scaling group to zero.
func (c *AutoScaling) DeleteAutoScalingGroup(input *DeleteAutoScalingGroupInput) (*DeleteAutoScalingGroupOutput, error) {
	req, out := c.DeleteAutoScalingGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteLaunchConfiguration = "DeleteLaunchConfiguration"

// DeleteLaunchConfigurationRequest generates a request for the DeleteLaunchConfiguration operation.
func (c *AutoScaling) DeleteLaunchConfigurationRequest(input *DeleteLaunchConfigurationInput) (req *request.Request, output *DeleteLaunchConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteLaunchConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLaunchConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteLaunchConfigurationOutput{}
	req.Data = output
	return
}

// Deletes the specified launch configuration.
//
// The launch configuration must not be attached to an Auto Scaling group.
// When this call completes, the launch configuration is no longer available
// for use.
func (c *AutoScaling) DeleteLaunchConfiguration(input *DeleteLaunchConfigurationInput) (*DeleteLaunchConfigurationOutput, error) {
	req, out := c.DeleteLaunchConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteLifecycleHook = "DeleteLifecycleHook"

// DeleteLifecycleHookRequest generates a request for the DeleteLifecycleHook operation.
func (c *AutoScaling) DeleteLifecycleHookRequest(input *DeleteLifecycleHookInput) (req *request.Request, output *DeleteLifecycleHookOutput) {
	op := &request.Operation{
		Name:       opDeleteLifecycleHook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLifecycleHookInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteLifecycleHookOutput{}
	req.Data = output
	return
}

// Deletes the specified lifecycle hook.
//
// If there are any outstanding lifecycle actions, they are completed first
// (ABANDON for launching instances, CONTINUE for terminating instances).
func (c *AutoScaling) DeleteLifecycleHook(input *DeleteLifecycleHookInput) (*DeleteLifecycleHookOutput, error) {
	req, out := c.DeleteLifecycleHookRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteNotificationConfiguration = "DeleteNotificationConfiguration"

// DeleteNotificationConfigurationRequest generates a request for the DeleteNotificationConfiguration operation.
func (c *AutoScaling) DeleteNotificationConfigurationRequest(input *DeleteNotificationConfigurationInput) (req *request.Request, output *DeleteNotificationConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteNotificationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNotificationConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteNotificationConfigurationOutput{}
	req.Data = output
	return
}

// Deletes the specified notification.
func (c *AutoScaling) DeleteNotificationConfiguration(input *DeleteNotificationConfigurationInput) (*DeleteNotificationConfigurationOutput, error) {
	req, out := c.DeleteNotificationConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opDeletePolicy = "DeletePolicy"

// DeletePolicyRequest generates a request for the DeletePolicy operation.
func (c *AutoScaling) DeletePolicyRequest(input *DeletePolicyInput) (req *request.Request, output *DeletePolicyOutput) {
	op := &request.Operation{
		Name:       opDeletePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeletePolicyOutput{}
	req.Data = output
	return
}

// Deletes the specified Auto Scaling policy.
//
// Deleting a policy deletes the underlying alarm action, but does not delete
// the alarm, even if it no longer has an associated action.
func (c *AutoScaling) DeletePolicy(input *DeletePolicyInput) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteScheduledAction = "DeleteScheduledAction"

// DeleteScheduledActionRequest generates a request for the DeleteScheduledAction operation.
func (c *AutoScaling) DeleteScheduledActionRequest(input *DeleteScheduledActionInput) (req *request.Request, output *DeleteScheduledActionOutput) {
	op := &request.Operation{
		Name:       opDeleteScheduledAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteScheduledActionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteScheduledActionOutput{}
	req.Data = output
	return
}

// Deletes the specified scheduled action.
func (c *AutoScaling) DeleteScheduledAction(input *DeleteScheduledActionInput) (*DeleteScheduledActionOutput, error) {
	req, out := c.DeleteScheduledActionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a request for the DeleteTags operation.
func (c *AutoScaling) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteTagsOutput{}
	req.Data = output
	return
}

// Deletes the specified tags.
func (c *AutoScaling) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAccountLimits = "DescribeAccountLimits"

// DescribeAccountLimitsRequest generates a request for the DescribeAccountLimits operation.
func (c *AutoScaling) DescribeAccountLimitsRequest(input *DescribeAccountLimitsInput) (req *request.Request, output *DescribeAccountLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountLimitsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAccountLimitsOutput{}
	req.Data = output
	return
}

// Describes the current Auto Scaling resource limits for your AWS account.
//
// For information about requesting an increase in these limits, see AWS Service
// Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html)
// in the Amazon Web Services General Reference.
func (c *AutoScaling) DescribeAccountLimits(input *DescribeAccountLimitsInput) (*DescribeAccountLimitsOutput, error) {
	req, out := c.DescribeAccountLimitsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAdjustmentTypes = "DescribeAdjustmentTypes"

// DescribeAdjustmentTypesRequest generates a request for the DescribeAdjustmentTypes operation.
func (c *AutoScaling) DescribeAdjustmentTypesRequest(input *DescribeAdjustmentTypesInput) (req *request.Request, output *DescribeAdjustmentTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeAdjustmentTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAdjustmentTypesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAdjustmentTypesOutput{}
	req.Data = output
	return
}

// Describes the policy adjustment types for use with PutScalingPolicy.
func (c *AutoScaling) DescribeAdjustmentTypes(input *DescribeAdjustmentTypesInput) (*DescribeAdjustmentTypesOutput, error) {
	req, out := c.DescribeAdjustmentTypesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAutoScalingGroups = "DescribeAutoScalingGroups"

// DescribeAutoScalingGroupsRequest generates a request for the DescribeAutoScalingGroups operation.
func (c *AutoScaling) DescribeAutoScalingGroupsRequest(input *DescribeAutoScalingGroupsInput) (req *request.Request, output *DescribeAutoScalingGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeAutoScalingGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAutoScalingGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAutoScalingGroupsOutput{}
	req.Data = output
	return
}

// Describes one or more Auto Scaling groups. If a list of names is not provided,
// the call describes all Auto Scaling groups.
func (c *AutoScaling) DescribeAutoScalingGroups(input *DescribeAutoScalingGroupsInput) (*DescribeAutoScalingGroupsOutput, error) {
	req, out := c.DescribeAutoScalingGroupsRequest(input)
	err := req.Send()
	return out, err
}

func (c *AutoScaling) DescribeAutoScalingGroupsPages(input *DescribeAutoScalingGroupsInput, fn func(p *DescribeAutoScalingGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeAutoScalingGroupsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeAutoScalingGroupsOutput), lastPage)
	})
}

const opDescribeAutoScalingInstances = "DescribeAutoScalingInstances"

// DescribeAutoScalingInstancesRequest generates a request for the DescribeAutoScalingInstances operation.
func (c *AutoScaling) DescribeAutoScalingInstancesRequest(input *DescribeAutoScalingInstancesInput) (req *request.Request, output *DescribeAutoScalingInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeAutoScalingInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAutoScalingInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAutoScalingInstancesOutput{}
	req.Data = output
	return
}

// Describes one or more Auto Scaling instances. If a list is not provided,
// the call describes all instances.
func (c *AutoScaling) DescribeAutoScalingInstances(input *DescribeAutoScalingInstancesInput) (*DescribeAutoScalingInstancesOutput, error) {
	req, out := c.DescribeAutoScalingInstancesRequest(input)
	err := req.Send()
	return out, err
}

func (c *AutoScaling) DescribeAutoScalingInstancesPages(input *DescribeAutoScalingInstancesInput, fn func(p *DescribeAutoScalingInstancesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeAutoScalingInstancesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeAutoScalingInstancesOutput), lastPage)
	})
}

const opDescribeAutoScalingNotificationTypes = "DescribeAutoScalingNotificationTypes"

// DescribeAutoScalingNotificationTypesRequest generates a request for the DescribeAutoScalingNotificationTypes operation.
func (c *AutoScaling) DescribeAutoScalingNotificationTypesRequest(input *DescribeAutoScalingNotificationTypesInput) (req *request.Request, output *DescribeAutoScalingNotificationTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeAutoScalingNotificationTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAutoScalingNotificationTypesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAutoScalingNotificationTypesOutput{}
	req.Data = output
	return
}

// Describes the notification types that are supported by Auto Scaling.
func (c *AutoScaling) DescribeAutoScalingNotificationTypes(input *DescribeAutoScalingNotificationTypesInput) (*DescribeAutoScalingNotificationTypesOutput, error) {
	req, out := c.DescribeAutoScalingNotificationTypesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeLaunchConfigurations = "DescribeLaunchConfigurations"

// DescribeLaunchConfigurationsRequest generates a request for the DescribeLaunchConfigurations operation.
func (c *AutoScaling) DescribeLaunchConfigurationsRequest(input *DescribeLaunchConfigurationsInput) (req *request.Request, output *DescribeLaunchConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeLaunchConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeLaunchConfigurationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeLaunchConfigurationsOutput{}
	req.Data = output
	return
}

// Describes one or more launch configurations. If you omit the list of names,
// then the call describes all launch configurations.
func (c *AutoScaling) DescribeLaunchConfigurations(input *DescribeLaunchConfigurationsInput) (*DescribeLaunchConfigurationsOutput, error) {
	req, out := c.DescribeLaunchConfigurationsRequest(input)
	err := req.Send()
	return out, err
}

func (c *AutoScaling) DescribeLaunchConfigurationsPages(input *DescribeLaunchConfigurationsInput, fn func(p *DescribeLaunchConfigurationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeLaunchConfigurationsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeLaunchConfigurationsOutput), lastPage)
	})
}

const opDescribeLifecycleHookTypes = "DescribeLifecycleHookTypes"

// DescribeLifecycleHookTypesRequest generates a request for the DescribeLifecycleHookTypes operation.
func (c *AutoScaling) DescribeLifecycleHookTypesRequest(input *DescribeLifecycleHookTypesInput) (req *request.Request, output *DescribeLifecycleHookTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeLifecycleHookTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLifecycleHookTypesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeLifecycleHookTypesOutput{}
	req.Data = output
	return
}

// Describes the available types of lifecycle hooks.
func (c *AutoScaling) DescribeLifecycleHookTypes(input *DescribeLifecycleHookTypesInput) (*DescribeLifecycleHookTypesOutput, error) {
	req, out := c.DescribeLifecycleHookTypesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeLifecycleHooks = "DescribeLifecycleHooks"

// DescribeLifecycleHooksRequest generates a request for the DescribeLifecycleHooks operation.
func (c *AutoScaling) DescribeLifecycleHooksRequest(input *DescribeLifecycleHooksInput) (req *request.Request, output *DescribeLifecycleHooksOutput) {
	op := &request.Operation{
		Name:       opDescribeLifecycleHooks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLifecycleHooksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeLifecycleHooksOutput{}
	req.Data = output
	return
}

// Describes the lifecycle hooks for the specified Auto Scaling group.
func (c *AutoScaling) DescribeLifecycleHooks(input *DescribeLifecycleHooksInput) (*DescribeLifecycleHooksOutput, error) {
	req, out := c.DescribeLifecycleHooksRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeLoadBalancers = "DescribeLoadBalancers"

// DescribeLoadBalancersRequest generates a request for the DescribeLoadBalancers operation.
func (c *AutoScaling) DescribeLoadBalancersRequest(input *DescribeLoadBalancersInput) (req *request.Request, output *DescribeLoadBalancersOutput) {
	op := &request.Operation{
		Name:       opDescribeLoadBalancers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoadBalancersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeLoadBalancersOutput{}
	req.Data = output
	return
}

// Describes the load balancers for the specified Auto Scaling group.
func (c *AutoScaling) DescribeLoadBalancers(input *DescribeLoadBalancersInput) (*DescribeLoadBalancersOutput, error) {
	req, out := c.DescribeLoadBalancersRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeMetricCollectionTypes = "DescribeMetricCollectionTypes"

// DescribeMetricCollectionTypesRequest generates a request for the DescribeMetricCollectionTypes operation.
func (c *AutoScaling) DescribeMetricCollectionTypesRequest(input *DescribeMetricCollectionTypesInput) (req *request.Request, output *DescribeMetricCollectionTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeMetricCollectionTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMetricCollectionTypesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeMetricCollectionTypesOutput{}
	req.Data = output
	return
}

// Describes the available CloudWatch metrics for Auto Scaling.
//
// Note that the GroupStandbyInstances metric is not returned by default. You
// must explicitly request this metric when calling EnableMetricsCollection.
func (c *AutoScaling) DescribeMetricCollectionTypes(input *DescribeMetricCollectionTypesInput) (*DescribeMetricCollectionTypesOutput, error) {
	req, out := c.DescribeMetricCollectionTypesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeNotificationConfigurations = "DescribeNotificationConfigurations"

// DescribeNotificationConfigurationsRequest generates a request for the DescribeNotificationConfigurations operation.
func (c *AutoScaling) DescribeNotificationConfigurationsRequest(input *DescribeNotificationConfigurationsInput) (req *request.Request, output *DescribeNotificationConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeNotificationConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeNotificationConfigurationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeNotificationConfigurationsOutput{}
	req.Data = output
	return
}

// Describes the notification actions associated with the specified Auto Scaling
// group.
func (c *AutoScaling) DescribeNotificationConfigurations(input *DescribeNotificationConfigurationsInput) (*DescribeNotificationConfigurationsOutput, error) {
	req, out := c.DescribeNotificationConfigurationsRequest(input)
	err := req.Send()
	return out, err
}

func (c *AutoScaling) DescribeNotificationConfigurationsPages(input *DescribeNotificationConfigurationsInput, fn func(p *DescribeNotificationConfigurationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeNotificationConfigurationsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeNotificationConfigurationsOutput), lastPage)
	})
}

const opDescribePolicies = "DescribePolicies"

// DescribePoliciesRequest generates a request for the DescribePolicies operation.
func (c *AutoScaling) DescribePoliciesRequest(input *DescribePoliciesInput) (req *request.Request, output *DescribePoliciesOutput) {
	op := &request.Operation{
		Name:       opDescribePolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribePoliciesOutput{}
	req.Data = output
	return
}

// Describes the policies for the specified Auto Scaling group.
func (c *AutoScaling) DescribePolicies(input *DescribePoliciesInput) (*DescribePoliciesOutput, error) {
	req, out := c.DescribePoliciesRequest(input)
	err := req.Send()
	return out, err
}

func (c *AutoScaling) DescribePoliciesPages(input *DescribePoliciesInput, fn func(p *DescribePoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribePoliciesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribePoliciesOutput), lastPage)
	})
}

const opDescribeScalingActivities = "DescribeScalingActivities"

// DescribeScalingActivitiesRequest generates a request for the DescribeScalingActivities operation.
func (c *AutoScaling) DescribeScalingActivitiesRequest(input *DescribeScalingActivitiesInput) (req *request.Request, output *DescribeScalingActivitiesOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingActivities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScalingActivitiesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeScalingActivitiesOutput{}
	req.Data = output
	return
}

// Describes one or more scaling activities for the specified Auto Scaling group.
// If you omit the ActivityIds, the call returns all activities from the past
// six weeks. Activities are sorted by the start time. Activities still in progress
// appear first on the list.
func (c *AutoScaling) DescribeScalingActivities(input *DescribeScalingActivitiesInput) (*DescribeScalingActivitiesOutput, error) {
	req, out := c.DescribeScalingActivitiesRequest(input)
	err := req.Send()
	return out, err
}

func (c *AutoScaling) DescribeScalingActivitiesPages(input *DescribeScalingActivitiesInput, fn func(p *DescribeScalingActivitiesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeScalingActivitiesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeScalingActivitiesOutput), lastPage)
	})
}

const opDescribeScalingProcessTypes = "DescribeScalingProcessTypes"

// DescribeScalingProcessTypesRequest generates a request for the DescribeScalingProcessTypes operation.
func (c *AutoScaling) DescribeScalingProcessTypesRequest(input *DescribeScalingProcessTypesInput) (req *request.Request, output *DescribeScalingProcessTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingProcessTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeScalingProcessTypesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeScalingProcessTypesOutput{}
	req.Data = output
	return
}

// Describes the scaling process types for use with ResumeProcesses and SuspendProcesses.
func (c *AutoScaling) DescribeScalingProcessTypes(input *DescribeScalingProcessTypesInput) (*DescribeScalingProcessTypesOutput, error) {
	req, out := c.DescribeScalingProcessTypesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeScheduledActions = "DescribeScheduledActions"

// DescribeScheduledActionsRequest generates a request for the DescribeScheduledActions operation.
func (c *AutoScaling) DescribeScheduledActionsRequest(input *DescribeScheduledActionsInput) (req *request.Request, output *DescribeScheduledActionsOutput) {
	op := &request.Operation{
		Name:       opDescribeScheduledActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScheduledActionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeScheduledActionsOutput{}
	req.Data = output
	return
}

// Describes the actions scheduled for your Auto Scaling group that haven't
// run. To describe the actions that have already run, use DescribeScalingActivities.
func (c *AutoScaling) DescribeScheduledActions(input *DescribeScheduledActionsInput) (*DescribeScheduledActionsOutput, error) {
	req, out := c.DescribeScheduledActionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *AutoScaling) DescribeScheduledActionsPages(input *DescribeScheduledActionsInput, fn func(p *DescribeScheduledActionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeScheduledActionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeScheduledActionsOutput), lastPage)
	})
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a request for the DescribeTags operation.
func (c *AutoScaling) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTagsOutput{}
	req.Data = output
	return
}

// Describes the specified tags.
//
// You can use filters to limit the results. For example, you can query for
// the tags for a specific Auto Scaling group. You can specify multiple values
// for a filter. A tag must match at least one of the specified values for it
// to be included in the results.
//
// You can also specify multiple filters. The result includes information for
// a particular tag only if it matches all the filters. If there's no match,
// no special message is returned.
func (c *AutoScaling) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	err := req.Send()
	return out, err
}

func (c *AutoScaling) DescribeTagsPages(input *DescribeTagsInput, fn func(p *DescribeTagsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeTagsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeTagsOutput), lastPage)
	})
}

const opDescribeTerminationPolicyTypes = "DescribeTerminationPolicyTypes"

// DescribeTerminationPolicyTypesRequest generates a request for the DescribeTerminationPolicyTypes operation.
func (c *AutoScaling) DescribeTerminationPolicyTypesRequest(input *DescribeTerminationPolicyTypesInput) (req *request.Request, output *DescribeTerminationPolicyTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeTerminationPolicyTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTerminationPolicyTypesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTerminationPolicyTypesOutput{}
	req.Data = output
	return
}

// Describes the termination policies supported by Auto Scaling.
func (c *AutoScaling) DescribeTerminationPolicyTypes(input *DescribeTerminationPolicyTypesInput) (*DescribeTerminationPolicyTypesOutput, error) {
	req, out := c.DescribeTerminationPolicyTypesRequest(input)
	err := req.Send()
	return out, err
}

const opDetachInstances = "DetachInstances"

// DetachInstancesRequest generates a request for the DetachInstances operation.
func (c *AutoScaling) DetachInstancesRequest(input *DetachInstancesInput) (req *request.Request, output *DetachInstancesOutput) {
	op := &request.Operation{
		Name:       opDetachInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DetachInstancesOutput{}
	req.Data = output
	return
}

// Removes one or more instances from the specified Auto Scaling group.
//
// After the instances are detached, you can manage them independently from
// the rest of the Auto Scaling group.
//
// If you do not specify the option to decrement the desired capacity, Auto
// Scaling launches instances to replace the ones that are detached.
//
// For more information, see Detach EC2 Instances from Your Auto Scaling Group
// (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/detach-instance-asg.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) DetachInstances(input *DetachInstancesInput) (*DetachInstancesOutput, error) {
	req, out := c.DetachInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opDetachLoadBalancers = "DetachLoadBalancers"

// DetachLoadBalancersRequest generates a request for the DetachLoadBalancers operation.
func (c *AutoScaling) DetachLoadBalancersRequest(input *DetachLoadBalancersInput) (req *request.Request, output *DetachLoadBalancersOutput) {
	op := &request.Operation{
		Name:       opDetachLoadBalancers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachLoadBalancersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DetachLoadBalancersOutput{}
	req.Data = output
	return
}

// Removes one or more load balancers from the specified Auto Scaling group.
//
// When you detach a load balancer, it enters the Removing state while deregistering
// the instances in the group. When all instances are deregistered, then you
// can no longer describe the load balancer using DescribeLoadBalancers. Note
// that the instances remain running.
func (c *AutoScaling) DetachLoadBalancers(input *DetachLoadBalancersInput) (*DetachLoadBalancersOutput, error) {
	req, out := c.DetachLoadBalancersRequest(input)
	err := req.Send()
	return out, err
}

const opDisableMetricsCollection = "DisableMetricsCollection"

// DisableMetricsCollectionRequest generates a request for the DisableMetricsCollection operation.
func (c *AutoScaling) DisableMetricsCollectionRequest(input *DisableMetricsCollectionInput) (req *request.Request, output *DisableMetricsCollectionOutput) {
	op := &request.Operation{
		Name:       opDisableMetricsCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableMetricsCollectionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DisableMetricsCollectionOutput{}
	req.Data = output
	return
}

// Disables monitoring of the specified metrics for the specified Auto Scaling
// group.
func (c *AutoScaling) DisableMetricsCollection(input *DisableMetricsCollectionInput) (*DisableMetricsCollectionOutput, error) {
	req, out := c.DisableMetricsCollectionRequest(input)
	err := req.Send()
	return out, err
}

const opEnableMetricsCollection = "EnableMetricsCollection"

// EnableMetricsCollectionRequest generates a request for the EnableMetricsCollection operation.
func (c *AutoScaling) EnableMetricsCollectionRequest(input *EnableMetricsCollectionInput) (req *request.Request, output *EnableMetricsCollectionOutput) {
	op := &request.Operation{
		Name:       opEnableMetricsCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableMetricsCollectionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &EnableMetricsCollectionOutput{}
	req.Data = output
	return
}

// Enables monitoring of the specified metrics for the specified Auto Scaling
// group.
//
// You can only enable metrics collection if InstanceMonitoring in the launch
// configuration for the group is set to True.
func (c *AutoScaling) EnableMetricsCollection(input *EnableMetricsCollectionInput) (*EnableMetricsCollectionOutput, error) {
	req, out := c.EnableMetricsCollectionRequest(input)
	err := req.Send()
	return out, err
}

const opEnterStandby = "EnterStandby"

// EnterStandbyRequest generates a request for the EnterStandby operation.
func (c *AutoScaling) EnterStandbyRequest(input *EnterStandbyInput) (req *request.Request, output *EnterStandbyOutput) {
	op := &request.Operation{
		Name:       opEnterStandby,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnterStandbyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnterStandbyOutput{}
	req.Data = output
	return
}

// Moves the specified instances into Standby mode.
//
// For more information, see Auto Scaling InService State (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingInServiceState.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) EnterStandby(input *EnterStandbyInput) (*EnterStandbyOutput, error) {
	req, out := c.EnterStandbyRequest(input)
	err := req.Send()
	return out, err
}

const opExecutePolicy = "ExecutePolicy"

// ExecutePolicyRequest generates a request for the ExecutePolicy operation.
func (c *AutoScaling) ExecutePolicyRequest(input *ExecutePolicyInput) (req *request.Request, output *ExecutePolicyOutput) {
	op := &request.Operation{
		Name:       opExecutePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExecutePolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &ExecutePolicyOutput{}
	req.Data = output
	return
}

// Executes the specified policy.
func (c *AutoScaling) ExecutePolicy(input *ExecutePolicyInput) (*ExecutePolicyOutput, error) {
	req, out := c.ExecutePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opExitStandby = "ExitStandby"

// ExitStandbyRequest generates a request for the ExitStandby operation.
func (c *AutoScaling) ExitStandbyRequest(input *ExitStandbyInput) (req *request.Request, output *ExitStandbyOutput) {
	op := &request.Operation{
		Name:       opExitStandby,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExitStandbyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ExitStandbyOutput{}
	req.Data = output
	return
}

// Moves the specified instances out of Standby mode.
//
// For more information, see Auto Scaling InService State (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingInServiceState.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) ExitStandby(input *ExitStandbyInput) (*ExitStandbyOutput, error) {
	req, out := c.ExitStandbyRequest(input)
	err := req.Send()
	return out, err
}

const opPutLifecycleHook = "PutLifecycleHook"

// PutLifecycleHookRequest generates a request for the PutLifecycleHook operation.
func (c *AutoScaling) PutLifecycleHookRequest(input *PutLifecycleHookInput) (req *request.Request, output *PutLifecycleHookOutput) {
	op := &request.Operation{
		Name:       opPutLifecycleHook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutLifecycleHookInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutLifecycleHookOutput{}
	req.Data = output
	return
}

// Creates or updates a lifecycle hook for the specified Auto Scaling Group.
//
// A lifecycle hook tells Auto Scaling that you want to perform an action on
// an instance that is not actively in service; for example, either when the
// instance launches or before the instance terminates.
//
// This operation is a part of the basic sequence for adding a lifecycle hook
// to an Auto Scaling group:
//
//  Create a notification target. A target can be either an Amazon SQS queue
// or an Amazon SNS topic. Create an IAM role. This role allows Auto Scaling
// to publish lifecycle notifications to the designated SQS queue or SNS topic.
// Create the lifecycle hook. You can create a hook that acts when instances
// launch or when instances terminate. If necessary, record the lifecycle action
// heartbeat to keep the instance in a pending state. Complete the lifecycle
// action.  For more information, see Auto Scaling Pending State (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingPendingState.html)
// and Auto Scaling Terminating State (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingTerminatingState.html)
// in the Auto Scaling Developer Guide.
//
// If you exceed your maximum limit of lifecycle hooks, which by default is
// 50 per region, the call fails. For information about updating this limit,
// see AWS Service Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html)
// in the Amazon Web Services General Reference.
func (c *AutoScaling) PutLifecycleHook(input *PutLifecycleHookInput) (*PutLifecycleHookOutput, error) {
	req, out := c.PutLifecycleHookRequest(input)
	err := req.Send()
	return out, err
}

const opPutNotificationConfiguration = "PutNotificationConfiguration"

// PutNotificationConfigurationRequest generates a request for the PutNotificationConfiguration operation.
func (c *AutoScaling) PutNotificationConfigurationRequest(input *PutNotificationConfigurationInput) (req *request.Request, output *PutNotificationConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutNotificationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutNotificationConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutNotificationConfigurationOutput{}
	req.Data = output
	return
}

// Configures an Auto Scaling group to send notifications when specified events
// take place. Subscribers to this topic can have messages for events delivered
// to an endpoint such as a web server or email address.
//
// For more information see Getting Notifications When Your Auto Scaling Group
// Changes (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/ASGettingNotifications.html)
// in the Auto Scaling Developer Guide.
//
// This configuration overwrites an existing configuration.
func (c *AutoScaling) PutNotificationConfiguration(input *PutNotificationConfigurationInput) (*PutNotificationConfigurationOutput, error) {
	req, out := c.PutNotificationConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opPutScalingPolicy = "PutScalingPolicy"

// PutScalingPolicyRequest generates a request for the PutScalingPolicy operation.
func (c *AutoScaling) PutScalingPolicyRequest(input *PutScalingPolicyInput) (req *request.Request, output *PutScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opPutScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutScalingPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutScalingPolicyOutput{}
	req.Data = output
	return
}

// Creates or updates a policy for an Auto Scaling group. To update an existing
// policy, use the existing policy name and set the parameters you want to change.
// Any existing parameter not changed in an update to an existing policy is
// not changed in this update request.
//
// If you exceed your maximum limit of step adjustments, which by default is
// 20 per region, the call fails. For information about updating this limit,
// see AWS Service Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html)
// in the Amazon Web Services General Reference.
func (c *AutoScaling) PutScalingPolicy(input *PutScalingPolicyInput) (*PutScalingPolicyOutput, error) {
	req, out := c.PutScalingPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opPutScheduledUpdateGroupAction = "PutScheduledUpdateGroupAction"

// PutScheduledUpdateGroupActionRequest generates a request for the PutScheduledUpdateGroupAction operation.
func (c *AutoScaling) PutScheduledUpdateGroupActionRequest(input *PutScheduledUpdateGroupActionInput) (req *request.Request, output *PutScheduledUpdateGroupActionOutput) {
	op := &request.Operation{
		Name:       opPutScheduledUpdateGroupAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutScheduledUpdateGroupActionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutScheduledUpdateGroupActionOutput{}
	req.Data = output
	return
}

// Creates or updates a scheduled scaling action for an Auto Scaling group.
// When updating a scheduled scaling action, if you leave a parameter unspecified,
// the corresponding value remains unchanged in the affected Auto Scaling group.
//
// For more information, see Scheduled Scaling (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/schedule_time.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) PutScheduledUpdateGroupAction(input *PutScheduledUpdateGroupActionInput) (*PutScheduledUpdateGroupActionOutput, error) {
	req, out := c.PutScheduledUpdateGroupActionRequest(input)
	err := req.Send()
	return out, err
}

const opRecordLifecycleActionHeartbeat = "RecordLifecycleActionHeartbeat"

// RecordLifecycleActionHeartbeatRequest generates a request for the RecordLifecycleActionHeartbeat operation.
func (c *AutoScaling) RecordLifecycleActionHeartbeatRequest(input *RecordLifecycleActionHeartbeatInput) (req *request.Request, output *RecordLifecycleActionHeartbeatOutput) {
	op := &request.Operation{
		Name:       opRecordLifecycleActionHeartbeat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RecordLifecycleActionHeartbeatInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RecordLifecycleActionHeartbeatOutput{}
	req.Data = output
	return
}

// Records a heartbeat for the lifecycle action associated with a specific token.
// This extends the timeout by the length of time defined by the HeartbeatTimeout
// parameter of PutLifecycleHook.
//
// This operation is a part of the basic sequence for adding a lifecycle hook
// to an Auto Scaling group:
//
//  Create a notification target. A target can be either an Amazon SQS queue
// or an Amazon SNS topic. Create an IAM role. This role allows Auto Scaling
// to publish lifecycle notifications to the designated SQS queue or SNS topic.
// Create the lifecycle hook. You can create a hook that acts when instances
// launch or when instances terminate. If necessary, record the lifecycle action
// heartbeat to keep the instance in a pending state. Complete the lifecycle
// action.  For more information, see Auto Scaling Pending State (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingPendingState.html)
// and Auto Scaling Terminating State (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingTerminatingState.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) RecordLifecycleActionHeartbeat(input *RecordLifecycleActionHeartbeatInput) (*RecordLifecycleActionHeartbeatOutput, error) {
	req, out := c.RecordLifecycleActionHeartbeatRequest(input)
	err := req.Send()
	return out, err
}

const opResumeProcesses = "ResumeProcesses"

// ResumeProcessesRequest generates a request for the ResumeProcesses operation.
func (c *AutoScaling) ResumeProcessesRequest(input *ScalingProcessQuery) (req *request.Request, output *ResumeProcessesOutput) {
	op := &request.Operation{
		Name:       opResumeProcesses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ScalingProcessQuery{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &ResumeProcessesOutput{}
	req.Data = output
	return
}

// Resumes the specified suspended Auto Scaling processes for the specified
// Auto Scaling group. To resume specific processes, use the ScalingProcesses
// parameter. To resume all processes, omit the ScalingProcesses parameter.
// For more information, see Suspend and Resume Auto Scaling Processes (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/US_SuspendResume.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) ResumeProcesses(input *ScalingProcessQuery) (*ResumeProcessesOutput, error) {
	req, out := c.ResumeProcessesRequest(input)
	err := req.Send()
	return out, err
}

const opSetDesiredCapacity = "SetDesiredCapacity"

// SetDesiredCapacityRequest generates a request for the SetDesiredCapacity operation.
func (c *AutoScaling) SetDesiredCapacityRequest(input *SetDesiredCapacityInput) (req *request.Request, output *SetDesiredCapacityOutput) {
	op := &request.Operation{
		Name:       opSetDesiredCapacity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetDesiredCapacityInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &SetDesiredCapacityOutput{}
	req.Data = output
	return
}

// Sets the size of the specified Auto Scaling group.
//
// For more information about desired capacity, see What Is Auto Scaling? (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/WhatIsAutoScaling.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) SetDesiredCapacity(input *SetDesiredCapacityInput) (*SetDesiredCapacityOutput, error) {
	req, out := c.SetDesiredCapacityRequest(input)
	err := req.Send()
	return out, err
}

const opSetInstanceHealth = "SetInstanceHealth"

// SetInstanceHealthRequest generates a request for the SetInstanceHealth operation.
func (c *AutoScaling) SetInstanceHealthRequest(input *SetInstanceHealthInput) (req *request.Request, output *SetInstanceHealthOutput) {
	op := &request.Operation{
		Name:       opSetInstanceHealth,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetInstanceHealthInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &SetInstanceHealthOutput{}
	req.Data = output
	return
}

// Sets the health status of the specified instance.
//
// For more information, see Health Checks (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/healthcheck.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) SetInstanceHealth(input *SetInstanceHealthInput) (*SetInstanceHealthOutput, error) {
	req, out := c.SetInstanceHealthRequest(input)
	err := req.Send()
	return out, err
}

const opSetInstanceProtection = "SetInstanceProtection"

// SetInstanceProtectionRequest generates a request for the SetInstanceProtection operation.
func (c *AutoScaling) SetInstanceProtectionRequest(input *SetInstanceProtectionInput) (req *request.Request, output *SetInstanceProtectionOutput) {
	op := &request.Operation{
		Name:       opSetInstanceProtection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetInstanceProtectionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetInstanceProtectionOutput{}
	req.Data = output
	return
}

// Updates the instance protection settings of the specified instances.
//
// For more information, see Instance Protection (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingBehavior.InstanceTermination.html#instance-protection)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) SetInstanceProtection(input *SetInstanceProtectionInput) (*SetInstanceProtectionOutput, error) {
	req, out := c.SetInstanceProtectionRequest(input)
	err := req.Send()
	return out, err
}

const opSuspendProcesses = "SuspendProcesses"

// SuspendProcessesRequest generates a request for the SuspendProcesses operation.
func (c *AutoScaling) SuspendProcessesRequest(input *ScalingProcessQuery) (req *request.Request, output *SuspendProcessesOutput) {
	op := &request.Operation{
		Name:       opSuspendProcesses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ScalingProcessQuery{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &SuspendProcessesOutput{}
	req.Data = output
	return
}

// Suspends the specified Auto Scaling processes for the specified Auto Scaling
// group. To suspend specific processes, use the ScalingProcesses parameter.
// To suspend all processes, omit the ScalingProcesses parameter.
//
// Note that if you suspend either the Launch or Terminate process types, it
// can prevent other process types from functioning properly.
//
// To resume processes that have been suspended, use ResumeProcesses.
//
// For more information, see Suspend and Resume Auto Scaling Processes (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/US_SuspendResume.html)
// in the Auto Scaling Developer Guide.
func (c *AutoScaling) SuspendProcesses(input *ScalingProcessQuery) (*SuspendProcessesOutput, error) {
	req, out := c.SuspendProcessesRequest(input)
	err := req.Send()
	return out, err
}

const opTerminateInstanceInAutoScalingGroup = "TerminateInstanceInAutoScalingGroup"

// TerminateInstanceInAutoScalingGroupRequest generates a request for the TerminateInstanceInAutoScalingGroup operation.
func (c *AutoScaling) TerminateInstanceInAutoScalingGroupRequest(input *TerminateInstanceInAutoScalingGroupInput) (req *request.Request, output *TerminateInstanceInAutoScalingGroupOutput) {
	op := &request.Operation{
		Name:       opTerminateInstanceInAutoScalingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateInstanceInAutoScalingGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &TerminateInstanceInAutoScalingGroupOutput{}
	req.Data = output
	return
}

// Terminates the specified instance and optionally adjusts the desired group
// size.
//
// This call simply makes a termination request. The instance is not terminated
// immediately.
func (c *AutoScaling) TerminateInstanceInAutoScalingGroup(input *TerminateInstanceInAutoScalingGroupInput) (*TerminateInstanceInAutoScalingGroupOutput, error) {
	req, out := c.TerminateInstanceInAutoScalingGroupRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateAutoScalingGroup = "UpdateAutoScalingGroup"

// UpdateAutoScalingGroupRequest generates a request for the UpdateAutoScalingGroup operation.
func (c *AutoScaling) UpdateAutoScalingGroupRequest(input *UpdateAutoScalingGroupInput) (req *request.Request, output *UpdateAutoScalingGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateAutoScalingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAutoScalingGroupInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UpdateAutoScalingGroupOutput{}
	req.Data = output
	return
}

// Updates the configuration for the specified Auto Scaling group.
//
// To update an Auto Scaling group with a launch configuration with InstanceMonitoring
// set to False, you must first disable the collection of group metrics. Otherwise,
// you will get an error. If you have previously enabled the collection of group
// metrics, you can disable it using DisableMetricsCollection.
//
// The new settings are registered upon the completion of this call. Any launch
// configuration settings take effect on any triggers after this call returns.
// Scaling activities that are currently in progress aren't affected.
//
// Note the following:
//
//   If you specify a new value for MinSize without specifying a value for
// DesiredCapacity, and the new MinSize is larger than the current size of the
// group, we implicitly call SetDesiredCapacity to set the size of the group
// to the new value of MinSize.
//
//   If you specify a new value for MaxSize without specifying a value for
// DesiredCapacity, and the new MaxSize is smaller than the current size of
// the group, we implicitly call SetDesiredCapacity to set the size of the group
// to the new value of MaxSize.
//
//   All other optional parameters are left unchanged if not specified.
func (c *AutoScaling) UpdateAutoScalingGroup(input *UpdateAutoScalingGroupInput) (*UpdateAutoScalingGroupOutput, error) {
	req, out := c.UpdateAutoScalingGroupRequest(input)
	err := req.Send()
	return out, err
}

// Describes scaling activity, which is a long-running process that represents
// a change to your Auto Scaling group, such as changing its size or replacing
// an instance.
type Activity struct {
	_ struct{} `type:"structure"`

	// The ID of the activity.
	ActivityId *string `type:"string" required:"true"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The reason the activity began.
	Cause *string `min:"1" type:"string" required:"true"`

	// A friendly, more verbose description of the activity.
	Description *string `type:"string"`

	// The details about the activity.
	Details *string `type:"string"`

	// The end time of the activity.
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A value between 0 and 100 that indicates the progress of the activity.
	Progress *int64 `type:"integer"`

	// The start time of the activity.
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The current status of the activity.
	StatusCode *string `type:"string" required:"true" enum:"ScalingActivityStatusCode"`

	// A friendly, more verbose description of the activity status.
	StatusMessage *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Activity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Activity) GoString() string {
	return s.String()
}

// Describes a policy adjustment type.
//
// For more information, see Dynamic Scaling (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/as-scale-based-on-demand.html)
// in the Auto Scaling Developer Guide.
type AdjustmentType struct {
	_ struct{} `type:"structure"`

	// The policy adjustment type. The valid values are ChangeInCapacity, ExactCapacity,
	// and PercentChangeInCapacity.
	AdjustmentType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AdjustmentType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdjustmentType) GoString() string {
	return s.String()
}

// Describes an alarm.
type Alarm struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the alarm.
	AlarmARN *string `min:"1" type:"string"`

	// The name of the alarm.
	AlarmName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Alarm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Alarm) GoString() string {
	return s.String()
}

type AttachInstancesInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more EC2 instance IDs.
	InstanceIds []*string `type:"list"`
}

// String returns the string representation
func (s AttachInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachInstancesInput) GoString() string {
	return s.String()
}

type AttachInstancesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachInstancesOutput) GoString() string {
	return s.String()
}

type AttachLoadBalancersInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// One or more load balancer names.
	LoadBalancerNames []*string `type:"list"`
}

// String returns the string representation
func (s AttachLoadBalancersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachLoadBalancersInput) GoString() string {
	return s.String()
}

type AttachLoadBalancersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachLoadBalancersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachLoadBalancersOutput) GoString() string {
	return s.String()
}

// Describes a block device mapping.
type BlockDeviceMapping struct {
	_ struct{} `type:"structure"`

	// The device name exposed to the EC2 instance (for example, /dev/sdh or xvdh).
	DeviceName *string `min:"1" type:"string" required:"true"`

	// The information about the Amazon EBS volume.
	Ebs *Ebs `type:"structure"`

	// Suppresses a device mapping.
	//
	// If this parameter is true for the root device, the instance might fail the
	// EC2 health check. Auto Scaling launches a replacement instance if the instance
	// fails the health check.
	NoDevice *bool `type:"boolean"`

	// The name of the virtual device (for example, ephemeral0).
	VirtualName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BlockDeviceMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockDeviceMapping) GoString() string {
	return s.String()
}

type CompleteLifecycleActionInput struct {
	_ struct{} `type:"structure"`

	// The name of the group for the lifecycle hook.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The action for the group to take. This parameter can be either CONTINUE or
	// ABANDON.
	LifecycleActionResult *string `type:"string" required:"true"`

	// A universally unique identifier (UUID) that identifies a specific lifecycle
	// action associated with an instance. Auto Scaling sends this token to the
	// notification target you specified when you created the lifecycle hook.
	LifecycleActionToken *string `min:"36" type:"string" required:"true"`

	// The name of the lifecycle hook.
	LifecycleHookName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CompleteLifecycleActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteLifecycleActionInput) GoString() string {
	return s.String()
}

type CompleteLifecycleActionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CompleteLifecycleActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteLifecycleActionOutput) GoString() string {
	return s.String()
}

type CreateAutoScalingGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group. This name must be unique within the scope of your
	// AWS account.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more Availability Zones for the group. This parameter is optional
	// if you specify subnets using the VPCZoneIdentifier parameter.
	AvailabilityZones []*string `min:"1" type:"list"`

	// The amount of time, in seconds, after a scaling activity completes before
	// another scaling activity can start. The default is 300.
	//
	// For more information, see Understanding Auto Scaling Cooldowns (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/Cooldown.html)
	// in the Auto Scaling Developer Guide.
	DefaultCooldown *int64 `type:"integer"`

	// The number of EC2 instances that should be running in the group. This number
	// must be greater than or equal to the minimum size of the group and less than
	// or equal to the maximum size of the group.
	DesiredCapacity *int64 `type:"integer"`

	// The amount of time, in seconds, that Auto Scaling waits before checking the
	// health status of an EC2 instance that has come into service. During this
	// time, any health check failures for the instance are ignored. The default
	// is 300.
	//
	// This parameter is required if you are adding an ELB health check.
	//
	// For more information, see Health Checks for Auto Scaling Instances (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/healthcheck.html)
	// in the Auto Scaling Developer Guide.
	HealthCheckGracePeriod *int64 `type:"integer"`

	// The service to use for the health checks. The valid values are EC2 and ELB.
	//
	// By default, health checks use Amazon EC2 instance status checks to determine
	// the health of an instance. For more information, see Health Checks (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/healthcheck.html)
	// in the Auto Scaling Developer Guide.
	HealthCheckType *string `min:"1" type:"string"`

	// The ID of the EC2 instance used to create a launch configuration for the
	// group. Alternatively, use the LaunchConfigurationName parameter to specify
	// a launch configuration instead of an EC2 instance.
	//
	// When you specify an ID of an instance, Auto Scaling creates a new launch
	// configuration and associates it with the group. This launch configuration
	// derives its attributes from the specified instance, with the exception of
	// the block device mapping.
	//
	// For more information, see Create an Auto Scaling Group from an EC2 Instance
	// (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/create-asg-from-instance.html)
	// in the Auto Scaling Developer Guide.
	InstanceId *string `min:"1" type:"string"`

	// The name of the launch configuration. Alternatively, use the InstanceId parameter
	// to specify an EC2 instance instead of a launch configuration.
	LaunchConfigurationName *string `min:"1" type:"string"`

	// One or more load balancers.
	//
	// For more information, see Load Balance Your Auto Scaling Group (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/US_SetUpASLBApp.html)
	// in the Auto Scaling Developer Guide.
	LoadBalancerNames []*string `type:"list"`

	// The maximum size of the group.
	MaxSize *int64 `type:"integer" required:"true"`

	// The minimum size of the group.
	MinSize *int64 `type:"integer" required:"true"`

	// Indicates whether newly launched instances are protected from termination
	// by Auto Scaling when scaling in.
	NewInstancesProtectedFromScaleIn *bool `type:"boolean"`

	// The name of the placement group into which you'll launch your instances,
	// if any. For more information, see Placement Groups (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	PlacementGroup *string `min:"1" type:"string"`

	// The tag to be created or updated. Each tag should be defined by its resource
	// type, resource ID, key, value, and a propagate flag. Valid values: key=value,
	// value=value, propagate=true or false. Value and propagate are optional parameters.
	//
	// For more information, see Tagging Auto Scaling Groups and Instances (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/ASTagging.html)
	// in the Auto Scaling Developer Guide.
	Tags []*Tag `type:"list"`

	// One or more termination policies used to select the instance to terminate.
	// These policies are executed in the order that they are listed.
	//
	// For more information, see Choosing a Termination Policy for Your Auto Scaling
	// Group (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/us-termination-policy.html)
	// in the Auto Scaling Developer Guide.
	TerminationPolicies []*string `type:"list"`

	// A comma-separated list of subnet identifiers for your virtual private cloud
	// (VPC).
	//
	// If you specify subnets and Availability Zones with this call, ensure that
	// the subnets' Availability Zones match the Availability Zones specified.
	//
	// For more information, see Auto Scaling and Amazon Virtual Private Cloud
	// (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/autoscalingsubnets.html)
	// in the Auto Scaling Developer Guide.
	VPCZoneIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateAutoScalingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAutoScalingGroupInput) GoString() string {
	return s.String()
}

type CreateAutoScalingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateAutoScalingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAutoScalingGroupOutput) GoString() string {
	return s.String()
}

type CreateLaunchConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Used for groups that launch instances into a virtual private cloud (VPC).
	// Specifies whether to assign a public IP address to each instance. For more
	// information, see Auto Scaling and Amazon Virtual Private Cloud (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/autoscalingsubnets.html)
	// in the Auto Scaling Developer Guide.
	//
	// If you specify a value for this parameter, be sure to specify at least one
	// subnet using the VPCZoneIdentifier parameter when you create your group.
	//
	// Default: If the instance is launched into a default subnet, the default
	// is true. If the instance is launched into a nondefault subnet, the default
	// is false. For more information, see Supported Platforms (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	AssociatePublicIpAddress *bool `type:"boolean"`

	// One or more mappings that specify how block devices are exposed to the instance.
	// For more information, see Block Device Mapping (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	BlockDeviceMappings []*BlockDeviceMapping `type:"list"`

	// The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to.
	// This parameter is supported only if you are launching EC2-Classic instances.
	// For more information, see ClassicLink (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClassicLinkVPCId *string `min:"1" type:"string"`

	// The IDs of one or more security groups for the VPC specified in ClassicLinkVPCId.
	// This parameter is required if ClassicLinkVPCId is specified, and is not supported
	// otherwise. For more information, see ClassicLink (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClassicLinkVPCSecurityGroups []*string `type:"list"`

	// Indicates whether the instance is optimized for Amazon EBS I/O. By default,
	// the instance is not optimized for EBS I/O. The optimization provides dedicated
	// throughput to Amazon EBS and an optimized configuration stack to provide
	// optimal I/O performance. This optimization is not available with all instance
	// types. Additional usage charges apply. For more information, see Amazon EBS-Optimized
	// Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	EbsOptimized *bool `type:"boolean"`

	// The name or the Amazon Resource Name (ARN) of the instance profile associated
	// with the IAM role for the instance.
	//
	// EC2 instances launched with an IAM role will automatically have AWS security
	// credentials available. You can use IAM roles with Auto Scaling to automatically
	// enable applications running on your EC2 instances to securely access other
	// AWS resources. For more information, see Launch Auto Scaling Instances with
	// an IAM Role (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/us-iam-role.html)
	// in the Auto Scaling Developer Guide.
	IamInstanceProfile *string `min:"1" type:"string"`

	// The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances.
	// For more information, see Finding an AMI (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ImageId *string `min:"1" type:"string"`

	// The ID of the EC2 instance to use to create the launch configuration.
	//
	// The new launch configuration derives attributes from the instance, with
	// the exception of the block device mapping.
	//
	// To create a launch configuration with a block device mapping or override
	// any other instance attributes, specify them as part of the same request.
	//
	// For more information, see Create a Launch Configuration Using an EC2 Instance
	// (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/create-lc-with-instanceID.html)
	// in the Auto Scaling Developer Guide.
	InstanceId *string `min:"1" type:"string"`

	// Enables detailed monitoring if it is disabled. Detailed monitoring is enabled
	// by default.
	//
	// When detailed monitoring is enabled, Amazon CloudWatch generates metrics
	// every minute and your account is charged a fee. When you disable detailed
	// monitoring, by specifying False, CloudWatch generates metrics every 5 minutes.
	// For more information, see Monitor Your Auto Scaling Instances (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/as-instance-monitoring.html)
	// in the Auto Scaling Developer Guide.
	InstanceMonitoring *InstanceMonitoring `type:"structure"`

	// The instance type of the EC2 instance. For information about available instance
	// types, see  Available Instance Types (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes)
	// in the Amazon Elastic Compute Cloud User Guide.
	InstanceType *string `min:"1" type:"string"`

	// The ID of the kernel associated with the AMI.
	KernelId *string `min:"1" type:"string"`

	// The name of the key pair. For more information, see Amazon EC2 Key Pairs
	// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html) in
	// the Amazon Elastic Compute Cloud User Guide.
	KeyName *string `min:"1" type:"string"`

	// The name of the launch configuration. This name must be unique within the
	// scope of your AWS account.
	LaunchConfigurationName *string `min:"1" type:"string" required:"true"`

	// The tenancy of the instance. An instance with a tenancy of dedicated runs
	// on single-tenant hardware and can only be launched into a VPC.
	//
	// You must set the value of this parameter to dedicated if want to launch
	// Dedicated Instances into a shared tenancy VPC (VPC with instance placement
	// tenancy attribute set to default).
	//
	// If you specify a value for this parameter, be sure to specify at least one
	// subnet using the VPCZoneIdentifier parameter when you create your group.
	//
	// For more information, see Auto Scaling and Amazon Virtual Private Cloud
	// (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/autoscalingsubnets.html)
	// in the Auto Scaling Developer Guide.
	//
	// Valid values: default | dedicated
	PlacementTenancy *string `min:"1" type:"string"`

	// The ID of the RAM disk associated with the AMI.
	RamdiskId *string `min:"1" type:"string"`

	// One or more security groups with which to associate the instances.
	//
	// If your instances are launched in EC2-Classic, you can either specify security
	// group names or the security group IDs. For more information about security
	// groups for EC2-Classic, see Amazon EC2 Security Groups (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	//
	// If your instances are launched into a VPC, specify security group IDs. For
	// more information, see Security Groups for Your VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html)
	// in the Amazon Virtual Private Cloud User Guide.
	SecurityGroups []*string `type:"list"`

	// The maximum hourly price to be paid for any Spot Instance launched to fulfill
	// the request. Spot Instances are launched when the price you specify exceeds
	// the current Spot market price. For more information, see Launch Spot Instances
	// in Your Auto Scaling Group (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/US-SpotInstances.html)
	// in the Auto Scaling Developer Guide.
	SpotPrice *string `min:"1" type:"string"`

	// The user data to make available to the launched EC2 instances. For more information,
	// see Instance Metadata and User Data (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	//
	// At this time, launch configurations don't support compressed (zipped) user
	// data files.
	UserData *string `type:"string"`
}

// String returns the string representation
func (s CreateLaunchConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLaunchConfigurationInput) GoString() string {
	return s.String()
}

type CreateLaunchConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateLaunchConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLaunchConfigurationOutput) GoString() string {
	return s.String()
}

type CreateOrUpdateTagsInput struct {
	_ struct{} `type:"structure"`

	// One or more tags.
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s CreateOrUpdateTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOrUpdateTagsInput) GoString() string {
	return s.String()
}

type CreateOrUpdateTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateOrUpdateTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOrUpdateTagsOutput) GoString() string {
	return s.String()
}

type DeleteAutoScalingGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group to delete.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// Specifies that the group will be deleted along with all instances associated
	// with the group, without waiting for all instances to be terminated. This
	// parameter also deletes any lifecycle actions associated with the group.
	ForceDelete *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteAutoScalingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAutoScalingGroupInput) GoString() string {
	return s.String()
}

type DeleteAutoScalingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAutoScalingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAutoScalingGroupOutput) GoString() string {
	return s.String()
}

type DeleteLaunchConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the launch configuration.
	LaunchConfigurationName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLaunchConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLaunchConfigurationInput) GoString() string {
	return s.String()
}

type DeleteLaunchConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLaunchConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLaunchConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteLifecycleHookInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group for the lifecycle hook.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The name of the lifecycle hook.
	LifecycleHookName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLifecycleHookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLifecycleHookInput) GoString() string {
	return s.String()
}

type DeleteLifecycleHookOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLifecycleHookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLifecycleHookOutput) GoString() string {
	return s.String()
}

type DeleteNotificationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (SNS) topic.
	TopicARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNotificationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNotificationConfigurationInput) GoString() string {
	return s.String()
}

type DeleteNotificationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNotificationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNotificationConfigurationOutput) GoString() string {
	return s.String()
}

type DeletePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The name or Amazon Resource Name (ARN) of the policy.
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyInput) GoString() string {
	return s.String()
}

type DeletePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyOutput) GoString() string {
	return s.String()
}

type DeleteScheduledActionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The name of the action to delete.
	ScheduledActionName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteScheduledActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScheduledActionInput) GoString() string {
	return s.String()
}

type DeleteScheduledActionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteScheduledActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScheduledActionOutput) GoString() string {
	return s.String()
}

type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// Each tag should be defined by its resource type, resource ID, key, value,
	// and a propagate flag. Valid values are: Resource type = auto-scaling-group,
	// Resource ID = AutoScalingGroupName, key=value, value=value, propagate=true
	// or false.
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

type DescribeAccountLimitsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountLimitsInput) GoString() string {
	return s.String()
}

type DescribeAccountLimitsOutput struct {
	_ struct{} `type:"structure"`

	// The maximum number of groups allowed for your AWS account. The default limit
	// is 20 per region.
	MaxNumberOfAutoScalingGroups *int64 `type:"integer"`

	// The maximum number of launch configurations allowed for your AWS account.
	// The default limit is 100 per region.
	MaxNumberOfLaunchConfigurations *int64 `type:"integer"`

	// The current number of groups for your AWS account.
	NumberOfAutoScalingGroups *int64 `type:"integer"`

	// The current number of launch configurations for your AWS account.
	NumberOfLaunchConfigurations *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeAccountLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountLimitsOutput) GoString() string {
	return s.String()
}

type DescribeAdjustmentTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAdjustmentTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAdjustmentTypesInput) GoString() string {
	return s.String()
}

type DescribeAdjustmentTypesOutput struct {
	_ struct{} `type:"structure"`

	// The policy adjustment types.
	AdjustmentTypes []*AdjustmentType `type:"list"`
}

// String returns the string representation
func (s DescribeAdjustmentTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAdjustmentTypesOutput) GoString() string {
	return s.String()
}

type DescribeAutoScalingGroupsInput struct {
	_ struct{} `type:"structure"`

	// The group names.
	AutoScalingGroupNames []*string `type:"list"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAutoScalingGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAutoScalingGroupsInput) GoString() string {
	return s.String()
}

type DescribeAutoScalingGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The groups.
	AutoScalingGroups []*Group `type:"list" required:"true"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAutoScalingGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAutoScalingGroupsOutput) GoString() string {
	return s.String()
}

type DescribeAutoScalingInstancesInput struct {
	_ struct{} `type:"structure"`

	// One or more Auto Scaling instances to describe, up to 50 instances. If you
	// omit this parameter, all Auto Scaling instances are described. If you specify
	// an ID that does not exist, it is ignored with no error.
	InstanceIds []*string `type:"list"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAutoScalingInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAutoScalingInstancesInput) GoString() string {
	return s.String()
}

type DescribeAutoScalingInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The instances.
	AutoScalingInstances []*InstanceDetails `type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAutoScalingInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAutoScalingInstancesOutput) GoString() string {
	return s.String()
}

type DescribeAutoScalingNotificationTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAutoScalingNotificationTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAutoScalingNotificationTypesInput) GoString() string {
	return s.String()
}

type DescribeAutoScalingNotificationTypesOutput struct {
	_ struct{} `type:"structure"`

	// One or more of the following notification types:
	//
	//  autoscaling:EC2_INSTANCE_LAUNCH
	//
	// autoscaling:EC2_INSTANCE_LAUNCH_ERROR
	//
	// autoscaling:EC2_INSTANCE_TERMINATE
	//
	// autoscaling:EC2_INSTANCE_TERMINATE_ERROR
	//
	// autoscaling:TEST_NOTIFICATION
	AutoScalingNotificationTypes []*string `type:"list"`
}

// String returns the string representation
func (s DescribeAutoScalingNotificationTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAutoScalingNotificationTypesOutput) GoString() string {
	return s.String()
}

type DescribeLaunchConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The launch configuration names.
	LaunchConfigurationNames []*string `type:"list"`

	// The maximum number of items to return with this call. The default is 100.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeLaunchConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLaunchConfigurationsInput) GoString() string {
	return s.String()
}

type DescribeLaunchConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The launch configurations.
	LaunchConfigurations []*LaunchConfiguration `type:"list" required:"true"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeLaunchConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLaunchConfigurationsOutput) GoString() string {
	return s.String()
}

type DescribeLifecycleHookTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeLifecycleHookTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLifecycleHookTypesInput) GoString() string {
	return s.String()
}

type DescribeLifecycleHookTypesOutput struct {
	_ struct{} `type:"structure"`

	// One or more of the following notification types:
	//
	//  autoscaling:EC2_INSTANCE_LAUNCHING
	//
	// autoscaling:EC2_INSTANCE_TERMINATING
	LifecycleHookTypes []*string `type:"list"`
}

// String returns the string representation
func (s DescribeLifecycleHookTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLifecycleHookTypesOutput) GoString() string {
	return s.String()
}

type DescribeLifecycleHooksInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The names of one or more lifecycle hooks.
	LifecycleHookNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeLifecycleHooksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLifecycleHooksInput) GoString() string {
	return s.String()
}

type DescribeLifecycleHooksOutput struct {
	_ struct{} `type:"structure"`

	// The lifecycle hooks for the specified group.
	LifecycleHooks []*LifecycleHook `type:"list"`
}

// String returns the string representation
func (s DescribeLifecycleHooksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLifecycleHooksOutput) GoString() string {
	return s.String()
}

type DescribeLoadBalancersInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeLoadBalancersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBalancersInput) GoString() string {
	return s.String()
}

type DescribeLoadBalancersOutput struct {
	_ struct{} `type:"structure"`

	// The load balancers.
	LoadBalancers []*LoadBalancerState `type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeLoadBalancersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBalancersOutput) GoString() string {
	return s.String()
}

type DescribeMetricCollectionTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeMetricCollectionTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMetricCollectionTypesInput) GoString() string {
	return s.String()
}

type DescribeMetricCollectionTypesOutput struct {
	_ struct{} `type:"structure"`

	// The granularities for the metrics.
	Granularities []*MetricGranularityType `type:"list"`

	// One or more metrics.
	Metrics []*MetricCollectionType `type:"list"`
}

// String returns the string representation
func (s DescribeMetricCollectionTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMetricCollectionTypesOutput) GoString() string {
	return s.String()
}

type DescribeNotificationConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	AutoScalingGroupNames []*string `type:"list"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeNotificationConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNotificationConfigurationsInput) GoString() string {
	return s.String()
}

type DescribeNotificationConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// The notification configurations.
	NotificationConfigurations []*NotificationConfiguration `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeNotificationConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNotificationConfigurationsOutput) GoString() string {
	return s.String()
}

type DescribePoliciesInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The maximum number of items to be returned with each call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// One or more policy names or policy ARNs to be described. If you omit this
	// list, all policy names are described. If an group name is provided, the results
	// are limited to that group. This list is limited to 50 items. If you specify
	// an unknown policy name, it is ignored with no error.
	PolicyNames []*string `type:"list"`

	// One or more policy types. Valid values are SimpleScaling and StepScaling.
	PolicyTypes []*string `type:"list"`
}

// String returns the string representation
func (s DescribePoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePoliciesInput) GoString() string {
	return s.String()
}

type DescribePoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// The scaling policies.
	ScalingPolicies []*ScalingPolicy `type:"list"`
}

// String returns the string representation
func (s DescribePoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePoliciesOutput) GoString() string {
	return s.String()
}

type DescribeScalingActivitiesInput struct {
	_ struct{} `type:"structure"`

	// The activity IDs of the desired scaling activities. If this list is omitted,
	// all activities are described. If the AutoScalingGroupName parameter is provided,
	// the results are limited to that group. The list of requested activities cannot
	// contain more than 50 items. If unknown activities are requested, they are
	// ignored with no error.
	ActivityIds []*string `type:"list"`

	// The name of the group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeScalingActivitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingActivitiesInput) GoString() string {
	return s.String()
}

type DescribeScalingActivitiesOutput struct {
	_ struct{} `type:"structure"`

	// The scaling activities.
	Activities []*Activity `type:"list" required:"true"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeScalingActivitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingActivitiesOutput) GoString() string {
	return s.String()
}

type DescribeScalingProcessTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeScalingProcessTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingProcessTypesInput) GoString() string {
	return s.String()
}

type DescribeScalingProcessTypesOutput struct {
	_ struct{} `type:"structure"`

	// The names of the process types.
	Processes []*ProcessType `type:"list"`
}

// String returns the string representation
func (s DescribeScalingProcessTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingProcessTypesOutput) GoString() string {
	return s.String()
}

type DescribeScheduledActionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The latest scheduled start time to return. If scheduled action names are
	// provided, this parameter is ignored.
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// Describes one or more scheduled actions. If you omit this list, the call
	// describes all scheduled actions. If you specify an unknown scheduled action
	// it is ignored with no error.
	//
	// You can describe up to a maximum of 50 instances with a single call. If
	// there are more items to return, the call returns a token. To get the next
	// set of items, repeat the call with the returned token in the NextToken parameter.
	ScheduledActionNames []*string `type:"list"`

	// The earliest scheduled start time to return. If scheduled action names are
	// provided, this parameter is ignored.
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s DescribeScheduledActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScheduledActionsInput) GoString() string {
	return s.String()
}

type DescribeScheduledActionsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// The scheduled actions.
	ScheduledUpdateGroupActions []*ScheduledUpdateGroupAction `type:"list"`
}

// String returns the string representation
func (s DescribeScheduledActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScheduledActionsOutput) GoString() string {
	return s.String()
}

type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// A filter used to scope the tags to return.
	Filters []*Filter `type:"list"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// The tags.
	Tags []*TagDescription `type:"list"`
}

// String returns the string representation
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

type DescribeTerminationPolicyTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeTerminationPolicyTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTerminationPolicyTypesInput) GoString() string {
	return s.String()
}

type DescribeTerminationPolicyTypesOutput struct {
	_ struct{} `type:"structure"`

	// The termination policies supported by Auto Scaling (OldestInstance, OldestLaunchConfiguration,
	// NewestInstance, ClosestToNextInstanceHour, and Default).
	TerminationPolicyTypes []*string `type:"list"`
}

// String returns the string representation
func (s DescribeTerminationPolicyTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTerminationPolicyTypesOutput) GoString() string {
	return s.String()
}

type DetachInstancesInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more instance IDs.
	InstanceIds []*string `type:"list"`

	// If True, the Auto Scaling group decrements the desired capacity value by
	// the number of instances detached.
	ShouldDecrementDesiredCapacity *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s DetachInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachInstancesInput) GoString() string {
	return s.String()
}

type DetachInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The activities related to detaching the instances from the Auto Scaling group.
	Activities []*Activity `type:"list"`
}

// String returns the string representation
func (s DetachInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachInstancesOutput) GoString() string {
	return s.String()
}

type DetachLoadBalancersInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// One or more load balancer names.
	LoadBalancerNames []*string `type:"list"`
}

// String returns the string representation
func (s DetachLoadBalancersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachLoadBalancersInput) GoString() string {
	return s.String()
}

type DetachLoadBalancersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachLoadBalancersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachLoadBalancersOutput) GoString() string {
	return s.String()
}

type DisableMetricsCollectionInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the group.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more of the following metrics. If you omit this parameter, all metrics
	// are disabled.
	//
	//  GroupMinSize
	//
	// GroupMaxSize
	//
	// GroupDesiredCapacity
	//
	// GroupInServiceInstances
	//
	// GroupPendingInstances
	//
	// GroupStandbyInstances
	//
	// GroupTerminatingInstances
	//
	// GroupTotalInstances
	Metrics []*string `type:"list"`
}

// String returns the string representation
func (s DisableMetricsCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableMetricsCollectionInput) GoString() string {
	return s.String()
}

type DisableMetricsCollectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableMetricsCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableMetricsCollectionOutput) GoString() string {
	return s.String()
}

// Describes an Amazon EBS volume.
type Ebs struct {
	_ struct{} `type:"structure"`

	// Indicates whether to delete the volume on instance termination.
	//
	// Default: true
	DeleteOnTermination *bool `type:"boolean"`

	// Indicates whether the volume should be encrypted. Encrypted EBS volumes must
	// be attached to instances that support Amazon EBS encryption. Volumes that
	// are created from encrypted snapshots are automatically encrypted. There is
	// no way to create an encrypted volume from an unencrypted snapshot or an unencrypted
	// volume from an encrypted snapshot. For more information, see Amazon EBS Encryption
	// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) in
	// the Amazon Elastic Compute Cloud User Guide.
	Encrypted *bool `type:"boolean"`

	// For Provisioned IOPS (SSD) volumes only. The number of I/O operations per
	// second (IOPS) to provision for the volume.
	//
	// Default: None
	Iops *int64 `min:"100" type:"integer"`

	// The ID of the snapshot.
	SnapshotId *string `min:"1" type:"string"`

	// The volume size, in gigabytes.
	//
	// Valid values: If the volume type is io1, the minimum size of the volume
	// is 10 GiB. If you specify SnapshotId and VolumeSize, VolumeSize must be equal
	// to or larger than the size of the snapshot.
	//
	// Default: If you create a volume from a snapshot and you don't specify a
	// volume size, the default is the size of the snapshot.
	//
	// Required: Required when the volume type is io1.
	VolumeSize *int64 `min:"1" type:"integer"`

	// The volume type.
	//
	// Valid values: standard | io1 | gp2
	//
	// Default: standard
	VolumeType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Ebs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Ebs) GoString() string {
	return s.String()
}

type EnableMetricsCollectionInput struct {
	_ struct{} `type:"structure"`

	// The name or ARN of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The granularity to associate with the metrics to collect. The only valid
	// value is 1Minute.
	Granularity *string `min:"1" type:"string" required:"true"`

	// One or more of the following metrics. If you omit this parameter, all metrics
	// are enabled.
	//
	//  GroupMinSize
	//
	// GroupMaxSize
	//
	// GroupDesiredCapacity
	//
	// GroupInServiceInstances
	//
	// GroupPendingInstances
	//
	// GroupStandbyInstances
	//
	// GroupTerminatingInstances
	//
	// GroupTotalInstances
	//
	//  Note that the GroupStandbyInstances metric is not enabled by default. You
	// must explicitly request this metric.
	Metrics []*string `type:"list"`
}

// String returns the string representation
func (s EnableMetricsCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableMetricsCollectionInput) GoString() string {
	return s.String()
}

type EnableMetricsCollectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableMetricsCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableMetricsCollectionOutput) GoString() string {
	return s.String()
}

// Describes an enabled metric.
type EnabledMetric struct {
	_ struct{} `type:"structure"`

	// The granularity of the metric. The only valid value is 1Minute.
	Granularity *string `min:"1" type:"string"`

	// One of the following metrics:
	//
	//  GroupMinSize
	//
	// GroupMaxSize
	//
	// GroupDesiredCapacity
	//
	// GroupInServiceInstances
	//
	// GroupPendingInstances
	//
	// GroupStandbyInstances
	//
	// GroupTerminatingInstances
	//
	// GroupTotalInstances
	Metric *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EnabledMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnabledMetric) GoString() string {
	return s.String()
}

type EnterStandbyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more instances to move into Standby mode. You must specify at least
	// one instance ID.
	InstanceIds []*string `type:"list"`

	// Specifies whether the instances moved to Standby mode count as part of the
	// Auto Scaling group's desired capacity. If set, the desired capacity for the
	// Auto Scaling group decrements by the number of instances moved to Standby
	// mode.
	ShouldDecrementDesiredCapacity *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s EnterStandbyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnterStandbyInput) GoString() string {
	return s.String()
}

type EnterStandbyOutput struct {
	_ struct{} `type:"structure"`

	// The activities related to moving instances into Standby mode.
	Activities []*Activity `type:"list"`
}

// String returns the string representation
func (s EnterStandbyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnterStandbyOutput) GoString() string {
	return s.String()
}

type ExecutePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The breach threshold for the alarm.
	//
	// This parameter is required if the policy type is StepScaling and not supported
	// otherwise.
	BreachThreshold *float64 `type:"double"`

	// If this parameter is true, Auto Scaling waits for the cooldown period to
	// complete before executing the policy. Otherwise, Auto Scaling executes the
	// policy without waiting for the cooldown period to complete.
	//
	// This parameter is not supported if the policy type is StepScaling.
	//
	// For more information, see Understanding Auto Scaling Cooldowns (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/Cooldown.html)
	// in the Auto Scaling Developer Guide.
	HonorCooldown *bool `type:"boolean"`

	// The metric value to compare to BreachThreshold. This enables you to execute
	// a policy of type StepScaling and determine which step adjustment to use.
	// For example, if the breach threshold is 50 and you want to use a step adjustment
	// with a lower bound of 0 and an upper bound of 10, you can set the metric
	// value to 59.
	//
	// If you specify a metric value that doesn't correspond to a step adjustment
	// for the policy, the call returns an error.
	//
	// This parameter is required if the policy type is StepScaling and not supported
	// otherwise.
	MetricValue *float64 `type:"double"`

	// The name or ARN of the policy.
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ExecutePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutePolicyInput) GoString() string {
	return s.String()
}

type ExecutePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ExecutePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutePolicyOutput) GoString() string {
	return s.String()
}

type ExitStandbyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more instance IDs. You must specify at least one instance ID.
	InstanceIds []*string `type:"list"`
}

// String returns the string representation
func (s ExitStandbyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExitStandbyInput) GoString() string {
	return s.String()
}

type ExitStandbyOutput struct {
	_ struct{} `type:"structure"`

	// The activities related to moving instances out of Standby mode.
	Activities []*Activity `type:"list"`
}

// String returns the string representation
func (s ExitStandbyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExitStandbyOutput) GoString() string {
	return s.String()
}

// Describes a filter.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter. The valid values are: "auto-scaling-group", "key",
	// "value", and "propagate-at-launch".
	Name *string `type:"string"`

	// The value of the filter.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Describes an Auto Scaling group.
type Group struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the group.
	AutoScalingGroupARN *string `min:"1" type:"string"`

	// The name of the group.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more Availability Zones for the group.
	AvailabilityZones []*string `min:"1" type:"list" required:"true"`

	// The date and time the group was created.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The amount of time, in seconds, after a scaling activity completes before
	// another scaling activity can start.
	DefaultCooldown *int64 `type:"integer" required:"true"`

	// The desired size of the group.
	DesiredCapacity *int64 `type:"integer" required:"true"`

	// The metrics enabled for the group.
	EnabledMetrics []*EnabledMetric `type:"list"`

	// The amount of time, in seconds, that Auto Scaling waits before checking the
	// health status of an EC2 instance that has come into service.
	HealthCheckGracePeriod *int64 `type:"integer"`

	// The service to use for the health checks. The valid values are EC2 and ELB.
	HealthCheckType *string `min:"1" type:"string" required:"true"`

	// The EC2 instances associated with the group.
	Instances []*Instance `type:"list"`

	// The name of the associated launch configuration.
	LaunchConfigurationName *string `min:"1" type:"string"`

	// One or more load balancers associated with the group.
	LoadBalancerNames []*string `type:"list"`

	// The maximum size of the group.
	MaxSize *int64 `type:"integer" required:"true"`

	// The minimum size of the group.
	MinSize *int64 `type:"integer" required:"true"`

	// Indicates whether newly launched instances are protected from termination
	// by Auto Scaling when scaling in.
	NewInstancesProtectedFromScaleIn *bool `type:"boolean"`

	// The name of the placement group into which you'll launch your instances,
	// if any. For more information, see Placement Groups (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	PlacementGroup *string `min:"1" type:"string"`

	// The current state of the group when DeleteAutoScalingGroup is in progress.
	Status *string `min:"1" type:"string"`

	// The suspended processes associated with the group.
	SuspendedProcesses []*SuspendedProcess `type:"list"`

	// The tags for the group.
	Tags []*TagDescription `type:"list"`

	// The termination policies for the group.
	TerminationPolicies []*string `type:"list"`

	// One or more subnet IDs, if applicable, separated by commas.
	//
	// If you specify VPCZoneIdentifier and AvailabilityZones, ensure that the
	// Availability Zones of the subnets match the values for AvailabilityZones.
	VPCZoneIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Group) GoString() string {
	return s.String()
}

// Describes an EC2 instance.
type Instance struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which the instance is running.
	AvailabilityZone *string `min:"1" type:"string" required:"true"`

	// The health status of the instance.
	HealthStatus *string `min:"1" type:"string" required:"true"`

	// The ID of the instance.
	InstanceId *string `min:"1" type:"string" required:"true"`

	// The launch configuration associated with the instance.
	LaunchConfigurationName *string `min:"1" type:"string" required:"true"`

	// A description of the current lifecycle state. Note that the Quarantined state
	// is not used.
	LifecycleState *string `type:"string" required:"true" enum:"LifecycleState"`

	// Indicates whether the instance is protected from termination by Auto Scaling
	// when scaling in.
	ProtectedFromScaleIn *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Instance) GoString() string {
	return s.String()
}

// Describes an EC2 instance associated with an Auto Scaling group.
type InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group associated with the instance.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The Availability Zone for the instance.
	AvailabilityZone *string `min:"1" type:"string" required:"true"`

	// The health status of this instance. "Healthy" means that the instance is
	// healthy and should remain in service. "Unhealthy" means that the instance
	// is unhealthy and Auto Scaling should terminate and replace it.
	HealthStatus *string `min:"1" type:"string" required:"true"`

	// The ID of the instance.
	InstanceId *string `min:"1" type:"string" required:"true"`

	// The launch configuration associated with the instance.
	LaunchConfigurationName *string `min:"1" type:"string" required:"true"`

	// The lifecycle state for the instance. For more information, see Auto Scaling
	// Instance States (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingGroupLifecycle.html#AutoScalingStates)
	// in the Auto Scaling Developer Guide.
	LifecycleState *string `min:"1" type:"string" required:"true"`

	// Indicates whether the instance is protected from termination by Auto Scaling
	// when scaling in.
	ProtectedFromScaleIn *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceDetails) GoString() string {
	return s.String()
}

// Describes whether instance monitoring is enabled.
type InstanceMonitoring struct {
	_ struct{} `type:"structure"`

	// If True, instance monitoring is enabled.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s InstanceMonitoring) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceMonitoring) GoString() string {
	return s.String()
}

// Describes a launch configuration.
type LaunchConfiguration struct {
	_ struct{} `type:"structure"`

	// [EC2-VPC] Indicates whether to assign a public IP address to each instance.
	AssociatePublicIpAddress *bool `type:"boolean"`

	// A block device mapping, which specifies the block devices for the instance.
	BlockDeviceMappings []*BlockDeviceMapping `type:"list"`

	// The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to.
	// This parameter can only be used if you are launching EC2-Classic instances.
	// For more information, see ClassicLink (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClassicLinkVPCId *string `min:"1" type:"string"`

	// The IDs of one or more security groups for the VPC specified in ClassicLinkVPCId.
	// This parameter is required if ClassicLinkVPCId is specified, and cannot be
	// used otherwise. For more information, see ClassicLink (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClassicLinkVPCSecurityGroups []*string `type:"list"`

	// The creation date and time for the launch configuration.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Controls whether the instance is optimized for EBS I/O (true) or not (false).
	EbsOptimized *bool `type:"boolean"`

	// The name or Amazon Resource Name (ARN) of the instance profile associated
	// with the IAM role for the instance.
	IamInstanceProfile *string `min:"1" type:"string"`

	// The ID of the Amazon Machine Image (AMI).
	ImageId *string `min:"1" type:"string" required:"true"`

	// Controls whether instances in this group are launched with detailed monitoring.
	InstanceMonitoring *InstanceMonitoring `type:"structure"`

	// The instance type for the instances.
	InstanceType *string `min:"1" type:"string" required:"true"`

	// The ID of the kernel associated with the AMI.
	KernelId *string `min:"1" type:"string"`

	// The name of the key pair.
	KeyName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the launch configuration.
	LaunchConfigurationARN *string `min:"1" type:"string"`

	// The name of the launch configuration.
	LaunchConfigurationName *string `min:"1" type:"string" required:"true"`

	// The tenancy of the instance, either default or dedicated. An instance with
	// dedicated tenancy runs in an isolated, single-tenant hardware and can only
	// be launched into a VPC.
	PlacementTenancy *string `min:"1" type:"string"`

	// The ID of the RAM disk associated with the AMI.
	RamdiskId *string `min:"1" type:"string"`

	// The security groups to associate with the instances.
	SecurityGroups []*string `type:"list"`

	// The price to bid when launching Spot Instances.
	SpotPrice *string `min:"1" type:"string"`

	// The user data available to the instances.
	UserData *string `type:"string"`
}

// String returns the string representation
func (s LaunchConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LaunchConfiguration) GoString() string {
	return s.String()
}

// Describes a lifecycle hook, which tells Auto Scaling that you want to perform
// an action when an instance launches or terminates. When you have a lifecycle
// hook in place, the Auto Scaling group will either:
//
//  Pause the instance after it launches, but before it is put into service
// Pause the instance as it terminates, but before it is fully terminated  For
// more information, see Auto Scaling Pending State (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingPendingState.html)
// and Auto Scaling Terminating State (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingTerminatingState.html)
// in the Auto Scaling Developer Guide.
type LifecycleHook struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group for the lifecycle hook.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// Defines the action the Auto Scaling group should take when the lifecycle
	// hook timeout elapses or if an unexpected failure occurs. The valid values
	// are CONTINUE and ABANDON. The default value is CONTINUE.
	DefaultResult *string `type:"string"`

	// The maximum time, in seconds, that an instance can remain in a Pending:Wait
	// or Terminating:Wait state. The default is 172800 seconds (48 hours).
	GlobalTimeout *int64 `type:"integer"`

	// The maximum time, in seconds, that can elapse before the lifecycle hook times
	// out. The default is 3600 seconds (1 hour). When the lifecycle hook times
	// out, Auto Scaling performs the action defined in the DefaultResult parameter.
	// You can prevent the lifecycle hook from timing out by calling RecordLifecycleActionHeartbeat.
	HeartbeatTimeout *int64 `type:"integer"`

	// The name of the lifecycle hook.
	LifecycleHookName *string `min:"1" type:"string"`

	// The state of the EC2 instance to which you want to attach the lifecycle hook.
	// For a list of lifecycle hook types, see DescribeLifecycleHookTypes.
	LifecycleTransition *string `type:"string"`

	// Additional information that you want to include any time Auto Scaling sends
	// a message to the notification target.
	NotificationMetadata *string `min:"1" type:"string"`

	// The ARN of the notification target that Auto Scaling uses to notify you when
	// an instance is in the transition state for the lifecycle hook. This ARN target
	// can be either an SQS queue or an SNS topic. The notification message sent
	// to the target includes the following:
	//
	//  Lifecycle action token User account ID Name of the Auto Scaling group Lifecycle
	// hook name EC2 instance ID Lifecycle transition Notification metadata
	NotificationTargetARN *string `min:"1" type:"string"`

	// The ARN of the IAM role that allows the Auto Scaling group to publish to
	// the specified notification target.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LifecycleHook) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleHook) GoString() string {
	return s.String()
}

// Describes the state of a load balancer.
type LoadBalancerState struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `min:"1" type:"string"`

	// One of the following load balancer states:
	//
	//  Adding - The instances in the group are being registered with the load
	// balancer.
	//
	// Added - All instances in the group are registered with the load balancer.
	//
	// InService - At least one instance in the group passed an ELB health check.
	//
	// Removing - The instances are being deregistered from the load balancer.
	// If connection draining is enabled, Elastic Load Balancing waits for in-flight
	// requests to complete before deregistering the instances.
	State *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LoadBalancerState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancerState) GoString() string {
	return s.String()
}

// Describes a metric.
type MetricCollectionType struct {
	_ struct{} `type:"structure"`

	// One of the following metrics:
	//
	//  GroupMinSize
	//
	// GroupMaxSize
	//
	// GroupDesiredCapacity
	//
	// GroupInServiceInstances
	//
	// GroupPendingInstances
	//
	// GroupStandbyInstances
	//
	// GroupTerminatingInstances
	//
	// GroupTotalInstances
	Metric *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MetricCollectionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricCollectionType) GoString() string {
	return s.String()
}

// Describes a granularity of a metric.
type MetricGranularityType struct {
	_ struct{} `type:"structure"`

	// The granularity. The only valid value is 1Minute.
	Granularity *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MetricGranularityType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricGranularityType) GoString() string {
	return s.String()
}

// Describes a notification.
type NotificationConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// One of the following event notification types:
	//
	//  autoscaling:EC2_INSTANCE_LAUNCH
	//
	// autoscaling:EC2_INSTANCE_LAUNCH_ERROR
	//
	// autoscaling:EC2_INSTANCE_TERMINATE
	//
	// autoscaling:EC2_INSTANCE_TERMINATE_ERROR
	//
	// autoscaling:TEST_NOTIFICATION
	NotificationType *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (SNS) topic.
	TopicARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s NotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationConfiguration) GoString() string {
	return s.String()
}

// Describes a process type.
//
// For more information, see Auto Scaling Processes (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/US_SuspendResume.html#process-types)
// in the Auto Scaling Developer Guide.
type ProcessType struct {
	_ struct{} `type:"structure"`

	// One of the following processes:
	//
	//  Launch
	//
	// Terminate
	//
	// AddToLoadBalancer
	//
	// AlarmNotification
	//
	// AZRebalance
	//
	// HealthCheck
	//
	// ReplaceUnhealthy
	//
	// ScheduledActions
	ProcessName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ProcessType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProcessType) GoString() string {
	return s.String()
}

type PutLifecycleHookInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group to which you want to assign the lifecycle
	// hook.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// Defines the action the Auto Scaling group should take when the lifecycle
	// hook timeout elapses or if an unexpected failure occurs. The value for this
	// parameter can be either CONTINUE or ABANDON. The default value for this parameter
	// is ABANDON.
	DefaultResult *string `type:"string"`

	// The amount of time, in seconds, that can elapse before the lifecycle hook
	// times out. When the lifecycle hook times out, Auto Scaling performs the action
	// defined in the DefaultResult parameter. You can prevent the lifecycle hook
	// from timing out by calling RecordLifecycleActionHeartbeat. The default is
	// 3600 seconds (1 hour).
	HeartbeatTimeout *int64 `type:"integer"`

	// The name of the lifecycle hook.
	LifecycleHookName *string `min:"1" type:"string" required:"true"`

	// The instance state to which you want to attach the lifecycle hook. For a
	// list of lifecycle hook types, see DescribeLifecycleHookTypes.
	//
	// This parameter is required for new lifecycle hooks, but optional when updating
	// existing hooks.
	LifecycleTransition *string `type:"string"`

	// Contains additional information that you want to include any time Auto Scaling
	// sends a message to the notification target.
	NotificationMetadata *string `min:"1" type:"string"`

	// The ARN of the notification target that Auto Scaling will use to notify you
	// when an instance is in the transition state for the lifecycle hook. This
	// ARN target can be either an SQS queue or an SNS topic.
	//
	// This parameter is required for new lifecycle hooks, but optional when updating
	// existing hooks.
	//
	// The notification message sent to the target will include:
	//
	//  LifecycleActionToken. The Lifecycle action token. AccountId. The user account
	// ID. AutoScalingGroupName. The name of the Auto Scaling group. LifecycleHookName.
	// The lifecycle hook name. EC2InstanceId. The EC2 instance ID. LifecycleTransition.
	// The lifecycle transition. NotificationMetadata. The notification metadata.
	//  This operation uses the JSON format when sending notifications to an Amazon
	// SQS queue, and an email key/value pair format when sending notifications
	// to an Amazon SNS topic.
	//
	// When you call this operation, a test message is sent to the notification
	// target. This test message contains an additional key/value pair: Event:autoscaling:TEST_NOTIFICATION.
	NotificationTargetARN *string `min:"1" type:"string"`

	// The ARN of the IAM role that allows the Auto Scaling group to publish to
	// the specified notification target.
	//
	// This parameter is required for new lifecycle hooks, but optional when updating
	// existing hooks.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutLifecycleHookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLifecycleHookInput) GoString() string {
	return s.String()
}

type PutLifecycleHookOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutLifecycleHookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLifecycleHookOutput) GoString() string {
	return s.String()
}

type PutNotificationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The type of event that will cause the notification to be sent. For details
	// about notification types supported by Auto Scaling, see DescribeAutoScalingNotificationTypes.
	NotificationTypes []*string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (SNS) topic.
	TopicARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutNotificationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutNotificationConfigurationInput) GoString() string {
	return s.String()
}

type PutNotificationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutNotificationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutNotificationConfigurationOutput) GoString() string {
	return s.String()
}

type PutScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// The adjustment type. Valid values are ChangeInCapacity, ExactCapacity, and
	// PercentChangeInCapacity.
	//
	// For more information, see Dynamic Scaling (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/as-scale-based-on-demand.html)
	// in the Auto Scaling Developer Guide.
	AdjustmentType *string `min:"1" type:"string" required:"true"`

	// The name or ARN of the group.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The amount of time, in seconds, after a scaling activity completes and before
	// the next scaling activity can start. If this parameter is not specified,
	// the default cooldown period for the group applies.
	//
	// This parameter is not supported unless the policy type is SimpleScaling.
	//
	// For more information, see Understanding Auto Scaling Cooldowns (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/Cooldown.html)
	// in the Auto Scaling Developer Guide.
	Cooldown *int64 `type:"integer"`

	// The estimated time, in seconds, until a newly launched instance can contribute
	// to the CloudWatch metrics. The default is to use the value specified for
	// the default cooldown period for the group.
	//
	// This parameter is not supported if the policy type is SimpleScaling.
	EstimatedInstanceWarmup *int64 `type:"integer"`

	// The aggregation type for the CloudWatch metrics. Valid values are Minimum,
	// Maximum, and Average. If the aggregation type is null, the value is treated
	// as Average.
	//
	// This parameter is not supported if the policy type is SimpleScaling.
	MetricAggregationType *string `min:"1" type:"string"`

	// The minimum number of instances to scale. If the value of AdjustmentType
	// is PercentChangeInCapacity, the scaling policy changes the DesiredCapacity
	// of the Auto Scaling group by at least this many instances. Otherwise, the
	// error is ValidationError.
	MinAdjustmentMagnitude *int64 `type:"integer"`

	// Available for backward compatibility. Use MinAdjustmentMagnitude instead.
	MinAdjustmentStep *int64 `type:"integer"`

	// The name of the policy.
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The policy type. Valid values are SimpleScaling and StepScaling. If the policy
	// type is null, the value is treated as SimpleScaling.
	PolicyType *string `min:"1" type:"string"`

	// The amount by which to scale, based on the specified adjustment type. A positive
	// value adds to the current capacity while a negative number removes from the
	// current capacity.
	//
	// This parameter is required if the policy type is SimpleScaling and not supported
	// otherwise.
	ScalingAdjustment *int64 `type:"integer"`

	// A set of adjustments that enable you to scale based on the size of the alarm
	// breach.
	//
	// This parameter is required if the policy type is StepScaling and not supported
	// otherwise.
	StepAdjustments []*StepAdjustment `type:"list"`
}

// String returns the string representation
func (s PutScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutScalingPolicyInput) GoString() string {
	return s.String()
}

type PutScalingPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the policy.
	PolicyARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutScalingPolicyOutput) GoString() string {
	return s.String()
}

type PutScheduledUpdateGroupActionInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The number of EC2 instances that should be running in the group.
	DesiredCapacity *int64 `type:"integer"`

	// The time for this action to end.
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The maximum size for the Auto Scaling group.
	MaxSize *int64 `type:"integer"`

	// The minimum size for the Auto Scaling group.
	MinSize *int64 `type:"integer"`

	// The time when recurring future actions will start. Start time is specified
	// by the user following the Unix cron syntax format. For more information,
	// see Cron (http://en.wikipedia.org/wiki/Cron) in Wikipedia.
	//
	// When StartTime and EndTime are specified with Recurrence, they form the
	// boundaries of when the recurring action will start and stop.
	Recurrence *string `min:"1" type:"string"`

	// The name of this scaling action.
	ScheduledActionName *string `min:"1" type:"string" required:"true"`

	// The time for this action to start, in "YYYY-MM-DDThh:mm:ssZ" format in UTC/GMT
	// only (for example, 2014-06-01T00:00:00Z).
	//
	// If you try to schedule your action in the past, Auto Scaling returns an
	// error message.
	//
	// When StartTime and EndTime are specified with Recurrence, they form the
	// boundaries of when the recurring action starts and stops.
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// This parameter is deprecated; use StartTime instead.
	//
	// The time for this action to start. If both Time and StartTime are specified,
	// their values must be identical.
	Time *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s PutScheduledUpdateGroupActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutScheduledUpdateGroupActionInput) GoString() string {
	return s.String()
}

type PutScheduledUpdateGroupActionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutScheduledUpdateGroupActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutScheduledUpdateGroupActionOutput) GoString() string {
	return s.String()
}

type RecordLifecycleActionHeartbeatInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group for the hook.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// A token that uniquely identifies a specific lifecycle action associated with
	// an instance. Auto Scaling sends this token to the notification target you
	// specified when you created the lifecycle hook.
	LifecycleActionToken *string `min:"36" type:"string" required:"true"`

	// The name of the lifecycle hook.
	LifecycleHookName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RecordLifecycleActionHeartbeatInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordLifecycleActionHeartbeatInput) GoString() string {
	return s.String()
}

type RecordLifecycleActionHeartbeatOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RecordLifecycleActionHeartbeatOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordLifecycleActionHeartbeatOutput) GoString() string {
	return s.String()
}

type ResumeProcessesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ResumeProcessesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResumeProcessesOutput) GoString() string {
	return s.String()
}

// Describes a scaling policy.
type ScalingPolicy struct {
	_ struct{} `type:"structure"`

	// The adjustment type, which specifies how ScalingAdjustment is interpreted.
	// Valid values are ChangeInCapacity, ExactCapacity, and PercentChangeInCapacity.
	AdjustmentType *string `min:"1" type:"string"`

	// The CloudWatch alarms related to the policy.
	Alarms []*Alarm `type:"list"`

	// The name of the Auto Scaling group associated with this scaling policy.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The amount of time, in seconds, after a scaling activity completes before
	// any further trigger-related scaling activities can start.
	Cooldown *int64 `type:"integer"`

	// The estimated time, in seconds, until a newly launched instance can contribute
	// to the CloudWatch metrics.
	EstimatedInstanceWarmup *int64 `type:"integer"`

	// The aggregation type for the CloudWatch metrics. Valid values are Minimum,
	// Maximum, and Average.
	MetricAggregationType *string `min:"1" type:"string"`

	// The minimum number of instances to scale. If the value of AdjustmentType
	// is PercentChangeInCapacity, the scaling policy changes the DesiredCapacity
	// of the Auto Scaling group by at least this many instances. Otherwise, the
	// error is ValidationError.
	MinAdjustmentMagnitude *int64 `type:"integer"`

	// Available for backward compatibility. Use MinAdjustmentMagnitude instead.
	MinAdjustmentStep *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the policy.
	PolicyARN *string `min:"1" type:"string"`

	// The name of the scaling policy.
	PolicyName *string `min:"1" type:"string"`

	// The policy type. Valid values are SimpleScaling and StepScaling.
	PolicyType *string `min:"1" type:"string"`

	// The amount by which to scale, based on the specified adjustment type. A positive
	// value adds to the current capacity while a negative number removes from the
	// current capacity.
	ScalingAdjustment *int64 `type:"integer"`

	// A set of adjustments that enable you to scale based on the size of the alarm
	// breach.
	StepAdjustments []*StepAdjustment `type:"list"`
}

// String returns the string representation
func (s ScalingPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingPolicy) GoString() string {
	return s.String()
}

type ScalingProcessQuery struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more of the following processes:
	//
	//  Launch
	//
	// Terminate
	//
	// HealthCheck
	//
	// ReplaceUnhealthy
	//
	// AZRebalance
	//
	// AlarmNotification
	//
	// ScheduledActions
	//
	// AddToLoadBalancer
	ScalingProcesses []*string `type:"list"`
}

// String returns the string representation
func (s ScalingProcessQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingProcessQuery) GoString() string {
	return s.String()
}

// Describes a scheduled update to an Auto Scaling group.
type ScheduledUpdateGroupAction struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The number of instances you prefer to maintain in the group.
	DesiredCapacity *int64 `type:"integer"`

	// The date and time that the action is scheduled to end. This date and time
	// can be up to one month in the future.
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The maximum size of the group.
	MaxSize *int64 `type:"integer"`

	// The minimum size of the group.
	MinSize *int64 `type:"integer"`

	// The recurring schedule for the action.
	Recurrence *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the scheduled action.
	ScheduledActionARN *string `min:"1" type:"string"`

	// The name of the scheduled action.
	ScheduledActionName *string `min:"1" type:"string"`

	// The date and time that the action is scheduled to begin. This date and time
	// can be up to one month in the future.
	//
	// When StartTime and EndTime are specified with Recurrence, they form the
	// boundaries of when the recurring action will start and stop.
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// This parameter is deprecated; use StartTime instead.
	Time *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ScheduledUpdateGroupAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduledUpdateGroupAction) GoString() string {
	return s.String()
}

type SetDesiredCapacityInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The number of EC2 instances that should be running in the Auto Scaling group.
	DesiredCapacity *int64 `type:"integer" required:"true"`

	// By default, SetDesiredCapacity overrides any cooldown period associated with
	// the Auto Scaling group. Specify True to make Auto Scaling to wait for the
	// cool-down period associated with the Auto Scaling group to complete before
	// initiating a scaling activity to set your Auto Scaling group to its new capacity.
	HonorCooldown *bool `type:"boolean"`
}

// String returns the string representation
func (s SetDesiredCapacityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetDesiredCapacityInput) GoString() string {
	return s.String()
}

type SetDesiredCapacityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetDesiredCapacityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetDesiredCapacityOutput) GoString() string {
	return s.String()
}

type SetInstanceHealthInput struct {
	_ struct{} `type:"structure"`

	// The health status of the instance. Set to Healthy if you want the instance
	// to remain in service. Set to Unhealthy if you want the instance to be out
	// of service. Auto Scaling will terminate and replace the unhealthy instance.
	HealthStatus *string `min:"1" type:"string" required:"true"`

	// The ID of the EC2 instance.
	InstanceId *string `min:"1" type:"string" required:"true"`

	// If the Auto Scaling group of the specified instance has a HealthCheckGracePeriod
	// specified for the group, by default, this call will respect the grace period.
	// Set this to False, if you do not want the call to respect the grace period
	// associated with the group.
	//
	// For more information, see the HealthCheckGracePeriod parameter description
	// for CreateAutoScalingGroup.
	ShouldRespectGracePeriod *bool `type:"boolean"`
}

// String returns the string representation
func (s SetInstanceHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetInstanceHealthInput) GoString() string {
	return s.String()
}

type SetInstanceHealthOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetInstanceHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetInstanceHealthOutput) GoString() string {
	return s.String()
}

type SetInstanceProtectionInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more instance IDs.
	InstanceIds []*string `type:"list" required:"true"`

	// Indicates whether the instance is protected from termination by Auto Scaling
	// when scaling in.
	ProtectedFromScaleIn *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s SetInstanceProtectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetInstanceProtectionInput) GoString() string {
	return s.String()
}

type SetInstanceProtectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetInstanceProtectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetInstanceProtectionOutput) GoString() string {
	return s.String()
}

// Describes an adjustment based on the difference between the value of the
// aggregated CloudWatch metric and the breach threshold that you've defined
// for the alarm.
//
// For the following examples, suppose that you have an alarm with a breach
// threshold of 50:
//
//   If you want the adjustment to be triggered when the metric is greater
// than or equal to 50 and less than 60, specify a lower bound of 0 and an upper
// bound of 10.
//
//   If you want the adjustment to be triggered when the metric is greater
// than 40 and less than or equal to 50, specify a lower bound of -10 and an
// upper bound of 0.
//
//   There are a few rules for the step adjustments for your step policy:
//
//   The ranges of your step adjustments can't overlap or have a gap.
//
//   At most one step adjustment can have a null lower bound. If one step adjustment
// has a negative lower bound, then there must be a step adjustment with a null
// lower bound.
//
//   At most one step adjustment can have a null upper bound. If one step adjustment
// has a positive upper bound, then there must be a step adjustment with a null
// upper bound.
//
//   The upper and lower bound can't be null in the same step adjustment.
type StepAdjustment struct {
	_ struct{} `type:"structure"`

	// The lower bound for the difference between the alarm threshold and the CloudWatch
	// metric. If the metric value is above the breach threshold, the lower bound
	// is inclusive (the metric must be greater than or equal to the threshold plus
	// the lower bound). Otherwise, it is exclusive (the metric must be greater
	// than the threshold plus the lower bound). A null value indicates negative
	// infinity.
	MetricIntervalLowerBound *float64 `type:"double"`

	// The upper bound for the difference between the alarm threshold and the CloudWatch
	// metric. If the metric value is above the breach threshold, the upper bound
	// is exclusive (the metric must be less than the threshold plus the upper bound).
	// Otherwise, it is inclusive (the metric must be less than or equal to the
	// threshold plus the upper bound). A null value indicates positive infinity.
	//
	// The upper bound must be greater than the lower bound.
	MetricIntervalUpperBound *float64 `type:"double"`

	// The amount by which to scale, based on the specified adjustment type. A positive
	// value adds to the current capacity while a negative number removes from the
	// current capacity.
	ScalingAdjustment *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s StepAdjustment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepAdjustment) GoString() string {
	return s.String()
}

type SuspendProcessesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SuspendProcessesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SuspendProcessesOutput) GoString() string {
	return s.String()
}

// Describes an Auto Scaling process that has been suspended. For more information,
// see ProcessType.
type SuspendedProcess struct {
	_ struct{} `type:"structure"`

	// The name of the suspended process.
	ProcessName *string `min:"1" type:"string"`

	// The reason that the process was suspended.
	SuspensionReason *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SuspendedProcess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SuspendedProcess) GoString() string {
	return s.String()
}

// Describes a tag for an Auto Scaling group.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key.
	Key *string `min:"1" type:"string" required:"true"`

	// Determines whether the tag is added to new instances as they are launched
	// in the group.
	PropagateAtLaunch *bool `type:"boolean"`

	// The name of the group.
	ResourceId *string `type:"string"`

	// The type of resource. The only supported value is auto-scaling-group.
	ResourceType *string `type:"string"`

	// The tag value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Describes a tag for an Auto Scaling group.
type TagDescription struct {
	_ struct{} `type:"structure"`

	// The tag key.
	Key *string `min:"1" type:"string"`

	// Determines whether the tag is added to new instances as they are launched
	// in the group.
	PropagateAtLaunch *bool `type:"boolean"`

	// The name of the group.
	ResourceId *string `type:"string"`

	// The type of resource. The only supported value is auto-scaling-group.
	ResourceType *string `type:"string"`

	// The tag value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s TagDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagDescription) GoString() string {
	return s.String()
}

type TerminateInstanceInAutoScalingGroupInput struct {
	_ struct{} `type:"structure"`

	// The ID of the EC2 instance.
	InstanceId *string `min:"1" type:"string" required:"true"`

	// If true, terminating the instance also decrements the size of the Auto Scaling
	// group.
	ShouldDecrementDesiredCapacity *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s TerminateInstanceInAutoScalingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateInstanceInAutoScalingGroupInput) GoString() string {
	return s.String()
}

type TerminateInstanceInAutoScalingGroupOutput struct {
	_ struct{} `type:"structure"`

	// A scaling activity.
	Activity *Activity `type:"structure"`
}

// String returns the string representation
func (s TerminateInstanceInAutoScalingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateInstanceInAutoScalingGroupOutput) GoString() string {
	return s.String()
}

type UpdateAutoScalingGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more Availability Zones for the group.
	AvailabilityZones []*string `min:"1" type:"list"`

	// The amount of time, in seconds, after a scaling activity completes before
	// another scaling activity can start. The default is 300.
	//
	// For more information, see Understanding Auto Scaling Cooldowns (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/Cooldown.html)
	// in the Auto Scaling Developer Guide.
	DefaultCooldown *int64 `type:"integer"`

	// The number of EC2 instances that should be running in the Auto Scaling group.
	// This number must be greater than or equal to the minimum size of the group
	// and less than or equal to the maximum size of the group.
	DesiredCapacity *int64 `type:"integer"`

	// The amount of time, in seconds, that Auto Scaling waits before checking the
	// health status of an EC2 instance that has come into service. The default
	// is 300.
	//
	// For more information, see Health Checks For Auto Scaling Instances (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/healthcheck.html)
	// in the Auto Scaling Developer Guide.
	HealthCheckGracePeriod *int64 `type:"integer"`

	// The service to use for the health checks. The valid values are EC2 and ELB.
	HealthCheckType *string `min:"1" type:"string"`

	// The name of the launch configuration.
	LaunchConfigurationName *string `min:"1" type:"string"`

	// The maximum size of the Auto Scaling group.
	MaxSize *int64 `type:"integer"`

	// The minimum size of the Auto Scaling group.
	MinSize *int64 `type:"integer"`

	// Indicates whether newly launched instances are protected from termination
	// by Auto Scaling when scaling in.
	NewInstancesProtectedFromScaleIn *bool `type:"boolean"`

	// The name of the placement group into which you'll launch your instances,
	// if any. For more information, see Placement Groups (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	PlacementGroup *string `min:"1" type:"string"`

	// A standalone termination policy or a list of termination policies used to
	// select the instance to terminate. The policies are executed in the order
	// that they are listed.
	//
	// For more information, see Choosing a Termination Policy for Your Auto Scaling
	// Group (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/us-termination-policy.html)
	// in the Auto Scaling Developer Guide.
	TerminationPolicies []*string `type:"list"`

	// The ID of the subnet, if you are launching into a VPC. You can specify several
	// subnets in a comma-separated list.
	//
	// When you specify VPCZoneIdentifier with AvailabilityZones, ensure that the
	// subnets' Availability Zones match the values you specify for AvailabilityZones.
	//
	// For more information, see Auto Scaling and Amazon Virtual Private Cloud
	// (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/autoscalingsubnets.html)
	// in the Auto Scaling Developer Guide.
	VPCZoneIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateAutoScalingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAutoScalingGroupInput) GoString() string {
	return s.String()
}

type UpdateAutoScalingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAutoScalingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAutoScalingGroupOutput) GoString() string {
	return s.String()
}

const (
	// @enum LifecycleState
	LifecycleStatePending = "Pending"
	// @enum LifecycleState
	LifecycleStatePendingWait = "Pending:Wait"
	// @enum LifecycleState
	LifecycleStatePendingProceed = "Pending:Proceed"
	// @enum LifecycleState
	LifecycleStateQuarantined = "Quarantined"
	// @enum LifecycleState
	LifecycleStateInService = "InService"
	// @enum LifecycleState
	LifecycleStateTerminating = "Terminating"
	// @enum LifecycleState
	LifecycleStateTerminatingWait = "Terminating:Wait"
	// @enum LifecycleState
	LifecycleStateTerminatingProceed = "Terminating:Proceed"
	// @enum LifecycleState
	LifecycleStateTerminated = "Terminated"
	// @enum LifecycleState
	LifecycleStateDetaching = "Detaching"
	// @enum LifecycleState
	LifecycleStateDetached = "Detached"
	// @enum LifecycleState
	LifecycleStateEnteringStandby = "EnteringStandby"
	// @enum LifecycleState
	LifecycleStateStandby = "Standby"
)

const (
	// @enum ScalingActivityStatusCode
	ScalingActivityStatusCodePendingSpotBidPlacement = "PendingSpotBidPlacement"
	// @enum ScalingActivityStatusCode
	ScalingActivityStatusCodeWaitingForSpotInstanceRequestId = "WaitingForSpotInstanceRequestId"
	// @enum ScalingActivityStatusCode
	ScalingActivityStatusCodeWaitingForSpotInstanceId = "WaitingForSpotInstanceId"
	// @enum ScalingActivityStatusCode
	ScalingActivityStatusCodeWaitingForInstanceId = "WaitingForInstanceId"
	// @enum ScalingActivityStatusCode
	ScalingActivityStatusCodePreInService = "PreInService"
	// @enum ScalingActivityStatusCode
	ScalingActivityStatusCodeInProgress = "InProgress"
	// @enum ScalingActivityStatusCode
	ScalingActivityStatusCodeWaitingForElbconnectionDraining = "WaitingForELBConnectionDraining"
	// @enum ScalingActivityStatusCode
	ScalingActivityStatusCodeMidLifecycleAction = "MidLifecycleAction"
	// @enum ScalingActivityStatusCode
	ScalingActivityStatusCodeWaitingForInstanceWarmup = "WaitingForInstanceWarmup"
	// @enum ScalingActivityStatusCode
	ScalingActivityStatusCodeSuccessful = "Successful"
	// @enum ScalingActivityStatusCode
	ScalingActivityStatusCodeFailed = "Failed"
	// @enum ScalingActivityStatusCode
	ScalingActivityStatusCodeCancelled = "Cancelled"
)
