/*
 * **
 * ** Copyright (C) 2001-2005 Fyodor Yarochkin <fygrave@tigerteam.net>,
 * **                    Ofir Arkin       <ofir@sys-security.com>
 * **                    Meder Kydyraliev <meder@o0o.nu>
 * **
 * ** This program is free software; you can redistribute it and/or modify
 * ** it under the terms of the GNU General Public License as published by
 * ** the Free Software Foundation; either version 2 of the License, or
 * ** (at your option) any later version.
 * **
 * **
 * ** This program is distributed in the hope that it will be useful,
 * ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 * ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * ** GNU General Public License for more details.
 * **
 * ** You should have received a copy of the GNU General Public License
 * ** along with this program; if not, write to the Free Software
 * ** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * */
#include "xp_lib.h"

int xp_lib::tokenize(const char *input, char delimiter, vector<string> *tokens) {

	string str(input);
	string::size_type pos, lastpos;

	if (tokens == NULL)
		return FAIL;
	pos = str.find_first_of(delimiter);
	lastpos = str.find_first_not_of(delimiter, 0);

	/* tokenizer */
	while (pos != string::npos && lastpos != string::npos) {
		tokens->push_back(str.substr(lastpos, pos - lastpos));
		lastpos = str.find_first_not_of(delimiter, pos);
		pos = str.find_first_of(delimiter, lastpos);
	}
	if (pos == string::npos && lastpos != string::npos) {
		// handle the last token
		tokens->push_back(str.substr(lastpos, str.size()-lastpos+1));
	}
	return OK;
}

int xp_lib::tokenize(const char *input, char delimiter, vector<int> *tokens) {
	vector <string> str_vector;
	unsigned int ix;
	
	if (tokens != NULL && tokenize(input, delimiter, &str_vector) == OK) {
		for (ix = 0; ix < str_vector.size(); ix++) {
			tokens->push_back(atoi(str_vector[ix].c_str()));
		}
		return OK;
	}
	return FAIL;
}

string xp_lib::int_to_string(int toconvert) {
	char buf[512];
	string retval;
	memset(buf, 0, sizeof(buf));
	snprintf(buf, sizeof(buf), "%d", toconvert);
	retval = buf;
	return retval;
}
