#ifndef UNIVERSAL_REAL_HH
#define UNIVERSAL_REAL_HH

#include <iostream>
#include <warped/SerializedInstance.h>
#include <warped/DeserializerManager.h>
#include "tyvis/VHDLData.hh"
using std::cout;

class AccessVariable;
class UniversalInteger;

struct UniversalReal : public VHDLData {
  friend inline ostream& operator<<(ostream&, const UniversalReal&);

  double val;

  static const UniversalReal &getMax();
  static const UniversalReal &getMin();

  virtual VHDLData::UniversalType getUniversalKind() const{
    return UNIVERSAL_REAL;
  }

  UniversalReal() { val = 0.0; }
  UniversalReal(double d) { val = d;}
  UniversalReal(float f) { val = (double) f;}
  UniversalReal(const UniversalReal& d) : VHDLData() { val = (double) d.val; }
  UniversalReal(int value) { val = value;}
  UniversalReal(char c) { val = c; }
  UniversalReal(bool b) { val = b; }
  UniversalReal(const VHDLData& v);

  VHDLData& operator=(const VHDLData& from) {
    val = (double) ((UniversalReal *) &from)->val;
    return *this;
  }

  UniversalReal& operator=(const UniversalReal& from) {
    val = (double) from.val;
    return *this;
  }

  bool operator==( const RValue &compareTo ) const {
    return val == dynamic_cast<const UniversalReal &>( compareTo.readVal() );
  }

  bool operator!=( const RValue &compareTo ) const {
    return val != dynamic_cast<const UniversalReal &>( compareTo.readVal() );
  }

  bool operator>( const RValue &compareTo ) const{
    return val > dynamic_cast<const UniversalReal &>( compareTo.readVal() );
  }

  bool operator>=( const RValue &compareTo ) const {
    return val >= dynamic_cast<const UniversalReal &>( compareTo.readVal() );
  }

  bool operator<( const RValue &compareTo ) const {
    return val < dynamic_cast<const UniversalReal &>( compareTo.readVal() );
  }

  bool operator<=( const RValue &compareTo ) const {
    return val <= dynamic_cast<const UniversalReal &>( compareTo.readVal() );
  }

  UniversalReal &operator=( double from ){
    val = from;
    return *this;
  }
  
  operator double() const { return val; }
  
  UniversalReal assign(char ch) { 
    val = UniversalReal(ch - '0');
    return val;
  }

  int getIntValue() const { return (int)val; }
  LONG getInt64Value() const { return (LONG)val; }
  double getDoubleValue() const { return val; }
  
  int savantwrite(AccessVariable &) const;
  int savantwrite(AccessType &) const;
  int savantread(AccessVariable &);
  int savantread(AccessType &);
  int savantread(char *) {
    return NORMAL_RETURN;
  }
  int savantwrite( ostringstream &os) const {
    os << this->val;
    return NORMAL_RETURN;
  }
  
  VHDLData* clone() const {
    return new UniversalReal(*this);
  }
  
  int getSize() const { return sizeof(*this); }
  void print(ostream& os = cout) const { os << getDoubleValue(); }

  static UniversalReal typeCast(VHDLData& toCast);

  static const string &getUniversalRealType(){
    static const string universalRealType = "UniversalReal";
    return universalRealType;
  }

  const string &getDataType() const {
    return getUniversalRealType();
  }

  void serialize( SerializedInstance *addTo ) const {
    addTo->addDouble( val );
  }

  static Serializable *deserialize( SerializedInstance *si ){
    return new UniversalReal( si->getDouble() );
  }

  static void registerDeserializer(){
    DeserializerManager::instance()->registerDeserializer( getUniversalRealType(),
							   &UniversalReal::deserialize );
  }

  UniversalReal unaryPlus() const;
  UniversalReal unaryMinus() const;
  UniversalReal abs() const;
  UniversalReal plus( const RValue & ) const;
  UniversalReal minus( const RValue & ) const;
  UniversalReal multiply( const RValue & ) const;
  UniversalReal divide( const RValue & ) const;
  UniversalReal pow( const RValue & ) const;
};


inline ostream& operator<<(ostream& os, const UniversalReal& d) {
  os << d.val;
  return os;
}

#endif
