#ifndef ENUMERATION_TYPE_INFO_HH
#define ENUMERATION_TYPE_INFO_HH

#include "tyvis/TypeInfo.hh"

class EnumerationTypeInfo : public TypeInfo {
public:
  EnumerationTypeInfo();
  EnumerationTypeInfo(int n, char **, int left, ArrayInfo::ArrayDirn_t);
  ~EnumerationTypeInfo();
  EnumerationTypeInfo(const EnumerationTypeInfo& ei);
  char **get_imageMap() const;
  int get_no_of_elements() const;
  int get_left() const;
  int get_right() const;
  ArrayInfo::ArrayDirn_t get_direction() const;
  EnumerationTypeInfo& operator=(const EnumerationTypeInfo &ei);
  TypeInfo &operator=(const TypeInfo &ti) {
    return operator=( static_cast<const EnumerationTypeInfo &>(ti) );
  }

  TypeInfoKind getKind() const {
    return ENUM_INFO;
  }

  int getCharacterOffset() const;
  
  int get_range() const;
  VHDLType* createObject(ObjectBase::ObjectType) const;
  
  bool is_character_type() const;

protected:
  char **imageMap;
  int no_of_elements;
  int left;
  ArrayInfo::ArrayDirn_t dirn;
  
private:
};

#endif
