<?php
/**
 * The Turba script to add a new entry into an address book.
 *
 * $Horde: turba/add.php,v 1.54.4.2 2005/01/27 03:31:58 chuck Exp $
 *
 * Copyright 2000-2005 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (ASL).  If you
 * did not receive this file, see http://www.horde.org/licenses/asl.php.
 */

@define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once TURBA_BASE . '/lib/Renderer.php';
require_once TURBA_BASE . '/lib/ObjectView.php';
require_once TURBA_BASE . '/lib/AbstractObject.php';
require_once 'Horde/Variables.php';
require_once 'Horde/Form.php';
require_once 'Horde/Form/Action.php';

/* Get some variables. */
$vars = &Variables::getDefaultVariables();
$source = $vars->get('source');
$url = $vars->get('url');

/* Get a source or a list of sources. */
$sources = array();
$default_source = $prefs->getValue('default_dir');
foreach ($cfgSources as $key => $curSource) {
    if (empty($curSource['readonly']) || (isset($curSource['admin']) && in_array(Auth::getAuth(), $curSource['admin']))) {
        $sources[$key] = $curSource['title'];
    }
}

/* Exit with an error message if no sources to add to. */
if (empty($sources)) {
    $notification->push(_("There are no writeable address books. None of the available address books are configured to allow you to add new entries to them. If you believe this is an error, please contact your system administrator."), 'horde.error');
    $url = (!empty($url) ? Horde::url($url, true) : Horde::applicationUrl('browse.php', true));
    header('Location: ' . $url);
    exit;
}

/* Set up the form. */
$form = &Horde_Form::singleton('', $vars, _("New Contact"));
$form->setButtons(_("Save"), _("Reset to Defaults"));
$form->addHidden('', 'url', 'text', false);
$form->addHidden('', 'key', 'text', false);

/* Check if a source selection box is required. */
if (count($sources) > 1) {
    /* Multiple sources, show a selection box. */
    $v = &$form->addVariable(_("Choose an address book"), 'source', 'enum', true, false, null, array($sources, true));
    $action = &Horde_Form_Action::factory('submit');
    $v->setAction($action);
    $v->setOption('trackchange', true);
    if (is_null($vars->get('formname')) &&
        $vars->get($v->getVarName()) != $vars->get('__old_'.$v->getVarName())) {
        $notification->push(sprintf(_("Selected address book '%s'."), $sources[$source]), 'horde.message');
    }
    $form->setButtons(_("Add"));
} else {
    /* One source, no selection box but store the value in a hidden field. */
    $form->addHidden('', 'source', 'text', true);
    $source = key($sources);
}

/* A source has been selected, connect and set up the fields. */
if ($source) {
    $driver = &Turba_Driver::singleton($source, $cfgSources[$source]);
    if (is_a($driver, 'PEAR_Error')) {
        $notification->push(sprintf(_("Failed to access the address book: %s"), $driver->getMessage()), 'horde.error');
    } else {
        $object = &new Turba_AbstractObject($driver);
        $view = &new Turba_ObjectView($object);

        /* Get the form and set up the variables. */
        $view->setupForm($form);
        $vars->set('source', $source);
    }
}

/* Validate the form. */
if ($source && $form->validate($vars)) {
    /* Form valid, save data. */
    $form->getInfo($vars, $info);

    $source = $info['source'];
    $object = $info['object'];

    /* Create Contact. */
    $key = $driver->add($object);
    if (!is_a($key, 'PEAR_Error')) {
        $vars->set('key', $key);
        $name = isset($object['name']) ? $object['name'] : _("Address book entry");
        $notification->push(sprintf(_("%s added."), $name), 'horde.success');
        if (empty($info['url'])) {
            $uri = Horde::applicationUrl('display.php', true);
            $uri = Util::addParameter($uri, array('source' => $info['source'], 'key' => $key), null, false);
        } else {
            $uri = $info['url'];
        }
        header('Location: ' . $uri);
        exit;
    }

    Horde::logMessage($key, __FILE__, __LINE__, PEAR_LOG_ERR);
    $notification->push(_("There was an error adding the new contact. Contact your system administrator for further help.") . $key->getMessage(), 'horde.error');
}

$notification->push('var i = 0; while (document.forms[0].elements[i].type == \'hidden\' || document.forms[0].elements[i].disabled) i++; document.forms[0].elements[i].focus();', 'javascript');
$title = _("New Contact");
require TURBA_TEMPLATES . '/common-header.inc';
require TURBA_TEMPLATES . '/menu.inc';

/* Render the form. */
$renderer = &new Turba_Renderer();
$form->renderActive($renderer, $vars, 'add.php', 'post');

require $registry->get('templates', 'horde') . '/common-footer.inc';
