/*
SMS Server Tools
Copyright (C) Stefan Frings

This program is free software unless you got it under another license directly
from the author. You can redistribute it and/or modify it under the terms of
the GNU General Public License as published by the Free Software Foundation.
Either version 2 of the License, or (at your option) any later version.

http://www.meinemullemaus.de/
mailto: smstools@meinemullemaus.de
*/

#ifndef MODEMINIT_H
#define MODEMINIT_H

#include <termios.h>

int modem; // File handle of serial port
int baudrate;
int errorsleeptime;  // Time to wait after ERROR
int rtscts; // 1 enables hardware handshake via RTS/CTS
int quickinit; // 1 makes a quicker initialization.
char device[100]; // Name of serial port
char initstring[100]; // Initialisation string
char modemname[100]; // Name of modem
char smsc[100]; // Number of SMSC
char pin[16]; // PIN for the SIM card
char mode[10]; // Coding mode old, new, ascii, digicom
struct termios oldtio;

// put_command
// Sends a command to the modem and waits max timout*0.1 seconds for an answer.
// The function returns the length of the answer.
// The answer can be Ok, ERROR or expect. After getting the answer the
// functions reads 0.1s more and returns then.
// The command may be empty or NULL. 

int put_command(char* command,char* answer,int max,int timeout,char* expect);

void setmodemparams(); /* setup serial port */

void initmodem();

void openmodem(); // Open the serial port


#endif
