// 
// $Id: qasignalredirect.cpp,v 1.1 2000/06/12 10:53:28 amos-cvs Exp $
//
// Implementation of QaSignalRedirect class
//
// Jan Borsodi <jb@ez.no>
// Created on: <12-Jun-2000 11:13:40 amos>
//
// Copyright (C) Jan Borsodi.  All rights reserved.


#include "qasignalredirect.hpp"
#include <qobject.h>

/*!
  \class QaSignalRedirect qasignalredirect.hpp
  \brief
  \author <a href="mailto:jb@ez.no">Jan Borsodi</a>
  \date Enter current date here

*/

/*!
  Default constructor
*/

QaSignalRedirect::QaSignalRedirect( int id, QObject *parent, const char *name )
    : QObject( parent, name ), ID( id )
{
}

/*!
  Destroys the object
*/

QaSignalRedirect::~QaSignalRedirect()
{
}

/*!
  Returns the ID which this redirector should send.
*/

int QaSignalRedirect::id() const
{
    return ID;
}

/*!
  Sets the ID which this redirector should send.
*/

void QaSignalRedirect::setID( int id )
{
    ID = id;
}

/*!
  Activates the redirector, it will then send a signal with the specified signal.
*/

void QaSignalRedirect::activate()
{
    emit redirect( ID );
}
