import sha

from Ft.Server.Common import ResourceTypes, Schema

from Ft.Server.Server import FtServerServerException, Error

import test_helper
def test_create(tester):


    tester.startTest("Add Alias")

    repo = test_helper.GetRepo(tester)
    doc = repo.fetchResource("/test/doc1")
    alias = doc.addAlias("alias1")

    aMd = alias.getMetaDataResource().getContent()
    aContent = alias.getContent()

    cd,md = test_helper.TestMetaData(tester,
                                     aMd,
                                     'alias1',
                                     ResourceTypes.ResourceType.ALIAS,
                                     [],
                                     tester.test_data['userName'],
                                     'text/xml',
                                     str(len(aContent)),
                                     [],
                                     )

    tester.compare(ALIAS1,aContent)

    test_helper.TestAliasRdf(tester,
                             repo,
                             alias.getAbsolutePath(),
                             len(aContent),
                             tester.test_data['userName'],
                             cd,
                             md,
                             'text/xml',
                             Schema.NULL_DOCDEF,
                             doc.getAbsolutePath())

    tester.compare(ResourceTypes.ResourceType.ALIAS,repo.hasResource("/test/alias1;no-traverse"))
    alias = repo.fetchResource("/test/alias1;no-traverse")
    tester.compare(doc,alias.traverse())
    tester.compare(doc,alias.getReference())
    tester.compare(doc,repo.fetchResource("/test/alias1"))
    repo.txCommit()

    repo = test_helper.GetRepo(tester)
    doc = repo.fetchResource("/test/doc1")
    alias1 = repo.fetchResource("/test/alias1;no-traverse")
    alias2 = alias1.addAlias("alias2")

    tester.compare(doc,alias2.traverse())
    tester.compare(alias1,alias2.getReference())
    tester.compare(doc,repo.fetchResource("/test/alias2"))

    repo.txCommit()

    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource("/test")
    alias3 = test.addAlias("alias3")

    tester.compare(test,alias3.traverse())
    tester.compare(test,alias3.getReference())
    tester.compare(test,repo.fetchResource("/test/alias3"))

    repo.txCommit()

    tester.testDone()

    return




def test_access(tester):

    tester.startTest("Alias Access")

    repo = test_helper.GetRepo(tester)
    alias = repo.fetchResource("/test/alias1;no-traverse")
    doc = repo.fetchResource("/test/doc1")

    tester.compare(ResourceTypes.ResourceType.ALIAS,repo.hasResource("/test/alias1;no-traverse"))
    tester.compare(doc,alias.traverse())
    tester.compare(doc,alias.getReference())
    tester.compare(doc,repo.fetchResource("/test/alias1"))
    repo.txRollback()
    tester.testDone()



def test_delete(tester):

    tester.startTest("Remove Alias")
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    test.removeAlias('alias3')
    tester.compare(0,test.hasResource('/test/alias3;no-traverse'))

    repo.deleteResource('/test/alias1;no-traverse')
    tester.compare(0,repo.hasResource('/test/alias1;no-traverse'))
    repo.txCommit()

    repo = test_helper.GetRepo(tester)
    tester.compare(0,repo.hasResource('/test/alias3;no-traverse'))
    tester.compare(0,repo.hasResource('/test/alias1;no-traverse'))
    tester.compare(0,repo.hasResource('/test/alias3;traverse'))
    tester.compare(0,repo.hasResource('/test/alias1;traverse'))
    tester.testException(repo.fetchResource,('/test/alias2',),FtServerServerException,{'code':Error.UNKNOWN_PATH})
    repo.txRollback()

    tester.testDone()


def test_complex(tester):


    tester.startTest("Complex Alias Creation")

    repo = test_helper.GetRepo(tester)

    c = repo.createContainer('/test/c')
    ca = c.addAlias('/test/ca')

    subc = c.createContainer('subc')
    subca = subc.addAlias('/test/ca/subca')
    subcac = repo.fetchResource('/test/ca/subca')

    doc = subcac.createDocument('/test/ca/subca/doc',DOC1,forcedType=ResourceTypes.ResourceType.XML_DOCUMENT)
    doca = doc.addAlias('/test/ca/subca/doca')

    tester.compare(c,repo.fetchResource("/test/c"))
    tester.compare(ca,repo.fetchResource("/test/ca;no-traverse"))
    tester.compare(c,repo.fetchResource("/test/ca"))

    tester.compare(subc,repo.fetchResource("/test/c/subc"))
    tester.compare(subc,repo.fetchResource("/test/ca/subc"))
    tester.compare(subc,repo.fetchResource("/test/c/subca"))
    tester.compare(subc,repo.fetchResource("/test/ca/subca"))
    tester.compare(subca,repo.fetchResource("/test/c/subca;no-traverse"))
    tester.compare(subca,repo.fetchResource("/test/ca/subca;no-traverse"))

    tester.compare(doc,repo.fetchResource("/test/c/subc/doc"))
    tester.compare(doc,repo.fetchResource("/test/ca/subc/doc"))
    tester.compare(doc,repo.fetchResource("/test/c/subca/doc"))
    tester.compare(doc,repo.fetchResource("/test/ca/subca/doc"))
    tester.compare(doc,repo.fetchResource("/test/c/subc/doca"))
    tester.compare(doc,repo.fetchResource("/test/ca/subc/doca"))
    tester.compare(doc,repo.fetchResource("/test/c/subca/doca"))
    tester.compare(doc,repo.fetchResource("/test/ca/subca/doca"))
    tester.compare(doca,repo.fetchResource("/test/c/subc/doca;no-traverse"))
    tester.compare(doca,repo.fetchResource("/test/ca/subc/doca;no-traverse"))
    tester.compare(doca,repo.fetchResource("/test/c/subca/doca;no-traverse"))
    tester.compare(doca,repo.fetchResource("/test/ca/subca/doca;no-traverse"))
    repo.txCommit()
    tester.testDone()
    return




def cleanup(tester):

    tester.startTest("Clean Up")
    repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        t = repo.fetchResource('/test')
        t.delete()
    repo.createContainer("/test",1)
    repo.createDocument("/test/doc1",DOC1,forcedType=ResourceTypes.ResourceType.XML_DOCUMENT)
    repo.txCommit()
    tester.testDone()


DOC1="""<docelem v='foo'/>"""
ALIAS1="""<ftss:Alias xmlns:ftss="http://xmlns.4suite.org/reserved" reference=\'/test/doc1\'/>"""


def Test(tester):

    cleanup(tester)
    test_create(tester)
    test_access(tester)
    test_complex(tester)
    test_delete(tester)

