#!/usr/bin/env python
########################################################################
# $Header: /var/local/cvsroot/4Suite/setup.py,v 1.30 2005/04/18 05:10:10 uogbuji Exp $
"""
The master installation specification

Copyright 2005 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

# Create a dummy __config__ module to pass some setup-only values
# to the Ft module
import sys, imp

module = sys.modules['Ft.__config__'] = imp.new_module('Ft.__config__')
module.NAME = '4Suite'
module.VERSION = '0.0'
# If we want localizations during setup, we need to set this to the
# directory containing that message catalog hierarchy.
module.LOCALEDIR = None


# Add the structures to the global namespace for exec-ing the package files.
from distutils.core import Extension
from Ft.Lib.DistExt import Structures

structs = {'Extension' : Extension}
for name in Structures.__all__:
    structs[name] = getattr(Structures, name)


# Search out available packages
import os, glob

package_info = {}
for pkgfile in glob.glob(os.path.join('packages', '*.pkg')):
    pkginfo = {}
    execfile(pkgfile, structs, pkginfo)

    name = pkginfo.get('name')
    if not name:
        print "Unnamed package %r, skipped" % pkgfile
    elif package_info.has_key(name):
        print "Duplicate package %r, ignoring %r" % (name, pkgfile)
    else:
        # Remove any pkg-private declarations
        for key in pkginfo.keys():
            if key.startswith('_'):
                del pkginfo[key]

        package_info[name] = pkginfo


# Perform requested setup action(s)
from distutils import core
from Ft.Lib.DistExt import PackageManager, Localization

kwargs = {
    # our Distribution class
    'distclass': PackageManager.PackageManager,

    # PackageManager specific
    'package_info': package_info,
    'package_root': 'Ft',
    'manifest_templates': ['graft packages'],
    'validate_templates': ['prune Ft/Ods',
                           'prune test/Ods',
                           'prune profile/Ods',
                          ],

     # Fields used in package metadata 1.0 (PEP 241 / Python 2.1+):
     'name': '4Suite',
     'version': '1.0b2',
     'description': 'an open-source platform for XML and RDF processing',
     'author': 'Fourthought, Inc.',
     'maintainer': 'Fourthought, Inc.',
     'author_email': '4suite@4suite.org',
     'maintainer_email': '4suite@4suite.org',
     'url': 'http://4suite.org/',
     'license': 'other',
     'long_description': '4Suite is a Python-based toolkit for XML and RDF '
                         'application development. It features a library of '
                         'integrated tools for XML processing, implementing '
                         'open technologies such as DOM, RDF, XSLT, XInclude, '
                         'XPointer, XLink, XPath, XUpdate, RELAX NG, and '
                         'XML/SGML Catalogs. Layered upon this is an XML and '
                         'RDF data repository and server, which supports '
                         'multiple methods of data access, query, indexing, '
                         'transformation, rich linking, and rule processing, '
                         'and provides the data infrastructure of a full '
                         'database system, including transactions, '
                         'concurrency, access control, and management tools.'
                         'It also supports HTTP, RPC, and FTP, plus APIs in '
                         'Python and XSLT.'
                         '\n\n'
                         "4Suite's license_ is based on the ASL_."
                         '\n\n'
                         '.. _license: http://4suite.org/COPYRIGHT\n'
                         '.. _ASL: http://www.apache.org/licenses/LICENSE-1.1\n',
      'platforms': ['POSIX', 'Windows'],
      'keywords': ['Python', 'XML', 'RDF', 'XSLT', 'XPath', 'DOM',
                   'XInclude', 'XPointer', 'XLink', 'XUpdate',
                   'RELAX', 'XML Catalogs',
                   'HTTP', 'FTP', 'SOAP',
                   '4Suite', '4SS',
                   'server', 'repository', 'metadata',
                  ],
    }

addl_kwargs = {
      # Fields added in package metadata 1.1 (PEP 314 / Python 2.3+):
      #'Download-URL': '', # if given, must be specific to this release
      'requires': 'Python (>2.2.1)',
      'provides': ['Ft', 'Ft.Lib', 'Ft.Rdf', 'Ft.Xml', 'Ft.Server'],
      'obsoletes': [],
      'conflicts': ['PyXML (<0.8.4)'],
      'classifiers': [
          'Development Status :: 4 - Beta',
          'License :: Other/Proprietary License',
          'Operating System :: POSIX',
          'Operating System :: Microsoft :: Windows',
          'Programming Language :: Python',
          'Topic :: Software Development :: Libraries :: Application Frameworks',
          'Topic :: Software Development :: Libraries :: Python Modules',
          'Topic :: Text Processing :: Markup :: XML',
          ]
    }

# Py 2.3 docs suggest not assuming anything
if hasattr(core, 'setup_keywords'):
    for key, val in addl_kwargs.items():
        if key in core.setup_keywords:
            kwargs[key] = val

core.setup(**kwargs)
