<?xml version='1.0' encoding='UTF-8'?>
<!DOCTYPE rdf:RDF [
    <!ENTITY rdf 'http://www.w3.org/1999/02/22-rdf-syntax-ns#'>
    <!ENTITY dc 'http://purl.org/dc/elements/1.1/'>
    <!ENTITY xbel 'http://rdfinference.org/schemata/xbel#'>
]>

<!--

  XBEL to RDF converter, specialized for BookerT
  See http://pyxml.sourceforge.net/topics/xbel/

-->

<xsl:transform
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ftss='http://xmlns.4suite.org/reserved'
  xmlns:rdf="&rdf;"
  xmlns:dc="&dc;"
  xmlns:xbel="&xbel;"
  version="1.0"
>

  <xsl:param name='ftss:path'/>

  <xsl:output indent="yes"/>
  <xsl:strip-space elements="*"/>

  <xsl:template match="/">
    <rdf:RDF>
      <xsl:apply-templates/>
    </rdf:RDF>
  </xsl:template>
 
  <xsl:template match="title"/>
  <xsl:template match="desc"/>
  <xsl:template match="info"/>

  <xsl:template match="*">
    <xsl:param name="subjects"/>
    <xsl:apply-templates>
      <xsl:with-param name="subjects" select="$subjects"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template name="node-common">
      <xsl:param name="subjects"/>
      <xsl:if test='@id'>
        <xsl:attribute name='rdf:ID' namespace='&rdf;'/>
      </xsl:if>
      <xsl:if test='title'>
        <dc:title><xsl:value-of select='title'/></dc:title>
      </xsl:if>
      <xsl:if test='desc'>
        <dc:description><xsl:value-of select='desc'/></dc:description>
      </xsl:if>
        <xsl:for-each select="$subjects">
          <dc:subject><xsl:value-of select='.'/></dc:subject>
        </xsl:for-each>
  </xsl:template>

  <xsl:template match="xbel">
    <!-- empty node set trick -->
    <xsl:variable name="subjects" select="/.."/>
    <xbel:collection>
      <xsl:call-template name="node-common">
        <xsl:with-param name="subjects" select="$subjects"/>
      </xsl:call-template>
      <xsl:apply-templates>
        <xsl:with-param name="subjects" select="$subjects"/>
      </xsl:apply-templates>
    </xbel:collection>
  </xsl:template>

  <xsl:template match="folder">
    <xsl:param name="subjects"/>
    <xsl:variable name="new-subjects" select="$subjects|title"/>
    <xsl:apply-templates>
      <xsl:with-param name="subjects" select="$new-subjects"/>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="bookmark">
    <xsl:param name="subjects"/>
    <xbel:contains rdf:parseType='Resource'>
      <xbel:index><xsl:number count='*'/></xbel:index>
      <xbel:item>
        <xbel:bookmark>
          <xsl:call-template name="node-common">
            <xsl:with-param name="subjects" select="$subjects"/>
          </xsl:call-template>
          <xbel:link><xsl:value-of select='@href'/></xbel:link>
        </xbel:bookmark>
      </xbel:item>
    </xbel:contains>
  </xsl:template>

  <ftss:CreationParams FullTextIndex='0' EnforceSchema='0'><ftss:Validator
type='http://schemas.4suite.org/4ss#documentdefinition.no_validation'/></ftss:CreationParams>

</xsl:transform>

