########################################################################
#
# File Name: 	        MetaObject.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/MetaObject.py.html
#
"""
Implements the MetaObject meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

ftods_attributes = ['name', 'comment']

from Ft.Ods.MetaData import RepositoryObject
from Ft.Ods.MetaData import MetaKind
from Ft.Ods.StorageManager.Adapters import Constants

from Ft.Ods.PersistentObject import TupleDefinitions


class MetaObject(RepositoryObject.RepositoryObject):
    def __init__(self, db, data, meta_kind):
        if data is None:
            self.__dict__['name'] = ''
            self.__dict__['comment'] = ''

        RepositoryObject.RepositoryObject.__init__(self, db, data,meta_kind)

    def absolute_name(self):
        p = self.parent()
        if p:
            pas = p.absolute_name()
            if pas:
                pas = pas + '::'
            return pas + self.name
        return self.name

    __str__ = absolute_name

    def parent(self):
        if self.definedIn == None:
            return None
        if self.definedIn.meta_kind == MetaKind.mk_repository:
            
            return None
        return self.definedIn

    #relationship definedIn
    def form_definedIn(self, definedIn, inverse=1):
        from Ft.Ods.MetaData import DefiningScope
        self._4ods_formRelationship('definedIn',DefiningScope.DefiningScope,'defines','add',definedIn,inverse)
        
    def drop_definedIn(self, definedIn, inverse=1):
        self._4ods_dropRelationship('definedIn','defines','remove',definedIn,inverse)




    _tupleNames = (('name',),('comment',),('definedIn',))

    _tupleDefinitions = {'name':{TupleDefinitions.TYPE:Constants.Types.STRING,
                                 },
                         'comment':{TupleDefinitions.TYPE:Constants.Types.STRING,
                                    },
                         'definedIn':{TupleDefinitions.TYPE:Constants.Types.ROBJECT,
                                      TupleDefinitions.READONLY:1,
                                      TupleDefinitions.RELATIONSHIP:1,
                                      }
                         }

    _localExtents = ()
