/**********  Simple input values **********/
%typemap(python, in) GLbyte, GLubyte, GLshort
{
	if (PyInt_Check($input) || PyLong_Check($input))
	{
		$1= ($1_type)(PyInt_AsLong( $input ));
	}
	else if (PyString_Check ($input))
	{
		/* what is a GLshort's size? */
		$1= ($1_type) PyString_AsString($input)[0];
	}
}

%typemap(python, in) GLboolean
{
	$1= (PyObject_IsTrue($input)) ? GL_TRUE : GL_FALSE;
}


%typemap(python, out) const GLubyte*
{
	if ($1) 
	{
	    $result= PyString_FromString($1); 
	}
	else 
	{
	    Py_INCREF($result = Py_None);
	}
}


%typemap(python, in) const void *buffer
{
	int len;
	PyObject* str;
	if ($input == Py_None) 
	{
		$1= NULL; 
	}
	else
	{
		str = PyObject_Str($input);
		PyString_AsStringAndSize(str, (char**)&$1, &len);
		Py_DECREF(str);
	}
}


%typemap(python, out) const wchar_t*
{
	if ($1) 
	{
	    $result = PyUnicode_FromWideChar($1, wcslen($1)); 
	}
	else 
	{
	    Py_INCREF($result= Py_None);
	}
}


%typemap(python,in) PyObject*, void*
{
	$1 = $input;
}

%typemap(python,out) PyObject*, void*
{
	$result= $1;
}

%typemap(python,in) PyObject* pyfunc
{
	if ($input != Py_None && !PyCallable_Check($input))
	{
		PyErr_SetString(PyExc_Exception, "Not callable.");
		return NULL;
	}
	$1 = $input;
}












%typemap(python,ignore) GLenum type_UNSIGNED_BYTE
{
	$1 = GL_UNSIGNED_BYTE;
}

%typemap(python,ignore) GLenum type_BYTE
{
	$1 = GL_BYTE;
}

%typemap(python,ignore) GLenum type_UNSIGNED_SHORT
{
	$1 = GL_UNSIGNED_SHORT;
}

%typemap(python,ignore) GLenum type_SHORT
{
	$1 = GL_SHORT;
}

%typemap(python,ignore) GLenum type_UNSIGNED_INT
{
	$1 = GL_UNSIGNED_INT;
}

%typemap(python,ignore) GLenum type_INT
{
	$1 = GL_INT;
}

%typemap(python,ignore) GLenum type_FLOAT
{
	$1 = GL_FLOAT;
}

%typemap(python,ignore) GLenum type_DOUBLE
{
	$1 = GL_DOUBLE;
}

%typemap(python,ignore) GLsizei stride_0, GLint stride_0, GLint ustride_0, GLint vstride_0
{
	$1 = 0;
}

