/*
 * statusdlg.cpp - dialogs for setting and reading status messages
 * Copyright (C) 2001, 2002  Justin Karneges
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include"statusdlg.h"

#include<qpushbutton.h>
#include<qlayout.h>
#include<qlabel.h>
#include<qcombobox.h>
#include<qinputdialog.h>
#include<qcheckbox.h>
#include"psicon.h"
#include"psiaccount.h"
#include"userlist.h"
#include"common.h"
#include"msgmle.h"


//----------------------------------------------------------------------------
// StatusShowDlg
//----------------------------------------------------------------------------
StatusShowDlg::StatusShowDlg(const UserListItem &u)
:QDialog(0, 0, false, WDestructiveClose)
{
	// build the dialog
	QVBoxLayout *vb = new QVBoxLayout(this, 8);
	PsiTextView *te = new PsiTextView(this);
	vb->addWidget(te);
	QHBoxLayout *hb = new QHBoxLayout(vb);
	QPushButton *pb = new QPushButton(tr("&Close"), this);
	connect(pb, SIGNAL(clicked()), SLOT(close()));
	hb->addStretch(1);
	hb->addWidget(pb);
	hb->addStretch(1);

	// set the rest up
	te->setReadOnly(true);
	te->setTextFormat(RichText);
	te->setText(u.makeDesc());

	setCaption(tr("Status for %1").arg(jidnick(u.jid().full(), u.name())));
	resize(400,240);

	pb->setFocus();
}


//----------------------------------------------------------------------------
// StatusSetDlg
//----------------------------------------------------------------------------
static int combomap[7] = { STATUS_CHAT, STATUS_ONLINE, STATUS_AWAY, STATUS_XA, STATUS_DND, STATUS_INVISIBLE, STATUS_OFFLINE };

class StatusSetDlg::Private
{
public:
	Private() {}

	PsiCon *psi;
	PsiAccount *pa;
	Status s;
	ChatView *te;
	QComboBox *cb_type, *cb_preset;
	QCheckBox *save;
};

StatusSetDlg::StatusSetDlg(PsiCon *psi, const Status &s)
:QDialog(0, 0, false, WDestructiveClose)
{
	d = new Private;
	d->psi = psi;
	d->pa = 0;
	d->psi->dialogRegister(this);
	d->s = s;

	setCaption(CAP(tr("Set Status: All accounts")));
	init();
}

StatusSetDlg::StatusSetDlg(PsiAccount *pa, const Status &s)
:QDialog(0, 0, false, WDestructiveClose)
{
	d = new Private;
	d->psi = 0;
	d->pa = pa;
	d->pa->dialogRegister(this);
	d->s = s;

	setCaption(CAP(tr("Set Status: %1").arg(d->pa->name())));
	init();
}

void StatusSetDlg::init()
{
	int type = makeSTATUS(d->s);

	// build the dialog
	QVBoxLayout *vb = new QVBoxLayout(this, 8);
	QHBoxLayout *hb1 = new QHBoxLayout(vb);

	QLabel *l;
	l = new QLabel(tr("Status:"), this);
	hb1->addWidget(l);
	d->cb_type = new QComboBox(this);
	int n;
	for(n = 0; n < 7; ++n)
		d->cb_type->insertItem(status2txt(combomap[n]));
	for(n = 0; n < 7; ++n) {
		if(type == combomap[n]) {
			d->cb_type->setCurrentItem(n);
			break;
		}
	}
	hb1->addWidget(d->cb_type,1);
	l = new QLabel(tr("Preset:"), this);
	hb1->addWidget(l);
	d->cb_preset = new QComboBox(this);
	d->cb_preset->insertItem(tr("<None>"));
	QStringList presets=option.sp.varsToStringList();
	presets.sort();
	d->cb_preset->insertStringList(presets);
	connect(d->cb_preset, SIGNAL(highlighted(int)), SLOT(chooseStatusPreset(int)));
	hb1->addWidget(d->cb_preset,1);

	d->te = new ChatView(this);
	d->te->setReadOnly(false);
	d->te->setTextFormat(PlainText);
	d->te->setMinimumHeight(50);
	vb->addWidget(d->te);
	QHBoxLayout *hb = new QHBoxLayout(vb);
	QPushButton *pb1 = new QPushButton(tr("&Set"), this);
	QPushButton *pb2 = new QPushButton(tr("&Cancel"), this);
	d->save = new QCheckBox(this);
	d->save->setText(tr("Sa&ve as Preset"));
	d->save->setChecked(false);
	hb->addWidget(pb1);
	hb->addStretch(1);
	hb->addWidget(d->save);
	hb->addStretch(1);
	hb->addWidget(pb2);

	// set the rest up
	d->te->setTextFormat(PlainText);
	d->te->setText(d->s.status());
	d->te->selectAll();
	connect(pb1, SIGNAL(clicked()), SLOT(doButton()));
	connect(pb2, SIGNAL(clicked()), SLOT(cancel()));
	d->te->setFocus();

	resize(400,240);
}

StatusSetDlg::~StatusSetDlg()
{
	if(d->psi)
		d->psi->dialogUnregister(this);
	else if(d->pa)
		d->pa->dialogUnregister(this);
	delete d;
}

void StatusSetDlg::keyPressEvent(QKeyEvent *e)
{
	if(e->key() == Key_Escape)
		close();
	else if(e->key() == Key_Return && ((e->state() & ControlButton) || (e->state() & AltButton)) )
		doButton();
	else
		e->ignore();
}

void StatusSetDlg::doButton()
{
	// Save preset
	if (d->save->isChecked()) {
		QString text;
		while(1) {
			// Get preset
			bool ok = FALSE;
			text = QInputDialog::getText(
				CAP(tr("New Status Preset")),
					tr("Please enter a name for the new status preset:"),
					QLineEdit::Normal, text, &ok, this);
			if (!ok)
				return;
			
			// Check preset name
			if (text.isEmpty()) {
				QMessageBox::information(this, tr("Error"), 
					tr("Can't create a blank preset!"));
			}
			else if(option.sp.findByKey(text) != option.sp.end()) {
				QMessageBox::information(this, tr("Error"), 
					tr("You already have a preset with that name!"));
			}
			else 
				break;
		}
		// Store preset
		option.sp.set(text,d->te->text());
	} 

	// Set status
	int type = combomap[d->cb_type->currentItem()];
	QString str = d->te->text();

	set(makeStatus(type, str));
	close();
}

void StatusSetDlg::chooseStatusPreset(int x)
{
	if(x < 1)
		return;

	d->te->setText(option.sp.get(d->cb_preset->text(x)));
}

void StatusSetDlg::cancel()
{
	emit cancelled();
	close();
}

void StatusSetDlg::reject()
{
	cancel();
	QDialog::reject();
}
