#TRUSTED aa0951c5d647926b616d4007984e90f939b8317c5f02f7c73a2a6af6cd1f24633954ea1090ea7e7d18d28b38f486806f643406ed7ab65d81a418e75b9a2de6bbe85d99ccce2caceefacc3efaf763065eb5a1a21b2176a3290ca1cd5ac11123709bb17d980b56b725f1c083f4698ddd7acac85211802ba042c91c91cd0600a3fea2b1c9092c61fe0d5b35a998f1f58584839ba9db8c9a3295c17eae8745b263518b3293116e2351e645dde489c50e8c0428de4232be917667e06ce11aee6b5b85b712597e892ebf9a05b6108451bd72007f1430ef52d2fff12625ce747530675712a3c0547f0e657108b6dfc0bdd71486c39e61fdef5a934fe976a718dcad347901269bb823ceca33e6f272af6a68e2f40c19b2e36322ae1f61fcbb0f8799c9dda7c7e825936b98aee48eb992cf40d5296f0312771dad93978bc42388f1b36f95601d4c6f0af1d881ebda0ce90f78797bac20982801c39c4462ecf083c074d89ffa9cb82c9cfccbe03758e37ca720f346659ca806822bbed25db7917ebd4881fc9e1b39d2b2bf0f07204798d34e7db44433c368e9dd761361721b47e59549e60db0bf0bb05b869ed2b399836412cd8365f6a7a398e43143f8da7dd776b96178c50b80e303ab54b878e20962117800354351fad992bfd049984969c79b990756d4700d0267e8172f789bc860c5a5cadf760635f745e90a34f116eb0fbc89932057
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15880);
 script_version ("1.1");
 name["english"] = "Hydra: PCNFS";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find PCNFS accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force PCNFS authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_udp_ports(640);
 script_dependencies("hydra_options.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = 640;
if (! get_udp_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "pcnfs";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*)? password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/pcnfs/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following PC-NFS accounts:\n' + report);
