/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.connector.rmi.jrmp;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;

import javax.management.NotificationListener;

import mx4j.tools.connector.rmi.RemoteNotificationListenerSupport;

/**
 *
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.1 $
 */
public class JRMPRemoteNotificationListenerSupport extends RemoteNotificationListenerSupport
{
	public JRMPRemoteNotificationListenerSupport(NotificationListener clientListener)
	{
		super(clientListener);
	}

	public void export() throws RemoteException
	{
		UnicastRemoteObject.exportObject(getRemoteNotificationListener());
	}

	public void export(int port) throws RemoteException
	{
		UnicastRemoteObject.exportObject(getRemoteNotificationListener(), port);
	}

	public void export(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException
	{
		UnicastRemoteObject.exportObject(getRemoteNotificationListener(), port, csf, ssf);
	}

	public void unexport() throws NoSuchObjectException
	{
		UnicastRemoteObject.unexportObject(getRemoteNotificationListener(), true);
	}
}
