/*
 *  Copyright (C) MX4J.
 *  All rights reserved.
 *
 *  This software is distributed under the terms of the MX4J License version 1.0.
 *  See the terms of the MX4J License in the documentation provided with this software.
 */
package mx4j.tools.adaptor.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.management.JMException;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * EmptyCommandProcessor, returns an empty xml tree
 *
 * @author    <a href="mailto:tibu@users.sourceforge.net">Carlos Quiroz</a>
 * @version   $Revision: 1.1 $
 */
public class EmptyCommandProcessor extends HttpCommandProcessorAdaptor
{

	/**
	 * Constructs a new EmptyCommandProcessor
	 *
	 */
	public EmptyCommandProcessor()
	{
	}


	public Document executeRequest(HttpInputStream in)
		throws IOException, JMException
	{
		Document document = builder.newDocument();

		Element root = document.createElement("empty");
		document.appendChild(root);

		return document;
	}

}

