#line 2 "debug.c"
/*-
 * C-SaCzech
 * Copyright (c) 1996-2002 Jaromir Dolecek <dolecek@ics.muni.cz>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Jaromir Dolecek
 *	for the CSacek project.
 * 4. The name of Jaromir Dolecek may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY JAROMIR DOLECEK ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL JAROMIR DOLECEK BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: debug.c,v 1.42 2002/02/03 11:13:41 dolecek Exp $ */

#include "csacek.h"

#ifdef CSA_DEBUG

#ifdef __MSWIN__
int csa_debug_uniqid=0;
#endif

#ifdef CSA_THREADSAFE
csa_mutex *csa_debuglog_mutex;
#endif

static int debug_no=0;		/* debug log number */

/* initialize debugfd and a few other needed things */
FILE *
csa_debug_start()
{
   const char *prefix, *suffix;
   char buf[2048];
   FILE *dd;
   int debug_num;
   int num;

   prefix = getenv("TEMP");
   if (!prefix) {
	prefix = getenv("TMP");
   	if (!prefix) {
#ifdef __MSWIN__
   		prefix = "C:\\";
#else
   		prefix = "/tmp";
#endif
	}
   }

#ifdef __MSWIN__
   suffix = ".csa";
   /* see csa_init_compat() for why we use this instead of getpid()
    * under MS Windows */
   num = csa_debug_uniqid;
#else
   suffix = "";
   num = (int) getpid();
#endif

   csa_acquire_mutex(csa_debuglog_mutex);
   debug_num = debug_no++;
   csa_release_mutex(csa_debuglog_mutex);
   
   sprintf(buf, "%s/csacek_debug_%d_%d%s", prefix, num, debug_num,
		suffix);

   dd = fopen(buf, "wb");
   if (dd) {
   	/* do NOT buffer debug log  - program can crash any time */
#ifndef SETVBUF_REVERSED
	setvbuf(dd, NULL, _IONBF, 0 ); /* "normal" form */
#else
	setvbuf(dd, _IONBF, NULL, 0 ); /* reversed form */
#endif

	csa_debug(dd, "--- BEGIN DEBUG LOG ---");
   }

   return dd;
}
	
/*
 * write a message to debug log
 */
void 
#ifdef __ANSI_C__
csa_debug(FILE *dbg, const char *fmt, ...)
#else
csa_debug(dbg, fmt /*, ... */)
  FILE *dbg;
  const char *fmt;
#endif /* __ANSI_C__ */
{
  va_list arg;

  fputs("DEBUG: ", dbg);
  va_start(arg, fmt);
#ifndef __ANSI_C__
  fmt = va_arg(arg, char *);
#endif
  vfprintf(dbg, fmt, arg);
  va_end(arg);
  fputs("\n", dbg);
}

void 
csa_debug_end(dbg)
  FILE *dbg;
{
	csa_debug(dbg, "--- END DEBUG LOG ---");
	fclose(dbg);
}

static void x_debug_end __P((void *));
static void x_debug_child_end __P((void *));

static void
x_debug_end(dbg)
  void * dbg;
{
	csa_debug_end((FILE *)dbg);
}

static void
x_debug_child_end(dbg)
  void *dbg;
{
	/*
	 * If the dbg stream would be buffered, this would
	 * probably cause that some data would be duplicated
	 * on child cleanup in debug log (the underlying buffer
	 * would be flushed in parent and in child as well),
	 * but since it's NOT buffered, there is no problem.
	 */
	fclose((FILE *)dbg);
}

/* schedules closing of the debug log file upon the pool destroy */
void csa_debug_register_cleanup(wpool, dbg)
  struct pool *wpool;
  FILE *dbg;
{
	ap_register_cleanup(wpool, (void *)dbg, x_debug_end,
		x_debug_child_end);
}
#endif /* CSA_DEBUG */
