/* vim:tabstop=4:expandtab:shiftwidth=4
 * 
 * Idesk -- XShadowImage.cpp
 *
 * Copyright (c) 2002, Chris (nikon) (nikon@sc.rr.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *      Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *      
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *      
 *      Neither the name of the <ORGANIZATION> nor the names of its
 *      contributors may be used to endorse or promote products derived from
 *      this software without specific prior written permission.
 *
 * (See the included file COPYING / BSD )
 */

#include "XShadowImage.h"
#include "XIconWithShadow.h"

XShadowImage::XShadowImage(AbstractContainer * c, AbstractIcon * iParent,
                           AbstractConfig * con, AbstractIconConfig * iConfig)
                            : XIdeskImage(c, iParent, con, iConfig)
{
}

void XShadowImage::refreshIcon()
{
    XIconWithShadow * sIcon = dynamic_cast<XIconWithShadow *>(iconParent);

    x = sIcon->getShadowX();
    y = sIcon->getShadowY();

}

void XShadowImage::configure()
{
    DesktopIconConfig * dIconConfig =
        dynamic_cast<DesktopIconConfig *>(iconConfig);
    
    transparency = dIconConfig->getSnapShadowTrans();

    if (transparency == -1 )
        transparency = 200; //default value
}

void XShadowImage::renderShadowToImage(Pixmap &buffer, int fX, int fY)
{
    XIconWithShadow * sIcon = dynamic_cast<XIconWithShadow *>(iconParent);
    XDesktopContainer * xContainer =
        dynamic_cast<XDesktopContainer *>(container);

    //sIcon->snapShadow();

    x = sIcon->getShadowX();
    y = sIcon->getShadowY();

    ImlibImage *background;
    unsigned char *bgRgb;

    background = Imlib_crop_and_clone_image(imlibData, spareRoot, x, y, width, height );
    bgRgb = background->rgb_data;

    applyMouseOverEffects(background, bgRgb);
    
    ImlibColor IClr={255,0,255,0};
    Imlib_set_image_shape(imlibData, background, &IClr);
    
    int xCord = x - fX;
    int yCord = y - fY;
    
    Imlib_paste_image(imlibData, background, buffer, xCord, yCord,
                      width, height);
    
    Imlib_kill_image(imlibData, background );
}
