/*Written with Emacs.*/
/*
  GtkDiskFree shows free space on your mounted partitions.  Copyright
  (C) 2001-2002 Dj-Death (Landwerlin Lionel)
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA */

#define COLOR_MAX  65535
#define COLOR_MIN  0
#define COLOR_MED  32768

#define KBLOCK     1024.0

#define ULONG(arg) ((gulong)arg)

/* On some OS like Linux or Solaris, we need to know the name of files
   which contain list of mounted and not mounted filesystems to get
   informations about it. Note that most of *BSD do not use file to
   store list of mounted fs. */
#if defined  __LINUX__ || defined __SOLARIS4__ 
# define MTAB_FILESYSTEMS "/etc/mtab"
# define FSTAB_FILESYSTEMS "/etc/fstab"
#endif

#ifdef __SOLARIS5__
# define MTAB_FILESYSTEMS         "/etc/mnttab"
# define FSTAB_FILESYSTEMS        "/etc/vfstab"
#endif

#define FILESYSTEM(arg) ((filesystem_t *)arg)

typedef struct
{
	/* Informations */
	gint new;
	gint mounted;
	gint real;
	gint need_update;
	
	/* Refer to an exitant line if exist */
	GtkTreePath *path;
	
	/* Size, free, used */
	gulong size;
	gulong used;
	gulong free;
	/* percent */
	gint pused;
	gint pfree;
	
	/* Displayed strings */
	gchar *fs_name;
	gchar *fs_mntpt;
	gchar *fs_options;
	gchar *fs_type;
	gchar *fs_size;
	gchar *fs_used;
	gchar *fs_free;
	gchar *fs_pused;
	gchar *fs_pfree;
	
	/* Pixbuf */
	GdkPixbuf *pixbuf;
} filesystem_t;

filesystem_t *filesystem_new (gint stat);
void filesystem_free (filesystem_t *fs);


gboolean gui_list_set_line_unremovable (GtkTreePath *path, gint val);
void gui_list_set_lines_removable (void);
void gui_list_remove_old_lines (void);
gboolean gui_list_check_cell_chars (GtkTreeIter *iter, gint column, gchar *text);
gboolean gui_list_check_cell_long (GtkTreeIter *iter, gint column, glong value);
gboolean gui_list_check_cell_int (GtkTreeIter *iter, gint column, gint value);
GtkTreePath *gui_list_find_row (gchar *mount_point);
gint gui_list_row_needs_update (filesystem_t *fs);
void gui_list_update (order_t action, filesystem_t *fs, GtkTreeIter *riter);
void gui_list_pre_update (filesystem_t *fs);
gboolean gui_list_main_update (GtkTreeView *);

void list_make_pixmap (filesystem_t *fs);
gint list_filesystem_percent (gulong all, gulong value);
gchar *list_filesystem_size (gulong value);
void list_filesystem_info (filesystem_t *fs);
filesystem_t *list_search (GList *list, gchar *text);
GList *list_filesystems_not_mounted (void);
GList *list_filesystems_mounted (void);
GList *list_filesystems_merge (GList *l1, GList *l2);
filesystem_t*list_total_filesystems (GList *list);
void list_filesystems (void);
