# postgres.pl - part of dbengine
# see closer information at http://www.cis-computer.com/dbengine
#
# Version 1.1 <c> 2001
# Ingo Ciechowski		ic	<ciechowski@cis-computer.com>
#


sub db_connect2database {
	$descdb		=~ s/\/(\w+)//;
	$dbdesc		=~ s/\/(\w+)//;
	$uniqOID	= "oid";
	$host		= ";host=$server" if($server ne "localhost" && length($server)>0);

	#
	# contact our database server to connect to the database with our data and die properly if this attempt fails...
	$dbase  = $defdb unless $dbase;
	$dbconn=DBI->connect("dbi:Pg:dbname=$dbase;port=$port".$host,"$user","$passwd");
	&connError("could not connect to $dbase on server $server port $port *** try $scriptname?dbase='aValidDatabaseName' ***");

	#
	# contact our databse to connect to the database with additional display information
	# if we can't contact this database we'll have to die :-((
	if($dbdesc) {
		$dbdconn=DBI->connect("dbi:Pg:dbname=$dbdesc;port=$port".$host,"$user","$passwd");
		&connError("could not connect to $dbdesc on server $server port $port *** try $scriptname?dbdesc='aValidDatabaseName' ***");

	#
	# if there was no additional name specified we try to access the default $descdb database,
	# but if that fails we simply assume that our user wants to store this information in the same database
	} else {
		$dbdconn=DBI->connect("dbi:Pg:dbname=$descdb;port=$port".$host,"$user", "$passwd");
 		$dbdconn=$dbconn unless (defined($dbdconn));
		$dbdesc	= $descdb;
	}
}


sub db_getUniqOIDField {
	return $uniqOID	= "oid";
}


sub db_isView {
	#
	# returns 1 if the given table is a view,
	# i.e. read-only
	my ($name)	= @_;
	my ($isView)	= 0;

	my $cmd	= "select definition from pg_views where viewname = '$name'";
	my $result = $dbdconn->prepare($cmd);
	$result->execute || $log->debug("Could not view definition. SQL Error:$DBI::errstr");
	my $isView = 1 if($result->rows > 0);

 	return $isView;
} # db_isView



sub db_initVars {
	$dbVar{'childRM'}	= "removeChildOnParentDelete='t'";
	$dbVar{'offset'}	= 0;
}




sub db_getDbaseFieldTypes {
	#
	# we request a list of all fieldnames, types and displayinfos for $table
	# the result then is stored in the ass. arrays %fieldtype, %fieldlength,
	# %fielddisplay, %fielddispstring, %fielddisporder, %fielddispcolumn, %fielddefault and %fieldeval
	# %fieldtype	= %fieldlength  = %fielddisplay =   %fielddispstring	=   %fielddisporder =   %fielddispcolumn	=   %fielddefault   =   %fieldeval  = undef;
	$comm  = "SELECT a.attname, t.typname, a.attlen, a.atttypmod FROM pg_class c, pg_attribute a, pg_type t  WHERE c.relname = \'$table\'";
	$comm .= " and a.attnum > 0 and a.attrelid = c.oid and a.atttypid = t.oid";
	$fieldresult=$dbconn->prepare($comm);	#rl
	$fieldresult->execute;			#rl


	#
	# lets build our ass. arrays now
	while(@array = $fieldresult->fetchrow_array()) {
		$fieldtype{$array[0]}   = $array[1];	#rl 
		$fieldlength{$array[0]} = $array[2];	#rl
		$fieldlength{$array[0]} = $array[3]-4 if($fieldtype{$array[0]} eq "bpchar") ;
	}
	&dBaseError($fieldresult, $comm."  (".$fieldresult->rows()." rows found)") if($fieldresult->rows() == 0);
	$fieldresult->execute;

	while(@row = $fieldresult->fetchrow_array) {
		push @fieldnames, $row[0];
	}
} # getDbaseFieldTypes


1;
