#
# <c> 1999 Rudolf Lippan <rlippan@elastic.com>
# wrapper package for Sys:Syslog
#
# Modified - WLM 01/05/30: Add support for Windows platforms by checking os type
# before loading Sys::Syslog module which doesn't exist on Win32 and adding test
# conditions to all calls to this module.

package LOG;

use strict;
use Carp;
use vars	'$os_win';
BEGIN
{
	$os_win = ($^O =~ /win/i);
	unless ($os_win) {
		require Sys::Syslog;
		Sys::Syslog->import;
	}
}

sub _get_caller_info ();

sub new {
	my $self={};
	my $classname=shift;
	openlog($0, '', 'local2') unless ($os_win);
	bless ($self,$classname);
	return $self;
}

sub debug {
	my $str=_get_caller_info;
	syslog("debug", "DEBUG: $str $_[1]") unless ($os_win);
	carp ("DEBUG:$_[1]");
}

sub error {
	my $str=_get_caller_info;
	syslog("err", "ERROR: $str $_[1]") unless ($os_win);
	croak ("ERROR:$_[1]");
}

sub info {
	my $str=_get_caller_info;
	syslog("info", "INFO: $str $_[1]") unless ($os_win);
	carp ("INFO:$_[1]");
}


sub warn {
	my $str=_get_caller_info;
	syslog("warning", "WARNING: $str $_[1]") unless ($os_win);
	carp ("WARNING:$_[1]");
}

sub design {
	if ($VBN::ProductionLoad) {	
		my $str=_get_caller_info; 
		syslog("info", "DESIGN NOTE INFO: $str $_[1]") unless ($os_win);
		carp ("INFO:$_[1]");
	}
}

sub _get_caller_info () {
	my ($package, $name, $line, $sub)=caller(1);
	$sub=(caller(2))[3]  if ((caller(2))[3]) ;
	my $asdf= $sub =~ /main::(.*)/ if $sub;
	my $originator=$1 || "none?";
	my $info_str="Subroutine:$originator, at line:$line";
	return $info_str;
}

sub test { 
	my $info_str=_get_caller_info;
	print("info", "DESIGN NOTE INFO:$info_str $_[1]\n");
}


1;

