#include <bakery/App/Dialog_OverwriteFile.h>
#include <gtkmm/box.h>
#include <libintl.h>

namespace Bakery
{


Dialog_OverwriteFile::Dialog_OverwriteFile(const Glib::ustring& filepath)
: Gtk::MessageDialog(gettext("Do you want to overwrite the existing file?\n\nDocument:\n") + filepath, false /* no markup */, Gtk::MESSAGE_QUESTION, Gtk::BUTTONS_NONE)
{
  set_title(gettext("Overwrite File?"));

  add_button(gettext("Overwrite"), BUTTON_Overwrite);
  add_button(gettext("Choose New FileName"), BUTTON_ChooseNewFilename);
}

Dialog_OverwriteFile::~Dialog_OverwriteFile()
{

}


} //namespace
