/*
 * $Header: /home/cvs/jakarta-struts/src/share/org/apache/struts/taglib/tiles/GetTag.java,v 1.6 2004/03/14 06:23:49 sraeburn Exp $
 * $Revision: 1.6 $
 * $Date: 2004/03/14 06:23:49 $
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.struts.taglib.tiles;

/**
 * This is the tag handler for &lt;tiles:get&gt;, which gets
 * content from the request scope and either includes the content or prints
 * it, depending upon the value of the content's <code>direct</code> attribute.
 *
 * This tag is intended to be compatible with the same tag from Templates (David Geary).
 * Implementation extends InsertTag for facility (no so well).
 * The only difference is the default value of attribute 'ignore', which is <code>true</code>
 * for this tag (default behavior of David Geary's templates).
 */
public class GetTag extends InsertTag {


    /**
     * Constructor.
     * Set default value for 'isErrorIgnored' to <code>true</code>.
     */
    public GetTag() {
        isErrorIgnored = true;
    }

    /**
     * Release all allocated resources.
     */
    public void release() {

        super.release();
        isErrorIgnored = true;
    }


}
