/* *******************************************************************
 * Copyright (c) 2002 Palo Alto Research Center, Incorporated (PARC).
 * All rights reserved. 
 * This program and the accompanying materials are made available 
 * under the terms of the Common Public License v1.0 
 * which accompanies this distribution and is available at 
 * http://www.eclipse.org/legal/cpl-v10.html 
 *  
 * Contributors: 
 *     PARC     initial implementation 
 * ******************************************************************/


package org.aspectj.weaver.patterns;

import org.aspectj.weaver.patterns.*;

import junit.framework.TestCase;

/**
 * @author hugunin
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class NamePatternParserTestCase extends TestCase {		
	/**
	 * Constructor for PatternTestCase.
	 * @param name
	 */
	public NamePatternParserTestCase(String name) {
		super(name);
	}
	
	public void testMatch() {
		checkMatch(NamePatternTestCase.matchAll);
		checkMatch(NamePatternTestCase.match1);
		checkMatch(NamePatternTestCase.match2);
		
		
		NamePattern p = new PatternParser("abc *").parseNamePattern();
		assertEquals(new NamePattern("abc"), p);
	}

	/**
	 * Method checkMatch.
	 * @param string
	 * @param matchAll
	 * @param b
	 */
	private void checkMatch(String[] patterns) {
		for (int i=0, len=patterns.length; i < len; i++) {
			String pattern = patterns[i];
			ITokenSource tokenSource = BasicTokenSource.makeTokenSource(pattern);
			NamePattern p1 = new PatternParser(tokenSource).parseNamePattern();
			NamePattern p2 = new NamePattern(pattern);
			assertEquals("pattern: " + pattern, p2, p1);
		    assertEquals("eof", IToken.EOF, tokenSource.next());
		}
	}
}
