/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.ObjectValue;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.NodeInfo;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.SAXException;

public abstract class NodeSetValue
extends Value {
    public Value evaluate(Context context) throws SAXException {
        this.sort();
        return this;
    }

    public NodeSetValue evaluateAsNodeSet(Context context) throws SAXException {
        this.sort();
        return this;
    }

    public abstract NodeEnumeration enumerate() throws SAXException;

    public NodeEnumeration enumerate(Context context) throws SAXException {
        return this.enumerate();
    }

    public abstract void setSorted(boolean var1);

    public abstract boolean isSorted() throws SAXException;

    public abstract String asString() throws SAXException;

    public double asNumber() throws SAXException {
        return new StringValue(this.asString()).asNumber();
    }

    public boolean asBoolean() throws SAXException {
        return !this.isEmpty();
    }

    public abstract int getCount() throws SAXException;

    public abstract boolean isEmpty() throws SAXException;

    public boolean isSingular() throws SAXException {
        return this.getCount() == 1;
    }

    public abstract boolean contains(NodeInfo var1) throws SAXException;

    public abstract Vector getVector() throws SAXException;

    public abstract NodeInfo[] getNodes() throws SAXException;

    public abstract NodeSetValue sort() throws SAXException;

    public abstract NodeInfo getFirst() throws SAXException;

    public boolean equals(Value value) throws SAXException {
        if (value instanceof NodeSetValue) {
            NodeEnumeration nodeEnumeration = this.enumerate();
            NodeEnumeration nodeEnumeration2 = ((NodeSetValue)value).enumerate();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            while (nodeEnumeration.hasMoreElements()) {
                hashtable.put(nodeEnumeration.nextElement().getValue(), "x");
            }
            while (nodeEnumeration2.hasMoreElements()) {
                if (hashtable.get(nodeEnumeration2.nextElement().getValue()) == null) continue;
                return true;
            }
            return false;
        }
        if (value instanceof NumericValue) {
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = nodeEnumeration.nextElement();
                if (Value.stringToNumber(nodeInfo.getValue()) != value.asNumber()) continue;
                return true;
            }
            return false;
        }
        if (value instanceof StringValue) {
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = nodeEnumeration.nextElement();
                if (!nodeInfo.getValue().equals(value.asString())) continue;
                return true;
            }
            return false;
        }
        if (value instanceof BooleanValue) {
            return this.asBoolean() == value.asBoolean();
        }
        if (value instanceof FragmentValue || value instanceof ObjectValue) {
            return this.equals(new StringValue(value.asString()));
        }
        throw new SAXException("Unknown data type in a relational expression");
    }

    public boolean notEquals(Value value) throws SAXException {
        if (value instanceof NodeSetValue) {
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                String string = nodeEnumeration.nextElement().getValue();
                NodeEnumeration nodeEnumeration2 = ((NodeSetValue)value).enumerate();
                while (nodeEnumeration2.hasMoreElements()) {
                    String string2 = nodeEnumeration2.nextElement().getValue();
                    if (string.equals(string2)) continue;
                    return true;
                }
            }
            return false;
        }
        if (value instanceof NumericValue) {
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = nodeEnumeration.nextElement();
                if (Value.stringToNumber(nodeInfo.getValue()) == value.asNumber()) continue;
                return true;
            }
            return false;
        }
        if (value instanceof StringValue) {
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = nodeEnumeration.nextElement();
                if (nodeInfo.getValue().equals(value.asString())) continue;
                return true;
            }
            return false;
        }
        if (value instanceof BooleanValue) {
            return this.asBoolean() != value.asBoolean();
        }
        if (value instanceof FragmentValue || value instanceof ObjectValue) {
            return this.notEquals(new StringValue(value.asString()));
        }
        throw new SAXException("Unknown data type in a relational expression");
    }

    public boolean compare(int n, Value value) throws SAXException {
        if (n == 11) {
            return this.equals(value);
        }
        if (n == 34) {
            return this.notEquals(value);
        }
        if (value instanceof NodeSetValue) {
            double d;
            double d2 = Double.NEGATIVE_INFINITY;
            double d3 = Double.POSITIVE_INFINITY;
            boolean bl = true;
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                d = Value.stringToNumber(nodeEnumeration.nextElement().getValue());
                if (d < d3) {
                    d3 = d;
                }
                if (d > d2) {
                    d2 = d;
                }
                bl = false;
            }
            if (bl) {
                return false;
            }
            d = Double.NEGATIVE_INFINITY;
            double d4 = Double.POSITIVE_INFINITY;
            boolean bl2 = true;
            NodeEnumeration nodeEnumeration2 = ((NodeSetValue)value).enumerate();
            while (nodeEnumeration2.hasMoreElements()) {
                double d5 = Value.stringToNumber(nodeEnumeration2.nextElement().getValue());
                if (d5 < d4) {
                    d4 = d5;
                }
                if (d5 > d) {
                    d = d5;
                }
                bl2 = false;
            }
            if (bl2) {
                return false;
            }
            switch (n) {
                case 22: {
                    return d3 < d;
                }
                case 24: {
                    return d3 <= d;
                }
                case 21: {
                    return d2 > d4;
                }
                case 23: {
                    return d2 >= d4;
                }
            }
            return false;
        }
        if (value instanceof NumericValue || value instanceof StringValue) {
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = nodeEnumeration.nextElement();
                if (!this.numericCompare(n, Value.stringToNumber(nodeInfo.getValue()), value.asNumber())) continue;
                return true;
            }
            return false;
        }
        if (value instanceof BooleanValue) {
            return this.numericCompare(n, new BooleanValue(this.asBoolean()).asNumber(), new BooleanValue(value.asBoolean()).asNumber());
        }
        if (value instanceof FragmentValue || value instanceof ObjectValue) {
            return this.compare(n, new StringValue(value.asString()));
        }
        throw new SAXException("Unknown data type in a relational expression");
    }
}

