#!/usr/local/bin/perl
# save_domain.cgi
# Update or delete a domain

require './virtual-server-lib.pl';
&require_bind() if ($config{'dns'});
&require_useradmin();
&require_mail() if ($config{'mail'});
&ReadParse();
$d = &get_domain($in{'dom'});
$access{'edit'} && &can_edit_domain($d) || &error($text{'edit_ecannot'});
$oldd = { %$d };

# Validate inputs
&error_setup($text{'save_err'});
if ($config{'home_quotas'} && !$d->{'parent'} && $access{'edit'} == 1) {
	if ($in{'quota'} eq -1) { $in{'quota'} = $in{'otherquota'} };
	if ($in{'uquota'} eq -1) { $in{'uquota'} = $in{'otheruquota'} };
	$in{'quota_def'} || $in{'quota'} =~ /^\d+$/ ||
		&error($text{'save_equota'});
	$in{'uquota_def'} || $in{'uquota'} =~ /^\d+$/ ||
		&error($text{'save_euquota'});
	}
if ($config{'bw_active'} && !$d->{'parent'} && &master_admin()) {
	$d->{'bw_limit'} = &parse_bandwidth("bw", $text{'save_ebwlimit'});
	}
$d->{'db'} = &database_name($d) if (!$d->{'db'});
if ($d->{'proxy_pass_mode'} == 1 && !$d->{'web'}) {
	# Updating existing proxy
	$in{'proxy_pass'} =~ /^(http|https):\/\/\S+$/ ||
		&error($text{'setup_eproxy'});
	$d->{'proxy_pass'} = $in{'proxy_pass'};
	}
if (defined($in{'proxy'})) {
	if ($in{'proxy_def'}) {
		# Turning off proxying
		$d->{'proxy_pass'} = undef;
		$d->{'proxy_pass_mode'} = 0;
		}
	else {
		# Turning on proxying and web
		$in{'proxy'} =~ /^(http|https):\/\/\S+$/ ||
			&error($text{'setup_eproxy'});
		$d->{'proxy_pass'} = $in{'proxy'};
		$d->{'proxy_pass_mode'} = $config{'proxy_pass'};
		}
	}

# Work out which features are relevant
@dom_features = $d->{'alias'} ? @alias_features :
		$d->{'parent'} ? ( grep { $_ ne "webmin" } @features ) :
			         @features;

# Work around possible bad 'db' name
if (!$d->{'mysql'} && $in{'mysql'} && &check_mysql_clash($d, 'db')) {
	$d->{'db'} = &database_name($d);
	}

# Check for various clashes
%newdom = %$d;
foreach $f (@dom_features, @feature_plugins) {
        if ($in{$f}) {
		$newdom{$f} = 1;
		if (!$d->{$f}) {
			$check{$f}++;
			}
		}
	else {
		$newdom{$f} = 0;
		}
	}
$derr = &virtual_server_depends(\%newdom);
&error($derr) if ($derr);
$cerr = &virtual_server_clashes(\%newdom, \%check);
&error($cerr) if ($cerr);

if (!$d->{'alias'}) {
	if ($config{'all_namevirtual'}) {
		# Make sure any new IP *is* assigned
		&check_ipaddress($in{'ip'}) || &error($text{'setup_eip'});
		if ($d->{'ip'} ne $in{'ip'} && !&check_virt_clash($in{'ip'})) {
			&error(&text('setup_evirtclash2'));
			}
		}
	elsif ($in{'virt'} && !$d->{'virt'}) {
		if ($config{'ip_ranges'}) {
			# Allocate the IP now
			$in{'ip'} = &free_ip_address();
			$in{'ip'} || &text('setup_evirtalloc');
			}
		else {
			# Make sure the IP isn't assigned yet
			&check_ipaddress($in{'ip'}) || &error($text{'setup_eip'});
			if (&check_virt_clash($in{'ip'})) {
				&error(&text('setup_evirtclash'));
				}
			}
		}
	}

# Check if any features are being deleted, and if so ask the user if
# he is sure
if (!$in{'confirm'} && !$d->{'disabled'}) {
	local @losing;
	foreach $f (@dom_features) {
		if ($config{$f} && $d->{$f} && !$in{$f}) {
			push(@losing, $f);
			}
		}
	foreach $f (@feature_plugins) {
		if ($d->{$f} && !$in{$f}) {
			push(@plosing, $f);
			}
		}
	if (@losing || @plosing) {
		&ui_print_header(&domain_in($d), $text{'save_title'}, "");

		print "<p>",&text('save_rusure',"<tt>$d->{'dom'}</tt>"),"<p>\n";
		print "<ul>\n";
		local $pfx = $d->{'parent'} ? "sublosing_" : "losing_";
		foreach $f (@losing) {
			print "<li>",$text{'feature_'.$f}," - ",
				     $text{$pfx.$f},"<br>\n";
			}
		foreach $f (@plosing) {
			print "<li>",&plugin_call($f, "feature_name")," - ",
			     &plugin_call($f, "feature_losing"),"<br>\n";
			}
		print "</ul>\n";

		print &check_clicks_function();
		print "<center><form action=save_domain.cgi>\n";
		foreach $k (keys %in) {
			foreach $v (split(/\0/, $in{$k})) {
				print "<input type=hidden name=$k value='",
				      &html_escape($v),"'>\n";
				}
			}
		print "<input type=submit name=confirm ",
		      "value='$text{'save_dok'}' ",
		      "onClick='check_clicks(form)'>\n";
		print "</form></center>\n";

		&ui_print_footer("edit_domain.cgi?dom=$in{'dom'}", $text{'edit_return'},
			"", $text{'index_return'});
		exit;
		}
	}

# Make the changes
&ui_print_unbuffered_header(&domain_in($d), $text{'save_title'}, "");

# Run the before command
&set_domain_envs($d, "MODIFY_DOMAIN");
$merr = &making_changes();
&error(&text('save_emaking', "<tt>$merr</tt>")) if (defined($merr));

# Update description, password and quotas in domain object
$d->{'owner'} = $in{'owner'};
if (!$in{'passwd_def'}) {
	if ($d->{'disabled'}) {
		# Clear any saved passwords, as they should
		# be reset at this point
		$d->{'disabled_mysqlpass'} = undef;
		$d->{'disabled_postgrespass'} = undef;
		}
	$d->{'pass'} = $in{'passwd'};
	$d->{'pass_set'} = 1;	# indicates that the password has been changed
	}
else {
	$d->{'pass_set'} = 0;
	}
if ($config{'home_quotas'} && !$d->{'parent'} && $access{'edit'} == 1) {
	$d->{'uquota'} = $in{'uquota_def'} ? undef :
				&quota_parse('uquota', $config{'home_quotas'});
	$d->{'quota'} = $in{'quota_def'} ? undef :
				&quota_parse('quota', $config{'home_quotas'});
	}
$d->{'email'} = $in{'email_def'} ? undef : $in{'email'};

# Update password and email in subdomains
foreach $sd (&get_domain_by("parent", $d->{'id'})) {
	$sd->{'pass'} = $d->{'pass'};
	$sd->{'email'} = $d->{'email'};
	}

if ($config{'all_namevirtual'} && !$d->{'alias'}) {
	# Possibly changing IP
	$d->{'ip'} = $in{'ip'};
	delete($d->{'dns_ip'});
	}
elsif ($in{'virt'} && !$d->{'virt'}) {
	# Need to bring up IP
	$d->{'ip'} = $in{'ip'};
	$d->{'virt'} = 1;
	$d->{'name'} = 0;
	delete($d->{'dns_ip'});
	&setup_virt($d);
	}
if ($d->{'alias'} && !$d->{'ip'}) {
	# IP lost bug to bug! Fix it up ..
	$aliasdom = &get_domain($d->{'alias'});
	$d->{'ip'} = $aliasdom->{'ip'};
	}

if (!$d->{'disabled'}) {
	# Enable or disable features
	my $f;
	foreach $f (@dom_features) {
		if ($config{$f}) {
			$d->{$f} = $in{$f};
			}
		}
	foreach $f (@feature_plugins) {
		$d->{$f} = $in{$f};
		}
	foreach $f (@dom_features) {
		if ($config{$f}) {
			local $sfunc = "setup_$f";
			local $dfunc = "delete_$f";
			local $mfunc = "modify_$f";
			if ($in{$f} && !$oldd->{$f}) {
				&$sfunc($d);
				}
			elsif (!$in{$f} && $oldd->{$f}) {
				&$dfunc($d);
				}
			elsif ($in{$f}) {
				&$mfunc($d, $oldd);
				}
			}
		}
	foreach $f (@feature_plugins) {
		if ($in{$f} && !$oldd->{$f}) {
			&plugin_call($f, "feature_setup", $d);
			}
		elsif (!$in{$f} && $oldd->{$f}) {
			&plugin_call($f, "feature_delete", $d);
			}
		elsif ($in{$f}) {
			&plugin_call($f, "feature_modify", $d, $oldd);
			}
		}
	}
else {
	# Only modify unix if disabled
	if ($d->{'unix'}) {
		&modify_unix($d, $oldd);
		}
	}

if ($d->{'parent'}) {
	# Refresh parent Webmin user
	$parentdom = &get_domain($d->{'parent'});
	&modify_webmin($parentdom, $parentdom);
	}

# Update custom fields
&parse_custom_fields($d, \%in);

# Save new domain details
print $text{'save_domain'},"<br>\n";
&save_domain($d);
print $text{'setup_done'},"<p>\n";

# Run the after command
&run_post_actions();
&set_domain_envs($d, "MODIFY_DOMAIN");
&made_changes();
&webmin_log("modify", "domain", $d->{'dom'}, $d);

&ui_print_footer("edit_domain.cgi?dom=$in{'dom'}", $text{'edit_return'},
	"", $text{'index_return'});

