#!/usr/local/bin/perl
# domain_setup.cgi
# Create a new virtual domain

require './virtual-server-lib.pl';
$access{'create'} || &error($text{'form_ecannot'});
&require_bind() if ($config{'dns'});
&require_useradmin();
&require_mail() if ($config{'mail'});
&require_mysql() if ($config{'mysql'});
&require_postgres() if ($config{'postgres'});
&require_acl();
&ReadParse();
&error_setup($text{'setup_err'});

# Get parent settings
if ($in{'to'}) {
	$aliasdom = &get_domain($in{'to'});
	$aliasdom || &error($text{'form_ealiasdom'});
	$parentdom = $aliasdom->{'parent'} ?
		&get_domain($aliasdom->{'parent'}) : $aliasdom;
	$parentuser = $parentdom->{'user'};
	&can_edit_domain($aliasdom) || &error($text{'form_ecannot'});
	}
elsif ($access{'create'} == 2) {
	$parentuser = $remote_user;
	}
elsif ($in{'parentuser'}) {
	$parentuser = $in{'parentuser'};
	}
if ($parentuser && !$parentdom) {
	$parentdom = &get_domain_by("user", $parentuser, "parent", "");
	$parentdom || &error(&text('form_eparent', $parentuser));
	}

# Check if domains limit has been exceeded
if ($parentdom) {
	($dcount, $dmax) = &count_domains($parentdom);
	&error(&text('setup_emaxnone')) if (!$dmax);
	&error(&text('setup_emax', $dmax)) if ($dcount >= $dmax);
	}

# Validate inputs (check domain name to see if in use)
$in{'dom'} =~ /^[A-Za-z0-9\.\-]+$/ || &error($text{'setup_edomain'});
$in{'dom'} = lc($in{'dom'});
$in{'owner'} =~ s/\r|\n//g;
$in{'owner'} =~ /:/ && &error($text{'setup_eowner'});
foreach $d (&list_domains()) {
	&error($text{'setup_edomain2'}) if (lc($d->{'dom'}) eq lc($in{'dom'}));
	}
$tmpl = &get_template($in{'template'});
if (!$parentuser) {
	# Validate user and password-related inputs for top-level domain
	$in{'email_def'} || $in{'email'} =~ /\S/ ||
		&error($text{'setup_eemail'});
	if (!$in{'unix'}) {
		$tmpl->{'mail_on'} eq "none" || !$in{'email_def'} ||
			&error($text{'setup_eemail2'});
		}
	if ($in{'unix'} || $in{'webmin'}) {
		$in{'pass'} =~ /\S/ || &error($text{'setup_epass'});
		}
	if ($in{'user_def'}) {
		($user, $try1, $try2) = &unixuser_name($in{'dom'});
		$user || &error(&text('setup_eauto', $try1, $try2));
		}
	else {
		$in{'user'} = lc($in{'user'});
		$user = $in{'user'};
		$user =~ /^[^\t :]+$/ || &error($text{'setup_euser2'});
		defined(getpwnam($user)) && &error($text{'setup_euser'});
		}
	if ($in{'mgroup_def'}) {
		$group = $user;
		}
	else {
		$in{'mgroup'} = lc($in{'mgroup'});
		$group = $in{'mgroup'};
		$group =~ /^[^\t :]+$/ || &error($text{'setup_egroup2'});
		}
	if (!$in{'group_def'}) {
		$in{'group'} = lc($in{'group'});
		$in{'group'} eq $group && &error(&text('setup_egroup3', $group));
		local ($sg) = &get_domain_by("group", $in{'group'});
		$sg && &error(&text('setup_egroup4', $sg->{'dom'}));
		}
	$home_base || &error($text{'setup_ehomebase'});
	$uerr = &useradmin::check_username_restrictions($user);
	if ($uerr) {
		&error(&text('setup_eusername', $user, $uerr));
		}
	$user =~ /^[a-zA-z]/ || &error(&text('setup_eusername2', $user));
	if ($config{'home_quotas'}) {
		if ($in{'quota'} == -1) { $in{'quota'} = $in{'otherquota'} };
		if ($in{'uquota'} == -1) { $in{'uquota'} = $in{'otheruquota'} }; 
		$in{'quota'} =~ /^\d+$/ ||  &error($text{'setup_equota'});
		$in{'uquota'} =~ /^\d+$/ ||  &error($text{'setup_euquota'});
		}
	$in{'mailboxlimit_def'} || $in{'mailboxlimit'} =~ /^[1-9]\d*$/ ||
		&error($text{'setup_emailboxlimit'});
	$in{'dbslimit_def'} || $in{'dbslimit'} =~ /^[1-9]\d*$/ ||
		&error($text{'setup_edbslimit'});
	if ($config{'bw_active'}) {
		$bw = &parse_bandwidth("bw", $text{'setup_ebwlimit'});
		}
	$in{'doms_def'} || $in{'doms'} =~ /^\d*$/ ||
		error($text{'setup_edomslimit'});
	}
if (!$aliasdom) {
	# Validate non-alias domain inputs
	$in{'mailbox'} && !$in{'mail'} && &error($text{'setup_emailbox'});
	if ($config{'proxy_pass'} && $in{'web'} && !$in{'proxy_def'}) {
		($proxy = $in{'proxy'}) =~ /^(http|https):\/\/\S+$/ ||
			&error($text{'setup_eproxy'});
		}
	if (!$in{'prefix_def'}) {
		$in{'prefix'} =~ /^[a-z0-9\.\-]+$/i ||
			&error($text{'setup_eprefix'});
		$pclash = &get_domain_by("prefix", $in{'prefix'});
		$pclash && &error($text{'setup_eprefix2'});
		}
	if (&database_feature() && !$access{'nodbname'} && !$in{'db_def'}) {
		$in{'db'} =~ /^[a-z0-9\-\_]+$/i ||
			&error($text{'setup_edbname'});
		}
	if (defined($in{'fwdto'}) && !$in{'fwdto_def'}) {
		$in{'mail'} ||
			&error($text{'setup_efwdtomail'});
		$in{'fwdto'} =~ /^\S+\@\S+$/ ||
			&error($text{'setup_efwdto'});
		$fwdto = { 'from' => "\@$in{'dom'}",
			   'to' => [ $in{'fwdto'} ] };
		}
	}

if (!$aliasdom) {
	$defip = &get_default_ip();
	if ($config{'all_namevirtual'}) {
		# Make sure the IP *is* assigned
		&check_ipaddress($in{'ip'}) || &error($text{'setup_eip'});
		if (!&check_virt_clash($in{'ip'})) {
			&error(&text('setup_evirtclash2'));
			}
		}
	elsif ($in{'virt'}) {
		if ($config{'ip_ranges'}) {
			# Allocate the IP now
			$in{'ip'} = &free_ip_address();
			$in{'ip'} || &text('setup_evirtalloc');
			}
		else {
			# Make sure the IP isn't assigned yet
			&check_ipaddress($in{'ip'}) || &error($text{'setup_eip'});
			if (&check_virt_clash($in{'ip'})) {
				&error(&text('setup_evirtclash'));
				}
			}
		}
	}

if ($parentdom) {
	# Make sure domain is under parent
	local $derr = &valid_domain_name($parentdom, $in{'dom'});
	&error($derr) if ($derr);
	}

if ($parentuser) {
	# User and group IDs come from parent
	$gid = $parentdom->{'gid'};
	$ugid = $parentdom->{'ugid'};
	$user = $parentdom->{'user'};
	$group = $parentdom->{'group'};
	$uid = $parentdom->{'uid'};
	if ($in{'prefix_def'}) {
		if ($config{'longname'}) {
			$prefix = $in{'dom'};
			}
		else {
			$in{'dom'} =~ /^([^\.]+)/;
			$prefix = $1;
			}
		}
	else {
		$prefix = $in{'prefix'};
		}
	}
else {
	# Work out user and group IDs
	&build_group_taken(\%gtaken, \%ggtaken);
	$gid = &allocate_gid(\%gtaken);
	$ugid = $in{'group_def'} ? $gid : getgrnam($in{'group'});
	$ugroup = $in{'group_def'} ? $group : $in{'group'};
	&build_taken(\%taken, \%utaken);
	$uid = &allocate_uid(\%taken);
	$prefix = $in{'prefix_def'} ? $group : $in{'prefix'};
	}

# Build up domain object
%dom = ( 'id', &domain_id(),
	 'dom', $in{'dom'},
	 'user', $user,
	 'group', $group,
	 'prefix', $prefix,
	 'ugroup', $ugroup,
	 $parentuser ?
		( 'pass', $parentdom->{'pass'} ) :
	 	( 'quota', &quota_parse('quota', $config{'home_quotas'}),
	 	  'uquota', &quota_parse('uquota', $config{'home_quotas'}),
		  'pass', $in{'pass'} ),
	 'alias', $aliasdom ? $aliasdom->{'id'} : undef,
	 'uid', $uid,
	 'gid', $gid,
	 'ugid', $ugid,
	 'owner', $in{'owner'},
	 'email', $parentdom ? $parentdom->{'email'} :
		  !$in{'email_def'} ? $in{'email'} :
		  $in{'mailbox'} ? $user."\@".$in{'dom'} :
				   undef,
	 'name', $config{'all_namevirtual'} ? 1 : $in{'virt'} ? 0 : 1,
	 'ip', $aliasdom ? $aliasdom->{'ip'} :
	       $config{'all_namevirtual'} ? $in{'ip'} :
	       $in{'virt'} ? $in{'ip'} : $defip,
	 'dns_ip', $in{'virt'} || $config{'all_namevirtual'} ? undef :
		   $config{'dns_ip'},
	 'virt', $config{'all_namevirtual'} ? 0 : $in{'virt'},
	 'source', 'domain_setup.cgi',
	 'proxy_pass', $proxy,
	 'proxy_pass_mode', $proxy ? $config{'proxy_pass'} : 0,
	 $parentuser ? ( ) :
		( 'mailboxlimit',
		  $in{'mailboxlimit_def'} ? undef : $in{'mailboxlimit'},
		  'dbslimit',
		  $in{'dbslimit_def'} ? undef : $in{'dbslimit'},
		  'bw_limit', $bw,
		  'domslimit',
		  $in{'domslimit_def'} == 1 ? undef :
		  $in{'domslimit_def'} == 2 ? "*" : $in{'domslimit'},
		  'nodbname', $in{'nodbname'},
		),
	 'parent', $parentdom ? $parentdom->{'id'} : "",
	 'template', $in{'template'},
	);
$dom{'db'} = $in{'db_def'} || !&database_feature() || $access{'nodbname'} ?
		&database_name(\%dom) : $in{'db'};
my $f;
foreach $f (@features, @feature_plugins) {
	$dom{$f} = $in{$f};
	$dom{"limit_$f"} = $f eq "webmin" ? 0 : $in{$f};
	}
$dom{'home'} = &server_home_directory(\%dom, $parentdom);

# Check for various clashes
$derr = &virtual_server_depends(\%dom);
&error($derr) if ($derr);
$cerr = &virtual_server_clashes(\%dom);
&error($cerr) if ($cerr);

# Update custom fields
&parse_custom_fields(\%dom, \%in);

&ui_print_unbuffered_header(&domain_in(\%dom), $text{'setup_title'}, "");

$err = &create_virtual_server(\%dom, $parentdom, $parentuser);
&error($err) if ($err);

if ($fwdto) {
	&$first_print(&text('setup_fwding', $in{'fwdto'}));
	&create_virtuser($fwdto);
	&$second_print($text{'setup_done'});
	}

&webmin_log("create", "domain", $dom{'dom'}, \%dom);

&ui_print_footer("", $text{'index_return'});


