<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * create a new product or modify an existing one
 *
 * @modulegroup url
 * @module url_new
 * @package url
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('url','new');
 loadmodule('url');
 loadlayout();

 /**
  * change/modify a url
  */
 class url_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $lang,$tutos,$table;

     echo "<form name=\"urlnew\" action=\"url_ins.php\" method=\"POST\">\n";
     echo $this->DataTableStart();

     echo "  <tr><th colspan=\"4\">\n";
     echo myentities($this->name) ;
     echo "  </th></tr>\n";

     echo "<tr>\n";
     echo " <td colspan=\"3\">". sprintf ($lang['ProdCreation'],$this->obj->creator->getLink(),$this->obj->creation->getDateTime()) ."</td>\n";
     echo " <td align=\"right\">". acl_link($this->obj) ."</td>";
     echo "</tr>\n";

     echo "  <tr>\n";
     echo $this->showfieldc($lang[$this->ref->getType()]);
     echo $this->showData($this->ref->getLink(),3);
     echo "  </tr>\n";

     echo "  <tr>\n";
     echo $this->showfieldc($lang['URLName'],1,"urlname");
     echo "   <td colspan=\"3\"><input size=\"". min($table['url']['name'][size],50) ."\" maxlength=\"". $table['url']['name'][size] ."\" name=\"urlname\" value=\"". myentities($this->obj->name) ."\"></td>\n";
     echo "  </tr>\n";

     echo "  <tr>\n";
     echo $this->showfieldc($lang['URL'],1,"url");
     echo "   <td colspan=\"3\"><input size=\"". min($table['url']['url'][size],50) ."\" maxlength=\"". $table['url']['url'][size] ."\" name=\"url\" value=\"". $this->obj->url ."\"></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     if ( isset($this->obj->id) && ($this->obj->id != -1) ) {
       submit_reset(0,1,1,1,1,0);
     } else {
       submit_reset(0,-1,1,1,1,0);
     }
     echo "</tr>\n";

     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
     echo $this->setfocus("urlnew.urlname");
     echo $lang['FldsRequired'] ."\n";
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->obj = new url($this->dbconn);
     if ( isset($_GET['id']) ){
       $this->obj->read($_GET['id']);
       $this->name = $lang['URLMod'];
       $this->addHidden("id",$this->obj->id);
       $this->ref = getObject($this->dbconn,$this->obj->link_id);
       $this->addHidden("link_id",$this->ref->id);
       if ($this->obj->id < 0) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
     } else {
       $this->name = $lang['URLCreate'];
       if ( isset($_GET['link_id']) ){
         $this->ref = getObject($this->dbconn,$_GET['link_id']);
         $this->addHidden("link_id",$this->ref->id);
       } else {
         $this->stop = true;
       }
     }
     if (($this->obj->id < 0) && !$this->user->feature_ok(useurl,PERM_NEW) ) {
       $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if (! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }

     # menu
     $x = url::getSelectLink($this->user,$lang['Search']);
     $x[category][] = "obj";
     $this->addMenu($x);

     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( url => $this->obj->getDelURL(),
                   text => $lang['Delete'],
                   info => $lang['URLDel'],
                   confirm => true,
                   category => array("url","del","obj")
                 );
       $this->addMenu($x);
     }

     add_module_newlinks($this,$this->obj);
   }
 }

 $l = new url_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: url_new.php,v 1.10 2004/01/20 16:14:05 gokohnert Exp $
    $Author: gokohnert $
-->