<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * Editing of teams and their permissions
 *
 * @modulegroup team
 * @module team_new
 * @package team
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("team","new");

 /**
  * change/modify a team
  */
 class team_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $lang, $tutos;

     $this->assign('action', 'team_ins.php');
     $this->assign('id', $this->obj->id);

     $this->assign('title', sprintf($lang['Showing'],
				    $lang[$this->obj->getType()]));

     $this->assign('creation',
		   array('label' => $lang['TeamCreation'],
			 'value' => $this->obj->creation->getLinkDateTime()));

     $this->assign('name',
		   array('label' => $lang['TeamName'],
			 'name'  => 'name',
			 'value' => myentities($this->obj->name)));

     $this->assign('email',
		   array('label' => $lang['AdrEmail'],
			 'name'  => 'email',
			 'value' => myentities($this->obj->email)));

     $members = array();
     foreach( $this->obj->member as $i => $f )
       $members[$i] = $f->getFullname();

     if( $this->obj->owner != -1 )
       if( ! in_array($this->obj->owner->id, $members) )
	 $members[$this->obj->owner->id] = $this->obj->owner->getFullname();

     $this->assign('manager',
		   array('label'    => $lang['TeamManager'],
			 'name'     => 'owner',
			 'options'  => $members,
			 'selected' => $this->obj->owner->id));

     $this->assign('Delete',        $lang['Delete']);
     $this->assign('TeamManager',   $lang['TeamManager']);
     $this->assign('TeamMember',    $lang['TeamMember']);
     $this->assign('TeamPosMember', $lang['TeamPosMember']);

     foreach( $this->obj->member as $i => $f ) {
       $member[$i] = array('name'  => $f->getFullname(),
			   'title' => $f->getFullname(),
			   'link'  => $f->getUrl());
     }
     $this->assign('members', $member);
     $this->assign('owner_id', $this->obj->owner->id);


     if ( $this->user->isadmin() ) {
       // Members of the virtual 0 team
       $x = new team($this->dbconn);
       $x->read(0);
       $x->read_member();
       foreach($x->member as $aid => $o) {
         $uids[$aid] = $o->getFullName();
         $cchecked[$aid] = "";
       }
       $q = "SELECT id,name FROM ". $x->tablename ;
       $r = $this->dbconn->Exec($q);
       $n = $r->numrows();
       $a = 0;
       for ( $a = 0;  $a < $n; $a++ ) {
         $aid = $r->get($a,"id");
         if ($aid == $this->obj->id) {
           continue;
         }

         $uids[$aid] = $lang['Team']." ".$r->get($a,"name");
         $cchecked[$aid] = "";
       }
       $r->free();
       unset($x);
     }
     else {
       $this->user->readKnownParties();
       foreach($this->user->a_parties as $aid => $f) {
         $uids[$aid] = $f;
         $cchecked[$aid] = "";
       }
       foreach($this->user->t_parties as $aid => $f) {
         if ($aid == $this->obj->id) continue;
         $uids[$aid] = $f;
         $cchecked[$aid] = "";
       }
     }

     // Remove team where we are member
     foreach ($this->obj->teamlist as $aid => $f) {
       unset($uids[$aid]);
       unset($cchecked[$aid]);
     }

     // Remove Current Members
     foreach($this->obj->member as $aid => $adr) {
       unset($uids[$aid]);
     }

     $new_members = array();

     foreach( $uids as $i => $f ) {
       $new_members[$i] = myentities($f);
     }
     $this->assign('new_members', 
		   array('options' => $new_members,
			 'size'    => max(count($members), 10)));

     /*
     module_addforms($this->user,$this->obj,8);

     // Feature Permisssions
     permission_form($this,$this->user,$this->obj);
     */

     $this->assign('InputOk',   $lang['InputOk']);
     $this->assign('ChangesOk', $lang['ChangesOk']);
     $this->assign('Enter', $lang['Enter']);
     $this->assign('Reset', $lang['Reset']);

     $this->assign('focus', "teamadd.name");

     $this->assign('FldsRequired', $lang['FldsRequired']);

     $this->template('team_new');
   }

   /**
    * navigate
    */
   Function navigate() {
   }

   /**
    * prepare
    */
   Function prepare() {
     global $msg,$tutos,$lang;

     $this->obj = new team($this->dbconn);
     if ( isset($_GET['id'])  ) {
       $this->obj->read($_GET['id']);
       $this->obj->read_member();
       $this->obj->read_permissions();
       $this->name = $lang['TeamModify'] .": ". $this->obj->getFullName();
       team::obj_read($this->obj);
     } else {
       $this->obj->name = $lang['PlsChangeName'];
       $this->name = $lang['TeamCreate'];
       $this->member[$this->user->id] = $this->user;
     }
     if ( isset($_GET['name']) ) {
       $this->obj->name = trim(Stripslashes($_GET['name']));
     }
     if ( isset($_GET['email']) ) {
       $this->obj->email = trim(Stripslashes($_GET['email']));
     }
     if ( ($this->obj->id < 0) && !$this->user->feature_ok(useteams,PERM_NEW) ) {
       $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if (! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     # menu
     $x = team::getSelectLink($this->user,$lang['Search']);
     $x['category'][] = "obj";
     $x['image'] = 'search';
     $this->addMenu($x);

     if ( $this->user->feature_ok(useteams,PERM_NEW) ) {
       $x = array('url'   => "team_new.php",
                  'text'  => $lang['NewEntry'],
                  'info'  => $lang['TeamCreateI'],
		  'image' => 'new',
                  'category' => array("team","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array('url'  => $this->obj->getDelURL(),
                  'text' => $lang['Delete'],
                  'info' => sprintf($lang['TeamDeleteI'],
				    $this->obj->getFullName()),
		  'image' => 'delete',
                  'category' => array("team","del","obj")
                 );
       $this->addMenu($x);
     }
     add_module_newlinks($this,$this->obj);
     web_StackStartLayout($this,"team_new.php","team_new.php?".$_SERVER['QUERY_STRING']);     
   }
 }

 $l = new team_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: team_new.php,v 1.43.2.3 2004/09/30 17:09:33 tapoueh Exp $
    $Author: tapoueh $
-->