<?php
/**
 * Copyright 1999 - 2004 by Gero Kohnert
 *
 * @modulegroup task
 * @module task_new
 * @package task
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'task.pinc';
 include_once 'product.pinc';
 include_once 'timetrack.pinc';

 require_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("task","new");

 /**
  * display a form to enter/modify a task
  */
 class task_new extends layout {
   /**
    *
    */
   Function info() {
     global $lang,$table;

     $this->assign('action', 'task_ins.php');

     if ( $this->obj->id != -1 )
       $this->assign('title', sprintf($lang['TaskModify'],$this->obj->name));
     else
       $this->assign('title', $lang['TaskCreate']);

     $this->assign('id', $this->obj->id);
     $this->assign('creation', sprintf($lang['TaskCreation'],
				       $this->obj->creator->getLink(),
				       $this->obj->creation->getDateTime()));
     $this->assign('acl_link', acl_link($this->obj));
			 
     $this->assign('name',
		   array('id'    => 'name',
			 'label' => $lang['TaskName'],
			 'size'  => min($table['task']['name'][size], 40),
			 'maxl'  => $table['task']['name'][size],
			 'value' => $this->obj->name));

     $this->assign('logical', 
		   array('label' => $lang['TaskLogical'],
			 'value' => $this->obj->logical));
     $this->assign('has_subtask', count($this->obj->children) > 0);

     if( $this->obj->logical ) {
       // For logical tasks, we also need the real data
       // as oposed to calculated ones to be presented
       $this->assign('real_volumes',
		     array('volume'      => $this->obj->volume,
			   'volume_done' => $this->obj->volume_done,
			   'volume_todo' => $this->obj->volume_todo));
     }
       
     $this->assign('milestone', 
		   array('label' => $lang['TaskMilestone'],
			 'value' => $this->obj->milestone));

     $states = array();
     foreach($lang['TaskStates'] as $f => $i ) {
       $states[$f] = $lang['TaskStates'][$f];
       if( $f == $this->obj->state )
	 $state = $f;
     }
     $this->assign('state',
		   array('id'    => 'state',
			 'label' => $lang['TaskState'],
			 'value' => $this->obj->get_state(),
			 'options'  => $states,
			 'selected' => $state));

     $this->assign('parent', $this->obj->parent);
     $this->assign('pid', $this->obj->p_id);

     if( ($this->obj->parent != -1) 
	 && ($this->obj->parent->gettype() != "address") ) {

       $this->assign_parent_select('subtask');

     }
     else
       $this->assign('subtask', '');

     // Description
     $this->assign('desc',
		   array('id'    => 'desc',
			 'label' => $lang['TaskDesc'],
			 'len'   => $this->dbconn->txtlen,
			 'value' => $this->obj->desc));

     // Task workers
     if( $this->obj->parent->getType() == "product" ) {
       $project = $this->obj->parent;
     }
     else if( $this->obj->parent->getType() == "address" ) {
       $project = -1;
     }
     else {
       $ptasks = array();
       $project = $this->obj->getProject($ptasks);
     }

     $parts = $this->user->askPeople($this->obj->worker, $project);
     // $this->debug($parts);

     $this->assign('workers',
		   array('id'      => 'people',
			 'name'    => 'worker[]',
			 'label'   => $lang['TaskWorker'],
			 'options' => $parts));

     $this->assign('volume',
		   array('id'     => 'volume',
			 'label'  => $lang['TaskVolumeFull'],
			 'value'  => number_format($this->obj->get_volume(), 2,
						   $lang['DecPoint'],
						   $lang['ThousandPoint'])));

     $this->assign('is_creator', 
		   $this->user->id == $this->obj->creator->id ||
		   array_key_exists((int)$this->user->id, $this->obj->worker));

     $this->assign('volume_done',
		   array('id'    => 'volume_done',
			 'label' => $lang['TaskVolumeDone'],
			 'value' =>
			 number_format($this->obj->get_volume_done(), 2,
				       $lang['DecPoint'],
				       $lang['ThousandPoint'])));
     
     /**
      * Volume done and volume todo
      *
      * Give a check box for the user to choose to indicate volume
      * done or to ask the system to calculate it
      *
      * On task creation, default is to auto calc volume todo, on task
      * editing, we should by default allow for manual input.
      *
      */
     if( $this->obj->id > 0 ) {
       // Task editing
       $this->assign('calc_volume_todo',
		     array('id'    => 'calc_volume_todo',
			   'label' => $lang['TaskVolumeTodoC'],
			   'value' => 0));

       $this->assign('volume_todo',
		     array('id'    => 'volume_todo',
			   'label' => $lang['TaskVolumeTodo'],
			   'value' =>
			   number_format($this->obj->get_volume_todo(), 2,
					 $lang['DecPoint'],
					 $lang['ThousandPoint'])));
     }
     else {
       // Task creation
       $this->assign('calc_volume_todo',
		     array('id'    => 'calc_volume_todo',
			   'label' => $lang['TaskVolumeTodoC'],
			   'value' => 1));

       $this->assign('volume_todo',
		     array('id'    => 'volume_todo',
			   'label' => $lang['TaskVolumeTodo'],
			   'value' => ''));
     }
     $this->assign_date($lang['TaskS_Start'],
			"s_start", $this->obj->get_s_start());
     $this->assign_date($lang['TaskS_End'],
			"s_end", $this->obj->get_s_end());

     // References to modules
     // module_addforms($this->user,$this->obj,4);
 
     $this->assign('InputOk',   $lang['InputOk']);
     $this->assign('ChangesOk', $lang['ChangesOk']);
     $this->assign('Enter', $lang['Enter']);
     $this->assign('Reset', $lang['Reset']);

     $this->assign('focus', "taskadd.name");

     $this->assign('FldsRequired', $lang['FldsRequired']);

     $this->template('task_new');
   }

   /**
    * navigate
    */
   Function navigate() {
   }

   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->obj = new task($this->dbconn);
     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
       $this->name = sprintf($lang['TaskModify'],$this->obj->getFullName());
       if ( $this->obj->id < 0 ) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true ;
       }
     } else {
       $this->name = $lang['TaskCreate'];
     }
     if ( ($this->obj->id < 0) && !$this->user->feature_ok(usetaskmanagement,PERM_NEW) ) {
       $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( ! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true ;
     }

     if ( isset($_GET['name']) ) {
       $this->obj->name = StripSlashes($_GET['name']);
     }
     if ( isset($_GET['desc']) ) {
       $this->obj->desc = StripSlashes($_GET['desc']);
     }
     if ( isset($_GET['state']) ) {
       $this->obj->state = $_GET['state'];
     }
     if ( isset($_GET['volume']) ) {
       $this->obj->volume = StripSlashes($_GET['volume']);
     }
     if ( isset($_GET['volume_done']) ) {
       $this->obj->volume_done = StripSlashes($_GET['volume_done']);
     }
     if ( isset($_GET['volume_todo']) ) {
       $this->obj->volume_todo = StripSlashes($_GET['volume_todo']);
     }
     if ( isset($_GET['worker']) ) {
       foreach ($_GET['worker'] as $i => $f) {
         $this->obj->worker[$f] = new tutos_address($this->dbconn);
         $this->obj->worker[$f]->read($f);
       }
     }
     if ( isset($_GET['s_start']) ) {
       $this->obj->s_start->setDateTime($_GET['s_start']);
     }
     if ( isset($_GET['s_end']) ) {
       $this->obj->s_end->setDateTime($_GET['s_end']);
     }
     if ( isset($_GET['pid']) ) {
       $this->obj->parent = GetObject($this->dbconn,$_GET['pid']);
       if ( $this->obj->parent != -1 ) {
         $this->obj->p_id = $this->obj->parent->id;
       }
     }
     $this->obj->read_relations();
     if ( $this->obj->p_id < 0 ) {
       $msg .= "Sorry we need a parent object <br>";
       $this->stop = true ;
     }

     # menu
     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array('url'   => $this->obj->getDelURL(),
                  'text'  => $lang['Delete'],
		  'image' => 'delete',
                  'info' => sprintf($lang['TaskDelete'],
				    $this->obj->getFullname()),
                  'category' => array("task","del","obj"),
                  'confirm' => true
                 );
       $this->addMenu($x);
     }
     add_module_newlinks($this,$this->obj);

     web_StackStartLayout($this, "task_new.php",
			  "task_new.php?".$_SERVER['QUERY_STRING']);     
   }
 }

 $l = new task_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: task_new.php,v 1.57.2.16 2005/04/13 15:36:08 tapoueh Exp $
    $Author: tapoueh $
-->