<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * this script parses all the inputs and stores the object into the database.
 * on completition it jumps to the detail screen of the stored object
 *
 * @modulegroup task
 * @module task_ins
 * @package task
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'task.pinc';
 include_once 'product.pinc';
 include_once 'timetrack.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("task","ins");

 $msg = "";

 $gotourl="task_new.php";

 $t = new task($dbconn);

 if ( isset($_POST['id']) ) {
   $t->read($_POST['id']);
   $gotourl= addUrlParameter($gotourl,"id=". $t->id,true);
 }

 if ( !isset($_POST['pid']) || ($_POST['pid'] == "") ) {
   $pid =  $current_user->id;
 } else {
   $pid = $_POST['pid'];
   $gotourl= addUrlParameter($gotourl,"pid=". $pid,true);
 }
 $t->setParent($pid);


 if ( !isset($_POST['name']) || (trim($_POST['name']) == "") ) {
   $msg .= sprintf($lang['Err0009'],$lang['TaskName']) ."<br>";
 } else {
   $t->setName(trim(StripSlashes($_POST['name'])));
   $gotourl= addUrlParameter($gotourl,"name=". UrlEncode($t->name),true);
 }
 if ( !isset($_POST['desc']) || (trim($_POST['desc']) == "") ) {
   $msg .= sprintf($lang['Err0009'],$lang['TaskDesc']) ."<br>";
 } else {
   $t->setDescription(trim(StripSlashes($_POST['desc'])));
   $gotourl= addUrlParameter($gotourl,"desc=". UrlEncode($t->desc),true);
 }
 if ( !isset($_POST['state']) || ($_POST['state'] == "") ) {
   $msg .= sprintf($lang['Err0014'],$lang['TaskState']) ."<br>";
 } else {
   $state = $_POST['state'];
   $gotourl= addUrlParameter($gotourl,"state=". UrlEncode($state),true);
 }

// Logical and milestone are boolean checkboxes
$t->logical   =
   isset($_POST['logical']) && $_POST['logical'] == "on" ? 1 : 0;

if( isset($_POST['logical']) )
     $gotourl = addUrlParameter($gotourl,
				'logical='.UrlEncode($_POST['logical']), true);

$t->milestone =
  isset($_POST['milestone']) && $_POST['milestone'] == "on" ? 1 : 0;

if( isset($_POST['logical']) )
     $gotourl = addUrlParameter($gotourl,
				'milestone='.UrlEncode($_POST['milestone']),
				true);

 if ( !checkfloat($_POST['volume'],true) ) {
   $msg .= sprintf($lang['Err0017'],$lang['TaskVolumeFull']) ."<br>";
 } else {
   $gotourl= addUrlParameter($gotourl,"volume=". UrlEncode($_POST['volume']),true);
 }

 $volume_done = $_POST['volume_done'];
 if ( !checkfloat($volume_done,true) ) {
   $msg .= sprintf($lang['Err0009'],$lang['TaskVolumeDone']) ."<br>";
 } else {
   $gotourl= addUrlParameter($gotourl,"volume_done=". UrlEncode($volume_done),true);
 }

if( isset($_POST['calc_volume_todo']) && $_POST['calc_volume_todo'] == 'on' ) {
  // User want us to calculate volume done based on given volume and
  // volume_todo
  if( $volume_done < $volume ) {
    $volume_todo = $volume - $volume_done;
  }
  else
    $volume_todo = 0;
}
else {
  $volume_todo = $_POST['volume_todo'];
  if ( !checkfloat($volume_todo)
       || ($volume_todo < 0 && $volume_todo != -1.0)) {
    $msg .= sprintf($lang['Err0009'],$lang['TaskVolumeTodo']) ."<br>";
  }
  else {
    $gotourl= addUrlParameter($gotourl,
			      "volume_todo=". UrlEncode($volume_todo),true);
  }
}

 $project = -1;
 $rid = array();

 if ( !isset($_POST['worker']) ) {
   $msg .= sprintf($lang['Err0014'],$lang['TaskWorker']) ."<br>";
 } else {
   $t->worker = array();

   $ptasks = array();
   $project = $t->getProject($ptasks);
   if ( $project->getType() == "product" ) {
     $project->readroles();
   }

   foreach($_POST['worker'] as $i => $f ) {
     $t->worker[$f] = getObject($dbconn,$f);
     $gotourl= addUrlParameter($gotourl,"worker[]=". $f,true);

     if ( $project->getType() == "product" ) {
      $hasrole = false;
     } else {
      $hasrole = true;
     }
     /**
      * If the selected worker does not have a role in the product, we
      * ask the user which role to assign him
      */
     if (isset($project->role)) {
       @reset($project->role);
       while( ! $hasrole and list($role, $xf) = each($project->role) ) {
         if( isset($project->role[$role]) && is_array($project->role[$role]) ) {
           @reset($project->role[$role]);
           while( ! $hasrole and list($i, $o) = each($project->role[$role])) {
             switch( $o->getType() ) {
             case "user":
             case "address": {
               $hasrole = $f == $o->id;
               break;
             }
             case "team": {
               $hasrole = $f == $o->id;
#               $o->read_member();
#               foreach($o->member as $xx) {
#                 $hasrole = $f == $xx;
#               }
               break;
             }
             default:
               break;
             }
           }
         }
       }
	 }
     if( ! $hasrole and ! in_array($f, $rid) ) {
       error_log('task_ins: no role for '.$f);
       $rid[] = $f;
     }
   }
 }

 $s_start = new DateTime(0);
 $s_start->setDateTimeF("s_start");
 $gotourl= addUrlParameter($gotourl,"s_start=". $s_start->getYYYYMMDDHHMM(),true);
 if ( !$s_start->checkDMY() ) {
   $msg .= sprintf($lang['Err0038'],$lang['TaskS_Start']) ."<br>";
 }

if( $t->milestone ) {
  $s_end = $s_start;
}
else {
  $s_end = new DateTime(0);
  $s_end->setDateTimeF("s_end");
}

 $gotourl= addUrlParameter($gotourl,"s_end=". $s_end->getYYYYMMDDHHMM(),true);
 if ( !$s_end->checkDMY() ) {
   $msg .= sprintf($lang['Err0038'],$lang['TaskS_End']) ."<br>";
 }

 if ( ($s_start->ts > $s_end->ts ) ) {
   $msg .= $lang['Err0002'] ."<br>";
 }

 # other modules
 $msg .= module_parseforms($current_user,$t,$gotourl);

 if ( $msg == "" ) {
   $t->parent = getObject($dbconn,$t->p_id);

   # First time work done
   if ( ($t->volume_done == 0) && ($volume_done > 0) ) {
     $t->setRStart(new DateTime());
   }
   # First time state set to finished
   if ( ($t->state != TASK_FINISH) && ($state == TASK_FINISH) ) {
     $t->setREnd(new DateTime());
   }
   if ( ($volume_done > $t->volume_done) && ($state == TASK_FINISH) ) {
     $t->setREnd(new DateTime());
   }

   if( ! $t->logical ) {
     $t->setState($state);
     $t->setVolume($_POST['volume']);
     $t->setVolumeDone($volume_done);

     if( isset($_POST['calc_volume_todo'])
	 && $_POST['calc_volume_todo'] == 'on' 
	 && $t->volume_todo > $t->diff )
       $t->setVolumeTodo($t->volume_todo - $t->diff);
     else
       $t->setVolumeTodo($volume_todo);

     $t->setSStart($s_start);
     $t->setSEnd($s_end);
   }

   $newobj = $t->id<0;
   $dbconn->Begin("WORK");
   $msg .= $t->save();
   $dbconn->Commit("WORK");

   if( count($rid) == 0 ) {
     // When modifying a task we got back too much
     // $gotourl= web_StackPop($newobj?2:3);
     // $gotourl = web_StackPop(2);
     $gotourl = "task_show.php?id=".$t->id;
   }
   else {
     // In that case goto product_role_new to give a role to the
     // selected worker
     $gotourl = "product_role_new.php";
     $gotourl = addUrlParameter($gotourl, "id=".$project->id, true);

     foreach( $rid as $r ) {
       $gotourl = addUrlParameter($gotourl, "rid[]=".$r, true);
     }
   }
 }

 $gotourl = addMessage($gotourl,$msg,true);
 $gotourl = addSessionKey($gotourl,true);

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: task_ins.php,v 1.40.2.9 2005/04/12 10:29:57 tapoueh Exp $
  *  $Author: tapoueh $
  */
?>