<?php
/**
 * Copyright 2001 - 2003 by Gero Kohnert
 *
 * @modulegroup resource
 * @module resource_show
 * @package resource
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("resource","show");
 loadmodule("resource");
 loadlayout();
 /**
  * display a resource and its usage
  */
 class resource_show extends layout {
   /**
    *
    */
   Function info() {
     global $tutos,$lang;

     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"4\">". sprintf($lang['Showing'],myentities($this->obj->getFullName())) ."</th>\n";
     echo "</tr>\n";

     echo "<tr>\n";

#     echo $this->showfield($lang['createdby']);
#     echo $this->showdata($this->obj->creator->getLink(),3);
#     echo "</tr><tr>\n";

     echo $this->showfield($lang['ResName']);
     echo $this->showdata(myentities($this->obj->name),3);

     echo "</tr><tr>\n";
     echo $this->showfield($lang['ResDesc']);
     echo $this->showdata(myentities($this->obj->desc),3);

     # Usage
     $this->obj->readUsage();
     if ( count($this->obj->ulist) > 0 ) {
       echo "</tr><tr>\n";
       echo "<th colspan=\"4\">". $lang['ResUsage'] ."</th>\n";
       # First all future appointments and running projekts/tasks
       $line = 0;
       foreach ($this->obj->ulist as $i => $f) {
         $ts = $f->getTimespan();
         if ( ($f->getType() == "appointment") && ($f->end->getTimestamp() - time() > 0) ) {
           echo "</tr><tr class=\"line0\">\n";
           echo "<td>". $lang[$f->getType()] ."</td>\n";
           echo "<td colspan=\"2\">". $f->getLink($f->descr) ."</td>\n";
           echo "<td>". $ts['desc'] ."</td>\n";
         } else if ( ($f->getType() == "task") && ($f->s_end->getTimestamp() - time() > 0) ) {
           echo "</tr><tr class=\"line0\">\n";
           echo "<td>". $lang[$f->getType()] ."</td>\n";
           echo "<td colspan=\"2\">". $f->getLink() ."</td>\n";
           echo "<td>". $ts['desc'] ."</td>\n";
         } else if ( ($f->getType() == "product") &&  ($f->isalive() == 1) ) {
           echo "</tr><tr class=\"line0\">\n";
           echo "<td>". $lang[$f->getType()] ."</td>\n";
           echo "<td colspan=\"2\">". $f->getLink() ."</td>\n";
           echo "<td>". $ts['desc'] ."</td>\n";
         } else if ( ($f->getType() == "installation") &&  ($f->instdate->getTimestamp() - time() > 0) ) {
           echo "</tr><tr class=\"line0\">\n";
           echo "<td>". $lang[$f->getType()] ."</td>\n";
           echo "<td colspan=\"2\">". $f->getLink() ."</td>\n";
           echo "<td>". $ts['desc'] ."</td>\n";
         }
       }
       # Then some recent appointments
       $x = 0;
       @reset ($this->obj->ulist);
       while ( (list ($i,$f) = @each ($this->obj->ulist)) && ($x < $tutos[maxshort]) ) {
         $ts = $f->getTimespan();
         if ( ($f->getType() == "appointment") && ($f->end->getTimestamp() - time() < 0) ) {
           echo "</tr><tr class=\"line2\">\n";
           echo "<td>". $lang[$f->getType()] ."</td>\n";
           echo "<td colspan=\"2\"><i>". $f->getLink($f->descr) ."</i></td>\n";
           echo "<td>". $ts['desc'] ."</td>\n";
           $x++;
         }
       }
       # Then the old tasks and projects
       $x = 0;
       @reset ($this->obj->ulist);
       while ( (list ($i,$f) = @each ($this->obj->ulist)) && ($x < $tutos[maxshort]) ) {
         $ts = $f->getTimespan();
         if ( ($f->getType() == "task") && ($f->s_end->getTimestamp() - time() < 0) ) {
           echo "</tr><tr class=\"line2\">\n";
           echo "<td>". $lang[$f->getType()] ."</td>\n";
           echo "<td colspan=\"2\"><i>". $f->getLink() ."</i></td>\n";
           echo "<td>". $ts['desc'] ."</td>\n";
           $x++;
         } else if ( ($f->getType() == "product") &&  ($f->isalive() == 0) ) {
           echo "</tr><tr class=\"line2\">\n";
           echo "<td>". $lang[$f->getType()] ."</td>\n";
           echo "<td colspan=\"2\"><i>". $f->getLink() ."</i></td>\n";
           echo "<td>".  $ts['desc'] ."</td>\n";
           $x++;
         } else if ( ($f->getType() == "installation") &&  ($f->instdate->getTimestamp() - time() < 0) ) {
           echo "</tr><tr class=\"line2\">\n";
           echo "<td>". $lang[$f->getType()] ."</td>\n";
           echo "<td colspan=\"2\"><i>". $f->getLink() ."</i></td>\n";
           echo "<td>". $ts['desc'] ."</td>\n";
         }
       }
     }
     echo "</tr>\n";

     # References to modules
     show_module_infolists($this->user,$this->obj,4,$this->format);
     echo $this->obj->getHistoryLink(4);
     echo $this->DataTableEnd();
   }
   /**
    * naviagte
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['ResDetail'];
     $this->obj = new resource($this->dbconn);
     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
     } else {
       $msg .= $lang['Err0048'] ."<br>";
       $this->stop = true;
     }
     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( $this->obj->id < 0 ) {
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else {
       $this->name .=": ". myentities($this->obj->getFullName());
     }
     # menu
     $m = resource::getOverviewLink($this->user,$lang['Resources']);
     $m[category][] = "obj";
     $this->addMenu($m);
     if ( $this->user->feature_ok(useresource,PERM_NEW) ) {
       $m = array( url => "resource/resource_new.php",
                   text => $lang['NewEntry'],
                   info => $lang['ResCreate'],
                   category => array("resource","new","obj")
                 );
       $this->addMenu($m);
     }
     if ( $this->obj->mod_ok() ) {
       $m = array( url => $this->obj->getModURL(),
                   text => $lang['Modify'],
                   info => sprintf($lang['ResModifyI'],$this->obj->getFullName()),
                   category => array("resource","mod","obj")
                 );
       $this->addMenu($m);
     }
     if ( $this->user->feature_ok(usecalendar,PERM_SEE) ) {
       $m = array( url => "calendar.php?team=".$this->obj->id,
                   text => $lang['Calendar'],
                   info => sprintf($lang['ShowCal'],$this->obj->getFullName()),
                   category => array("app","show","module")
                 );
       $this->addMenu($m);
     }
     add_module_addlinks($this,$this->obj);

     # add this page to the browsehistory of the users session
     $this->addtohistory();
   }
 }

 $l = new resource_show($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: resource_show.php,v 1.23 2004/01/20 16:14:05 gokohnert Exp $
    $Author: gokohnert $
-->